/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.swingx.color.ColorUtil;

public class JXColorSelectionButton
extends JButton {
    private JDialog dialog = null;
    private JColorChooser chooser = null;
    private BufferedImage colorwell;

    public JXColorSelectionButton() {
        this(Color.red);
    }

    public JXColorSelectionButton(Color col) {
        this.setBackground(col);
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JXColorSelectionButton.this.dialog == null) {
                    JXColorSelectionButton.this.dialog = JColorChooser.createDialog(JXColorSelectionButton.this, "Choose a color", true, JXColorSelectionButton.this.getChooser(), new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            System.out.println("okay");
                        }
                    }, new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            System.out.println("cancel");
                        }
                    });
                    JXColorSelectionButton.this.dialog.getContentPane().add(JXColorSelectionButton.this.getChooser());
                    JXColorSelectionButton.this.getChooser().getSelectionModel().addChangeListener(new ColorChangeListener(JXColorSelectionButton.this));
                }
                JXColorSelectionButton.this.dialog.setVisible(true);
                Color color = JXColorSelectionButton.this.getChooser().getColor();
                if (color != null) {
                    JXColorSelectionButton.this.setBackground(color);
                }
            }
        });
        this.setContentAreaFilled(false);
        this.setOpaque(false);
        try {
            this.colorwell = ImageIO.read(this.getClass().getResourceAsStream("/org/jdesktop/swingx/color/colorwell.png"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.addPropertyChangeListener("background", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JXColorSelectionButton.this.getChooser().setColor(JXColorSelectionButton.this.getBackground());
            }
        });
    }

    protected void paintComponent(Graphics g) {
        Insets ins = new Insets(5, 5, 5, 5);
        if (this.colorwell != null) {
            ColorUtil.tileStretchPaint(g, this, this.colorwell, ins);
        }
        g.setColor(ColorUtil.removeAlpha(this.getBackground()));
        g.fillRect(ins.left, ins.top, this.getWidth() - ins.left - ins.right, this.getHeight() - ins.top - ins.bottom);
        g.setColor(ColorUtil.setBrightness(this.getBackground(), 0.85f));
        g.drawRect(ins.left, ins.top, this.getWidth() - ins.left - ins.right - 1, this.getHeight() - ins.top - ins.bottom - 1);
        g.drawRect(ins.left + 1, ins.top + 1, this.getWidth() - ins.left - ins.right - 3, this.getHeight() - ins.top - ins.bottom - 3);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Color Button Test");
        frame.setDefaultCloseOperation(3);
        JPanel panel = new JPanel();
        panel.add(new JXColorSelectionButton());
        panel.add(new JLabel("ColorSelectionButton test"));
        frame.add(panel);
        frame.pack();
        frame.setVisible(true);
    }

    public JColorChooser getChooser() {
        if (this.chooser == null) {
            this.chooser = new JColorChooser();
        }
        return this.chooser;
    }

    private class ColorChangeListener
    implements ChangeListener {
        public JXColorSelectionButton button;

        public ColorChangeListener(JXColorSelectionButton button) {
            this.button = button;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.button.setBackground(this.button.getChooser().getColor());
        }
    }
}

