/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise;

import fr.unistra.ibmc.paradise.ParadiseAgent;
import fr.unistra.ibmc.paradise.services.ParadisePlatform;
import fr.unistra.ibmc.paradise.tools.AbstractParadiseTool;
import fr.unistra.ibmc.paradise.tools.ParadiseWorkingSession;
import fr.unistra.ibmc.paradise.tools.component.DefaultProgressMonitor;
import fr.unistra.ibmc.paradise.tools.component.ProgressMonitor;
import fr.unistra.ibmc.paradise.utils.IOUtils;
import fr.unistra.ibmc.paradise.utils.ParadiseConfig;
import groovy.lang.Binding;
import groovy.ui.Console;
import jade.wrapper.ControllerException;
import java.io.File;
import java.io.IOException;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JLabel;
import org.jdesktop.swingworker.SwingWorker;
import org.jdom.JDOMException;

public class Paradise
extends AbstractParadiseTool {
    public static final String releaseName = "PARADISE engine 2.0";
    private static String currentPlatformAddress;
    public static int mainFeaturesCreatedCount;
    private ProgressMonitor monitor = new DefaultProgressMonitor();
    public static final int STRUCTURAL_ALIGNMENT = 0;
    public static final int SECONDARY_STRUCTURE_PREDICTION = 1;
    public static final int TERTIARY_STRUCTURE_ANNOTATION = 2;
    public static final int SECONDARY_STRUCTURE_DRAWING = 3;
    public static final int HELICES_REORGANIZATION = 4;
    public static final int TERTIARY_STRUCTURE_PREDICTION = 5;
    public static final int TERTIARY_STRUCTURE_REFINEMENT = 6;
    public static final int SEND_RESIDUES_BY_CHAT = 7;
    public static final int NC_RNAS_CANDIDATES_SEARCHING = 8;

    public Paradise(ParadiseWorkingSession workingSession) {
        super(releaseName, workingSession);
    }

    public ProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    public static String getCurrentPlatformAddress() {
        return currentPlatformAddress;
    }

    public static void setCurrentPlatformAddress(String currentPlatformAddress) {
        Paradise.currentPlatformAddress = currentPlatformAddress;
    }

    public static String getInstallPath() {
        return Paradise.class.getProtectionDomain().getCodeSource().getLocation().getPath().split("paradise.jar")[0];
    }

    public static File getTmpDirectory() {
        File tmpDir = new File(new StringBuffer(Paradise.getInstallPath()).append("tmp").toString());
        if (!tmpDir.exists()) {
            tmpDir.mkdir();
        }
        return tmpDir;
    }

    public static File getTertiaryDataDirectory() {
        File tertiaryDataDir;
        block6: {
            tertiaryDataDir = new File(Paradise.getParadiseDirectory(), "tertiary_data");
            if (!tertiaryDataDir.exists()) {
                tertiaryDataDir.mkdir();
                try {
                    File dataZipped = new File(Paradise.getInstallPath(), "tertiary_data.zip");
                    if (dataZipped.exists()) {
                        try {
                            IOUtils.extractArchivedFile(Paradise.getParadiseDirectory().getAbsolutePath(), dataZipped);
                            dataZipped.delete();
                            break block6;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            return null;
                        }
                    }
                    IOUtils.copyDirectory(new File(new File(Paradise.getInstallPath()), "tertiary_data"), tertiaryDataDir);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }
        return tertiaryDataDir;
    }

    public static File getDatabasesDirectory() {
        File sequencesDir = new File(Paradise.getParadiseDirectory(), "databases");
        if (!sequencesDir.exists()) {
            sequencesDir.mkdir();
        }
        return sequencesDir;
    }

    public static File getParadiseDirectory() {
        File userDir = new File(new StringBuffer(System.getProperty("user.home")).append(System.getProperty("file.separator")).append(".paradise").append(System.getProperty("file.separator")).toString());
        if (!userDir.exists()) {
            userDir.mkdir();
        }
        return userDir;
    }

    public static String getScriptsPath() {
        return new StringBuffer(Paradise.getInstallPath()).append("scripts").append(System.getProperty("file.separator")).toString();
    }

    public static String getWorkingDirectory() {
        Preferences preferences = Preferences.userNodeForPackage(Paradise.class);
        return preferences.get("Working Directory", Paradise.getInstallPath());
    }

    public static void setWorkingDirectory(String workingDirectory) {
        Preferences preferences = Preferences.userNodeForPackage(Paradise.class);
        preferences.put("Working Directory", workingDirectory);
    }

    public static void main(String[] args) throws IOException, ControllerException, JDOMException, BackingStoreException {
        if (args.length == 0) {
            ParadisePlatform.launchParadisePlatform();
            new Connect("localhost").execute();
        } else if (args.length == 1) {
            if ("algorithms_path".equals(args[0])) {
                System.out.println(ParadiseConfig.getAlgorithmsPath());
            } else {
                new Connect(args[0]).execute();
            }
        }
    }

    public void launch() {
        Binding b = new Binding();
        b.setProperty("session", (Object)this.getWorkingSession());
        b.setProperty("agent", (Object)this.agent);
        Console console = new Console(b);
        console.setCurrentFileChooserDir(new File(Paradise.getInstallPath()));
        console.setStatusLabel(new JLabel("Connected to " + ((ParadiseWorkingSession)this.moleculeFactory).getPlatformAddress() + ", ready for work..."));
        console.run();
    }

    static {
        mainFeaturesCreatedCount = 0;
    }

    static class Connect
    extends SwingWorker {
        private String platformAddress;

        Connect(String platformAddress) {
            this.platformAddress = platformAddress;
        }

        protected Object doInBackground() throws Exception {
            System.out.println("try to connect to " + this.platformAddress);
            ParadiseWorkingSession p = new ParadiseWorkingSession(this.platformAddress);
            new ParadiseAgent(p);
            return null;
        }
    }
}

