/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.core;

import fr.unistra.ibmc.paradise.BiologicalSymbolException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;

public class PhylogeneticTree {
    private DefaultMutableTreeNode root;
    private Map<Integer, DefaultMutableTreeNode> nodes_by_tax_id = new HashMap<Integer, DefaultMutableTreeNode>();
    private Map<String, DefaultMutableTreeNode> nodes_by_name = new HashMap<String, DefaultMutableTreeNode>();

    public PhylogeneticTree() {
        this.root = new DefaultMutableTreeNode("SuperRoot");
        this.nodes_by_tax_id.put(0, this.root);
        this.nodes_by_name.put("SuperRoot", this.root);
    }

    public void addNode(String organismName, String rank, int tax_id, int parent_tax_id) {
        DefaultMutableTreeNode n = this.nodes_by_tax_id.get(tax_id);
        if (n == null) {
            n = new DefaultMutableTreeNode(organismName);
            this.nodes_by_tax_id.put(tax_id, n);
        }
        n.setUserObject(organismName);
        this.nodes_by_name.put(organismName, n);
        DefaultMutableTreeNode parent = this.nodes_by_tax_id.get(parent_tax_id);
        if (parent == null) {
            parent = new DefaultMutableTreeNode();
            this.nodes_by_tax_id.put(parent_tax_id, parent);
        }
        parent.add(n);
    }

    public DefaultMutableTreeNode getRoot() {
        return this.root;
    }

    public int getSharedAncestorToRootDistance(String referenceOrganismName, String organismName1) throws BiologicalSymbolException {
        DefaultMutableTreeNode n1 = this.nodes_by_name.get(referenceOrganismName);
        DefaultMutableTreeNode n2 = this.nodes_by_name.get(organismName1);
        if (n1 == null) {
            throw new BiologicalSymbolException("Unknown organism", referenceOrganismName, null);
        }
        if (n2 == null) {
            throw new BiologicalSymbolException("Unknown organism", organismName1, null);
        }
        return n1.getPath().length - ((DefaultMutableTreeNode)n1.getSharedAncestor(n2)).getPath().length;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        this.printNode(0, b, this.root);
        return b.toString();
    }

    public String[] getPhylogeny(String organismName) throws BiologicalSymbolException {
        DefaultMutableTreeNode n = this.nodes_by_name.get(organismName);
        if (n == null) {
            throw new BiologicalSymbolException("Unknown organism", organismName, null);
        }
        return Arrays.asList(n.getUserObjectPath()).toArray(new String[0]);
    }

    private void printNode(int leadingSpaces, StringBuffer b, DefaultMutableTreeNode n) {
        int i;
        for (i = 0; i < leadingSpaces; ++i) {
            b.append("-");
        }
        b.append("-").append(n.getUserObject()).append("\n");
        for (i = 0; i < leadingSpaces; ++i) {
            b.append("|");
        }
        b.append("|");
        for (i = 0; i < n.getChildCount(); ++i) {
            this.printNode(leadingSpaces + 1, b, (DefaultMutableTreeNode)n.getChildAt(i));
        }
    }
}

