/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.core;

import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class Source
implements Serializable {
    private String name;
    private String type;
    private String id;

    public Source() {
        this("Undefined", "Undefined", "Undefined");
    }

    public Source(String id, String name, String type) {
        this.id = id;
        this.name = name;
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public static Source getFileAsSource(File f) {
        try {
            return new Source(f.getName(), InetAddress.getLocalHost().getHostName(), "local file");
        }
        catch (UnknownHostException e) {
            return new Source(f.getName(), "Unknown Machine", "local file");
        }
    }

    public static Source getDatabaseEntryAsSource(String databaseName, String entryID) {
        return new Source(entryID, databaseName, "database");
    }

    public static Source getGraphicalToolAsSource(String toolName) {
        try {
            return new Source(toolName, InetAddress.getLocalHost().getHostName(), "graphical tool");
        }
        catch (UnknownHostException e) {
            return new Source(toolName, "Unknown Machine", "graphical tool");
        }
    }

    public static Source getAnalysisAsSource(String analysisName) {
        try {
            return new Source(analysisName, InetAddress.getLocalHost().getHostName(), "analysis");
        }
        catch (UnknownHostException e) {
            return new Source(analysisName, "Unknown Machine", "analysis");
        }
    }

    public String toString() {
        if ("local file".equals(this.type)) {
            return "from " + this.id;
        }
        if ("database".equals(this.type)) {
            return "from entry " + this.id + " in " + this.name + " database";
        }
        if ("graphical tool".equals(this.type)) {
            return "constructed with " + this.name;
        }
        return "calculated by " + this.name;
    }

    public boolean equals(Object o) {
        if (!Source.class.isInstance(o)) {
            return false;
        }
        Source source = (Source)o;
        return source.type.equals(this.type) && source.id.equals(this.id) && source.name.equals(this.name);
    }
}

