/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.core.io;

import fr.unistra.ibmc.paradise.BiologicalSymbolException;
import fr.unistra.ibmc.paradise.core.Location;
import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.MoleculeFactory;
import fr.unistra.ibmc.paradise.core.ParadiseID;
import fr.unistra.ibmc.paradise.core.Source;
import fr.unistra.ibmc.paradise.core.features.Residue3D;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.core.features.StructuralAlignment;
import fr.unistra.ibmc.paradise.core.features.StructuralFeatureFactory;
import fr.unistra.ibmc.paradise.core.features.TertiaryStructure;
import fr.unistra.ibmc.paradise.core.io.AbstractParadiseFileIO;
import fr.unistra.ibmc.paradise.core.io.FileParsingException;
import fr.unistra.ibmc.paradise.tools.component.ProgressMonitor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDBFileIO
extends AbstractParadiseFileIO {
    public static final String[] suffixes = new String[]{"pdb"};
    public static boolean parseProteins;
    private static int LEFT_ALIGN;
    private static int RIGHT_ALIGN;
    protected StructuralFeatureFactory tertiaryFactory;
    protected List<TertiaryStructure> tertiaryStructures;
    private Map<String, Molecule> molecules;

    public PDBFileIO(MoleculeFactory moleculeFactory) {
        super("PDB File parser", moleculeFactory);
    }

    @Override
    public List<Molecule> getMolecules() {
        return new ArrayList<Molecule>(this.molecules.values());
    }

    public static Map<ParadiseID, String> writePDBFile(List<Residue3D> residues, boolean exportNumberingSystem, File f) throws FileNotFoundException, InterruptedException {
        HashMap<ParadiseID, String> mapping = new HashMap<ParadiseID, String>();
        PrintWriter pw = new PrintWriter(new FileOutputStream(f));
        int atomID = 0;
        NumberFormat coordFormat = NumberFormat.getInstance(Locale.ENGLISH);
        coordFormat.setMinimumFractionDigits(3);
        coordFormat.setMaximumFractionDigits(3);
        Location residueLocation = null;
        residues = PDBFileIO.order(residues);
        char lastMoleculeName = 'A';
        TertiaryStructure ts = null;
        for (Residue3D residue : residues) {
            String moleculeLabel;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Molecule m = residue.getMolecules().iterator().next();
            residueLocation = residue.getFullLocation(m);
            String residueName = m.getResidueAt(residueLocation.getStart());
            if (ts == null) {
                ts = residue.getParentFeatures(TertiaryStructure.class).get(0);
            }
            if ((moleculeLabel = ts.getMoleculeLabel(m)) == null) {
                lastMoleculeName = (char)(lastMoleculeName + 1);
                moleculeLabel = "" + lastMoleculeName;
                ts.addMoleculeLabel(moleculeLabel, m);
            }
            mapping.put(residue.getMolecules().iterator().next().getParadiseID(), "" + m.getName().charAt(0));
            for (Residue3D.Atom a : residue.getAtoms()) {
                if (!a.hasCoordinatesFilled()) continue;
                pw.print(PDBFileIO.getPDBField(6, "ATOM", LEFT_ALIGN));
                pw.print(PDBFileIO.getPDBField(5, "" + ++atomID, RIGHT_ALIGN));
                pw.print("  ");
                pw.print(PDBFileIO.getPDBField(4, a.getName().replace('\'', '*'), LEFT_ALIGN));
                pw.print(PDBFileIO.getPDBField(3, residueName, RIGHT_ALIGN));
                pw.print(PDBFileIO.getPDBField(1, " " + moleculeLabel, LEFT_ALIGN));
                if (exportNumberingSystem) {
                    pw.print(PDBFileIO.getPDBField(4, ts.getResidueLabel(residueLocation.getStart(), m), RIGHT_ALIGN));
                } else {
                    pw.print(PDBFileIO.getPDBField(4, "" + residueLocation.getStart(), RIGHT_ALIGN));
                }
                pw.print(PDBFileIO.getPDBField(1, "", LEFT_ALIGN));
                pw.print("   ");
                pw.print(PDBFileIO.getPDBField(8, "" + coordFormat.format(a.getX()), RIGHT_ALIGN));
                pw.print(PDBFileIO.getPDBField(8, "" + coordFormat.format(a.getY()), RIGHT_ALIGN));
                pw.print(PDBFileIO.getPDBField(8, "" + coordFormat.format(a.getZ()), RIGHT_ALIGN));
                pw.println(PDBFileIO.getPDBField(26, "", LEFT_ALIGN));
            }
            if (PDBFileIO.hasNext(residue, residues) && !PDBFileIO.changeMolecule(residue, PDBFileIO.getNext(residue, residues))) continue;
            pw.print(PDBFileIO.getPDBField(6, "TER", LEFT_ALIGN));
            pw.print(PDBFileIO.getPDBField(5, "" + ++atomID, RIGHT_ALIGN));
            pw.print("  ");
            pw.print(PDBFileIO.getPDBField(4, "", LEFT_ALIGN));
            pw.print(PDBFileIO.getPDBField(3, residueName, RIGHT_ALIGN));
            pw.print(PDBFileIO.getPDBField(1, " " + moleculeLabel, LEFT_ALIGN));
            if (exportNumberingSystem) {
                pw.print(PDBFileIO.getPDBField(4, ts.getResidueLabel(residueLocation.getStart(), m), RIGHT_ALIGN));
            } else {
                pw.print(PDBFileIO.getPDBField(4, "" + residueLocation.getStart(), RIGHT_ALIGN));
            }
            pw.print(PDBFileIO.getPDBField(1, "", LEFT_ALIGN));
            pw.print("   ");
            pw.print(PDBFileIO.getPDBField(8, "", RIGHT_ALIGN));
            pw.print(PDBFileIO.getPDBField(8, "", RIGHT_ALIGN));
            pw.print(PDBFileIO.getPDBField(8, "", RIGHT_ALIGN));
            pw.println(PDBFileIO.getPDBField(26, "", LEFT_ALIGN));
        }
        pw.println("END   ");
        pw.close();
        return mapping;
    }

    private static List<Residue3D> order(List<Residue3D> residues) {
        ArrayList<Residue3D> ret = new ArrayList<Residue3D>();
        HashMap lists = new HashMap();
        for (Residue3D res : residues) {
            Molecule m = res.getMolecules().iterator().next();
            if (!lists.containsKey(m)) {
                lists.put(m, new ArrayList());
            }
            PDBFileIO.orderAdd(res, (List)lists.get(m));
        }
        for (List l : lists.values()) {
            for (Residue3D res : l) {
                ret.add(res);
            }
        }
        return ret;
    }

    private static void orderAdd(Residue3D res, List<Residue3D> list) {
        for (Residue3D lr : list) {
            if (res.getAnnotations().get(0).getLocation().getStart() >= lr.getAnnotations().get(0).getLocation().getStart()) continue;
            list.add(list.indexOf(lr), res);
            return;
        }
        list.add(res);
    }

    private static boolean changeMolecule(Residue3D r1, Residue3D r2) {
        return r1.getAnnotations().get(0).getMolecule() != r2.getAnnotations().get(0).getMolecule();
    }

    private static Residue3D getNext(Residue3D residue, List<Residue3D> residues) {
        int index = residues.indexOf(residue);
        return residues.get(index + 1);
    }

    private static boolean hasNext(Residue3D residue, List<Residue3D> residues) {
        int index = residues.indexOf(residue);
        return index != -1 && index != residues.size() - 1;
    }

    public TertiaryStructure getTertiaryStructure() {
        return this.tertiaryStructures.get(0);
    }

    @Override
    public List<TertiaryStructure> getTertiaryStructures() {
        return new ArrayList<TertiaryStructure>(this.tertiaryStructures);
    }

    @Override
    public List<SecondaryStructure> getSecondaryStructures() {
        return new ArrayList<SecondaryStructure>();
    }

    @Override
    public List<StructuralAlignment> getStructuralAlignments() {
        return new ArrayList<StructuralAlignment>();
    }

    @Override
    public void parseFile(File f, ProgressMonitor monitor) throws FileParsingException, InterruptedException {
        this.molecules = new HashMap<String, Molecule>();
        this.tertiaryFactory = this.createStructuralFeatureFactory();
        if (this.tertiaryStructures == null) {
            this.tertiaryStructures = new ArrayList<TertiaryStructure>();
        } else {
            this.tertiaryStructures.clear();
        }
        TertiaryStructure currentTertiaryStructure = null;
        Molecule molecule = null;
        BufferedReader input = null;
        int currentModel = 1;
        try {
            input = new BufferedReader(new FileReader(f));
            String line = null;
            String tag = "fake";
            int nucleic_chain_id = 1;
            int protein_chain_id = 1;
            String molecule_label = "fake";
            int nt_id = 0;
            int aa_id = 0;
            String resId = "fake";
            Residue3D r = null;
            HashMap<String, float[]> atoms = new HashMap<String, float[]>();
            boolean isInsideNucleicAcid = false;
            boolean isInsideProtein = false;
            boolean ter_tag = false;
            while ((line = input.readLine()) != null) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                try {
                    tag = line.substring(0, 6).trim();
                }
                catch (IndexOutOfBoundsException e) {
                    tag = "fake";
                }
                if ((tag.equalsIgnoreCase("ATOM") || tag.equalsIgnoreCase("HETATM")) && !line.substring(17, 21).trim().equals("HOH") && line.substring(21, 22).trim().length() != 0) {
                    String choice;
                    if (!molecule_label.equalsIgnoreCase(line.substring(21, 22).trim()) || ter_tag) {
                        if ((isInsideNucleicAcid || isInsideProtein) && molecule_label.length() > 0) {
                            if (isInsideNucleicAcid) {
                                ++nucleic_chain_id;
                                isInsideNucleicAcid = false;
                            } else {
                                ++protein_chain_id;
                                isInsideProtein = false;
                            }
                        }
                        molecule_label = line.substring(21, 22).trim();
                        nt_id = 0;
                        aa_id = 0;
                        resId = line.substring(22, 27).trim();
                        r = null;
                        if (ter_tag) {
                            ter_tag = false;
                        }
                    } else if (!resId.equalsIgnoreCase(line.substring(22, 27).trim())) {
                        resId = line.substring(22, 27).trim();
                        r = null;
                    }
                    if (line.substring(12, 16).trim().equals("O4*") || line.substring(12, 16).trim().equals("O4'")) {
                        ++nt_id;
                        if (!isInsideNucleicAcid) {
                            isInsideNucleicAcid = true;
                            if (currentModel > 1) {
                                molecule = this.molecules.get(molecule_label);
                            } else {
                                molecule = this.moleculeFactory.createRNA(new ParadiseID(), molecule_label, Source.getFileAsSource(f), "");
                                this.molecules.put(molecule_label, molecule);
                            }
                            if (currentTertiaryStructure == null) {
                                currentTertiaryStructure = this.tertiaryFactory.createTertiaryStructure(new ParadiseID(), "Tertiary Structure", Source.getFileAsSource(f), molecule, new Location());
                                currentTertiaryStructure.setModel(currentModel);
                                this.tertiaryStructures.add(currentTertiaryStructure);
                            } else {
                                molecule.addFeature(currentTertiaryStructure, new Location(1, molecule.getLength()));
                            }
                            currentTertiaryStructure.addMoleculeLabel(molecule_label, molecule);
                        }
                        if (currentModel == 1) {
                            try {
                                molecule.addResidue(line.substring(17, 21).trim());
                            }
                            catch (BiologicalSymbolException e) {
                                choice = null;
                                while (choice == null || choice.length() == 0) {
                                    choice = (String)JOptionPane.showInputDialog(null, "Please choose an unmodified residue", "Unknown Residue " + line.substring(17, 21).trim(), 2, null, new String[]{"A", "U", "G", "C", "?"}, "A");
                                    molecule.addModifiedResidue(line.substring(17, 21).trim(), choice);
                                }
                                molecule.addResidue(choice);
                            }
                        }
                        r = this.tertiaryFactory.createResidue3D(currentTertiaryStructure, molecule, nt_id);
                        for (Map.Entry e : atoms.entrySet()) {
                            r.setAtomCoordinates(((String)e.getKey()).replace('*', '\''), ((float[])e.getValue())[0], ((float[])e.getValue())[1], ((float[])e.getValue())[2]);
                        }
                        atoms.clear();
                        currentTertiaryStructure.addResidueLabel(resId, nt_id, molecule);
                    } else if (line.substring(12, 16).trim().equals("CA") && parseProteins) {
                        ++aa_id;
                        if (!isInsideProtein) {
                            isInsideProtein = true;
                            if (currentModel > 1) {
                                molecule = this.molecules.get(molecule_label);
                            } else {
                                molecule = this.moleculeFactory.createProtein(new ParadiseID(), molecule_label, Source.getFileAsSource(f), "");
                                this.molecules.put(molecule_label, molecule);
                            }
                            if (currentTertiaryStructure == null) {
                                currentTertiaryStructure = this.tertiaryFactory.createTertiaryStructure(new ParadiseID(), ",Tertiary Structure", Source.getFileAsSource(f), molecule, new Location());
                                currentTertiaryStructure.setModel(currentModel);
                                this.tertiaryStructures.add(currentTertiaryStructure);
                            } else {
                                molecule.addFeature(currentTertiaryStructure, new Location(1, molecule.getLength()));
                            }
                            currentTertiaryStructure.addMoleculeLabel(molecule_label, molecule);
                        }
                        if (currentModel == 1) {
                            try {
                                molecule.addResidue(line.substring(17, 21).trim());
                            }
                            catch (BiologicalSymbolException e) {
                                choice = null;
                                while (choice == null || choice.length() == 0) {
                                    choice = (String)JOptionPane.showInputDialog(null, "Please choose an unmodified residue", "Unknown Residue " + line.substring(17, 21).trim(), 2, null, new String[]{"A", "U", "G", "C", "?"}, "A");
                                    molecule.addModifiedResidue(line.substring(17, 21).trim(), choice);
                                }
                                molecule.addResidue(choice);
                            }
                        }
                        r = this.tertiaryFactory.createResidue3D(currentTertiaryStructure, molecule, aa_id);
                        for (Map.Entry e : atoms.entrySet()) {
                            r.setAtomCoordinates((String)e.getKey(), ((float[])e.getValue())[0], ((float[])e.getValue())[1], ((float[])e.getValue())[2]);
                        }
                        atoms.clear();
                        currentTertiaryStructure.addResidueLabel(resId, nt_id, molecule);
                    }
                    float[] coord = new float[]{Float.parseFloat(line.substring(30, 38).trim()), Float.parseFloat(line.substring(38, 46).trim()), Float.parseFloat(line.substring(46, 54).trim())};
                    if (r != null) {
                        r.setAtomCoordinates(line.substring(12, 16).trim().replace('*', '\''), coord[0], coord[1], coord[2]);
                        continue;
                    }
                    atoms.put(line.substring(12, 16).trim(), coord);
                    continue;
                }
                if (tag.equalsIgnoreCase("TER")) {
                    ter_tag = true;
                    continue;
                }
                if (!tag.equalsIgnoreCase("MODEL")) continue;
                currentTertiaryStructure = null;
                currentModel = Integer.parseInt(line.split("\\s+")[1].trim());
            }
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FileParsingException(e.getMessage(), e);
        }
    }

    @Override
    public FileFilter getFileFilter() {
        return new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                for (String suffix : suffixes) {
                    if (!file.getName().endsWith(suffix)) continue;
                    return true;
                }
                return false;
            }

            public String getDescription() {
                return "PDB files";
            }
        };
    }

    private static String getPDBField(int finalsize, String word, int align) {
        StringBuffer field = new StringBuffer();
        if (align == LEFT_ALIGN) {
            field.append(word);
            for (int i = 0; i < finalsize - word.length(); ++i) {
                field.append(" ");
            }
        } else {
            for (int i = 0; i < finalsize - word.length(); ++i) {
                field.append(" ");
            }
            field.append(word);
        }
        return field.toString();
    }

    static {
        LEFT_ALIGN = 0;
        RIGHT_ALIGN = 1;
    }
}

