/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.core.io;

import fr.unistra.ibmc.paradise.BiologicalSymbolException;
import fr.unistra.ibmc.paradise.core.Location;
import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.MoleculeFactory;
import fr.unistra.ibmc.paradise.core.ParadiseID;
import fr.unistra.ibmc.paradise.core.RNA;
import fr.unistra.ibmc.paradise.core.Source;
import fr.unistra.ibmc.paradise.core.features.BaseBaseInteraction;
import fr.unistra.ibmc.paradise.core.features.Helix;
import fr.unistra.ibmc.paradise.core.features.IdentityFeatureFactory;
import fr.unistra.ibmc.paradise.core.features.RNASecondaryStructure;
import fr.unistra.ibmc.paradise.core.features.Residue3D;
import fr.unistra.ibmc.paradise.core.features.ResidueIdentity;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructureDisplay;
import fr.unistra.ibmc.paradise.core.features.StructuralAlignment;
import fr.unistra.ibmc.paradise.core.features.StructuralFeatureFactory;
import fr.unistra.ibmc.paradise.core.features.TertiaryStructure;
import fr.unistra.ibmc.paradise.core.io.AbstractParadiseFileIO;
import fr.unistra.ibmc.paradise.core.io.FastaFileIO;
import fr.unistra.ibmc.paradise.core.io.FileParsingException;
import fr.unistra.ibmc.paradise.core.io.PDBFileIO;
import fr.unistra.ibmc.paradise.tools.ParadiseWorkingSession;
import fr.unistra.ibmc.paradise.tools.component.ProgressMonitor;
import fr.unistra.ibmc.paradise.utils.IOUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RNAMLFileIO
extends AbstractParadiseFileIO {
    public static final String[] suffixes = new String[]{"xml", "rnaml"};
    private List<Molecule> molecules;
    private List<RNASecondaryStructure> secondaryStructures;
    private List<StructuralAlignment> structuralAlignments;
    private List<TertiaryStructure> tertiaryStructures;
    private StructuralFeatureFactory structuralFactory;
    private IdentityFeatureFactory identityFactory;
    private Document document;

    public RNAMLFileIO(MoleculeFactory moleculeFactory) {
        super("RNAML File parser", moleculeFactory);
    }

    @Override
    public void parseFile(File f, ProgressMonitor monitor) throws FileParsingException, InterruptedException {
        this.molecules = new ArrayList<Molecule>();
        this.secondaryStructures = new ArrayList<RNASecondaryStructure>();
        this.structuralAlignments = new ArrayList<StructuralAlignment>();
        this.tertiaryStructures = new ArrayList<TertiaryStructure>();
        this.structuralFactory = this.createStructuralFeatureFactory();
        this.identityFactory = this.createIdentityFeatureFactory();
        try {
            IOUtils.writeToFile(f.getParent() + System.getProperty("file.separator") + "rnaml.dtd", RNAMLFileIO.class.getResourceAsStream("rnaml.dtd"));
            SAXBuilder builder = new SAXBuilder(false);
            this.document = builder.build(f);
            Element root = this.document.getRootElement();
            if (root.getAttributeValue("version") != null && root.getAttributeValue("version").equals("paradise 1.0")) {
                ParadiseRnaMLParser1_0 p = new ParadiseRnaMLParser1_0();
                p.parse(f, root);
                this.molecules.addAll(p.molecules.values());
                this.secondaryStructures.addAll(p.secondaryStructures.values());
                this.tertiaryStructures.addAll(p.tertiaryStructures.values());
                this.structuralAlignments.addAll(p.structuralAlignments.values());
            } else if (root.getAttributeValue("version") != null && root.getAttributeValue("version").equals("paradise 2.0")) {
                ParadiseRnaMLParser2_0 p = new ParadiseRnaMLParser2_0();
                p.parse(Source.getFileAsSource(f), root);
                this.molecules.addAll(p.molecules.values());
                this.secondaryStructures.addAll(p.secondaryStructures.values());
                this.tertiaryStructures.addAll(p.tertiaryStructures.values());
                this.structuralAlignments.addAll(p.structuralAlignments.values());
            } else {
                RnaMLParser p = new RnaMLParser();
                p.parse(f, root, monitor);
                this.molecules.addAll(p.molecules.values());
                this.secondaryStructures.addAll(p.secondaryStructures.values());
            }
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FileParsingException(e);
        }
    }

    @Override
    public FileFilter getFileFilter() {
        return new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                for (String suffix : suffixes) {
                    if (!file.getName().endsWith(suffix)) continue;
                    return true;
                }
                return false;
            }

            public String getDescription() {
                return "RNAML files";
            }
        };
    }

    @Override
    public List<SecondaryStructure> getSecondaryStructures() {
        return new ArrayList<SecondaryStructure>(this.secondaryStructures);
    }

    @Override
    public List<StructuralAlignment> getStructuralAlignments() {
        return new ArrayList<StructuralAlignment>(this.structuralAlignments);
    }

    @Override
    public List<TertiaryStructure> getTertiaryStructures() {
        return new ArrayList<TertiaryStructure>(this.tertiaryStructures);
    }

    @Override
    public List<Molecule> getMolecules() {
        return new ArrayList<Molecule>(this.molecules);
    }

    private class ParadiseRnaMLParser2_0 {
        private int ssCount;
        private int tsCount;
        private int alignmentCount;
        private HashMap<Integer, ResidueIdentity> columnToResidueIdentity;
        private Map<String, Molecule> molecules;
        private Map<String, RNASecondaryStructure> secondaryStructures = new HashMap<String, RNASecondaryStructure>();
        private Map<String, StructuralAlignment> structuralAlignments = new HashMap<String, StructuralAlignment>();
        private Map<String, TertiaryStructure> tertiaryStructures = new HashMap<String, TertiaryStructure>();

        private ParadiseRnaMLParser2_0() {
            this.molecules = new HashMap<String, Molecule>();
        }

        private void parse(Source source, Element root) throws BiologicalSymbolException, FileParsingException, IOException, JDOMException, InterruptedException {
            this.traverseJDOMElement(source, root);
            for (RNASecondaryStructure ss : this.secondaryStructures.values()) {
                for (Molecule m : ss.getMolecules()) {
                    Location single_strands_location = new Location(1, m.getLength());
                    for (Helix h : ss.getHelices()) {
                        Location helixLocation = h.getFullLocation(m);
                        if (helixLocation == null) continue;
                        single_strands_location.remove(helixLocation);
                    }
                    int sstrand_count = 0;
                    int[] boundaries = single_strands_location.getBoundaries();
                    for (int i = 0; i < boundaries.length; i += 2) {
                        RNAMLFileIO.this.structuralFactory.createSingleStrand("SS" + sstrand_count++, ss, m, new Location(boundaries[i], boundaries[i + 1]));
                    }
                }
            }
        }

        private void traverseJDOMElement(Source source, Element node) throws BiologicalSymbolException, FileParsingException, InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Element child2 = null;
            String name = null;
            for (Element child2 : node.getChildren()) {
                Object sequence;
                name = child2.getName();
                if (name.equals("molecule")) {
                    Element seqdata;
                    String moleculeSequence = "";
                    String moleculeName = "";
                    Element identity = child2.getChild("identity");
                    String type = "rna";
                    Attribute _type = child2.getAttribute("type");
                    if (_type != null) {
                        type = _type.getValue();
                    }
                    if (identity != null) {
                        Element nameEl = identity.getChild("name");
                        String string = moleculeName = nameEl != null ? nameEl.getValue() : "rna" + this.molecules.size();
                    }
                    if ((sequence = child2.getChild("sequence")) != null && (seqdata = sequence.getChild("seq-data")) != null) {
                        moleculeSequence = seqdata.getValue().trim();
                    }
                    if ("rna".equals(type)) {
                        this.molecules.put(child2.getAttributeValue("id"), RNAMLFileIO.this.moleculeFactory.createRNA(new ParadiseID(), moleculeName, source, moleculeSequence));
                    } else if ("protein".equals(type)) {
                        this.molecules.put(child2.getAttributeValue("id"), RNAMLFileIO.this.moleculeFactory.createProtein(new ParadiseID(), moleculeName, source, moleculeSequence));
                    }
                } else if (name.equals("tertiary-structure")) {
                    TertiaryStructure ts = this.tertiaryStructures.get(child2.getAttributeValue("id"));
                    if (ts == null) {
                        ts = RNAMLFileIO.this.structuralFactory.createTertiaryStructure(new ParadiseID(), "TS" + ++this.tsCount, source);
                        this.tertiaryStructures.put(child2.getAttributeValue("id"), ts);
                    }
                    ts.setSource(source);
                    ts.setName(child2.getAttributeValue("name"));
                    for (Object o : child2.getChildren("base")) {
                        Element base = (Element)o;
                        int position = Integer.parseInt(base.getAttributeValue("base-id"));
                        Residue3D r = RNAMLFileIO.this.structuralFactory.createResidue3D(ts, this.molecules.get(base.getAttributeValue("molecule-id")), position);
                        for (Object e : base.getChildren("atom")) {
                            Element atom = (Element)e;
                            r.setAtomCoordinates(atom.getAttributeValue("type"), Float.parseFloat(atom.getAttributeValue("x")), Float.parseFloat(atom.getAttributeValue("y")), Float.parseFloat(atom.getAttributeValue("z")));
                        }
                    }
                } else if (name.equals("structure-annotation")) {
                    Molecule m;
                    RNASecondaryStructure ss = this.secondaryStructures.get(child2.getAttributeValue("id"));
                    if (ss == null) {
                        ss = RNAMLFileIO.this.structuralFactory.createRNASecondaryStructure(new ParadiseID(), "SS" + ++this.ssCount, source);
                        this.secondaryStructures.put(child2.getAttributeValue("id"), ss);
                    }
                    ss.setSource(source);
                    ss.setName(child2.getAttributeValue("name"));
                    for (Object e : child2.getChildren("base-pair")) {
                        Element bp = (Element)e;
                        BaseBaseInteraction interaction = null;
                        interaction = bp.getAttributeValue("molecule1-id").equals(bp.getAttributeValue("molecule2-id")) ? RNAMLFileIO.this.structuralFactory.createBaseBaseInteraction(bp.getAttributeValue("edge1").toCharArray()[0], bp.getAttributeValue("edge2").toCharArray()[0], bp.getAttributeValue("orientation").toCharArray()[0], 1, ss, this.molecules.get(bp.getAttributeValue("molecule1-id")), new Location(new Location(Integer.parseInt(bp.getAttributeValue("base1-id"))), new Location(Integer.parseInt(bp.getAttributeValue("base2-id"))))) : RNAMLFileIO.this.structuralFactory.createBaseBaseInteraction(bp.getAttributeValue("edge1").toCharArray()[0], bp.getAttributeValue("edge2").toCharArray()[0], bp.getAttributeValue("orientation").toCharArray()[0], 1, ss, this.molecules.get(bp.getAttributeValue("molecule1-id")), new Location(Integer.parseInt(bp.getAttributeValue("base1-id")), Integer.parseInt(bp.getAttributeValue("base1-id"))), this.molecules.get(bp.getAttributeValue("molecule2-id")), new Location(Integer.parseInt(bp.getAttributeValue("base2-id")), Integer.parseInt(bp.getAttributeValue("base2-id"))));
                        for (Object _e : bp.getChildren("atoms-interaction")) {
                            Element atomInteraction = (Element)_e;
                            if (atomInteraction.getAttributeValue("molecule1-id").equals(atomInteraction.getAttributeValue("molecule2-id"))) {
                                RNAMLFileIO.this.structuralFactory.createAtomAtomInteraction(interaction, atomInteraction.getAttributeValue("atom1-type"), atomInteraction.getAttributeValue("atom2-type"), atomInteraction.getAttributeValue("type").toCharArray()[0], this.molecules.get(atomInteraction.getAttributeValue("molecule1-id")), new Location(new Location(Integer.parseInt(atomInteraction.getAttributeValue("base1-id"))), new Location(Integer.parseInt(atomInteraction.getAttributeValue("base2-id")))));
                                continue;
                            }
                            RNAMLFileIO.this.structuralFactory.createAtomAtomInteraction(interaction, atomInteraction.getAttributeValue("atom1-type"), atomInteraction.getAttributeValue("atom2-type"), atomInteraction.getAttributeValue("type").toCharArray()[0], this.molecules.get(atomInteraction.getAttributeValue("molecule1-id")), new Location(Integer.parseInt(atomInteraction.getAttributeValue("base1-id"))), this.molecules.get(atomInteraction.getAttributeValue("molecule2-id")), new Location(Integer.parseInt(atomInteraction.getAttributeValue("base2-id"))));
                        }
                    }
                    for (Object e : child2.getChildren("atoms-interaction")) {
                        Element atomInteraction = (Element)e;
                        if (atomInteraction.getAttributeValue("molecule1-id").equals(atomInteraction.getAttributeValue("molecule2-id"))) {
                            RNAMLFileIO.this.structuralFactory.createAtomAtomInteraction(ss, atomInteraction.getAttributeValue("atom1-type"), atomInteraction.getAttributeValue("atom2-type"), atomInteraction.getAttributeValue("type").toCharArray()[0], this.molecules.get(atomInteraction.getAttributeValue("molecule1-id")), new Location(new Location(Integer.parseInt(atomInteraction.getAttributeValue("base1-id"))), new Location(Integer.parseInt(atomInteraction.getAttributeValue("base2-id")))));
                            continue;
                        }
                        RNAMLFileIO.this.structuralFactory.createAtomAtomInteraction(ss, atomInteraction.getAttributeValue("atom1-type"), atomInteraction.getAttributeValue("atom2-type"), atomInteraction.getAttributeValue("type").toCharArray()[0], this.molecules.get(atomInteraction.getAttributeValue("molecule1-id")), new Location(Integer.parseInt(atomInteraction.getAttributeValue("base1-id")), Integer.parseInt(atomInteraction.getAttributeValue("base1-id"))), this.molecules.get(atomInteraction.getAttributeValue("molecule2-id")), new Location(Integer.parseInt(atomInteraction.getAttributeValue("base2-id")), Integer.parseInt(atomInteraction.getAttributeValue("base2-id"))));
                    }
                    for (Object e : child2.getChildren("helix")) {
                        Element helixElement = (Element)e;
                        int _5end = Integer.parseInt(helixElement.getAttributeValue("base5-id"));
                        int _3end = Integer.parseInt(helixElement.getAttributeValue("base3-id"));
                        int length = Integer.parseInt(helixElement.getAttributeValue("length"));
                        Helix h = null;
                        h = helixElement.getAttributeValue("molecule1-id").equals(helixElement.getAttributeValue("molecule2-id")) ? RNAMLFileIO.this.structuralFactory.createHelix(helixElement.getAttributeValue("id"), ss, this.molecules.get(helixElement.getAttributeValue("molecule1-id")), new Location(new Location(_5end, _5end + length - 1), new Location(_3end - length + 1, _3end))) : RNAMLFileIO.this.structuralFactory.createHelix(helixElement.getAttributeValue("id"), ss, this.molecules.get(helixElement.getAttributeValue("molecule1-id")), new Location(_5end, _5end + length - 1), this.molecules.get(helixElement.getAttributeValue("molecule2-id")), new Location(_3end - length + 1, _3end));
                        if (h == null) continue;
                        for (Object o : helixElement.getChildren("base-pair")) {
                            Element bp = (Element)o;
                            BaseBaseInteraction interaction = null;
                            interaction = bp.getAttributeValue("molecule1-id").equals(bp.getAttributeValue("molecule2-id")) ? RNAMLFileIO.this.structuralFactory.createBaseBaseInteraction(bp.getAttributeValue("edge1").toCharArray()[0], bp.getAttributeValue("edge2").toCharArray()[0], bp.getAttributeValue("orientation").toCharArray()[0], 1, h, this.molecules.get(bp.getAttributeValue("molecule1-id")), new Location(new Location(Integer.parseInt(bp.getAttributeValue("base1-id"))), new Location(Integer.parseInt(bp.getAttributeValue("base2-id"))))) : RNAMLFileIO.this.structuralFactory.createBaseBaseInteraction(bp.getAttributeValue("edge1").toCharArray()[0], bp.getAttributeValue("edge2").toCharArray()[0], bp.getAttributeValue("orientation").toCharArray()[0], 1, h, this.molecules.get(bp.getAttributeValue("molecule1-id")), new Location(Integer.parseInt(bp.getAttributeValue("base1-id"))), this.molecules.get(bp.getAttributeValue("molecule2-id")), new Location(Integer.parseInt(bp.getAttributeValue("base2-id"))));
                            for (Object _e : bp.getChildren("atoms-interaction")) {
                                Element atomInteraction = (Element)_e;
                                if (atomInteraction.getAttributeValue("molecule1-id").equals(atomInteraction.getAttributeValue("molecule2-id"))) {
                                    RNAMLFileIO.this.structuralFactory.createAtomAtomInteraction(interaction, atomInteraction.getAttributeValue("atom1-type"), atomInteraction.getAttributeValue("atom2-type"), atomInteraction.getAttributeValue("type").toCharArray()[0], this.molecules.get(atomInteraction.getAttributeValue("molecule1-id")), new Location(new Location(Integer.parseInt(atomInteraction.getAttributeValue("base1-id"))), new Location(Integer.parseInt(atomInteraction.getAttributeValue("base2-id")))));
                                    continue;
                                }
                                RNAMLFileIO.this.structuralFactory.createAtomAtomInteraction(interaction, atomInteraction.getAttributeValue("atom1-type"), atomInteraction.getAttributeValue("atom2-type"), atomInteraction.getAttributeValue("type").toCharArray()[0], this.molecules.get(atomInteraction.getAttributeValue("molecule1-id")), new Location(Integer.parseInt(atomInteraction.getAttributeValue("base1-id"))), this.molecules.get(atomInteraction.getAttributeValue("molecule2-id")), new Location(Integer.parseInt(atomInteraction.getAttributeValue("base2-id"))));
                            }
                        }
                    }
                    for (Object e : child2.getChildren("secondary-structure-display")) {
                        Element displayElement = (Element)e;
                        Molecule m2 = ss.getMolecules().iterator().next();
                        SecondaryStructureDisplay display = RNAMLFileIO.this.structuralFactory.createSecondaryStructureDisplay(ss, m2, ss.getFullLocation(m2));
                        for (Object o : displayElement.getChildren("ss-base-coord")) {
                            Element coord = (Element)o;
                            RNAMLFileIO.this.structuralFactory.createResidue2D(display, Float.parseFloat(coord.getAttributeValue("x")), Float.parseFloat(coord.getAttributeValue("y")), this.molecules.get(coord.getAttributeValue("molecule-id")), Integer.parseInt(coord.getAttributeValue("base-id")));
                        }
                    }
                    if (child2.getAttribute("alignment-id") != null) {
                        StructuralAlignment al = this.structuralAlignments.get(child2.getAttributeValue("alignment-id"));
                        try {
                            if (al == null) {
                                m = this.molecules.get(((Element)XPath.selectSingleNode((Object)RNAMLFileIO.this.document, (String)("/rnaml//alignment[@id=" + child2.getAttributeValue("alignment-id") + "]"))).getAttributeValue("molecule-ids").split(" ")[0]);
                                al = RNAMLFileIO.this.identityFactory.createStructuralAligment(new ParadiseID(), "Alignment" + ++this.alignmentCount, source, m, new Location());
                                this.structuralAlignments.put(child2.getAttributeValue("alignment-id"), al);
                            }
                            al.linkSecondaryStructure(ss);
                        }
                        catch (JDOMException e) {
                            throw new FileParsingException(e);
                        }
                    }
                    if (child2.getAttribute("tertiary-structure-id") != null) {
                        TertiaryStructure ts = this.tertiaryStructures.get(child2.getAttributeValue("tertiary-structure-id"));
                        try {
                            if (ts == null) {
                                m = this.molecules.get(((Element)XPath.selectSingleNode((Object)RNAMLFileIO.this.document, (String)("/rnaml//tertiary-structure[@id=" + child2.getAttributeValue("tertiary-structure-id") + "]"))).getAttributeValue("molecule-ids").split(" ")[0]);
                                ts = RNAMLFileIO.this.structuralFactory.createTertiaryStructure(new ParadiseID(), "TS" + ++this.tsCount, source, m, new Location());
                                this.tertiaryStructures.put(child2.getAttributeValue("tertiary-structure-id"), ts);
                            }
                            if (ss.annotatesNothing()) {
                                for (Molecule m3 : ts.getMolecules()) {
                                    m3.addFeature(ss, new Location(ts.getFullLocation(m3)));
                                }
                            }
                            ts.linkSecondaryStructure(ss);
                        }
                        catch (JDOMException e) {
                            throw new FileParsingException(e);
                        }
                    }
                } else if (child2.getName().equals("alignment")) {
                    StructuralAlignment alignment = this.structuralAlignments.get(child2.getAttributeValue("id"));
                    if (alignment == null) {
                        alignment = RNAMLFileIO.this.identityFactory.createStructuralAligment(new ParadiseID(), "Alignment" + ++this.alignmentCount, source);
                        this.structuralAlignments.put(child2.getAttributeValue("id"), alignment);
                    }
                    alignment.setName(child2.getAttributeValue("name"));
                    alignment.setSource(source);
                    this.columnToResidueIdentity = new HashMap();
                    for (Object o : child2.getChildren("ali-sequence")) {
                        Element c = (Element)o;
                        Molecule m = this.molecules.get(c.getAttributeValue("molecule-id"));
                        sequence = c.getValue();
                        char[] cs = ((String)sequence).toCharArray();
                        int positionInSequence = 0;
                        for (int j = 0; j < cs.length; ++j) {
                            if (cs[j] == '-') continue;
                            ++positionInSequence;
                            ResidueIdentity ri = this.columnToResidueIdentity.get(j);
                            if (ri != null) {
                                m.addFeature(ri, new Location(positionInSequence));
                                continue;
                            }
                            this.columnToResidueIdentity.put(j, RNAMLFileIO.this.identityFactory.createResidueIdentity(alignment, m, new Location(positionInSequence)));
                        }
                        if (c.getAttribute("structural-annotation-id") == null) continue;
                        RNASecondaryStructure _ss = this.secondaryStructures.get(c.getAttributeValue("structure-annotation-id"));
                        if (_ss == null) {
                            try {
                                Molecule _m = this.molecules.get(((Element)XPath.selectSingleNode((Object)RNAMLFileIO.this.document, (String)("/rnaml//structural-annotation[@id=" + child2.getAttributeValue("structural-annotation-id") + "]"))).getAttributeValue("molecule-ids").split(" ")[0]);
                                _ss = RNAMLFileIO.this.structuralFactory.createRNASecondaryStructure(new ParadiseID(), "SS" + ++this.ssCount, source, _m, new Location());
                                this.secondaryStructures.put(c.getAttributeValue("structural-annotation-id"), _ss);
                            }
                            catch (JDOMException e) {
                                throw new FileParsingException(e);
                            }
                        }
                        alignment.linkSecondaryStructure(_ss);
                    }
                    if (child2.getAttribute("structure-annotation-id") != null) {
                        RNASecondaryStructure _ss = this.secondaryStructures.get(child2.getAttributeValue("structure-annotation-id"));
                        _ss.linkStructuralAlignment(alignment);
                    }
                }
                this.traverseJDOMElement(source, child2);
            }
        }
    }

    private class ParadiseRnaMLParser1_0 {
        private int ssCount;
        private int tsCount;
        private RNA currentRNA;
        private boolean interMolecular;
        private HashMap<Integer, ResidueIdentity> columnToResidueIdentity;
        private StructuralAlignment currentStructuralAlignment;
        private TertiaryStructure currentTertiaryStructure;
        private RNASecondaryStructure currentSecondaryStructure;
        private SecondaryStructureDisplay currentSecondaryStructureDisplay;
        private Map<String, Molecule> molecules;
        private Map<String, RNASecondaryStructure> secondaryStructures = new HashMap<String, RNASecondaryStructure>();
        private Map<String, StructuralAlignment> structuralAlignments = new HashMap<String, StructuralAlignment>();
        private Map<String, TertiaryStructure> tertiaryStructures = new HashMap<String, TertiaryStructure>();

        private ParadiseRnaMLParser1_0() {
            this.molecules = new HashMap<String, Molecule>();
        }

        private void parse(File rnamlFile, Element root) throws BiologicalSymbolException, FileParsingException, IOException, JDOMException, InterruptedException {
            this.traverseJDOMElement(rnamlFile, root);
            for (RNASecondaryStructure ss : this.secondaryStructures.values()) {
                for (Molecule m : ss.getMolecules()) {
                    Location single_strands_location = new Location(1, m.getLength());
                    for (Helix h : ss.getHelices()) {
                        Location helixLocation = h.getFullLocation(m);
                        if (helixLocation == null) continue;
                        single_strands_location.remove(helixLocation);
                    }
                    int sstrand_count = 0;
                    int[] boundaries = single_strands_location.getBoundaries();
                    for (int i = 0; i < boundaries.length; i += 2) {
                        RNAMLFileIO.this.structuralFactory.createSingleStrand("SS" + sstrand_count++, ss, m, new Location(boundaries[i], boundaries[i + 1]));
                    }
                }
            }
        }

        private void traverseJDOMElement(File rnamlFile, Element node) throws BiologicalSymbolException, FileParsingException, InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Element child2 = null;
            String name = null;
            for (Element child2 : node.getChildren()) {
                name = child2.getName();
                if (name.equals("molecule")) {
                    Element seqdata;
                    Element sequence;
                    String rnaSequence = "";
                    String moleculeName = "";
                    Element identity = child2.getChild("identity");
                    if (identity != null) {
                        Element nameEl = identity.getChild("name");
                        String string = moleculeName = nameEl != null ? nameEl.getValue() : "" + this.molecules.size();
                    }
                    if ((sequence = child2.getChild("sequence")) != null && (seqdata = sequence.getChild("seq-data")) != null) {
                        rnaSequence = seqdata.getValue().trim();
                    }
                    this.currentRNA = RNAMLFileIO.this.moleculeFactory.createRNA(new ParadiseID(), moleculeName, Source.getFileAsSource(rnamlFile), rnaSequence);
                    this.molecules.put(child2.getAttributeValue("id"), this.currentRNA);
                } else if (name.equals("tertiary-structure")) {
                    this.currentTertiaryStructure = this.tertiaryStructures.get(new ParadiseID());
                    if (this.currentTertiaryStructure == null) {
                        this.currentTertiaryStructure = RNAMLFileIO.this.structuralFactory.createTertiaryStructure(new ParadiseID(), "Tertiary Structure" + ++this.tsCount, Source.getFileAsSource(rnamlFile));
                        this.tertiaryStructures.put(child2.getAttributeValue("id"), this.currentTertiaryStructure);
                    }
                    for (Object o : child2.getChildren("base")) {
                        Element base = (Element)o;
                        int position = Integer.parseInt(base.getAttributeValue("base-id"));
                        Residue3D r = RNAMLFileIO.this.structuralFactory.createResidue3D(this.currentTertiaryStructure, this.currentRNA, position);
                        for (Object e : base.getChildren("atom")) {
                            Element atom = (Element)e;
                            r.setAtomCoordinates(atom.getAttributeValue("type"), Float.parseFloat(atom.getAttributeValue("x")), Float.parseFloat(atom.getAttributeValue("y")), Float.parseFloat(atom.getAttributeValue("z")));
                        }
                    }
                } else if (name.equals("structure-annotation")) {
                    Element atomInteraction;
                    Element bp;
                    StructuralAlignment al;
                    if (child2.getAttribute("alignment-id") != null && (al = this.structuralAlignments.get(child2.getAttributeValue("alignment-id"))) == null) {
                        al = RNAMLFileIO.this.identityFactory.createStructuralAligment(new ParadiseID(), "?", Source.getFileAsSource(rnamlFile), this.currentRNA, new Location());
                        this.structuralAlignments.put(child2.getAttributeValue("id"), al);
                    }
                    if (this.interMolecular) {
                        this.currentSecondaryStructure = this.secondaryStructures.get(child2.getAttributeValue("id"));
                        for (Object e : child2.getChildren("base-pair")) {
                            bp = (Element)e;
                            RNAMLFileIO.this.structuralFactory.createBaseBaseInteraction(bp.getAttributeValue("edge1").toCharArray()[0], bp.getAttributeValue("edge2").toCharArray()[0], bp.getAttributeValue("orientation").toCharArray()[0], 1, this.currentSecondaryStructure, this.molecules.get(new ParadiseID()), new Location(Integer.parseInt(bp.getAttributeValue("base1-id"))), this.molecules.get(new ParadiseID()), new Location(Integer.parseInt(bp.getAttributeValue("base2-id"))));
                        }
                        for (Object e : child2.getChildren("atoms-interaction")) {
                            atomInteraction = (Element)e;
                            RNAMLFileIO.this.structuralFactory.createAtomAtomInteraction(this.currentSecondaryStructure, atomInteraction.getAttributeValue("atom1-type"), atomInteraction.getAttributeValue("atom2-type"), atomInteraction.getAttributeValue("type").toCharArray()[0], this.molecules.get(new ParadiseID()), new Location(Integer.parseInt(atomInteraction.getAttributeValue("base1-id"))), this.molecules.get(new ParadiseID()), new Location(Integer.parseInt(atomInteraction.getAttributeValue("base2-id"))));
                        }
                    } else {
                        this.currentSecondaryStructure = this.secondaryStructures.get(child2.getAttributeValue("id"));
                        if (this.currentSecondaryStructure == null) {
                            this.currentSecondaryStructure = RNAMLFileIO.this.structuralFactory.createRNASecondaryStructure(new ParadiseID(), "?", Source.getFileAsSource(rnamlFile), this.currentRNA, new Location());
                            this.secondaryStructures.put(child2.getAttributeValue("id"), this.currentSecondaryStructure);
                        }
                        for (Object e : child2.getChildren("base-pair")) {
                            bp = (Element)e;
                            RNAMLFileIO.this.structuralFactory.createBaseBaseInteraction(bp.getAttributeValue("edge5").toCharArray()[0], bp.getAttributeValue("edge3").toCharArray()[0], bp.getAttributeValue("orientation").toCharArray()[0], 1, this.currentSecondaryStructure, (Molecule)this.currentRNA, new Location(Integer.parseInt(bp.getAttributeValue("base5-id")), Integer.parseInt(bp.getAttributeValue("base3-id"))));
                        }
                        for (Object e : child2.getChildren("atoms-interaction")) {
                            atomInteraction = (Element)e;
                            RNAMLFileIO.this.structuralFactory.createAtomAtomInteraction(this.currentSecondaryStructure, atomInteraction.getAttributeValue("atom1-type"), atomInteraction.getAttributeValue("atom2-type"), atomInteraction.getAttributeValue("type").toCharArray()[0], (Molecule)this.currentRNA, new Location(Integer.parseInt(atomInteraction.getAttributeValue("base1-id")), Integer.parseInt(atomInteraction.getAttributeValue("base2-id"))));
                        }
                        if (child2.getAttributeValue("tertiary-structure-id") != null) {
                            TertiaryStructure ts = this.tertiaryStructures.get(child2.getAttributeValue("tertiary-structure-id"));
                            if (ts == null) {
                                ts = RNAMLFileIO.this.structuralFactory.createTertiaryStructure(new ParadiseID(), "TS" + ++this.tsCount, Source.getFileAsSource(rnamlFile), this.currentRNA, new Location());
                                this.tertiaryStructures.put(child2.getAttributeValue("id"), ts);
                            }
                            ts.linkSecondaryStructure(this.currentSecondaryStructure);
                        }
                    }
                } else if (name.equals("helix")) {
                    Element atomInteraction;
                    BaseBaseInteraction interaction;
                    Element bp;
                    Helix h;
                    int length;
                    int _3end;
                    int _5end;
                    if (this.interMolecular) {
                        _5end = Integer.parseInt(child2.getAttributeValue("base5-id"));
                        _3end = Integer.parseInt(child2.getAttributeValue("base3-id"));
                        length = Integer.parseInt(child2.getAttributeValue("length"));
                        h = RNAMLFileIO.this.structuralFactory.createHelix(child2.getAttributeValue("id"), this.currentSecondaryStructure, this.molecules.get(new ParadiseID()), new Location(_5end, _5end + length - 1), this.molecules.get(new ParadiseID()), new Location(_3end - length + 1, _3end));
                        if (h != null) {
                            for (Object o : child2.getChildren("base-pair")) {
                                bp = (Element)o;
                                interaction = RNAMLFileIO.this.structuralFactory.createBaseBaseInteraction(bp.getAttributeValue("edge1").toCharArray()[0], bp.getAttributeValue("edge2").toCharArray()[0], bp.getAttributeValue("orientation").toCharArray()[0], 1, this.currentSecondaryStructure, this.molecules.get(new ParadiseID()), new Location(Integer.parseInt(bp.getAttributeValue("base1-id"))), this.molecules.get(new ParadiseID()), new Location(Integer.parseInt(bp.getAttributeValue("base2-id"))));
                                for (Object e : bp.getChildren("atoms-interaction")) {
                                    atomInteraction = (Element)e;
                                    RNAMLFileIO.this.structuralFactory.createAtomAtomInteraction(interaction, atomInteraction.getAttributeValue("atom1-type"), atomInteraction.getAttributeValue("atom2-type"), atomInteraction.getAttributeValue("type").toCharArray()[0], this.molecules.get(new ParadiseID()), new Location(Integer.parseInt(atomInteraction.getAttributeValue("base1-id"))), this.molecules.get(new ParadiseID()), new Location(Integer.parseInt(atomInteraction.getAttributeValue("base2-id"))));
                                }
                            }
                        }
                    } else {
                        _5end = Integer.parseInt(child2.getAttributeValue("base5-id"));
                        _3end = Integer.parseInt(child2.getAttributeValue("base3-id"));
                        length = Integer.parseInt(child2.getAttributeValue("length"));
                        h = RNAMLFileIO.this.structuralFactory.createHelix(child2.getAttributeValue("id"), this.currentSecondaryStructure, this.currentRNA, new Location(new Location(_5end, _5end + length - 1), new Location(_3end - length + 1, _3end)));
                        for (Object o : child2.getChildren("base-pair")) {
                            bp = (Element)o;
                            interaction = RNAMLFileIO.this.structuralFactory.createBaseBaseInteraction(bp.getAttributeValue("edge5").toCharArray()[0], bp.getAttributeValue("edge3").toCharArray()[0], bp.getAttributeValue("orientation").toCharArray()[0], 1, this.currentSecondaryStructure, (Molecule)this.currentRNA, new Location(new Location(Integer.parseInt(bp.getAttributeValue("base5-id"))), new Location(Integer.parseInt(bp.getAttributeValue("base3-id")))));
                            for (Object e : bp.getChildren("atoms-interaction")) {
                                atomInteraction = (Element)e;
                                RNAMLFileIO.this.structuralFactory.createAtomAtomInteraction(interaction, atomInteraction.getAttributeValue("atom1-type"), atomInteraction.getAttributeValue("atom2-type"), atomInteraction.getAttributeValue("type").toCharArray()[0], (Molecule)this.currentRNA, new Location(Integer.parseInt(atomInteraction.getAttributeValue("base1-id")), Integer.parseInt(atomInteraction.getAttributeValue("base2-id"))));
                            }
                        }
                    }
                } else if (name.equals("inter-molecular-interactions")) {
                    this.interMolecular = true;
                } else if (name.equals("secondary-structure-display")) {
                    this.currentSecondaryStructureDisplay = RNAMLFileIO.this.structuralFactory.createSecondaryStructureDisplay(this.currentSecondaryStructure, this.currentRNA, this.currentSecondaryStructure.getFullLocation(this.currentRNA));
                    for (Object o : child2.getChildren("ss-base-coord")) {
                        Element coord = (Element)o;
                        RNAMLFileIO.this.structuralFactory.createResidue2D(this.currentSecondaryStructureDisplay, Float.parseFloat(coord.getAttributeValue("x")), Float.parseFloat(coord.getAttributeValue("y")), this.currentRNA, Integer.parseInt(coord.getAttributeValue("base-id")));
                    }
                } else if (child2.getName().equals("alignment")) {
                    this.currentStructuralAlignment = this.structuralAlignments.get(child2.getAttributeValue("id"));
                    if (this.currentStructuralAlignment == null) {
                        this.currentStructuralAlignment = RNAMLFileIO.this.identityFactory.createStructuralAligment(new ParadiseID(), "Structural Alignment", Source.getFileAsSource(rnamlFile));
                        this.structuralAlignments.put(child2.getAttributeValue("id"), this.currentStructuralAlignment);
                    }
                    this.columnToResidueIdentity = new HashMap();
                    for (Object o : child2.getChildren("ali-sequence")) {
                        Element c = (Element)o;
                        Molecule m = this.molecules.get(c.getAttributeValue("molecule-id"));
                        String sequence = c.getValue();
                        char[] cs = sequence.toCharArray();
                        int positionInSequence = 0;
                        for (int j = 0; j < cs.length; ++j) {
                            if (cs[j] == '-') continue;
                            ++positionInSequence;
                            ResidueIdentity ri = this.columnToResidueIdentity.get(j);
                            if (ri != null) {
                                m.addFeature(ri, new Location(positionInSequence));
                                continue;
                            }
                            this.columnToResidueIdentity.put(j, RNAMLFileIO.this.identityFactory.createResidueIdentity(this.currentStructuralAlignment, m, new Location(positionInSequence)));
                        }
                        if (c.getAttribute("structural-annotation-id") == null) continue;
                        RNASecondaryStructure _ss = this.secondaryStructures.get(c.getAttributeValue("structural-annotation-id"));
                        if (_ss == null) {
                            _ss = RNAMLFileIO.this.structuralFactory.createRNASecondaryStructure(new ParadiseID(), "SS" + ++this.ssCount, Source.getFileAsSource(rnamlFile), this.currentRNA, new Location());
                            this.secondaryStructures.put(child2.getAttributeValue("id"), _ss);
                        }
                        this.currentStructuralAlignment.linkSecondaryStructure(_ss);
                    }
                    if (child2.getAttribute("structure-annotation-id") != null) {
                        RNASecondaryStructure _ss = this.secondaryStructures.get(child2.getAttributeValue("structure-annotation-id"));
                        _ss.linkStructuralAlignment(this.currentStructuralAlignment);
                    }
                }
                this.traverseJDOMElement(rnamlFile, child2);
            }
        }
    }

    private class RnaMLParser {
        private int helixCount;
        private int sstrandCount;
        private int alignmentCount;
        private int modelCount;
        private int rnaSequenceCount;
        private int currentResidue = 1;
        private RNASecondaryStructure currentRNASecondaryStructure;
        private SecondaryStructureDisplay currentSecondaryStructureDisplay;
        private RNA currentRNA;
        private boolean interactions;
        private HashMap<Integer, ResidueIdentity> columnToResidueIdentity;
        private StructuralAlignment structuralAlignment;
        private Map<Integer, RNASecondaryStructure> secondaryStructures = new HashMap<Integer, RNASecondaryStructure>();
        private Map<Integer, Molecule> molecules = new HashMap<Integer, Molecule>();
        private Map<Integer, SecondaryStructureDisplay> secondaryStructureDisplays = new HashMap<Integer, SecondaryStructureDisplay>();

        private RnaMLParser() {
        }

        private void parse(File rnamlFile, Element root, ProgressMonitor monitor) throws BiologicalSymbolException, FileParsingException, IOException, JDOMException, InterruptedException {
            String commentValue;
            this.traverseJDOMElement(rnamlFile, root);
            for (RNASecondaryStructure ss : this.secondaryStructures.values()) {
                for (Molecule m : ss.getMolecules()) {
                    Location single_strands_location = new Location(1, m.getLength());
                    for (Helix h : ss.getHelices()) {
                        Location helixLocation = h.getFullLocation(m);
                        if (helixLocation == null) continue;
                        single_strands_location.remove(helixLocation);
                    }
                    int sstrand_count = 0;
                    int[] boundaries = single_strands_location.getBoundaries();
                    for (int i = 0; i < boundaries.length; i += 2) {
                        RNAMLFileIO.this.structuralFactory.createSingleStrand("SS" + sstrand_count++, this.currentRNASecondaryStructure, m, new Location(boundaries[i], boundaries[i + 1]));
                    }
                }
            }
            Attribute comment = root.getAttribute("comment");
            if (comment != null && (commentValue = comment.getValue().trim()).startsWith("s2s:")) {
                PDBFileIO pdbParser = new PDBFileIO(RNAMLFileIO.this.moleculeFactory);
                PDBFileIO.parseProteins = false;
                pdbParser.parseFile(new File(rnamlFile.getParentFile(), commentValue.split("s2s:")[1]), monitor);
                PDBFileIO.parseProteins = true;
                RNAMLFileIO.this.molecules.addAll(pdbParser.getMolecules());
                TertiaryStructure tertiaryStructure = pdbParser.getTertiaryStructure();
                Collection<Molecule> pdbMolecules = tertiaryStructure.getMolecules();
                tertiaryStructure.getFactory().copyTertiaryStructure(Arrays.asList(this.molecules.values().toArray(new Molecule[0])), tertiaryStructure);
                for (RNASecondaryStructure ss : this.secondaryStructures.values()) {
                    tertiaryStructure.linkSecondaryStructure(ss);
                }
                if (ParadiseWorkingSession.class.isInstance(RNAMLFileIO.this.moleculeFactory)) {
                    for (Molecule pdbMolecule : pdbMolecules) {
                        ((ParadiseWorkingSession)RNAMLFileIO.this.moleculeFactory).removeMolecule(pdbMolecule);
                    }
                }
            }
        }

        private void traverseJDOMElement(File rnamlFile, Element node) throws BiologicalSymbolException, FileParsingException, InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Element child2 = null;
            String name = null;
            for (Element child2 : node.getChildren()) {
                Object sequence;
                name = child2.getName();
                if (name.equals("molecule")) {
                    Element seqdata;
                    ++this.rnaSequenceCount;
                    this.modelCount = 0;
                    String rnaSequence = "";
                    sequence = child2.getChild("sequence");
                    if (sequence != null && (seqdata = sequence.getChild("seq-data")) != null) {
                        rnaSequence = seqdata.getValue().trim().toUpperCase().replaceAll("\\s*", "");
                    }
                    this.currentRNA = RNAMLFileIO.this.moleculeFactory.createRNA(new ParadiseID(), "" + this.rnaSequenceCount, Source.getFileAsSource(rnamlFile), rnaSequence);
                    this.molecules.put(this.rnaSequenceCount, this.currentRNA);
                } else if (name.equals("model")) {
                    ++this.modelCount;
                    this.currentRNASecondaryStructure = this.secondaryStructures.get(this.modelCount);
                    if (this.currentRNASecondaryStructure == null) {
                        this.currentRNASecondaryStructure = RNAMLFileIO.this.structuralFactory.createRNASecondaryStructure(new ParadiseID(), "?", Source.getFileAsSource(rnamlFile), this.currentRNA, new Location());
                        this.secondaryStructures.put(this.modelCount, this.currentRNASecondaryStructure);
                    }
                } else if (name.equals("str-analysis")) {
                    this.helixCount = 0;
                    this.sstrandCount = 0;
                } else if (name.equals("interactions")) {
                    this.interactions = true;
                    this.helixCount = 0;
                } else if (name.equals("base-pair")) {
                    this.defineBasePair(child2);
                } else if (name.equals("helix")) {
                    ++this.helixCount;
                    if (!this.interactions) {
                        this.defineHelix(child2);
                    } else {
                        this.defineInterHelix(child2);
                    }
                } else if (name.equals("ss-base-coord")) {
                    this.constructBase(child2);
                } else if (name.equals("coordinates")) {
                    this.constructSecondaryCoordinates(child2);
                } else if (name.equals("secondary-structure-display")) {
                    this.currentSecondaryStructureDisplay = this.secondaryStructureDisplays.get(this.modelCount);
                    if (this.currentSecondaryStructureDisplay == null) {
                        this.currentSecondaryStructureDisplay = RNAMLFileIO.this.structuralFactory.createSecondaryStructureDisplay(this.currentRNASecondaryStructure, this.currentRNA, this.currentRNASecondaryStructure.getFullLocation(this.currentRNA));
                        this.secondaryStructureDisplays.put(this.modelCount, this.currentSecondaryStructureDisplay);
                    }
                } else if (child2.getName().equals("alignment")) {
                    this.structuralAlignment = null;
                    this.columnToResidueIdentity = new HashMap();
                } else if (child2.getName().equals("ali-sequence")) {
                    String sequence_name = child2.getChild("molecule-id").getAttributeValue("ref").trim();
                    if (!FastaFileIO.SECONDARY_STRUCTURE_HEADER.equals(sequence_name)) {
                        sequence = child2.getChild("seq-data").getValue().trim();
                        if (this.structuralAlignment == null) {
                            this.structuralAlignment = RNAMLFileIO.this.identityFactory.createStructuralAligment(new ParadiseID(), "Alignment" + ++this.alignmentCount, Source.getFileAsSource(rnamlFile), this.currentRNA, new Location());
                            char[] cs = ((String)sequence).toCharArray();
                            int positionInSequence = 0;
                            for (int j = 0; j < cs.length; ++j) {
                                if (cs[j] == '-') continue;
                                this.columnToResidueIdentity.put(j, RNAMLFileIO.this.identityFactory.createResidueIdentity(this.structuralAlignment, this.currentRNA, new Location(++positionInSequence)));
                            }
                            for (RNASecondaryStructure ss : this.secondaryStructures.values()) {
                                ss.linkStructuralAlignment(this.structuralAlignment);
                            }
                        } else {
                            RNA rna = RNAMLFileIO.this.moleculeFactory.createRNA(new ParadiseID(), sequence_name, Source.getFileAsSource(rnamlFile), "");
                            char[] cs = ((String)sequence).toCharArray();
                            int positionInSequence = 0;
                            for (int j = 0; j < cs.length; ++j) {
                                if (cs[j] == '-') continue;
                                try {
                                    rna.addResidue("" + cs[j]);
                                }
                                catch (BiologicalSymbolException e) {
                                    String choice = null;
                                    while (choice == null || choice.length() == 0) {
                                        choice = (String)JOptionPane.showInputDialog(null, "Please choose an unmodified residue", "Unknown Residue " + cs[j], 2, null, new String[]{"A", "U", "G", "C", "?"}, "A");
                                        rna.addModifiedResidue("" + cs[j], choice);
                                    }
                                    rna.addResidue(choice);
                                }
                                ++positionInSequence;
                                ResidueIdentity ri = this.columnToResidueIdentity.get(j);
                                if (ri != null) {
                                    rna.addFeature(ri, new Location(positionInSequence));
                                    continue;
                                }
                                this.columnToResidueIdentity.put(j, RNAMLFileIO.this.identityFactory.createResidueIdentity(this.structuralAlignment, rna, new Location(positionInSequence)));
                            }
                        }
                    }
                } else if (child2.getName().equals("base") || child2.getName().equals("references") || child2.getName().equals("database-entry") || child2.getName().equals("analysis") || child2.getName().equals("revision")) continue;
                this.traverseJDOMElement(rnamlFile, child2);
            }
        }

        private void constructBase(Element b) {
            this.currentResidue = Integer.parseInt(b.getChild("base-id").getChild("position").getValue());
        }

        private void constructSecondaryCoordinates(Element coord) throws FileParsingException {
            String coordinates = coord.getValue();
            StringTokenizer token = new StringTokenizer(coordinates, " ");
            float[] baseCoord = new float[2];
            try {
                baseCoord[0] = Float.parseFloat(token.nextToken());
                baseCoord[1] = Float.parseFloat(token.nextToken());
            }
            catch (NumberFormatException nfe) {
                throw new FileParsingException(nfe);
            }
            RNAMLFileIO.this.structuralFactory.createResidue2D(this.currentSecondaryStructureDisplay, baseCoord[0], baseCoord[1], this.currentRNA, this.currentResidue);
        }

        private void defineBasePair(Element bp) throws BiologicalSymbolException {
            String base5id = bp.getChild("base-id-5p").getChild("base-id").getChild("position").getValue();
            String base3id = bp.getChild("base-id-3p").getChild("base-id").getChild("position").getValue();
            Element edge5 = bp.getChild("edge-5p");
            Element edge3 = bp.getChild("edge-3p");
            Element orientation = bp.getChild("bond-orientation");
            char _edge5 = '?';
            char _edge3 = '?';
            char _orientation = '?';
            if (orientation != null && edge5 != null && edge3 != null) {
                _orientation = orientation.getValue().trim().toUpperCase().toCharArray()[0];
                _edge5 = edge5.getValue().trim().toUpperCase().toCharArray()[0];
                _edge3 = edge3.getValue().trim().toUpperCase().toCharArray()[0];
            }
            if (_edge5 == '+' || _edge5 == '-') {
                _edge5 = 'W';
            }
            if (_edge3 == '+' || _edge3 == '-') {
                _edge3 = 'W';
            }
            String rna5id = null;
            String rna3id = null;
            Element molecule_id = bp.getChild("base-id-5p").getChild("base-id").getChild("molecule-id");
            if (molecule_id != null) {
                rna5id = molecule_id.getAttributeValue("ref");
            }
            if ((molecule_id = bp.getChild("base-id-3p").getChild("base-id").getChild("molecule-id")) != null) {
                rna3id = molecule_id.getAttributeValue("ref");
            }
            if (_orientation != '!' || _edge5 != '!' || _edge3 != '!') {
                if (!this.interactions) {
                    BaseBaseInteraction interaction = RNAMLFileIO.this.structuralFactory.createBaseBaseInteraction(_edge5, _edge3, _orientation, 1, this.currentRNASecondaryStructure, (Molecule)this.currentRNA, new Location(new Location(new Integer(base5id)), new Location(new Integer(base3id))));
                } else {
                    BaseBaseInteraction interaction = RNAMLFileIO.this.structuralFactory.createBaseBaseInteraction(_edge5, _edge3, _orientation, 1, this.currentRNASecondaryStructure, this.getMoleculeByName(rna5id), new Location(new Integer(base5id)), this.getMoleculeByName(rna3id), new Location(new Integer(base3id)));
                }
            }
        }

        private void defineHelix(Element h) throws FileParsingException {
            int length;
            int base3Id;
            int base5Id;
            try {
                base5Id = Integer.parseInt(h.getChild("base-id-5p").getChild("base-id").getChild("position").getValue());
                base3Id = Integer.parseInt(h.getChild("base-id-3p").getChild("base-id").getChild("position").getValue());
                length = Integer.parseInt(h.getChild("length").getValue());
            }
            catch (NumberFormatException nfe) {
                throw new FileParsingException(nfe);
            }
            Helix helix = RNAMLFileIO.this.structuralFactory.createHelix(h.getAttributeValue("id"), this.currentRNASecondaryStructure, this.currentRNA, new Location(new Location(base5Id, base5Id + length - 1), new Location(base3Id, base3Id - length + 1)));
        }

        private void defineInterHelix(Element h) {
            String[] helixDetails = new String[6];
            helixDetails[0] = h.getChild("base-id-5p").getChild("base-id").getChild("position").getValue();
            helixDetails[2] = h.getChild("base-id-3p").getChild("base-id").getChild("position").getValue();
            helixDetails[4] = h.getChild("length").getValue();
            helixDetails[5] = h.getAttributeValue("id");
            Element molecule_id = h.getChild("base-id-5p").getChild("base-id").getChild("molecule-id");
            if (molecule_id == null) {
                System.out.println("\nThe inter-helix base n" + helixDetails[0] + " 5boundarie lacks the molecule-id information");
                return;
            }
            helixDetails[1] = molecule_id.getAttributeValue("ref");
            molecule_id = h.getChild("base-id-3p").getChild("base-id").getChild("molecule-id");
            if (molecule_id == null) {
                System.out.println("\nThe inter-helix base n" + helixDetails[2] + " 3boundarie lacks the molecule-id information");
                return;
            }
            helixDetails[3] = molecule_id.getAttributeValue("ref");
            RNAMLFileIO.this.structuralFactory.createHelix(h.getAttributeValue(helixDetails[5]), this.currentRNASecondaryStructure, this.getMoleculeByName(helixDetails[1]), new Location(new Integer(helixDetails[0]), new Integer(helixDetails[0]) + new Integer(helixDetails[4]) - 1), this.getMoleculeByName(helixDetails[3]), new Location(new Integer(helixDetails[2]), new Integer(helixDetails[2]) - new Integer(helixDetails[4]) + 1));
        }

        private Molecule getMoleculeByName(String name) {
            for (Molecule m : this.molecules.values()) {
                if (!name.equals(m.getName())) continue;
                return m;
            }
            return null;
        }
    }
}

