/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.services.analysis.ibmc.contrafold;

import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.MoleculeFactory;
import fr.unistra.ibmc.paradise.core.ParadiseID;
import fr.unistra.ibmc.paradise.core.Source;
import fr.unistra.ibmc.paradise.core.analysis.AbstractAnalysis;
import fr.unistra.ibmc.paradise.core.analysis.AnalysisException;
import fr.unistra.ibmc.paradise.core.analysis.NoSolutionException;
import fr.unistra.ibmc.paradise.core.analysis.Parameters;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.core.io.BPSeqFileIO;
import fr.unistra.ibmc.paradise.services.analysis.ibmc.contrafold.ContrafoldServiceLocator;
import fr.unistra.ibmc.paradise.services.analysis.ibmc.contrafold.Contrafold_PortType;
import fr.unistra.ibmc.paradise.tools.component.DefaultProgressMonitor;
import fr.unistra.ibmc.paradise.utils.IOUtils;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IBMCContrafoldAnalysis
extends AbstractAnalysis {
    public IBMCContrafoldAnalysis(MoleculeFactory factory) {
        super("Contrafold (ARN/IBMC Web Service)", factory);
        this.addCategory("2D prediction");
    }

    @Override
    public void run(List<Molecule> molecules, Parameters parameters) throws AnalysisException, NoSolutionException {
        try {
            Molecule m = molecules.get(0);
            ContrafoldServiceLocator service = new ContrafoldServiceLocator();
            Contrafold_PortType contrafold = service.getContrafold();
            String bpseqResult = contrafold.predict2D(">" + m.getName() + "\n" + m.printSequence());
            File contrafoldOutput = IOUtils.createTemporaryFile("contrafold_output");
            FileUtils.writeStringToFile((File)contrafoldOutput, (String)bpseqResult);
            BPSeqFileIO parser = new BPSeqFileIO(this.moleculeFactory);
            parser.parseFile(contrafoldOutput, new DefaultProgressMonitor());
            m.removeAllSelectedFeatures();
            SecondaryStructure ss = (SecondaryStructure)parser.getMolecules().get(0).getAnnotations(SecondaryStructure.class).get(0).getFeature();
            SecondaryStructure copySS = ss.getFactory().copySecondaryStructure(Arrays.asList(m), ss, false);
            copySS.setParadiseID(new ParadiseID());
            copySS.setName("Secondary Structure");
            copySS.setSource(Source.getAnalysisAsSource(this.description));
            m.addSelectedFeature(copySS);
        }
        catch (Exception e) {
            throw new AnalysisException(e);
        }
    }
}

