/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.services.analysis.ibmc.rnadistance;

import fr.unistra.ibmc.paradise.core.Location;
import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.MoleculeFactory;
import fr.unistra.ibmc.paradise.core.ParadiseID;
import fr.unistra.ibmc.paradise.core.Source;
import fr.unistra.ibmc.paradise.core.analysis.AbstractAnalysis;
import fr.unistra.ibmc.paradise.core.analysis.AnalysisException;
import fr.unistra.ibmc.paradise.core.analysis.NoSolutionException;
import fr.unistra.ibmc.paradise.core.analysis.Parameters;
import fr.unistra.ibmc.paradise.core.features.IdentityFeatureFactory;
import fr.unistra.ibmc.paradise.core.features.RNASecondaryStructure;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.core.features.StructuralAlignment;
import fr.unistra.ibmc.paradise.core.features.StructuralFeatureFactory;
import fr.unistra.ibmc.paradise.core.features.StructuralIdentity;
import fr.unistra.ibmc.paradise.services.analysis.ibmc.rnadistance.RnadistanceServiceLocator;
import fr.unistra.ibmc.paradise.services.analysis.ibmc.rnadistance.Rnadistance_PortType;
import fr.unistra.ibmc.paradise.utils.IOUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.List;
import org.apache.commons.io.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IBMCRnadistanceAnalysis
extends AbstractAnalysis {
    protected IBMCRnadistanceAnalysis(MoleculeFactory factory) {
        super("RNADistance (ARN/IBMC Web Service)", factory);
        this.addCategory("structural alignment");
    }

    @Override
    public void run(List<Molecule> molecules, Parameters parameters) throws AnalysisException, NoSolutionException {
        try {
            File inputFile = IOUtils.createTemporaryFile("rnadistance_input");
            File rnadistanceOutputFile = IOUtils.createTemporaryFile("rnadistance_output");
            PrintWriter pw = new PrintWriter(inputFile);
            for (Molecule m : molecules) {
                pw.println(m.getSelectedFeatures(SecondaryStructure.class).get(0).printAsBracketNotation(m));
            }
            pw.close();
            RnadistanceServiceLocator service = new RnadistanceServiceLocator();
            Rnadistance_PortType rnadistance = service.getRnadistance();
            this.status = "Query to the webservice";
            this.status = "RNAdistance is running";
            long start = System.currentTimeMillis();
            String result = rnadistance.calculateDistance(FileUtils.readFileToString((File)inputFile));
            FileUtils.writeStringToFile((File)rnadistanceOutputFile, (String)result);
            this.status = "RNAdistance done in " + (System.currentTimeMillis() - start) / 1000L + "s";
            BufferedReader buff = new BufferedReader(new FileReader(rnadistanceOutputFile));
            String line = null;
            IdentityFeatureFactory identityFeatureFactory = this.createIdentityFeatureFactory();
            StructuralFeatureFactory structuralFeatureFactory = this.createStructuralFeatureFactory();
            StructuralAlignment alignment = identityFeatureFactory.createStructuralAligment(new ParadiseID(), "Alignment generated by RNADistance", Source.getAnalysisAsSource(this.description));
            int sequenceIndex = 0;
            StructuralIdentity si = null;
            RNASecondaryStructure ss = null;
            for (Molecule m : molecules) {
                m.removeAllSelectedFeatures();
                m.addSelectedFeature(alignment);
            }
            while ((line = buff.readLine()) != null) {
                if (!line.startsWith(".") && !line.startsWith("(") && !line.startsWith("_")) continue;
                char[] characters = line.trim().toCharArray();
                ++sequenceIndex;
                int alignmentPos = 0;
                int moleculePos = 1;
                Location gapsLocation = new Location();
                Location molecularLocation = new Location();
                ss = structuralFeatureFactory.createRNASecondaryStructure(new ParadiseID(), "Secondary Structure", Source.getAnalysisAsSource(this.description));
                molecules.get(sequenceIndex - 1).addSelectedFeature(ss);
                molecules.get(sequenceIndex - 1).addSelectedFeature(alignment);
                Location l = null;
                for (char c : characters) {
                    if (c != '_') {
                        if (c == '.') {
                            if (l == null) {
                                l = new Location(moleculePos);
                            } else {
                                l.add(moleculePos);
                            }
                        } else if (l != null) {
                            structuralFeatureFactory.createSingleStrand("SS", ss, molecules.get(sequenceIndex - 1), l);
                            l = null;
                        }
                        molecularLocation.add(moleculePos++);
                    } else {
                        gapsLocation.add(alignmentPos + 1);
                        if (l != null) {
                            structuralFeatureFactory.createSingleStrand("SS", ss, molecules.get(sequenceIndex - 1), l);
                            l = null;
                        }
                    }
                    ++alignmentPos;
                }
                if (si == null) {
                    si = identityFeatureFactory.createStructuralIdentity(alignment, "Structural Identity generated by RNADistance", molecules.get(sequenceIndex - 1), molecularLocation);
                } else {
                    molecules.get(sequenceIndex - 1).addFeature(si, molecularLocation);
                }
                si.addGapsLocation(molecules.get(sequenceIndex - 1), gapsLocation);
            }
        }
        catch (Exception e) {
            throw new AnalysisException(e);
        }
    }
}

