/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.tools;

import fr.unistra.ibmc.paradise.BiologicalSymbolException;
import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.ParadiseFeature;
import fr.unistra.ibmc.paradise.core.ParadiseID;
import fr.unistra.ibmc.paradise.core.Source;
import fr.unistra.ibmc.paradise.core.analysis.Parameters;
import fr.unistra.ibmc.paradise.core.features.Residue3D;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.core.features.StructuralDomain;
import fr.unistra.ibmc.paradise.core.features.StructuralFeatureFactory;
import fr.unistra.ibmc.paradise.core.features.TertiaryStructure;
import fr.unistra.ibmc.paradise.tools.AbstractParadiseToolAgent;
import fr.unistra.ibmc.paradise.tools.AnswerBehaviour;
import fr.unistra.ibmc.paradise.tools.MathematicaTool;
import fr.unistra.ibmc.paradise.tools.ParadiseWorkingSession;
import jade.core.behaviours.Behaviour;
import jade.gui.GuiEvent;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.lang.acl.UnreadableException;
import jade.wrapper.StaleProxyException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MathematicaAgent
extends AbstractParadiseToolAgent {
    public MathematicaAgent(ParadiseWorkingSession workingSession) throws StaleProxyException {
        super(new MathematicaTool(workingSession));
    }

    public void annotateTertiaryStructure(TertiaryStructure ts) {
        ArrayList<Molecule> molecules = new ArrayList<Molecule>();
        for (Molecule m : ts.getMolecules()) {
            m.removeAllSelectedFeatures();
            for (Residue3D r : ts.getSubFeatures(Residue3D.class, m)) {
                m.addSelectedFeature(r);
            }
            molecules.add(m);
        }
        this.addBehaviour((Behaviour)new AbstractParadiseToolAgent.ListAgentsBehaviour("3D annotation", new DefaultAnswerBehaviour("3D annotation", molecules, new Parameters()), this.paradiseTool.getProgressMonitor()));
    }

    public void predictTertiaryStructure(List<StructuralDomain> structuralDomains) {
        HashSet<Molecule> molecules = new HashSet<Molecule>();
        for (StructuralDomain sd : structuralDomains) {
            Collection<Molecule> _molecules = sd.getMolecules();
            molecules.addAll(_molecules);
            Molecule m = _molecules.iterator().next();
            m.addSelectedFeature(sd);
        }
        this.addBehaviour((Behaviour)new AbstractParadiseToolAgent.ListAgentsBehaviour("3D prediction", new DefaultAnswerBehaviour("3D annotation", new ArrayList(molecules), new Parameters()), this.paradiseTool.getProgressMonitor()));
    }

    public void predictSecondaryStructure(Molecule m) {
        this.addBehaviour((Behaviour)new AbstractParadiseToolAgent.ListAgentsBehaviour("2D prediction", new DefaultAnswerBehaviour("2D prediction", new ArrayList<Molecule>(Arrays.asList(m)), new Parameters()), this.paradiseTool.getProgressMonitor()));
    }

    protected void onGuiEvent(GuiEvent guiEvent) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefaultAnswerBehaviour
    extends AnswerBehaviour {
        private String analysisType;

        private DefaultAnswerBehaviour(String analysisType, ArrayList<Molecule> selectedMolecules, Parameters selectedParameters) {
            super(selectedMolecules, selectedParameters);
            this.analysisType = analysisType;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void action() {
            ACLMessage message = this.myAgent.receive(MessageTemplate.MatchConversationId((String)("" + this.conversationId)));
            if (message != null && message.getPerformative() == 11) {
                block17: {
                    try {
                        List<TertiaryStructure> tss;
                        ArrayList remoteMolecules = (ArrayList)message.getContentObject();
                        if (this.analysisType.equals("3D annotation")) {
                            SecondaryStructure ss = null;
                            for (Molecule remoteMolecule : remoteMolecules) {
                                for (ParadiseFeature f : remoteMolecule.getSelectedFeatures()) {
                                    if (ss == null) {
                                        ss = (SecondaryStructure)f;
                                    }
                                    ss.getFactory().copySecondaryStructure(this.selectedMolecules, ss, false);
                                }
                            }
                            ((Molecule)this.selectedMolecules.get(0)).getSelectedFeatures().get(0).getParentFeatures(TertiaryStructure.class).get(0).linkSecondaryStructure(ss);
                            break block17;
                        }
                        if (this.analysisType.equals("2D prediction")) {
                            SecondaryStructure ss = ((Molecule)remoteMolecules.get(0)).getSelectedFeatures(SecondaryStructure.class).get(0);
                            ss.getFactory().copySecondaryStructure(this.selectedMolecules, ss, false);
                            break block17;
                        }
                        if (this.analysisType.equals("3D prediction") && (tss = ((Molecule)remoteMolecules.get(0)).getSelectedFeatures(TertiaryStructure.class)).size() > 0) {
                            StructuralFeatureFactory factory = MathematicaAgent.this.paradiseTool.createStructuralFeatureFactory();
                            TertiaryStructure remote3D = tss.get(0);
                            TertiaryStructure local3D = factory.createTertiaryStructure(new ParadiseID(), "tertiary Structure", Source.getGraphicalToolAsSource(MathematicaAgent.this.paradiseTool.getDescription()));
                            ArrayList<Residue3D> residues3D = new ArrayList<Residue3D>();
                            for (Residue3D r : remote3D.getResidues3D()) {
                                Molecule localMolecule = null;
                                Molecule remoteMolecule = r.getMolecules().iterator().next();
                                for (Molecule _m : this.selectedMolecules) {
                                    if (!((Object)remoteMolecule).equals(_m)) continue;
                                    localMolecule = _m;
                                    break;
                                }
                                try {
                                    Residue3D r3d = factory.createResidue3D(local3D, localMolecule, r.getFullLocation(remoteMolecule).getStart());
                                    for (Residue3D.Atom ra : r.getAtoms()) {
                                        if (!ra.hasCoordinatesFilled()) continue;
                                        Residue3D.Atom la = r3d.getAtom(ra.getName());
                                        la.setCoordinates(ra.getX(), ra.getY(), ra.getZ());
                                    }
                                    residues3D.add(r3d);
                                }
                                catch (BiologicalSymbolException e) {
                                    this.monitor.printException(e);
                                    return;
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        this.monitor.printException(e);
                    }
                }
                this.monitor.stopAnimation();
                this.done = true;
                return;
            }
            if (message != null && message.getPerformative() == 7) {
                this.monitor.printMessage(message.getContent());
                return;
            }
            if (message == null) return;
            if (message.getPerformative() != 6) return;
            try {
                this.monitor.printException((Exception)message.getContentObject());
            }
            catch (UnreadableException e) {
                e.printStackTrace();
            }
            this.monitor.stopAnimation();
            this.done = true;
        }
    }
}

