/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.paradise.utils;

import fr.unistra.ibmc.paradise.utils.FileHandler;
import fr.unistra.ibmc.paradise.utils.HD;
import fr.unistra.ibmc.paradise.utils.OutputMode;
import fr.unistra.ibmc.paradise.utils.PDB;
import fr.unistra.ibmc.paradise.utils.ParsingException;
import fr.unistra.ibmc.paradise.utils.Printing;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HD2PDB {
    public static void main(String[] args) throws ParsingException {
        Printing.setReadMode(OutputMode.off);
        Printing.setWriteMode(OutputMode.off);
        HD2PDB.convert(args[0], args[1], new ArrayList<Integer>());
    }

    public static void convert(String HDFile, String PDBFile, ArrayList<Integer> cut) throws ParsingException {
        String line;
        FileHandler hd = new FileHandler(HDFile, 0);
        FileHandler pdb = new FileHandler(PDBFile, 1);
        int atn = 1;
        int cur = -1;
        char ch = 'A';
        HD atom = null;
        while ((line = hd.readLine()) != null) {
            atom = new HD(line);
            if (atom.residueNumber == cur + 1) {
                char oldresName = atom.residueName;
                if (HD2PDB.myContains(cut, cur)) {
                    pdb.println(PDB.getTerString(atn++, oldresName + "", ch, cur));
                    ch = (char)(ch + '\u0001');
                }
            }
            cur = atom.residueNumber;
            pdb.println(PDB.getAtomString(atn++, atom.atomName, atom.residueName + "", ch, atom.residueNumber, atom.x, atom.y, atom.z));
        }
        if (atom != null) {
            pdb.println(PDB.getTerString(atn++, atom.residueName + "", ch, atom.residueNumber));
        }
        hd.close();
        pdb.close();
    }

    public static void convert(String HDFile, String PDBFile) throws ParsingException {
        String line;
        FileHandler hd = new FileHandler(HDFile, 0);
        FileHandler pdb = new FileHandler(PDBFile, 1);
        int atn = 1;
        int cur = -1;
        char ch = 'A';
        HD atom = null;
        while ((line = hd.readLine()) != null) {
            atom = new HD(line);
            if (atom.residueNumber == cur + 1) {
                char c = atom.residueName;
            }
            cur = atom.residueNumber;
            pdb.println(PDB.getAtomString(atn++, atom.atomName, atom.residueName + "", ch, atom.residueNumber, atom.x, atom.y, atom.z));
        }
        if (atom != null) {
            pdb.println(PDB.getTerString(atn++, atom.residueName + "", ch, atom.residueNumber));
        }
        hd.close();
        pdb.close();
    }

    private static boolean myContains(ArrayList<Integer> cut, int cur) {
        for (Integer v : cut) {
            if (v != cur) continue;
            return true;
        }
        return false;
    }
}

