/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.jlink;

import com.wolfram.jlink.KernelLink;
import com.wolfram.jlink.MathLinkException;
import com.wolfram.jlink.StdLink;
import com.wolfram.jlink.Utils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.Hashtable;

public class MathInvocationHandler
implements InvocationHandler {
    private Hashtable handlers = new Hashtable(20);
    private KernelLink ml;
    private static Method hashCodeMethod;
    private static Method equalsMethod;
    private static Method toStringMethod;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$com$wolfram$jlink$Expr;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;

    public MathInvocationHandler() {
        this(StdLink.getLink());
    }

    public MathInvocationHandler(KernelLink ml) {
        this.ml = ml;
    }

    public MathInvocationHandler(String[][] handlers) {
        this(StdLink.getLink(), handlers);
    }

    public MathInvocationHandler(KernelLink ml, String[][] handlers) {
        this(ml);
        for (int i = 0; i < handlers.length; ++i) {
            this.setHandler(handlers[i][0], handlers[i][1]);
        }
    }

    public void setHandler(String meth, String func) {
        this.handlers.put(meth, func);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        int numArgs;
        String mathFunc;
        Object result = null;
        String methName = method.getName();
        Class<?> retType = method.getReturnType();
        if (method.getDeclaringClass() == (class$java$lang$Object == null ? (class$java$lang$Object = MathInvocationHandler.class$("java.lang.Object")) : class$java$lang$Object)) {
            if (method.equals(hashCodeMethod)) {
                return this.proxyHashCode(proxy);
            }
            if (method.equals(equalsMethod)) {
                return this.proxyEquals(proxy, args[0]);
            }
            if (method.equals(toStringMethod)) {
                return this.proxyToString(proxy);
            }
        }
        if ((mathFunc = (String)this.handlers.get(methName)) == null) {
            return null;
        }
        int n = numArgs = args != null ? args.length : 0;
        if (this.ml.equals(StdLink.getLink())) {
            StdLink.requestTransaction();
        }
        KernelLink kernelLink = this.ml;
        synchronized (kernelLink) {
            try {
                this.ml.putFunction("EvaluatePacket", 1);
                this.ml.putNext(70);
                this.ml.putArgCount(numArgs);
                this.ml.putFunction("ToExpression", 1);
                this.ml.put(mathFunc);
                for (int i = 0; i < numArgs; ++i) {
                    this.ml.put(args[i]);
                }
                this.ml.endPacket();
                this.ml.waitForAnswer();
                if (retType.equals(class$com$wolfram$jlink$Expr == null ? (class$com$wolfram$jlink$Expr = MathInvocationHandler.class$("com.wolfram.jlink.Expr")) : class$com$wolfram$jlink$Expr)) {
                    result = this.ml.getExpr();
                } else {
                    switch (this.ml.getNext()) {
                        case 43: {
                            result = this.readAsInt(retType, this.ml);
                            break;
                        }
                        case 42: {
                            result = this.readAsReal(retType, this.ml);
                            break;
                        }
                        case 34: {
                            result = this.ml.getString();
                            break;
                        }
                        case 35: {
                            result = this.ml.getSymbol();
                            if (!result.equals("Null")) break;
                            result = null;
                            break;
                        }
                        case 70: {
                            result = this.ml.getComplex();
                            break;
                        }
                        case 100000: {
                            result = this.ml.getObject();
                        }
                    }
                }
            }
            catch (MathLinkException exc) {
                this.ml.clearError();
                this.ml.newPacket();
                throw exc;
            }
        }
        return result;
    }

    private Object readAsReal(Class retType, KernelLink ml) throws MathLinkException {
        if (retType.equals(Double.TYPE)) {
            return new Double(ml.getDouble());
        }
        if (retType.equals(Float.TYPE)) {
            return new Float((float)ml.getDouble());
        }
        if (retType.equals(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = MathInvocationHandler.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
            return Utils.bigDecimalFromString(ml.getString());
        }
        return null;
    }

    private Object readAsInt(Class retType, KernelLink ml) throws MathLinkException {
        if (retType.equals(class$java$math$BigInteger == null ? (class$java$math$BigInteger = MathInvocationHandler.class$("java.math.BigInteger")) : class$java$math$BigInteger)) {
            return new BigInteger(ml.getString());
        }
        long i = ml.getLongInteger();
        if (retType.equals(Character.TYPE)) {
            if (i >= 0L && i <= 65535L) {
                return new Character((char)i);
            }
            return new Long(i);
        }
        if (retType.equals(Byte.TYPE)) {
            return new Byte((byte)i);
        }
        if (retType.equals(Short.TYPE)) {
            return new Short((short)i);
        }
        if (retType.equals(Integer.TYPE)) {
            return new Integer((int)i);
        }
        if (retType.equals(Float.TYPE)) {
            return new Float(i);
        }
        if (retType.equals(Double.TYPE)) {
            return new Double(i);
        }
        return new Long(i);
    }

    protected Integer proxyHashCode(Object proxy) {
        return new Integer(System.identityHashCode(proxy));
    }

    protected Boolean proxyEquals(Object proxy, Object other) {
        return proxy == other ? Boolean.TRUE : Boolean.FALSE;
    }

    protected String proxyToString(Object proxy) {
        return proxy.getClass().getName() + '@' + Integer.toHexString(proxy.hashCode());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            hashCodeMethod = (class$java$lang$Object == null ? (class$java$lang$Object = MathInvocationHandler.class$("java.lang.Object")) : class$java$lang$Object).getMethod("hashCode", null);
            equalsMethod = (class$java$lang$Object == null ? (class$java$lang$Object = MathInvocationHandler.class$("java.lang.Object")) : class$java$lang$Object).getMethod("equals", class$java$lang$Object == null ? (class$java$lang$Object = MathInvocationHandler.class$("java.lang.Object")) : class$java$lang$Object);
            toStringMethod = (class$java$lang$Object == null ? (class$java$lang$Object = MathInvocationHandler.class$("java.lang.Object")) : class$java$lang$Object).getMethod("toString", null);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(e.getMessage());
        }
    }
}

