/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble;

import com.sun.opengl.util.Animator;
import fr.unistra.ibmc.assemble.gui.Assemble;
import fr.unistra.ibmc.assemble.gui.EDMapPanel;
import fr.unistra.ibmc.assemble.gui.GlobalSelection;
import fr.unistra.ibmc.assemble.gui.ResidueManager;
import fr.unistra.ibmc.assemble.gui.SecondaryStructureNavigator;
import fr.unistra.ibmc.assemble.gui.UserSelection;
import fr.unistra.ibmc.assemble.gui.rendering.Renderer;
import fr.unistra.ibmc.assemble.maps.EDMap;
import fr.unistra.ibmc.assemble.maps.Map;
import fr.unistra.ibmc.assemble.ssviewer.features.Model2D;
import fr.unistra.ibmc.assemble.ssviewer.graphics.Rna2DViewer;
import fr.unistra.ibmc.assemble.structures.Model3D;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.core.features.TertiaryStructure;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GLCapabilities;
import org.noos.xing.mydoggy.DockedTypeDescriptor;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.ToolWindowAnchor;
import org.noos.xing.mydoggy.ToolWindowType;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mediator {
    private Assemble assemble;
    private Renderer renderer;
    private Animator animator;
    private GlobalSelection globalSelection;
    private List<UserSelection> userSelections;
    private Model3D model3D;
    private ResidueManager residueManager;
    private Rna2DViewer rna2DViewer;
    private SecondaryStructureNavigator secondaryStructureNavigator;
    private MyDoggyToolWindowManager myDoggyToolWindowManager;
    private String current3DModelState;

    public Mediator(Assemble assemble) {
        this.assemble = assemble;
        GLCapabilities caps = new GLCapabilities();
        caps.setHardwareAccelerated(true);
        caps.setDoubleBuffered(true);
        this.renderer = new Renderer(caps, this);
        this.globalSelection = new GlobalSelection(this);
        this.residueManager = new ResidueManager(this);
        this.userSelections = new ArrayList<UserSelection>();
    }

    public SecondaryStructureNavigator getSecondaryStructureNavigator() {
        return this.secondaryStructureNavigator;
    }

    public void setResidueManager(ResidueManager residueManager) {
        this.residueManager = residueManager;
        this.globalSelection.addSelectionListener(this.residueManager);
        this.residueManager.addSelectionListener(this.globalSelection);
        if (this.rna2DViewer != null) {
            this.rna2DViewer.addSelectionListener(this.residueManager);
            this.residueManager.addSelectionListener(this.rna2DViewer);
        }
        if (this.secondaryStructureNavigator != null) {
            this.residueManager.addSelectionListener(this.secondaryStructureNavigator);
            this.secondaryStructureNavigator.addSelectionListener(this.residueManager);
        }
    }

    public void setRna2DViewer(Rna2DViewer rna2DViewer) {
        this.rna2DViewer = rna2DViewer;
        this.globalSelection.addSelectionListener(this.rna2DViewer);
        this.rna2DViewer.addSelectionListener(this.globalSelection);
        if (this.residueManager != null) {
            this.rna2DViewer.addSelectionListener(this.residueManager);
            this.residueManager.addSelectionListener(this.rna2DViewer);
        }
        if (this.secondaryStructureNavigator != null) {
            this.rna2DViewer.addSelectionListener(this.secondaryStructureNavigator);
            this.secondaryStructureNavigator.addSelectionListener(this.rna2DViewer);
        }
    }

    public String getCurrent3DModelState() {
        return this.current3DModelState;
    }

    public Model2D get2DModel() {
        return this.rna2DViewer.getSecondaryCanvas().getModel2D();
    }

    public void setSecondaryStructureNavigator(SecondaryStructureNavigator secondaryStructureNavigator) {
        this.secondaryStructureNavigator = secondaryStructureNavigator;
        this.globalSelection.addSelectionListener(this.secondaryStructureNavigator);
        this.secondaryStructureNavigator.addSelectionListener(this.globalSelection);
        if (this.residueManager != null) {
            this.secondaryStructureNavigator.addSelectionListener(this.residueManager);
            this.residueManager.addSelectionListener(this.secondaryStructureNavigator);
        }
        if (this.rna2DViewer != null) {
            this.rna2DViewer.addSelectionListener(this.secondaryStructureNavigator);
            this.secondaryStructureNavigator.addSelectionListener(this.rna2DViewer);
        }
    }

    public Rna2DViewer getRna2DViewer() {
        return this.rna2DViewer;
    }

    public void addUserSelection(UserSelection selection) {
        this.userSelections.add(selection);
        this.assemble.getSecondaryStructureNavigator().addUserSelection(selection);
    }

    public List<UserSelection> getUserSelections() {
        return this.userSelections;
    }

    public void clearSession() {
        this.model3D = null;
        ToolWindow toolWindow = this.myDoggyToolWindowManager.getToolWindow((Object)"Map");
        if (toolWindow != null) {
            this.myDoggyToolWindowManager.unregisterToolWindow("Map");
        }
        this.globalSelection.clear();
        this.userSelections.clear();
        this.residueManager.clear();
        this.assemble.clearUndoSteps();
        toolWindow = this.myDoggyToolWindowManager.getToolWindow((Object)"Map");
        if (toolWindow != null) {
            this.myDoggyToolWindowManager.unregisterToolWindow("ResidueManager");
        }
        this.renderer.reinit();
        this.rna2DViewer.getSecondaryCanvas().clearDisplay();
        this.secondaryStructureNavigator.clear();
        System.gc();
    }

    public Assemble getAssemble() {
        return this.assemble;
    }

    public ResidueManager getResidueManager() {
        return this.residueManager;
    }

    public GlobalSelection getGlobalSelection() {
        return this.globalSelection;
    }

    public void addUndoStep(String name) {
        if (this.model3D != null) {
            this.get3DModel().addUndoStep(name);
            this.current3DModelState = name;
        }
    }

    public void restoreState(String stateName) {
        if (this.model3D != null) {
            this.get3DModel().restoreState(stateName);
            this.current3DModelState = stateName;
            this.get3DModel().fireModelRejected();
        }
    }

    public void createModel(SecondaryStructure ss, TertiaryStructure ts) {
        this.assemble.getProgressMonitor().printMessage("Create 3D Model...");
        this.model3D = new Model3D(this, ss, ts);
        this.model3D.addModelListener(this.renderer);
        this.model3D.addModelListener(this.residueManager);
        this.model3D.initialize();
        this.assemble.clearUndoSteps();
        this.assemble.addUndoStep("Initial State");
        this.renderer.updatePivot();
        this.renderer.reComputeNeeded();
        this.assemble.set3DSceneTitle(ts.getName());
    }

    public void loadRNASecondaryStructure(SecondaryStructure ss) {
        this.rna2DViewer.loadRNASecondaryStructure(ss);
        this.assemble.setModelManagerTitle(ss.getName());
    }

    public Model3D get3DModel() {
        return this.model3D;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    public void setAnimator(Animator animator) {
        this.animator = animator;
    }

    public void translateMap(float[] vector) {
        this.getDensityMap().translate(vector);
    }

    public void rotateMap(float[] axis, float angle) {
        this.getDensityMap().rotate(axis, angle);
    }

    public SecondaryStructure getSecondaryStructureDisplayed() {
        return this.rna2DViewer.getSecondaryCanvas().getModel2D().getSecondaryStructure();
    }

    public void stopAnimator() {
        if (this.animator.isAnimating()) {
            this.animator.stop();
        }
    }

    public void startAnimator() {
        if (!this.animator.isAnimating()) {
            this.animator.start();
        }
    }

    public void setToolWindowManager(MyDoggyToolWindowManager myDoggyToolWindowManager) {
        this.myDoggyToolWindowManager = myDoggyToolWindowManager;
    }

    public MyDoggyToolWindowManager getToolWindowManager() {
        return this.myDoggyToolWindowManager;
    }

    public void loadEDMap(EDMap edmap) {
        ToolWindow toolWindow = this.myDoggyToolWindowManager.getToolWindow((Object)"Map");
        if (toolWindow != null) {
            this.myDoggyToolWindowManager.unregisterToolWindow("Map");
        }
        ToolWindow mapToolWindow = this.myDoggyToolWindowManager.registerToolWindow("Map", "Map", null, (Component)new EDMapPanel(this, edmap), ToolWindowAnchor.RIGHT);
        mapToolWindow.setActive(true);
        DockedTypeDescriptor descriptor = (DockedTypeDescriptor)mapToolWindow.getTypeDescriptor(ToolWindowType.DOCKED);
        descriptor.setDockLength(300);
        descriptor.setPreviewEnabled(false);
    }

    public Map getDensityMap() {
        ToolWindow toolWindow = this.myDoggyToolWindowManager.getToolWindow((Object)"Map");
        if (toolWindow != null) {
            if (EDMapPanel.class.isInstance(toolWindow.getComponent())) {
                return ((EDMapPanel)toolWindow.getComponent()).getEDMap();
            }
            return null;
        }
        return null;
    }
}

