/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.gui;

import com.sun.opengl.util.Animator;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import fr.unistra.ibmc.assemble.AssembleAgent;
import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.behaviours.SecondaryStructureDrawingRequestAnswerBehaviour;
import fr.unistra.ibmc.assemble.behaviours.SecondaryStructurePredictionRequestAnswerBehaviour;
import fr.unistra.ibmc.assemble.behaviours.TertiaryStructureAnnotationRequestAnswerBehaviour;
import fr.unistra.ibmc.assemble.gui.RNAMotifsBrowser;
import fr.unistra.ibmc.assemble.gui.RnartDialog;
import fr.unistra.ibmc.assemble.gui.SecondaryStructureNavigator;
import fr.unistra.ibmc.assemble.gui.SplashScreen;
import fr.unistra.ibmc.assemble.gui.UserSelection;
import fr.unistra.ibmc.assemble.gui.labels.AngleLabel;
import fr.unistra.ibmc.assemble.gui.labels.AtomLabel;
import fr.unistra.ibmc.assemble.gui.labels.DihedralLabel;
import fr.unistra.ibmc.assemble.gui.labels.DistanceLabel;
import fr.unistra.ibmc.assemble.gui.rendering.OpenGLColor;
import fr.unistra.ibmc.assemble.gui.rendering.Renderer;
import fr.unistra.ibmc.assemble.maps.EDMap;
import fr.unistra.ibmc.assemble.ssviewer.features.BaseBaseInteraction2D;
import fr.unistra.ibmc.assemble.ssviewer.features.Interaction2D;
import fr.unistra.ibmc.assemble.ssviewer.features.Residue2D;
import fr.unistra.ibmc.assemble.ssviewer.graphics.Rna2DViewer;
import fr.unistra.ibmc.assemble.ssviewer.graphics.SecondaryCanvas;
import fr.unistra.ibmc.assemble.structures.Atom;
import fr.unistra.ibmc.assemble.structures.AtomSet;
import fr.unistra.ibmc.assemble.structures.Chain;
import fr.unistra.ibmc.assemble.structures.nucleicAcids.ResidueNA;
import fr.unistra.ibmc.assemble.utils.AssembleConfig;
import fr.unistra.ibmc.assemble.utils.AssembleModelParser;
import fr.unistra.ibmc.assemble.utils.RessourcesUtils;
import fr.unistra.ibmc.assemble.utils.Training;
import fr.unistra.ibmc.paradise.BiologicalSymbolException;
import fr.unistra.ibmc.paradise.Paradise;
import fr.unistra.ibmc.paradise.core.Location;
import fr.unistra.ibmc.paradise.core.MainParadiseFeature;
import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.MoleculeFactory;
import fr.unistra.ibmc.paradise.core.ParadiseFeature;
import fr.unistra.ibmc.paradise.core.RNA;
import fr.unistra.ibmc.paradise.core.analysis.NoSolutionException;
import fr.unistra.ibmc.paradise.core.analysis.Parameters;
import fr.unistra.ibmc.paradise.core.features.BaseBaseInteraction;
import fr.unistra.ibmc.paradise.core.features.Residue3D;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.core.features.StructuralDomain;
import fr.unistra.ibmc.paradise.core.features.StructuralFeatureFactory;
import fr.unistra.ibmc.paradise.core.features.TertiaryStructure;
import fr.unistra.ibmc.paradise.core.io.BPSeqFileIO;
import fr.unistra.ibmc.paradise.core.io.CTFileIO;
import fr.unistra.ibmc.paradise.core.io.FastaFileIO;
import fr.unistra.ibmc.paradise.core.io.PDBFileIO;
import fr.unistra.ibmc.paradise.core.io.ParadiseFileIO;
import fr.unistra.ibmc.paradise.core.io.ParadiseProjectIO;
import fr.unistra.ibmc.paradise.core.utils.Residue;
import fr.unistra.ibmc.paradise.tools.AbstractParadiseGUITool;
import fr.unistra.ibmc.paradise.tools.AbstractParadiseToolAgent;
import fr.unistra.ibmc.paradise.tools.ParadiseWorkingSession;
import fr.unistra.ibmc.paradise.tools.component.DefaultProgressMonitor;
import fr.unistra.ibmc.paradise.tools.component.FileParsingTask;
import fr.unistra.ibmc.paradise.tools.component.MemoryMonitor;
import fr.unistra.ibmc.paradise.tools.component.OpenFileFilter;
import fr.unistra.ibmc.paradise.tools.component.ParadiseTask;
import fr.unistra.ibmc.paradise.tools.component.ProgressMonitor;
import fr.unistra.ibmc.paradise.utils.GeneralUtils;
import fr.unistra.ibmc.paradise.utils.IOUtils;
import fr.unistra.ibmc.paradise.utils.JavaLibraryPath;
import fr.unistra.ibmc.paradise.utils.TBMath;
import fr.unistra.ibmc.paradise.utils.VTextIcon;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyShell;
import jade.gui.GuiEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.media.opengl.GLAutoDrawable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.MenuSelectionManager;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Application;
import org.jdesktop.swingworker.SwingWorker;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.JXFrame;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.VerticalLayout;
import org.jdesktop.swingx.decorator.AlternateRowHighlighter;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.error.ErrorInfo;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.noos.xing.mydoggy.DockedTypeDescriptor;
import org.noos.xing.mydoggy.PushAwayMode;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.ToolWindowAnchor;
import org.noos.xing.mydoggy.ToolWindowType;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Assemble
extends AbstractParadiseGUITool {
    public static final String releaseName = "Assemble 1.0, Release Candidate 3";
    private RNAMotifsBrowser rnaMotifsBrowser;
    private GroovyShell groovyShell;
    private SecondaryStructureNavigator secondaryStructureNavigator;
    public MessageBar messageBar;
    private StructuralFeatureFactory structuralFactory;
    FileMenu file;
    SecondaryModelMenu secondaryModel;
    TertiarySelectionMenu tertiarySelection;
    StereoMenu stereo;
    TertiaryModelMenu tertiaryModel;
    EditMenu edit;
    PluginsMenu plugins;
    HelpMenu help;
    private Mediator mediator;
    private Frame modelFrame;
    private UndoHistoryPanel undoHistoryPanel;

    public void tileVertically() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.window.setSize((int)screenSize.getWidth(), (int)screenSize.getHeight() / 2);
        this.window.setLocation(0, 0);
        this.window.validate();
        Rectangle r = this.window.getBounds();
        this.modelFrame.setSize((int)screenSize.getWidth(), (int)(screenSize.getHeight() - r.getHeight()));
        this.modelFrame.setLocation(0, (int)r.getHeight());
        this.modelFrame.validate();
    }

    public void tileHorizontally() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.window.setSize((int)screenSize.getWidth() / 2, (int)screenSize.getHeight());
        this.window.setLocation(0, 0);
        this.window.validate();
        Rectangle r = this.window.getBounds();
        this.modelFrame.setSize((int)(screenSize.getWidth() - r.getWidth()), (int)screenSize.getHeight());
        this.modelFrame.setLocation((int)r.getWidth(), 0);
        this.modelFrame.validate();
    }

    public SecondaryStructureNavigator getSecondaryStructureNavigator() {
        return this.secondaryStructureNavigator;
    }

    public static String getUserDirPath() {
        return new StringBuffer(System.getProperty("user.home")).append(System.getProperty("file.separator")).append(".assemble").append(System.getProperty("file.separator")).toString();
    }

    public static String getInstallPath() {
        return Assemble.class.getProtectionDomain().getCodeSource().getLocation().getPath().split("assemble.jar")[0];
    }

    public ProgressMonitor getProgressMonitor() {
        return this.messageBar;
    }

    public boolean isConnected() {
        return this.agent != null;
    }

    public void setModelManagerTitle(String title) {
        ((JXFrame)this.window).setTitle(title);
    }

    public void set3DSceneTitle(String title) {
        this.modelFrame.setTitle(title);
    }

    public MainParadiseFeature getCurrentFeature() {
        if (this.mediator == null || this.mediator.get3DModel() == null && this.mediator.get2DModel() == null) {
            return null;
        }
        if (this.mediator.get3DModel() != null) {
            return this.mediator.get3DModel().getTertiaryStructure();
        }
        return this.mediator.get2DModel().getSecondaryStructure();
    }

    public Assemble(ParadiseWorkingSession pws) {
        super(releaseName, pws);
    }

    public void updateTitle() {
        ((JXFrame)this.window).setTitle(((JXFrame)this.window).getTitle());
    }

    public void setComputeMode(boolean value) {
        if (value) {
            ((JFrame)this.window).getContentPane().setCursor(Cursor.getPredefinedCursor(3));
        } else {
            ((JFrame)this.window).getContentPane().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void setAssembleLastSavePath(File f) {
        Preferences prefs = Preferences.userRoot().node("Assemble");
        prefs.put("AssembleLastSavePath", f.getPath());
    }

    public String getAssembleLastSavePath() {
        Preferences prefs = Preferences.userRoot().node("Assemble");
        return prefs.get("AssembleLastSavePath", "myFiles");
    }

    public void setAssembleLastLoadPath(File f) {
        Preferences prefs = Preferences.userRoot().node("Assemble");
        prefs.put("AssembleLastLoadPath", f.getPath());
    }

    public String getAssembleLastLoadPath() {
        Preferences prefs = Preferences.userRoot().node("Assemble");
        return prefs.get("AssembleLastLoadPath", "myFiles");
    }

    public StructuralFeatureFactory getStructuralFeatureFactory() {
        if (this.structuralFactory == null) {
            this.structuralFactory = this.createStructuralFeatureFactory();
        }
        return this.structuralFactory;
    }

    public Mediator getMediator() {
        return this.mediator;
    }

    public void synchronize() {
        if (this.mediator.get3DModel() != null) {
            this.mediator.get3DModel().saveCoordinatesToParadise();
            ArrayList<Residue3D> residuesDisplayed = new ArrayList<Residue3D>();
            for (fr.unistra.ibmc.assemble.structures.Residue r : this.mediator.get3DModel().getResidues()) {
                residuesDisplayed.add(r.getResidue3D());
            }
            for (fr.unistra.ibmc.assemble.structures.Residue r : this.mediator.get3DModel().getTertiaryStructure().getResidues3D()) {
                if (residuesDisplayed.contains(r)) continue;
                this.mediator.get3DModel().getTertiaryStructure().removeResidue3D((Residue3D)r);
            }
            this.clearUndoSteps();
            this.addUndoStep("Initial State");
        }
    }

    public void addUndoStep(String name) {
        for (int i = 0; i < this.undoHistoryPanel.table.getRowCount(); ++i) {
            if (!this.undoHistoryPanel.table.getValueAt(i, 0).equals(name)) continue;
            JOptionPane.showMessageDialog(this.window, "This step already exists. Choose an other name!!");
            return;
        }
        ((DefaultTableModel)this.undoHistoryPanel.table.getModel()).addRow(new Object[]{name, new Date()});
        this.mediator.addUndoStep(name);
    }

    public void clearUndoSteps() {
        int total = this.undoHistoryPanel.table.getRowCount();
        if (this.mediator.get3DModel() != null) {
            for (int i = 0; i < total; ++i) {
                this.mediator.get3DModel().removeState((String)this.undoHistoryPanel.table.getValueAt(i, 0));
            }
        }
        ((DefaultTableModel)this.undoHistoryPanel.table.getModel()).getDataVector().removeAllElements();
        ((DefaultTableModel)this.undoHistoryPanel.table.getModel()).fireTableRowsDeleted(0, total);
    }

    public void selectResidues(Collection<Residue> residues, boolean isShiftDown) {
        List<fr.unistra.ibmc.assemble.structures.Residue> allResidues = this.mediator.get3DModel().getResidues();
        if (!isShiftDown) {
            this.mediator.getGlobalSelection().clear();
        }
        block0: for (Residue r : residues) {
            for (fr.unistra.ibmc.assemble.structures.Residue _r : allResidues) {
                if (!((Residue)_r.getResidue3D().getResidues().getResidues().iterator().next()).equals((Object)r)) continue;
                this.mediator.getGlobalSelection().add(_r);
                continue block0;
            }
        }
        this.mediator.getGlobalSelection().fireRenderingModified();
    }

    public fr.unistra.ibmc.assemble.structures.Residue getAssembleResidue(Residue paradiseResidue) {
        return this.mediator.get3DModel().getResidue(paradiseResidue);
    }

    public AtomSet getAtomsForStructuralDomain(StructuralDomain domain) {
        AtomSet atoms = new AtomSet(this.mediator);
        for (Residue r : domain.getResidues().getResidues()) {
            fr.unistra.ibmc.assemble.structures.Residue _r = this.mediator.getAssemble().getAssembleResidue(r);
            if (_r == null) continue;
            atoms.add(_r.getAtoms());
        }
        return atoms;
    }

    public void toForeGround() {
        this.window.toFront();
    }

    protected void startup() {
        this.window = new JXFrame(this.getDescription());
        JXFrame cfr_ignored_0 = (JXFrame)this.window;
        ((JXFrame)this.window).setDefaultCloseOperation(0);
        try {
            String osName = System.getProperty("os.name");
            if (osName.startsWith("Mac OS")) {
                JavaLibraryPath.add((File)new File(Assemble.getInstallPath() + "native" + System.getProperty("file.separator") + "mac"));
            } else if (osName.startsWith("Windows")) {
                if (System.getProperty("sun.arch.data.model").equals("32")) {
                    System.out.println("Loading Windows 32 Libraries");
                    JavaLibraryPath.add((File)new File(Assemble.getInstallPath() + "native" + System.getProperty("file.separator") + "win32"));
                } else if (System.getProperty("sun.arch.data.model").equals("64")) {
                    System.out.println("Loading Windows 64 Libraries");
                    JavaLibraryPath.add((File)new File(Assemble.getInstallPath() + "native" + System.getProperty("file.separator") + "win64"));
                } else {
                    System.err.println("Your Windows system is not recognized as either a 32bit nor a 64bit platform");
                    System.exit(1);
                }
            } else if (osName.startsWith("Linux") || osName.startsWith("FreeBSD")) {
                if (System.getProperty("sun.arch.data.model").equals("32")) {
                    System.out.println("Loading Linux32 Libraries");
                    JavaLibraryPath.add((File)new File(Assemble.getInstallPath() + "native" + System.getProperty("file.separator") + "linux32"));
                } else if (System.getProperty("sun.arch.data.model").equals("64")) {
                    System.out.println("Loading Linux64 Libraries");
                    JavaLibraryPath.add((File)new File(Assemble.getInstallPath() + "native" + System.getProperty("file.separator") + "linux64"));
                } else {
                    System.err.println("Your linux system is not recognized as either a 32bit nor a 64bit platform");
                    System.exit(1);
                }
            } else {
                System.err.println("Your system in not recognized as Windows, MacOS or Linux : no appropriate 3D drivers available. sorry.");
                System.exit(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.window.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                if (JOptionPane.showConfirmDialog(null, "Are you sure you want to exit Assemble?", "Confirm exit", 0) == 0) {
                    try {
                        AssembleConfig.save();
                    }
                    catch (BackingStoreException e1) {
                        e1.printStackTrace();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    System.exit(0);
                }
            }
        });
        this.groovyShell = new GroovyShell();
        this.mediator = new Mediator(this);
        this.mediator.setToolWindowManager(new MyDoggyToolWindowManager());
        this.mediator.getToolWindowManager().getToolWindowManagerDescriptor().setPushAwayMode(PushAwayMode.HORIZONTAL);
        Rna2DViewer rna2dViewer = new Rna2DViewer(this.workingSession, this.mediator);
        ((JFrame)this.window).setTitle("Assemble: Model Manager");
        this.messageBar = new MessageBar();
        AssembleDisplayPanel assembleDisplayPanel = new AssembleDisplayPanel();
        JScrollPane assembleDisplayPanelScrollPane = new JScrollPane((Component)((Object)assembleDisplayPanel));
        assembleDisplayPanelScrollPane.getViewport().setBackground(Color.WHITE);
        AssembleSelectionPanel assembleSelectionPanel = new AssembleSelectionPanel();
        JScrollPane assembleSelectionPanelScrollPane = new JScrollPane((Component)((Object)assembleSelectionPanel));
        assembleSelectionPanelScrollPane.getViewport().setBackground(Color.WHITE);
        AssembleEditionPanel assembleEditionPanel = new AssembleEditionPanel();
        JScrollPane assembleEditionPanelScrollPane = new JScrollPane((Component)((Object)assembleEditionPanel));
        assembleEditionPanelScrollPane.getViewport().setBackground(Color.WHITE);
        RNAMotifPanel rnamotifPanel = new RNAMotifPanel();
        JScrollPane rnaMotifPanelScrollPane = new JScrollPane((Component)((Object)rnamotifPanel));
        rnaMotifPanelScrollPane.getViewport().setBackground(Color.WHITE);
        SecondaryStructureDisplayPanel ssDisplayPanel = new SecondaryStructureDisplayPanel();
        JScrollPane ssDisplayPanelScrollPane = new JScrollPane((Component)((Object)ssDisplayPanel));
        ssDisplayPanelScrollPane.getViewport().setBackground(Color.WHITE);
        this.secondaryStructureNavigator = new SecondaryStructureNavigator(rna2dViewer.getRna2DViewerMediator(), this.mediator);
        JScrollPane navigatorScrollPane = new JScrollPane((Component)((Object)this.secondaryStructureNavigator));
        navigatorScrollPane.getViewport().setBackground(Color.WHITE);
        this.mediator.getToolWindowManager().getContentManager().addContent("2DView", "2D Viewer", null, (Component)new JScrollPane(rna2dViewer));
        ToolWindow toolWindow = this.mediator.getToolWindowManager().registerToolWindow("Explorer", "Model Explorer", null, (Component)navigatorScrollPane, ToolWindowAnchor.LEFT);
        DockedTypeDescriptor descriptor = (DockedTypeDescriptor)toolWindow.getTypeDescriptor(ToolWindowType.DOCKED);
        descriptor.setDockLength(200);
        descriptor.setPreviewEnabled(false);
        toolWindow = this.mediator.getToolWindowManager().registerToolWindow("RNAMotif", "RNA motif", null, (Component)rnaMotifPanelScrollPane, ToolWindowAnchor.RIGHT);
        descriptor = (DockedTypeDescriptor)toolWindow.getTypeDescriptor(ToolWindowType.DOCKED);
        descriptor.setDockLength(300);
        descriptor.setPreviewEnabled(false);
        toolWindow = this.mediator.getToolWindowManager().registerToolWindow("News", "News", null, (Component)((Object)new NewsPanel()), ToolWindowAnchor.BOTTOM);
        descriptor = (DockedTypeDescriptor)toolWindow.getTypeDescriptor(ToolWindowType.DOCKED);
        descriptor.setDockLength(50);
        descriptor.setPreviewEnabled(false);
        this.undoHistoryPanel = new UndoHistoryPanel();
        toolWindow = this.mediator.getToolWindowManager().registerToolWindow("Undo", "Undo History", null, (Component)((Object)this.undoHistoryPanel), ToolWindowAnchor.RIGHT);
        descriptor = (DockedTypeDescriptor)toolWindow.getTypeDescriptor(ToolWindowType.DOCKED);
        descriptor.setDockLength(300);
        descriptor.setPreviewEnabled(false);
        this.rnaMotifsBrowser = new RNAMotifsBrowser(this.mediator);
        toolWindow = this.mediator.getToolWindowManager().registerToolWindow("MotifsRepository", "RNA Motifs Repository", null, (Component)new JScrollPane((Component)((Object)this.rnaMotifsBrowser)), ToolWindowAnchor.BOTTOM);
        descriptor = (DockedTypeDescriptor)toolWindow.getTypeDescriptor(ToolWindowType.DOCKED);
        descriptor.setDockLength(200);
        descriptor.setPreviewEnabled(false);
        for (ToolWindow window : this.mediator.getToolWindowManager().getToolWindows()) {
            window.setAvailable(true);
        }
        this.window.add((Component)rna2dViewer.getToolbar(), "North");
        this.window.add((Component)this.mediator.getToolWindowManager(), "Center");
        this.window.add((Component)this.messageBar, "South");
        ((JXFrame)this.window).setJMenuBar((JMenuBar)new AssembleMenu());
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.window.pack();
        Renderer r = this.mediator.getRenderer();
        r.setPreferredSize(new Dimension((int)((double)screenSize.width * 0.8), (int)((double)screenSize.height * 0.4)));
        this.mediator.setAnimator(new Animator((GLAutoDrawable)r));
        this.modelFrame = new Frame("Assemble: 3D Model");
        this.modelFrame.setLayout(new BorderLayout());
        this.modelFrame.add((Component)((Object)this.mediator.getRenderer()), "Center");
        this.modelFrame.add((Component)new AssembleToolBar(), "North");
        this.mediator.getRenderer().setJFrame(this.modelFrame);
        this.modelFrame.pack();
        this.window.setSize(this.modelFrame.getSize());
        this.window.setLocation((int)((double)screenSize.width * 0.1), (int)((double)screenSize.height * 0.025));
        this.modelFrame.setLocation((int)this.window.getLocation().getX(), (int)(this.window.getLocation().getY() + (double)this.window.getHeight()));
        this.window.setVisible(true);
        this.modelFrame.setVisible(true);
    }

    public JFrame getFrame() {
        return (JFrame)this.window;
    }

    public static boolean updateAssemble() {
        try {
            URL updates = new URL("http://ftp.bioinformatics.org/pub/assemble/updates.xml");
            URLConnection urlConnection = updates.openConnection();
            urlConnection.setUseCaches(false);
            urlConnection.connect();
            InputStream stream = urlConnection.getInputStream();
            SAXBuilder sxb = new SAXBuilder();
            Document doc = sxb.build(stream);
            List versions = doc.getRootElement().getChildren("version");
            if (!versions.isEmpty()) {
                if (releaseName.equals(((Element)versions.get(0)).getChild("name").getText())) {
                    JOptionPane.showMessageDialog(null, "Assemble is up to date");
                    return false;
                }
                new UpdateFrame(versions);
                return true;
            }
            JOptionPane.showMessageDialog(null, "Assemble is up to date");
            return false;
        }
        catch (Exception e) {
            ErrorInfo errorInfo = new ErrorInfo("Error", "Problem during the update", null, null, (Throwable)e, Level.SEVERE, null);
            JXErrorPane.showDialog(null, (ErrorInfo)errorInfo);
            return false;
        }
    }

    public static String getMotifsPath() {
        String path = new StringBuffer(Assemble.getUserDirPath()).append("motifs").append(System.getProperty("file.separator")).toString();
        File f = new File(path);
        if (!f.exists()) {
            f.mkdir();
        }
        return path;
    }

    public static String getPluginsPath() {
        String path = new StringBuffer(Assemble.getUserDirPath()).append("plugins").append(System.getProperty("file.separator")).toString();
        File f = new File(path);
        if (!f.exists()) {
            f.mkdir();
        }
        return path;
    }

    public static void main(String[] args) throws BackingStoreException, IOException, JDOMException {
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        }
        catch (InstantiationException e) {
        }
        catch (ClassNotFoundException e) {
        }
        catch (UnsupportedLookAndFeelException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        AssembleConfig.parseConfigFile();
        if (args.length > 0 && "training".equals(args[0])) {
            new Training();
        } else {
            new SplashScreen();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UpdateFrame
    extends JFrame {
        private JProgressBar progressBar;
        private JLabel title;
        private SwingWorker currentTask;
        private List<String> newFiles;
        private List<String> filesToDelete;

        private UpdateFrame(List<Object> versions) throws IOException {
            super("Assemble Update");
            this.setDefaultCloseOperation(0);
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            this.progressBar = new JProgressBar(0, 100);
            this.progressBar.setValue(0);
            this.progressBar.setStringPainted(true);
            this.title = new JLabel("Searching first update...");
            panel.add((Component)this.title, "North");
            panel.add((Component)this.progressBar, "Center");
            panel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
            panel.setPreferredSize(new Dimension(400, 75));
            this.add(panel);
            this.pack();
            this.setResizable(false);
            GeneralUtils.centerOnScreen((Window)this);
            this.setVisible(true);
            boolean foundCurrentVersion = false;
            for (int i = versions.size() - 1; i >= 0; --i) {
                File f;
                Element newVersion = (Element)versions.get(i);
                if (!foundCurrentVersion && newVersion.getChild("name").getText().equals(Assemble.releaseName)) {
                    foundCurrentVersion = true;
                    continue;
                }
                if (!foundCurrentVersion) continue;
                if (newVersion.getAttribute("password") != null) {
                    String password = newVersion.getAttribute("password").getValue();
                    String userPassword = JOptionPane.showInputDialog(null, (Object)("Please enter a password to update to " + newVersion.getValue()));
                    if (userPassword == null || !password.equals(userPassword)) {
                        JOptionPane.showMessageDialog(null, "Wrong password");
                        this.dispose();
                        return;
                    }
                }
                this.newFiles = new ArrayList<String>();
                this.filesToDelete = new ArrayList<String>();
                this.setTitle("Update to " + newVersion.getChild("name").getText());
                for (Object _o : newVersion.getChild("files").getChildren("file")) {
                    Element file = (Element)_o;
                    if ("add".equals(file.getAttributeValue("action"))) {
                        this.title.setText("Add " + file.getChild("destination").getText());
                        this.updateFile(file.getChild("url").getText(), Assemble.getInstallPath() + file.getChild("destination").getText().replace('/', System.getProperty("file.separator").charAt(0)));
                        continue;
                    }
                    if (!"delete".equals(file.getAttributeValue("action"))) continue;
                    this.title.setText("Delete " + file.getChild("destination").getText());
                    this.filesToDelete.add(Assemble.getInstallPath() + file.getChild("destination").getText().replace('/', System.getProperty("file.separator").charAt(0)));
                }
                if (this.currentTask != null) {
                    while (!this.currentTask.isDone()) {
                    }
                }
                for (String newFile : this.newFiles) {
                    new File(newFile).delete();
                    new File(newFile + "_tmp").renameTo(new File(newFile));
                    if (!newFile.endsWith(".zip")) continue;
                    f = new File(newFile);
                    IOUtils.extractArchivedFile((String)f.getAbsolutePath(), (File)f);
                }
                for (String fileToDelete : this.filesToDelete) {
                    f = new File(fileToDelete);
                    if (f.isDirectory()) {
                        IOUtils.deleteDirectory((File)f);
                        continue;
                    }
                    f.delete();
                }
            }
            JOptionPane.showMessageDialog(null, "Assemble has been successfully updated to \"" + ((Element)versions.get(0)).getChild("name").getText() + "\"." + "\nRestart it to use the new version." + "\nRead the CHANGELOG file in the Assemble directory for details about this update.");
            this.dispose();
        }

        private void updateFile(final String fileToDownload, final String destination) {
            if (this.currentTask != null) {
                while (!this.currentTask.isDone()) {
                }
            }
            this.currentTask = new SwingWorker(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void doInBackground() {
                    URLConnection connection = null;
                    InputStream is = null;
                    FileOutputStream destinationFile = null;
                    try {
                        int currentPos;
                        URL url = new URL(fileToDownload);
                        connection = url.openConnection();
                        int length = connection.getContentLength();
                        UpdateFrame.this.progressBar.setMinimum(0);
                        UpdateFrame.this.progressBar.setMaximum(length);
                        UpdateFrame.this.progressBar.setValue(0);
                        if (length == -1) {
                            throw new IOException("Empty File");
                        }
                        is = new BufferedInputStream(connection.getInputStream());
                        byte[] data = new byte[length];
                        int currentBit = 0;
                        for (currentPos = 0; currentPos < length; currentPos += currentBit) {
                            UpdateFrame.this.progressBar.setValue(currentPos);
                            currentBit = is.read(data, currentPos, data.length - currentPos);
                            if (currentBit == -1) break;
                        }
                        if (currentPos != length) {
                            throw new IOException("The file has not been recovered completely: " + currentPos + " on " + length + ")");
                        }
                        destinationFile = new FileOutputStream(destination + "_tmp");
                        destinationFile.write(data);
                        destinationFile.flush();
                        UpdateFrame.this.newFiles.add(destination);
                    }
                    catch (MalformedURLException e) {
                        System.err.println("Malformed URL : " + fileToDownload);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    finally {
                        try {
                            is.close();
                            destinationFile.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    return null;
                }
            };
            this.currentTask.execute();
        }
    }

    class MessageBar
    extends JToolBar
    implements ProgressMonitor {
        private JTextField message;
        private JProgressBar progressBar;
        private MemoryMonitor memoryMonitor;
        private JLabel warning;
        private JLabel connectionStatus;
        private Exception currentException;
        private String messageAssociatedToTheException;
        private Timer timer;
        private Icon exclamation = RessourcesUtils.getIcon("16/exclamation.png");
        private Icon noExclamation = RessourcesUtils.getIcon("16/no-exclamation.png");

        MessageBar() {
            this.setFloatable(false);
            this.setBackground(Color.white);
            this.setLayout(new BoxLayout(this, 0));
            this.timer = new Timer(500, new ActionListener(){
                private boolean b = true;

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.b) {
                        MessageBar.this.warning.setIcon(MessageBar.this.exclamation);
                    } else {
                        MessageBar.this.warning.setIcon(MessageBar.this.noExclamation);
                    }
                    this.b = !this.b;
                }
            });
            this.message = new JTextField("Assemble ready...");
            this.message.setBackground(Color.white);
            this.message.setEditable(false);
            this.add(this.message);
            this.add(Box.createRigidArea(new Dimension(20, 0)));
            this.progressBar = new JProgressBar(){

                public Dimension getMaximumSize() {
                    return new Dimension(150, 20);
                }

                public Dimension getMinimumSize() {
                    return this.getMaximumSize();
                }

                public Dimension getPreferredSize() {
                    return this.getMaximumSize();
                }
            };
            this.add(this.progressBar);
            this.add(Box.createRigidArea(new Dimension(20, 0)));
            this.warning = new JLabel(this.noExclamation);
            this.warning.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    ErrorInfo errorInfo = new ErrorInfo("Error", MessageBar.this.messageAssociatedToTheException, null, null, (Throwable)MessageBar.this.currentException, Level.SEVERE, null);
                    MessageBar.this.timer.stop();
                    MessageBar.this.warning.setIcon(null);
                    MessageBar.this.currentException = null;
                    MessageBar.this.messageAssociatedToTheException = null;
                    JXErrorPane.showDialog(null, (ErrorInfo)errorInfo);
                }
            });
            this.add(this.warning);
            if (this.currentException == null) {
                this.warning.setToolTipText("No errors");
            } else {
                this.warning.setToolTipText("Click for error details");
            }
            this.add(Box.createRigidArea(new Dimension(5, 0)));
            this.connectionStatus = new JLabel(Assemble.this.isConnected() ? RessourcesUtils.getIcon("16/connect.png") : RessourcesUtils.getIcon("16/disconnect.png"));
            if (Assemble.this.isConnected()) {
                this.connectionStatus.setToolTipText("Connected to " + Assemble.this.workingSession.getPlatformAddress());
            } else {
                this.connectionStatus.setToolTipText("Not connected");
            }
            this.add(this.connectionStatus);
            this.add(Box.createRigidArea(new Dimension(20, 0)));
            this.memoryMonitor = new MemoryMonitor();
            this.add((Component)this.memoryMonitor);
            this.memoryMonitor.start();
        }

        public void printMessage(String message) {
            this.timer.stop();
            this.warning.setIcon(null);
            this.currentException = null;
            this.messageAssociatedToTheException = null;
            this.message.setText(message);
        }

        public void printException(Exception e) {
            this.timer.stop();
            this.warning.setIcon(null);
            this.currentException = null;
            this.messageAssociatedToTheException = null;
            if (NoSolutionException.class.isInstance(e)) {
                JOptionPane.showMessageDialog(Assemble.this.window, e.getMessage());
            } else {
                this.message.setText(e.getMessage());
                this.currentException = e;
                this.messageAssociatedToTheException = e.getMessage();
                this.timer.start();
            }
        }

        public void startAnimation() {
            this.progressBar.setIndeterminate(true);
        }

        public void stopAnimation() {
            this.progressBar.setIndeterminate(false);
        }
    }

    private class NewsPanel
    extends JXPanel {
        private static final String feedChannel = "http://serialized-thoughts.blogspot.com/feeds/posts/default";
        private List<Post> posts = new ArrayList<Post>();
        private String lastPostID;
        private AbstractTableModel dataModel;

        private NewsPanel() {
            this.setLayout(new BorderLayout());
            this.dataModel = new AbstractTableModel(){

                public int getColumnCount() {
                    return 2;
                }

                public int getRowCount() {
                    return NewsPanel.this.posts.size();
                }

                public Object getValueAt(int row, int col) {
                    Post p = (Post)NewsPanel.this.posts.get(row);
                    switch (col) {
                        case 0: {
                            return p.title;
                        }
                        case 1: {
                            return new SimpleDateFormat("yyyy.MM.dd HH:mm").format(p.date);
                        }
                    }
                    return null;
                }

                public String getColumnName(int col) {
                    switch (col) {
                        case 0: {
                            return "Post Title";
                        }
                        case 1: {
                            return "Publication Date";
                        }
                    }
                    return "?";
                }
            };
            final JXTable table = new JXTable((TableModel)this.dataModel);
            table.setEditable(false);
            table.setSortable(false);
            table.setColumnControlVisible(false);
            table.setHighlighters(new Highlighter[]{AlternateRowHighlighter.quickSilver});
            table.getColumnModel().getColumn(1).setMinWidth(200);
            table.getColumnModel().getColumn(1).setMaxWidth(200);
            table.getColumnModel().getColumn(1).setPreferredWidth(200);
            table.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseClicked(MouseEvent event) {
                    if (event.getClickCount() == 2) {
                        GeneralUtils.openBrowser((String)((Post)NewsPanel.this.posts.get(table.getSelectedRow())).url.toString());
                    }
                }
            });
            this.add(new JScrollPane((Component)table), "Center");
            new SwingWorker(){

                protected Object doInBackground() throws Exception {
                    NewsPanel.this.fetchRSSChannel();
                    new Timer(1800000, new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            try {
                                NewsPanel.this.fetchRSSChannel();
                            }
                            catch (FeedException e) {
                                e.printStackTrace();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }).start();
                    return null;
                }
            }.execute();
        }

        private void fetchRSSChannel() throws FeedException, IOException {
            SyndFeedInput sfi = new SyndFeedInput();
            SyndFeed feed = sfi.build((Reader)new XmlReader(new URL(feedChannel)));
            if (this.lastPostID == null) {
                for (Object o : feed.getEntries()) {
                    SyndEntry entry = (SyndEntry)o;
                    Post p = new Post();
                    p.id = entry.getUri();
                    if (this.lastPostID == null) {
                        this.lastPostID = p.id;
                    }
                    p.title = entry.getTitle();
                    p.url = new URL(entry.getLink());
                    p.date = entry.getPublishedDate();
                    this.posts.add(p);
                    this.dataModel.fireTableRowsInserted(this.posts.size() - 1, this.posts.size() - 1);
                }
            } else {
                Object o;
                SyndEntry entry;
                int i = 0;
                Iterator i$ = feed.getEntries().iterator();
                while (i$.hasNext() && !this.lastPostID.equals((entry = (SyndEntry)(o = i$.next())).getUri())) {
                    Post p = new Post();
                    p.id = entry.getUri();
                    if (this.lastPostID == null) {
                        this.lastPostID = p.id;
                    }
                    p.title = entry.getTitle();
                    p.url = new URL(entry.getLink());
                    p.date = entry.getPublishedDate();
                    this.posts.add(i++, p);
                    this.dataModel.fireTableRowsInserted(i - 1, i - 1);
                }
                if (i > 0) {
                    this.lastPostID = this.posts.get(0).id;
                    Assemble.this.mediator.getToolWindowManager().getToolWindow((Object)"News").setFlashing(true);
                }
            }
        }

        private class Post {
            private String title;
            private String id;
            private URL url;
            private Date date;

            private Post() {
            }
        }
    }

    private class UndoHistoryPanel
    extends JXPanel {
        private JXTable table;

        private UndoHistoryPanel() {
            this.setLayout(new BorderLayout());
            this.table = new JXTable();
            this.table.setBackground(Color.WHITE);
            this.table.setHighlighters(new Highlighter[]{AlternateRowHighlighter.quickSilver});
            this.table.setSortable(false);
            this.table.setModel((TableModel)new DefaultTableModel(new Object[0][2], new String[]{"Name", "Date"}){
                Class[] types;
                boolean[] canEdit;
                {
                    super(x0, x1);
                    this.types = new Class[]{String.class, Date.class};
                    this.canEdit = new boolean[]{false, false};
                }

                public Class getColumnClass(int columnIndex) {
                    return this.types[columnIndex];
                }

                public boolean isCellEditable(int rowIndex, int columnIndex) {
                    return this.canEdit[columnIndex];
                }
            });
            this.table.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        Assemble.this.mediator.restoreState((String)UndoHistoryPanel.this.table.getValueAt(UndoHistoryPanel.this.table.getSelectedRow(), 0));
                        Assemble.this.mediator.getGlobalSelection().clear();
                    }
                }
            });
            this.table.getColumn((Object)"Date").setCellRenderer(new TableCellRenderer(){

                public Component getTableCellRendererComponent(JTable table, Object o, boolean isSelected, boolean hasFocus, int row, int column) {
                    JLabel label = new JLabel(new SimpleDateFormat("yyyy.MM.dd HH:mm").format((Date)o));
                    label.setOpaque(true);
                    label.setFont(new Font(label.getFont().getName(), 0, label.getFont().getSize()));
                    if (isSelected) {
                        label.setForeground(table.getSelectionForeground());
                        label.setBackground(table.getSelectionBackground());
                    } else {
                        label.setForeground(table.getForeground());
                        label.setBackground(table.getBackground());
                    }
                    return label;
                }
            });
            this.add(new JScrollPane((Component)this.table), "Center");
        }
    }

    private class AssembleEditionPanel
    extends JXPanel {
        private AssembleEditionPanel() {
            this.setLayout((LayoutManager)new MigLayout("", "[left]"));
            this.setBackground(Color.WHITE);
        }
    }

    private class AssembleSelectionPanel
    extends JXPanel {
        private AssembleSelectionPanel() {
            this.setLayout((LayoutManager)new MigLayout("", "[left]"));
            this.setBackground(Color.WHITE);
        }
    }

    private class AssembleDisplayPanel
    extends JXPanel {
        private AssembleDisplayPanel() {
            this.setLayout((LayoutManager)new MigLayout("", "[left]"));
            this.setBackground(Color.WHITE);
        }
    }

    private class SecondaryStructureDisplayPanel
    extends JXPanel {
        private JCheckBox fiveToThreeCheckBox;
        private JCheckBox labels;

        private SecondaryStructureDisplayPanel() {
            this.setLayout((LayoutManager)new VerticalLayout(5));
            this.setBackground(Color.WHITE);
            JXPanel subPanel = new JXPanel();
            subPanel.setBackground(Color.WHITE);
            subPanel.add((Component)new LWFamilyButton("CWW"));
            subPanel.add((Component)new LWFamilyButton("TWW"));
            this.add((Component)subPanel);
            subPanel = new JXPanel();
            subPanel.setBackground(Color.WHITE);
            subPanel.add((Component)new LWFamilyButton("CHW"));
            subPanel.add((Component)new LWFamilyButton("THW"));
            this.add((Component)subPanel);
            subPanel = new JXPanel();
            subPanel.setBackground(Color.WHITE);
            subPanel.add((Component)new LWFamilyButton("CHH"));
            subPanel.add((Component)new LWFamilyButton("THH"));
            this.add((Component)subPanel);
            subPanel = new JXPanel();
            subPanel.setBackground(Color.WHITE);
            subPanel.add((Component)new LWFamilyButton("CHS"));
            subPanel.add((Component)new LWFamilyButton("THS"));
            this.add((Component)subPanel);
            subPanel = new JXPanel();
            subPanel.setBackground(Color.WHITE);
            subPanel.add((Component)new LWFamilyButton("CSW"));
            subPanel.add((Component)new LWFamilyButton("TSW"));
            this.add((Component)subPanel);
            subPanel = new JXPanel();
            subPanel.setBackground(Color.WHITE);
            subPanel.add((Component)new LWFamilyButton("CSS"));
            subPanel.add((Component)new LWFamilyButton("TSS"));
            this.add((Component)subPanel);
            subPanel = new JXPanel();
            subPanel.setBackground(Color.WHITE);
            subPanel.setLayout((LayoutManager)new VerticalLayout());
            this.fiveToThreeCheckBox = new JCheckBox("5'->3' orientation");
            this.fiveToThreeCheckBox.setBackground(Color.WHITE);
            this.fiveToThreeCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas() != null) {
                        Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().setFiveToThreeOrientationDisplay(!Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().isFiveToThreeOrientationDisplayed());
                    }
                }
            });
            subPanel.add((Component)this.fiveToThreeCheckBox);
            this.add((Component)subPanel);
            subPanel = new JXPanel();
            subPanel.setBackground(Color.WHITE);
            subPanel.setLayout((LayoutManager)new VerticalLayout());
            this.labels = new JCheckBox("labels");
            this.labels.setBackground(Color.WHITE);
            this.labels.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas() != null) {
                        Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().setDisplayLabels(SecondaryStructureDisplayPanel.this.labels.isSelected());
                    }
                }
            });
            subPanel.add((Component)this.labels);
            this.add((Component)subPanel);
        }

        private void updateDisplayOptions() {
            if (Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas() != null) {
                this.fiveToThreeCheckBox.setSelected(Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().isFiveToThreeOrientationDisplayed());
                this.labels.setSelected(Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().isLabelsDisplayed());
                for (Component c : this.getComponents()) {
                    if (!JXPanel.class.isInstance(c)) continue;
                    for (Component _c : ((JXPanel)c).getComponents()) {
                        if (!LWFamilyButton.class.isInstance(_c)) continue;
                        ((LWFamilyButton)_c).update(Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas());
                    }
                }
            }
        }

        private class LWFamilyButton
        extends JButton {
            private String family;

            private LWFamilyButton(final String family) {
                this.family = family;
                this.setIcon(new ImageIcon(RessourcesUtils.getImage(family + ".png")));
                this.setBackground(Color.WHITE);
                this.setToolTipText("Display/Hide this family");
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        if (Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas() != null) {
                            if (family.equals("CSs")) {
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("CSS");
                            } else if (family.equals("TSs")) {
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("TSS");
                            } else if (family.equals("CsS")) {
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("CSS");
                            } else if (family.equals("TsS")) {
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("TSS");
                            } else if (family.equals("CSS")) {
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("CSS");
                            } else if (family.equals("TSS")) {
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("TSS");
                            } else if (family.equals("CWH")) {
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("CHW");
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("CWH");
                            } else if (family.equals("CHW")) {
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("CHW");
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("CWH");
                            } else if (family.equals("TWH")) {
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("THW");
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("TWH");
                            } else if (family.equals("THW")) {
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("THW");
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("TWH");
                            } else if (family.equals("CHS")) {
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("CHS");
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("CSH");
                            } else if (family.equals("CSH")) {
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("CHS");
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("CSH");
                            } else if (family.equals("THS")) {
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("THS");
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("TSH");
                            } else if (family.equals("TSH")) {
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("THS");
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("TSH");
                            } else if (family.equals("CWS")) {
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("CSW");
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("CWS");
                            } else if (family.equals("CSW")) {
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("CSW");
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("CWS");
                            } else if (family.equals("TWS")) {
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("TSW");
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("TWS");
                            } else if (family.equals("TSW")) {
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("TSW");
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily("TWS");
                            } else {
                                Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().addFamily(family);
                            }
                            if (Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().displayFamily(family)) {
                                LWFamilyButton.this.setIcon(new ImageIcon(RessourcesUtils.getImage(family + ".png")));
                            } else {
                                LWFamilyButton.this.setIcon(new ImageIcon(RessourcesUtils.getImage(family + "_hidden.png")));
                            }
                        }
                    }
                });
            }

            private void update(SecondaryCanvas canvas) {
                if (canvas.displayFamily(this.family)) {
                    this.setIcon(new ImageIcon(RessourcesUtils.getImage(this.family + ".png")));
                } else {
                    this.setIcon(new ImageIcon(RessourcesUtils.getImage(this.family + "_hidden.png")));
                }
            }
        }
    }

    private class RNAMotifPanel
    extends JXPanel {
        private JLabel snapshot;
        private BufferedImage image;

        private RNAMotifPanel() {
            this.setLayout((LayoutManager)new MigLayout("", "[left]"));
            this.setBackground(Color.WHITE);
            this.snapshot = new JLabel();
            this.snapshot.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            this.snapshot.setIcon(new ImageIcon(RessourcesUtils.getImage("no_capture.png")));
            this.add(this.snapshot, "span");
            JButton capture = new JButton("capture");
            capture.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    if (Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().getModel2D() != null) {
                        RNAMotifPanel.this.image = Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().getImage(true);
                        if (RNAMotifPanel.this.image != null) {
                            RNAMotifPanel.this.snapshot.setIcon(new ImageIcon(RNAMotifPanel.this.image));
                        }
                    }
                }
            });
            this.add(capture, "span");
            this.add(new JLabel("RNA Motif Details"), "split, span, gaptop 20");
            this.add(new JSeparator(), "growx, wrap, gaptop 20");
            this.add(new JLabel("Name"), "gap 10");
            final JTextField motifName = new JTextField(10);
            this.add(motifName, "span");
            this.add(new JLabel("Category"), "gap 10");
            final ArrayList<String> motifCategories = new ArrayList<String>();
            for (File f : new File(Assemble.getMotifsPath()).listFiles()) {
                if (!f.isDirectory()) continue;
                motifCategories.add(f.getName());
            }
            final JComboBox<Object> motifCategory = new JComboBox<Object>(motifCategories.toArray());
            this.add(motifCategory);
            JButton b = new JButton("Create new category");
            b.setBackground(Color.WHITE);
            this.add(b, "wrap");
            b.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    String newCategoryName = JOptionPane.showInputDialog(Assemble.this.window, (Object)"Choose a new category name");
                    if (newCategoryName != null && newCategoryName.length() != 0) {
                        if (motifCategories.contains(newCategoryName)) {
                            JOptionPane.showMessageDialog(Assemble.this.window, "This category already exists!!");
                        } else {
                            new File(new File(Assemble.getMotifsPath()), newCategoryName).mkdir();
                            motifCategory.addItem(newCategoryName);
                            motifCategory.setSelectedItem(newCategoryName);
                        }
                    }
                }
            });
            this.add(new JLabel("Comment"), "span, gap 10");
            final JTextArea comment = new JTextArea(10, 30);
            this.add(new JScrollPane(comment), "span, gap 10");
            b = new JButton("Create motif");
            b.setBackground(Color.WHITE);
            b.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    List tss = Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().getModel2D().getSecondaryStructure().getParentFeatures(TertiaryStructure.class);
                    if (Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().getModel2D() != null && RNAMotifPanel.this.image != null && tss.size() != 0 && motifCategory.getSelectedItem() != null && motifName.getText().trim().length() != 0) {
                        try {
                            File rnamlFile2D = new File(new File(new File(Assemble.getMotifsPath()), (String)motifCategory.getSelectedItem()), motifName.getText().trim() + ".rnaml");
                            if (rnamlFile2D.exists()) {
                                JOptionPane.showMessageDialog(Assemble.this.window, "A motif with the name " + motifName.getText().trim() + " already exists!!");
                                return;
                            }
                            rnamlFile2D.createNewFile();
                            HashMap<Molecule, MyTreeSet> sortedResidues3D = new HashMap<Molecule, MyTreeSet>();
                            TertiaryStructure ts = (TertiaryStructure)tss.get(0);
                            for (Residue2D r : Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().getGraphicContext().getSelectedResiduesFromMotif()) {
                                Molecule m = (Molecule)r.getResidue2DFeature().getMolecules().iterator().next();
                                MyTreeSet _residues3D = (MyTreeSet)sortedResidues3D.get(m);
                                int position = r.getResidue2DFeature().getFullLocation(m).getStart();
                                if (_residues3D != null) {
                                    _residues3D.add(position, ts.getResidue3DAt(position, m));
                                    continue;
                                }
                                _residues3D = new MyTreeSet(m);
                                _residues3D.add(position, ts.getResidue3DAt(position, m));
                                sortedResidues3D.put(m, _residues3D);
                            }
                            Element rnaml = new Element("rnaml");
                            Document doc = new Document(rnaml);
                            Element tertiaryStructure = new Element("tertiary-structure");
                            tertiaryStructure.setAttribute("name", motifName.getText());
                            Element structureAnnotation = new Element("structure-annotation");
                            structureAnnotation.setAttribute("name", motifName.getText());
                            StringBuffer moleculeIds = new StringBuffer();
                            for (Map.Entry _e : sortedResidues3D.entrySet()) {
                                List<LocatedString> subSequences = ((MyTreeSet)_e.getValue()).getSubSequences();
                                for (LocatedString s : subSequences) {
                                    Element molecule = new Element("molecule");
                                    molecule.setAttribute("id", ((Molecule)_e.getKey()).getName() + subSequences.indexOf(s));
                                    moleculeIds.append(((Molecule)_e.getKey()).getName() + subSequences.indexOf(s) + " ");
                                    molecule.setAttribute("type", "rna");
                                    molecule.setAttribute("start", "" + s.location.getStart());
                                    molecule.setAttribute("end", "" + s.location.getEnd());
                                    rnaml.addContent((Content)molecule);
                                    Element identity = new Element("identity");
                                    molecule.addContent((Content)identity);
                                    Element name = new Element("name");
                                    identity.addContent((Content)name);
                                    name.addContent(((Molecule)_e.getKey()).getName() + subSequences.indexOf(s));
                                    Element sequence = new Element("sequence");
                                    molecule.addContent((Content)sequence);
                                    sequence.setAttribute("length", "" + s.subSequence.length());
                                    Element seqData = new Element("seq-data");
                                    seqData.addContent(s.subSequence);
                                    sequence.addContent((Content)seqData);
                                    for (Residue3D r : (MyTreeSet)_e.getValue()) {
                                        int position = r.getFullLocation((Molecule)_e.getKey()).getStart();
                                        if (!s.location.hasPosition(position)) continue;
                                        Element base = new Element("base");
                                        base.setAttribute("molecule-id", ((Molecule)_e.getKey()).getName() + subSequences.indexOf(s));
                                        tertiaryStructure.addContent((Content)base);
                                        int[] ends = s.location.getBoundaries();
                                        for (int i = 0; i < ends.length - 1; i += 2) {
                                            if (position < ends[i] || position > ends[i + 1]) continue;
                                            base.setAttribute("id", "" + (position - ends[i] + 1));
                                            break;
                                        }
                                        for (Residue3D.Atom a : r.getAtoms()) {
                                            if (!a.hasCoordinatesFilled()) continue;
                                            Element atom = new Element("atom");
                                            atom.setAttribute("type", a.getName());
                                            atom.setAttribute("x", "" + a.getX());
                                            atom.setAttribute("y", "" + a.getY());
                                            atom.setAttribute("z", "" + a.getZ());
                                            base.addContent((Content)atom);
                                        }
                                    }
                                }
                            }
                            tertiaryStructure.setAttribute("molecule-ids", moleculeIds.toString().trim());
                            rnaml.addContent((Content)tertiaryStructure);
                            structureAnnotation.setAttribute("molecule-ids", moleculeIds.toString().trim());
                            List<Interaction2D> interactionsToExport = Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().getGraphicContext().getSelectedInteractionsFromMotif();
                            for (Interaction2D interaction : interactionsToExport) {
                                int i;
                                int[] ends;
                                if (!BaseBaseInteraction2D.class.isInstance(interaction)) continue;
                                Molecule molecule = (Molecule)interaction.getResidue().getResidues().listIterator().next().getResidue2DFeature().getMolecules().iterator().next();
                                Molecule partnerMolecule = (Molecule)interaction.getPartnerResidue().getResidues().listIterator().next().getResidue2DFeature().getMolecules().iterator().next();
                                MyTreeSet treeSet = (MyTreeSet)sortedResidues3D.get(molecule);
                                MyTreeSet partnerTreeSet = (MyTreeSet)sortedResidues3D.get(partnerMolecule);
                                Element basePair = new Element("base-pair");
                                structureAnnotation.addContent((Content)basePair);
                                List<LocatedString> subSequences = treeSet.getSubSequences();
                                int position = interaction.getResidue().getAbsolutePosition();
                                basePair.setAttribute("orientation", "" + ((BaseBaseInteraction2D)interaction).getBaseBaseInteractionFeature().getOrientation());
                                block9: for (LocatedString s : subSequences) {
                                    if (!s.location.hasPosition(position)) continue;
                                    basePair.setAttribute("molecule1-id", molecule.getName() + subSequences.indexOf(s));
                                    ends = s.location.getBoundaries();
                                    for (i = 0; i < ends.length - 1; i += 2) {
                                        if (position < ends[i] || position > ends[i + 1]) continue;
                                        basePair.setAttribute("base1-id", "" + (position - ends[i] + 1));
                                        break block9;
                                    }
                                }
                                basePair.setAttribute("edge1", "" + ((BaseBaseInteraction2D)interaction).getBaseBaseInteractionFeature().getEdge1());
                                subSequences = partnerTreeSet.getSubSequences();
                                position = interaction.getPartnerResidue().getAbsolutePosition();
                                block11: for (LocatedString s : subSequences) {
                                    if (!s.location.hasPosition(position)) continue;
                                    basePair.setAttribute("molecule2-id", molecule.getName() + subSequences.indexOf(s));
                                    ends = s.location.getBoundaries();
                                    for (i = 0; i < ends.length - 1; i += 2) {
                                        if (position < ends[i] || position > ends[i + 1]) continue;
                                        basePair.setAttribute("base2-id", "" + (position - ends[i] + 1));
                                        break block11;
                                    }
                                }
                                basePair.setAttribute("edge2", "" + ((BaseBaseInteraction2D)interaction).getBaseBaseInteractionFeature().getEdge2());
                            }
                            rnaml.addContent((Content)structureAnnotation);
                            XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
                            FileWriter writer = new FileWriter(rnamlFile2D);
                            outputter.output(doc, (Writer)writer);
                            writer.close();
                            File pngFile = new File(new File(new File(Assemble.getMotifsPath()), (String)motifCategory.getSelectedItem()), motifName.getText().trim() + ".png");
                            ImageIO.write((RenderedImage)RNAMotifPanel.this.image, "png", pngFile);
                            File commentFile = new File(new File(Assemble.getMotifsPath(), (String)motifCategory.getSelectedItem()), motifName.getText().trim() + ".txt");
                            PrintWriter pw = new PrintWriter(commentFile);
                            pw.write(comment.getText());
                            pw.close();
                            JOptionPane.showMessageDialog(Assemble.this.window, "New motif created!!");
                            Assemble.this.rnaMotifsBrowser.addNewMotifEntry(rnamlFile2D, (String)motifCategory.getSelectedItem());
                        }
                        catch (IOException e1) {
                            JOptionPane.showMessageDialog(Assemble.this.window, "Cannot create the new RNA motif!!");
                            return;
                        }
                    }
                }

                class LocatedString {
                    private String subSequence;
                    private Location location;

                    LocatedString(String subSequence, Location l) {
                        this.subSequence = subSequence;
                        this.location = l;
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class MyTreeSet
                extends TreeSet<Residue3D> {
                    private Molecule m;
                    private Location location;

                    private MyTreeSet(final Molecule m) {
                        super(new Comparator(){

                            public int compare(Object o1, Object o2) {
                                return ((Residue3D)o1).getFullLocation(m).getStart() - ((Residue3D)o2).getFullLocation(m).getStart();
                            }

                            public boolean equals(Object obj) {
                                return false;
                            }
                        });
                        this.m = m;
                        this.location = new Location();
                    }

                    public void add(int position, Residue3D residue3D) {
                        if (super.add(residue3D)) {
                            this.location.add(position);
                        }
                    }

                    public List<LocatedString> getSubSequences() {
                        ArrayList<LocatedString> subSequences = new ArrayList<LocatedString>();
                        String sequence = this.m.printSequence();
                        int[] boundaries = this.location.getBoundaries();
                        for (int i = 0; i < boundaries.length - 1; i += 2) {
                            subSequences.add(new LocatedString(sequence.substring(boundaries[i] - 1, boundaries[i + 1]), new Location(boundaries[i], boundaries[i + 1])));
                        }
                        return subSequences;
                    }
                }
            });
            this.add(b, "span, gap 10");
        }
    }

    private class FlatButton
    extends JButton {
        private FlatButton(String url, String name) {
            this(RessourcesUtils.getIcon(url), name);
        }

        private FlatButton(Icon image, String name) {
            super(image);
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setBorderPainted(false);
            this.setBackground(Color.WHITE);
            this.addMouseListener(new MouseAdapter(){

                public void mouseEntered(MouseEvent e) {
                    FlatButton.this.setBackground(Color.LIGHT_GRAY);
                    FlatButton.this.setBorderPainted(true);
                }

                public void mouseExited(MouseEvent e) {
                    FlatButton.this.setBackground(Color.WHITE);
                    FlatButton.this.setBorderPainted(false);
                }
            });
            this.setToolTipText(name);
        }

        public Point getToolTipLocation(MouseEvent e) {
            return new Point(0, 0);
        }
    }

    private class PreferencesMenu
    extends JMenu
    implements ActionListener {
        private JMenuItem keyManager;
        private JMenuItem renderingOptions;

        private PreferencesMenu() {
            super("Preferences");
            this.keyManager = new JMenuItem("Keyboard Shortcuts");
            this.renderingOptions = new JMenuItem("3D Rendering Parameters");
            this.add(this.keyManager);
            this.add(this.renderingOptions);
            this.keyManager.addActionListener(this);
            this.renderingOptions.addActionListener(this);
            this.keyManager.setIcon(RessourcesUtils.getIcon("22/keyboard.png"));
            this.renderingOptions.setIcon(RessourcesUtils.getIcon("22/parameters.png"));
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
        }
    }

    private class PluginsMenu
    extends JMenu {
        private PluginsMenu() {
            super("Plugins");
            File pluginsDir = new File(Assemble.getPluginsPath());
            for (File pluginDir : pluginsDir.listFiles(new java.io.FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory();
                }
            })) {
                File script = new File(pluginDir, "Plugin.groovy");
                if (!script.exists()) continue;
                try {
                    Class pluginClass = Assemble.this.groovyShell.getClassLoader().parseClass(script);
                    this.add(new PluginMenuItem((GroovyObject)pluginClass.newInstance()));
                }
                catch (Exception e) {
                    ErrorInfo errorInfo = new ErrorInfo("Error", "Problem to load the plugin " + pluginDir, null, null, (Throwable)e, Level.SEVERE, null);
                    JXErrorPane.showDialog(null, (ErrorInfo)errorInfo);
                }
            }
        }

        private class PluginMenuItem
        extends JMenuItem {
            private GroovyObject plugin;

            private PluginMenuItem(final GroovyObject plugin) {
                super((String)plugin.invokeMethod("getTitle", null));
                this.setToolTipText((String)plugin.invokeMethod("getDescription", null));
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        new SwingWorker(){

                            protected Object doInBackground() {
                                try {
                                    plugin.invokeMethod("run", (Object)new Object[]{Assemble.this});
                                }
                                catch (Exception e) {
                                    ErrorInfo errorInfo = new ErrorInfo("Error", "Problem to execute the plugin", null, null, (Throwable)e, Level.SEVERE, null);
                                    JXErrorPane.showDialog(null, (ErrorInfo)errorInfo);
                                }
                                return null;
                            }
                        }.execute();
                    }
                });
            }
        }
    }

    private class EditMenu
    extends JMenu
    implements ActionListener {
        private JMenuItem cut;
        private JMenuItem bind;
        private JMenuItem bindAll;
        private JMenuItem superimposeAtom;
        private JMenuItem superimposeStruct;
        private JMenuItem torsion;
        private JMenuItem deleteMolecule;
        private JMenuItem stackblock;

        private EditMenu() {
            super("Edit");
            this.cut = new JMenuItem("Cut Chain");
            this.bind = new JMenuItem("Bind Chains");
            this.bindAll = new JMenuItem("Bind All Chains");
            this.superimposeAtom = new JMenuItem("Superimpose 2 atoms");
            this.superimposeStruct = new JMenuItem("Superimpose 2 similar structures");
            this.torsion = new JMenuItem("Torsions");
            this.deleteMolecule = new JMenuItem("Delete Molecule");
            this.stackblock = new JMenuItem("Stack All Building Blocks");
            this.addSeparator();
            this.add(this.cut);
            this.add(this.bind);
            this.add(this.bindAll);
            this.addSeparator();
            this.add(this.superimposeAtom);
            this.add(this.superimposeStruct);
            this.addSeparator();
            this.add(this.torsion);
            this.add(this.deleteMolecule);
            this.add(this.stackblock);
            this.cut.addActionListener(this);
            this.bind.addActionListener(this);
            this.bindAll.addActionListener(this);
            this.superimposeAtom.addActionListener(this);
            this.superimposeStruct.addActionListener(this);
            this.torsion.addActionListener(this);
            this.deleteMolecule.addActionListener(this);
            this.stackblock.addActionListener(this);
            this.torsion.setAccelerator(KeyStroke.getKeyStroke(84, 2));
            this.cut.setIcon(RessourcesUtils.getIcon("22/cut.png"));
            this.bind.setIcon(RessourcesUtils.getIcon("22/link.png"));
            this.bindAll.setIcon(RessourcesUtils.getIcon("22/link.png"));
            this.superimposeAtom.setIcon(RessourcesUtils.getIcon("22/superimpose.png"));
            this.superimposeStruct.setIcon(RessourcesUtils.getIcon("22/superimpose.png"));
            this.torsion.setIcon(RessourcesUtils.getIcon("22/torsion.png"));
            this.deleteMolecule.setIcon(RessourcesUtils.getIcon("22/unselect.png"));
            this.stackblock.setIcon(RessourcesUtils.getIcon("22/stackall.png"));
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == this.cut) {
                if (Assemble.this.mediator.getGlobalSelection().getSelectedResidues().size() != 1) {
                    JOptionPane.showMessageDialog(Assemble.this.window, "Select only one residue to use this option.");
                } else {
                    fr.unistra.ibmc.assemble.structures.Residue r = Assemble.this.mediator.getGlobalSelection().getSelectedResidues().iterator().next();
                    if (r.getChain().getLength() > 1) {
                        ((ResidueNA)r).splitChain();
                        Assemble.this.mediator.getRenderer().reComputeNeeded();
                    }
                }
            } else if (source == this.torsion) {
                if (Assemble.this.mediator.getGlobalSelection().getSelectedResidues().size() != 1) {
                    JOptionPane.showMessageDialog(Assemble.this.window, "Select only one residue to use this option.");
                } else {
                    Assemble.this.mediator.getResidueManager().setResidue(Assemble.this.mediator.getGlobalSelection().getSelectedResidues().iterator().next());
                    ToolWindow toolWindow = Assemble.this.mediator.getToolWindowManager().getToolWindow((Object)"ResidueManager");
                    if (toolWindow == null) {
                        toolWindow = Assemble.this.mediator.getToolWindowManager().registerToolWindow("ResidueManager", "Residue Manager", null, (Component)new JScrollPane((Component)((Object)Assemble.this.mediator.getResidueManager())), ToolWindowAnchor.RIGHT);
                    }
                    DockedTypeDescriptor descriptor = (DockedTypeDescriptor)toolWindow.getTypeDescriptor(ToolWindowType.DOCKED);
                    descriptor.setDockLength(300);
                    descriptor.setPreviewEnabled(false);
                    toolWindow.setAvailable(true);
                    toolWindow.setVisible(true);
                }
            } else if (source == this.bind) {
                if (Assemble.this.mediator.getGlobalSelection().getSelectedResidues().size() != 2) {
                    JOptionPane.showMessageDialog(Assemble.this.window, "Select only two residues to use this option.");
                } else {
                    Iterator<fr.unistra.ibmc.assemble.structures.Residue> it = Assemble.this.mediator.getGlobalSelection().getSelectedResidues().iterator();
                    fr.unistra.ibmc.assemble.structures.Residue r1 = it.next();
                    fr.unistra.ibmc.assemble.structures.Residue r2 = it.next();
                    ((ResidueNA)r1).bind((ResidueNA)r2);
                    Assemble.this.mediator.get3DModel().fireModelModified();
                }
            } else if (source == this.bindAll) {
                Assemble.this.mediator.get3DModel().bindAllChains();
                Assemble.this.mediator.get3DModel().fireModelModified();
            } else if (source == this.superimposeAtom) {
                Assemble.this.mediator.getRenderer().setSelectMode(48);
            } else if (source == this.superimposeStruct) {
                Assemble.this.mediator.getRenderer().setSelectMode(50);
            } else if (source == this.deleteMolecule) {
                Assemble.this.mediator.getRenderer().setSelectMode(47);
            } else if (source == this.stackblock) {
                for (Molecule molecule : Assemble.this.getWorkingSession().getMolecules()) {
                    Assemble.this.mediator.get3DModel().stackBuildingBlockInOrder((RNA)molecule);
                }
                Assemble.this.mediator.get3DModel().fireModelModified();
            }
        }
    }

    private class HelpMenu
    extends JMenu {
        private HelpMenu() {
            super("Help");
            this.add(new UpdateMenuItem());
            this.add(new OpenWebPageItem("Assemble Website", "http://bioinformatics.org/assemble/"));
        }

        private class UpdateMenuItem
        extends JMenuItem
        implements ActionListener {
            private UpdateMenuItem() {
                super("Update Assemble");
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                new SwingWorker(){

                    protected Object doInBackground() throws Exception {
                        Assemble.updateAssemble();
                        return null;
                    }
                }.execute();
            }
        }

        private class OpenWebPageItem
        extends JMenuItem
        implements ActionListener {
            private String url;

            public OpenWebPageItem(String webPageTitle, String url) {
                super(webPageTitle);
                this.url = url;
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                GeneralUtils.openBrowser((String)this.url);
            }
        }
    }

    private class TertiarySelectionMenu
    extends JMenu {
        private JMenuItem createUserSelection;

        public TertiarySelectionMenu() {
            super("3D Selection");
            this.createUserSelection = new JMenuItem("Store selection");
            this.add(this.createUserSelection);
            this.createUserSelection.setIcon(RessourcesUtils.getIcon("22/user.png"));
            this.createUserSelection.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    String name = JOptionPane.showInputDialog("Choose a name for your selection");
                    if (name != null && name.length() != 0) {
                        UserSelection us = new UserSelection(Assemble.this.mediator, name);
                        for (fr.unistra.ibmc.assemble.structures.Residue r : Assemble.this.mediator.getGlobalSelection().getSelectedResidues()) {
                            us.add(r);
                        }
                        for (Atom a : Assemble.this.mediator.getGlobalSelection().getSelectedAtoms()) {
                            us.add(a);
                        }
                        Assemble.this.mediator.addUserSelection(us);
                    }
                }
            });
            JMenu mutateResidues = new JMenu("Mutate as...");
            JMenuItem item = new JMenuItem("A");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    for (fr.unistra.ibmc.assemble.structures.Residue residue : Assemble.this.mediator.getGlobalSelection().getSelectedResidues()) {
                    }
                }
            });
            mutateResidues.add(item);
            item = new JMenuItem("U");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                }
            });
            mutateResidues.add(item);
            item = new JMenuItem("G");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                }
            });
            mutateResidues.add(item);
            item = new JMenuItem("C");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                }
            });
            mutateResidues.add(item);
            item = new JMenuItem("Center");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    Assemble.this.mediator.getRenderer().setPivot(Assemble.this.mediator.getGlobalSelection().getSelectionCenter());
                    Assemble.this.mediator.getGlobalSelection().fireRenderingModified();
                    Assemble.this.mediator.getGlobalSelection().fireRenderingModified();
                }
            });
            this.add(item);
            JMenu colorMenu = new JMenu("Color");
            item = new JMenuItem("By Atom Type");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    Assemble.this.mediator.getGlobalSelection().setAtomsDefaultColor();
                }
            });
            colorMenu.add(item);
            item = new JMenuItem("By Residue Type");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    Assemble.this.mediator.getGlobalSelection().setResiduesDefaultColor();
                }
            });
            colorMenu.add(item);
            colorMenu.add(new ColorMenu("Custom Color"));
            this.add(colorMenu);
            JMenu menu = new JMenu("Show");
            this.add(menu);
            item = new JMenuItem("Only");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    List<Atom> allAtoms = Assemble.this.mediator.get3DModel().getAtoms();
                    allAtoms.removeAll(Assemble.this.mediator.getGlobalSelection().getSelectedAtoms());
                    for (Atom a : allAtoms) {
                        a.setRenderingMode(7);
                    }
                    List<fr.unistra.ibmc.assemble.structures.Residue> allResidues = Assemble.this.mediator.get3DModel().getResidues();
                    allResidues.removeAll(Assemble.this.mediator.getGlobalSelection().getSelectedResidues());
                    for (fr.unistra.ibmc.assemble.structures.Residue r : allResidues) {
                        r.setRenderingMode(7);
                    }
                    Assemble.this.mediator.getGlobalSelection().setRenderingMode(1);
                }
            });
            menu.add(item);
            JMenu atomsAs = new JMenu("Atoms as");
            menu.add(atomsAs);
            item = new JMenuItem("Lines", RessourcesUtils.getIcon("50/mesh.png"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    Assemble.this.mediator.getGlobalSelection().setRenderingMode(1);
                }
            });
            atomsAs.add(item);
            item = new JMenuItem("Sticks", RessourcesUtils.getIcon("50/stickball.png"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    Assemble.this.mediator.getGlobalSelection().setRenderingMode(3);
                }
            });
            atomsAs.add(item);
            item = new JMenuItem("Covalence radius", RessourcesUtils.getIcon("50/cov.png"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    Assemble.this.mediator.getGlobalSelection().setRenderingMode(2);
                }
            });
            JMenu labels = new JMenu("Labels");
            menu.add(labels);
            item = new JMenuItem("Atom");
            item.setIcon(RessourcesUtils.getIcon("22/label.png"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    for (Atom a : Assemble.this.mediator.getGlobalSelection().getSelectedAtoms()) {
                        Assemble.this.mediator.get3DModel().addLabel(new AtomLabel(Assemble.this.mediator, a));
                    }
                }
            });
            labels.add(item);
            item = new JMenuItem("Distance");
            item.setIcon(RessourcesUtils.getIcon("22/distance.png"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    List<Atom> atoms = Assemble.this.mediator.getGlobalSelection().getSelectedAtoms();
                    if (atoms.size() != 2) {
                        JOptionPane.showMessageDialog(Assemble.this.window, "Select only two atoms to use this option.");
                    } else {
                        Iterator<Atom> it = atoms.iterator();
                        Assemble.this.mediator.get3DModel().addLabel(new DistanceLabel(Assemble.this.mediator, it.next(), it.next()));
                    }
                }
            });
            labels.add(item);
            item = new JMenuItem("Angle");
            item.setIcon(RessourcesUtils.getIcon("22/angle.png"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    List<Atom> atoms = Assemble.this.mediator.getGlobalSelection().getSelectedAtoms();
                    if (atoms.size() != 3) {
                        JOptionPane.showMessageDialog(Assemble.this.window, "Select only three atoms to use this option.");
                    } else {
                        Iterator<Atom> it = atoms.iterator();
                        Assemble.this.mediator.get3DModel().addLabel(new AngleLabel(Assemble.this.mediator, it.next(), it.next(), it.next()));
                    }
                }
            });
            labels.add(item);
            item = new JMenuItem("Dihedral");
            item.setIcon(RessourcesUtils.getIcon("22/dihedre.png"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    List<Atom> atoms = Assemble.this.mediator.getGlobalSelection().getSelectedAtoms();
                    if (atoms.size() != 4) {
                        JOptionPane.showMessageDialog(Assemble.this.window, "Select only four atoms to use this option.");
                    } else {
                        Iterator<Atom> it = atoms.iterator();
                        Assemble.this.mediator.get3DModel().addLabel(new DihedralLabel(Assemble.this.mediator, it.next(), it.next(), it.next(), it.next()));
                    }
                }
            });
            labels.add(item);
            item = new JMenuItem("BackBone");
            menu.add(item);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    Assemble.this.mediator.getGlobalSelection().setBackBoneDisplayed(true);
                }
            });
            item = new JMenuItem("Plane");
            menu.add(item);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    Assemble.this.mediator.getGlobalSelection().setPlaneDisplayed(true);
                }
            });
            menu = new JMenu("Hide");
            this.add(menu);
            item = new JMenuItem("Only");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    List<Atom> allAtoms = Assemble.this.mediator.get3DModel().getAtoms();
                    allAtoms.removeAll(Assemble.this.mediator.getGlobalSelection().getSelectedAtoms());
                    for (Atom a : allAtoms) {
                        a.setRenderingMode(1);
                    }
                    List<fr.unistra.ibmc.assemble.structures.Residue> allResidues = Assemble.this.mediator.get3DModel().getResidues();
                    allResidues.removeAll(Assemble.this.mediator.getGlobalSelection().getSelectedResidues());
                    for (fr.unistra.ibmc.assemble.structures.Residue r : allResidues) {
                        r.setRenderingMode(1);
                    }
                    Assemble.this.mediator.getGlobalSelection().setRenderingMode(7);
                }
            });
            menu.add(item);
            item = new JMenuItem("Atoms");
            menu.add(item);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    Assemble.this.mediator.getGlobalSelection().setRenderingMode(7);
                }
            });
            item = new JMenuItem("Labels");
            menu.add(item);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    Assemble.this.mediator.get3DModel().hideLabelsForSelection();
                }
            });
            item = new JMenuItem("BackBone");
            menu.add(item);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    Assemble.this.mediator.getGlobalSelection().setBackBoneDisplayed(false);
                }
            });
            item = new JMenuItem("Plane");
            menu.add(item);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    Assemble.this.mediator.getGlobalSelection().setPlaneDisplayed(false);
                }
            });
        }

        private class ColorMenu
        extends JMenu {
            protected Border unselectedBorder;
            protected Border selectedBorder;
            protected Border activeBorder;
            protected Hashtable paneTable;
            protected ColorPane colorPane;

            public ColorMenu(String name) {
                super(name);
                this.unselectedBorder = new CompoundBorder(new MatteBorder(1, 1, 1, 1, this.getBackground()), new BevelBorder(1, Color.white, Color.gray));
                this.selectedBorder = new CompoundBorder(new MatteBorder(1, 1, 1, 1, Color.red), new MatteBorder(1, 1, 1, 1, this.getBackground()));
                this.activeBorder = new CompoundBorder(new MatteBorder(1, 1, 1, 1, Color.blue), new MatteBorder(1, 1, 1, 1, this.getBackground()));
                JPanel p = new JPanel();
                p.setBorder(new EmptyBorder(5, 5, 5, 5));
                p.setLayout(new GridLayout(8, 8));
                this.paneTable = new Hashtable();
                int[] values = new int[]{0, 128, 192, 255};
                for (int r = 0; r < values.length; ++r) {
                    for (int g = 0; g < values.length; ++g) {
                        for (int b = 0; b < values.length; ++b) {
                            Color c = new Color(values[r], values[g], values[b]);
                            ColorPane pn = new ColorPane(c);
                            p.add(pn);
                            this.paneTable.put(c, pn);
                        }
                    }
                }
                this.add(p);
            }

            public void setColor(Color c) {
                Object obj = this.paneTable.get(c);
                if (obj == null) {
                    return;
                }
                if (this.colorPane != null) {
                    this.colorPane.setSelected(false);
                }
                this.colorPane = (ColorPane)obj;
                this.colorPane.setSelected(true);
            }

            public Color getColor() {
                if (this.colorPane == null) {
                    return null;
                }
                return this.colorPane.getColor();
            }

            public void doSelection() {
                this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand()));
            }

            private class ColorPane
            extends JPanel
            implements MouseListener {
                protected Color color;
                protected boolean isSelected;

                public ColorPane(Color c) {
                    this.color = c;
                    this.setBackground(c);
                    this.setBorder(ColorMenu.this.unselectedBorder);
                    String msg = "R " + c.getRed() + ", G " + c.getGreen() + ", B " + c.getBlue();
                    this.setToolTipText(msg);
                    this.addMouseListener(this);
                }

                public Color getColor() {
                    return this.color;
                }

                public Dimension getPreferredSize() {
                    return new Dimension(15, 15);
                }

                public Dimension getMaximumSize() {
                    return this.getPreferredSize();
                }

                public Dimension getMinimumSize() {
                    return this.getPreferredSize();
                }

                public void setSelected(boolean selected) {
                    this.isSelected = selected;
                    if (this.isSelected) {
                        this.setBorder(ColorMenu.this.selectedBorder);
                    } else {
                        this.setBorder(ColorMenu.this.unselectedBorder);
                    }
                }

                public boolean isSelected() {
                    return this.isSelected;
                }

                public void mousePressed(MouseEvent e) {
                }

                public void mouseClicked(MouseEvent e) {
                }

                public void mouseReleased(MouseEvent e) {
                    ColorMenu.this.setColor(this.color);
                    MenuSelectionManager.defaultManager().clearSelectedPath();
                    ColorMenu.this.doSelection();
                    Assemble.this.mediator.getGlobalSelection().setColor(this.color);
                }

                public void mouseEntered(MouseEvent e) {
                    this.setBorder(ColorMenu.this.activeBorder);
                }

                public void mouseExited(MouseEvent e) {
                    this.setBorder(this.isSelected ? ColorMenu.this.selectedBorder : ColorMenu.this.unselectedBorder);
                }
            }
        }
    }

    private class SecondaryModelMenu
    extends JMenu {
        private SecondaryModelMenu() {
            super("2D Model");
            if (!Assemble.this.isConnected()) {
                this.setEnabled(false);
                this.setToolTipText("Need RNA algorithms");
            }
            JMenuItem item = new JMenuItem("Rename...");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String name = JOptionPane.showInputDialog(Assemble.this.window, (Object)"Choose a new 2D Model name");
                    if (name != null && name.length() > 0) {
                        Assemble.this.mediator.get2DModel().getSecondaryStructure().setName(name);
                        Assemble.this.setModelManagerTitle(name);
                    }
                }
            });
            this.add(item);
            item = new JMenuItem("Reorganize helices");
            item.setIcon(RessourcesUtils.getIcon("22/magic.png"));
            if (!Assemble.this.isConnected()) {
                item.setEnabled(false);
                item.setToolTipText("Need RNA algorithms");
            }
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Assemble.this.mediator.getRna2DViewer().reorganizeHelices();
                }
            });
            this.add(item);
            item = new JMenuItem("Generate 3D from 2D");
            item.setIcon(RessourcesUtils.getIcon("22/generate3D.png"));
            if (!Assemble.this.isConnected()) {
                item.setEnabled(false);
                item.setToolTipText("Need RNA algorithms");
            }
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Assemble.this.mediator.getRna2DViewer().generate3D();
                }
            });
            this.add(item);
            JMenu menu = new JMenu("Import...");
            this.add(menu);
            item = new JMenuItem("RNA molecule");
            if (!Assemble.this.isConnected()) {
                item.setEnabled(false);
                item.setToolTipText("Need RNA algorithms");
            }
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser fileChooser = new JFileChooser(Paradise.getWorkingDirectory());
                    fileChooser.setFileHidingEnabled(true);
                    fileChooser.setAcceptAllFileFilterUsed(false);
                    final FastaFileIO parser = new FastaFileIO((MoleculeFactory)Assemble.this.workingSession);
                    fileChooser.setFileFilter((FileFilter)new OpenFileFilter((ParadiseFileIO)parser));
                    if (fileChooser.showOpenDialog(null) == 0) {
                        File f = fileChooser.getSelectedFile();
                        Paradise.setWorkingDirectory((String)f.getAbsolutePath());
                        new FileParsingTask((Application)Assemble.this, f, (ParadiseFileIO)parser, Assemble.this.messageBar, Assemble.this.workingSession){

                            protected void finished() {
                                super.finished();
                                List molecules = parser.getMolecules();
                                Molecule m = null;
                                if (molecules.size() == 0) {
                                    JOptionPane.showMessageDialog(Assemble.this.window, "No molecules available");
                                } else {
                                    m = molecules.size() > 1 ? (Molecule)JOptionPane.showInputDialog(Assemble.this.window, "Choose a molecule", "Choose a molecule", -1, null, molecules.toArray(), molecules.get(0)) : (Molecule)molecules.get(0);
                                }
                                if (m != null) {
                                    GuiEvent ev = new GuiEvent((Object)this, 1);
                                    ArrayList<Molecule> _molecules = new ArrayList<Molecule>();
                                    _molecules.add((Molecule)molecules.get(0));
                                    ev.addParameter((Object)new SecondaryStructurePredictionRequestAnswerBehaviour(_molecules, new Parameters()));
                                    ((AssembleAgent)Assemble.this.getAgent()).postGuiEvent(ev);
                                }
                            }
                        }.execute();
                    }
                }
            });
            menu.add(item);
            item = new JMenuItem("RNA Secondary Structure");
            if (!Assemble.this.isConnected()) {
                item.setEnabled(false);
                item.setToolTipText("Need RNA algorithms");
            }
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser fileChooser = new JFileChooser(Paradise.getWorkingDirectory());
                    fileChooser.setFileHidingEnabled(true);
                    fileChooser.setAcceptAllFileFilterUsed(false);
                    fileChooser.setFileFilter((FileFilter)new OpenFileFilter((ParadiseFileIO)new BPSeqFileIO((MoleculeFactory)Assemble.this.workingSession)));
                    fileChooser.setFileFilter((FileFilter)new OpenFileFilter((ParadiseFileIO)new CTFileIO((MoleculeFactory)Assemble.this.workingSession)));
                    if (fileChooser.showOpenDialog(null) == 0) {
                        File f = fileChooser.getSelectedFile();
                        Paradise.setWorkingDirectory((String)f.getAbsolutePath());
                        final CTFileIO parser = (CTFileIO)((OpenFileFilter)fileChooser.getFileFilter()).getParser();
                        new FileParsingTask((Application)Assemble.this, f, (ParadiseFileIO)parser, Assemble.this.messageBar, Assemble.this.workingSession){

                            protected void finished() {
                                super.finished();
                                Assemble.this.mediator.loadRNASecondaryStructure((SecondaryStructure)parser.getSecondaryStructures().get(0));
                                Assemble.this.mediator.startAnimator();
                            }
                        }.execute();
                    }
                }
            });
            menu.add(item);
        }
    }

    private class StereoMenu
    extends JMenu
    implements ActionListener {
        private ButtonGroup stereoMode;
        private JRadioButtonMenuItem mono;
        private JRadioButtonMenuItem split;
        private JRadioButtonMenuItem overlap;

        public StereoMenu() {
            super("Stereo");
            this.stereoMode = new ButtonGroup();
            this.mono = new JRadioButtonMenuItem("Mono");
            this.split = new JRadioButtonMenuItem("Split Stereo");
            this.overlap = new JRadioButtonMenuItem("Overlap Stereo");
            this.mono.setIcon(RessourcesUtils.getIcon("22/mono.png"));
            this.split.setIcon(RessourcesUtils.getIcon("22/split.png"));
            this.overlap.setIcon(RessourcesUtils.getIcon("22/overlap.png"));
            this.add(this.mono);
            this.add(this.split);
            this.add(this.overlap);
            this.mono.setSelected(true);
            this.mono.addActionListener(this);
            this.split.addActionListener(this);
            this.overlap.addActionListener(this);
            this.stereoMode.add(this.mono);
            this.stereoMode.add(this.split);
            this.stereoMode.add(this.overlap);
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == this.mono) {
                Assemble.this.mediator.getRenderer().setStereoMode(0);
            }
            if (source == this.split) {
                Assemble.this.mediator.getRenderer().setStereoMode(1);
            }
            if (source == this.overlap) {
                Assemble.this.mediator.getRenderer().setStereoMode(2);
            }
        }
    }

    private class TertiaryModelMenu
    extends JMenu
    implements ActionListener {
        private JCheckBoxMenuItem fog;
        private JCheckBoxMenuItem drawSelection;

        public TertiaryModelMenu() {
            super("3D Model");
            this.fog = new JCheckBoxMenuItem("Fog (Depth-Cueing)");
            this.drawSelection = new JCheckBoxMenuItem("Draw the Selection Mesh");
            JMenuItem item = new JMenuItem("Rename...");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String name = JOptionPane.showInputDialog(Assemble.this.window, (Object)"Choose a new 3D Model name");
                    if (name != null && name.length() > 0) {
                        Assemble.this.mediator.get3DModel().getTertiaryStructure().setName(name);
                        Assemble.this.set3DSceneTitle(name);
                    }
                }
            });
            this.add(item);
            this.fog.setSelected(Assemble.this.mediator.getRenderer().isFog());
            this.add(Assemble.this.stereo);
            this.add(new ColorMenu("3D Background Color"));
            JMenuItem hideAllLabels = new JMenuItem("Hide All Labels");
            hideAllLabels.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Assemble.this.mediator.get3DModel().hideLabels();
                }
            });
            this.add(hideAllLabels);
            this.addSeparator();
            this.add(this.fog);
            this.add(this.drawSelection);
            this.drawSelection.setSelected(true);
            this.fog.addActionListener(this);
            this.drawSelection.addActionListener(this);
            this.addSeparator();
            item = new JMenuItem("Center on Density Map"){

                public void paintComponent(Graphics graphics) {
                    this.setEnabled(Assemble.this.mediator.getDensityMap() != null);
                    super.paintComponent(graphics);
                }
            };
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    float[] mapCenter = Assemble.this.mediator.getDensityMap().getCenter();
                    float[] model3DCenter = Assemble.this.mediator.get3DModel().getCenter();
                    if (mapCenter != null) {
                        Assemble.this.mediator.get3DModel().translate(TBMath.vector((float[])model3DCenter, (float[])mapCenter));
                        Assemble.this.mediator.getRenderer().setPivot(mapCenter);
                        Assemble.this.mediator.get3DModel().fireModelModified();
                    }
                }
            });
            this.add(item);
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == this.fog) {
                Assemble.this.mediator.getRenderer().setFog(this.fog.isSelected());
                Assemble.this.mediator.getRenderer().reComputeNeeded();
            } else if (source == this.drawSelection) {
                Assemble.this.mediator.getRenderer().setDrawSelection(this.drawSelection.isSelected());
            }
        }

        private class ColorMenu
        extends JMenu {
            protected Border unselectedBorder;
            protected Border selectedBorder;
            protected Border activeBorder;
            protected Hashtable paneTable;
            protected ColorPane colorPane;

            public ColorMenu(String name) {
                super(name);
                this.unselectedBorder = new CompoundBorder(new MatteBorder(1, 1, 1, 1, this.getBackground()), new BevelBorder(1, Color.white, Color.gray));
                this.selectedBorder = new CompoundBorder(new MatteBorder(1, 1, 1, 1, Color.red), new MatteBorder(1, 1, 1, 1, this.getBackground()));
                this.activeBorder = new CompoundBorder(new MatteBorder(1, 1, 1, 1, Color.blue), new MatteBorder(1, 1, 1, 1, this.getBackground()));
                JPanel p = new JPanel();
                p.setBorder(new EmptyBorder(5, 5, 5, 5));
                p.setLayout(new GridLayout(8, 8));
                this.paneTable = new Hashtable();
                int[] values = new int[]{0, 128, 192, 255};
                for (int r = 0; r < values.length; ++r) {
                    for (int g = 0; g < values.length; ++g) {
                        for (int b = 0; b < values.length; ++b) {
                            Color c = new Color(values[r], values[g], values[b]);
                            ColorPane pn = new ColorPane(c);
                            p.add(pn);
                            this.paneTable.put(c, pn);
                        }
                    }
                }
                this.add(p);
            }

            public void setColor(Color c) {
                Object obj = this.paneTable.get(c);
                if (obj == null) {
                    return;
                }
                if (this.colorPane != null) {
                    this.colorPane.setSelected(false);
                }
                this.colorPane = (ColorPane)obj;
                this.colorPane.setSelected(true);
            }

            public Color getColor() {
                if (this.colorPane == null) {
                    return null;
                }
                return this.colorPane.getColor();
            }

            public void doSelection() {
                this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand()));
            }

            private class ColorPane
            extends JPanel
            implements MouseListener {
                protected Color color;
                protected boolean isSelected;

                public ColorPane(Color c) {
                    this.color = c;
                    this.setBackground(c);
                    this.setBorder(ColorMenu.this.unselectedBorder);
                    String msg = "R " + c.getRed() + ", G " + c.getGreen() + ", B " + c.getBlue();
                    this.setToolTipText(msg);
                    this.addMouseListener(this);
                }

                public Color getColor() {
                    return this.color;
                }

                public Dimension getPreferredSize() {
                    return new Dimension(15, 15);
                }

                public Dimension getMaximumSize() {
                    return this.getPreferredSize();
                }

                public Dimension getMinimumSize() {
                    return this.getPreferredSize();
                }

                public void setSelected(boolean selected) {
                    this.isSelected = selected;
                    if (this.isSelected) {
                        this.setBorder(ColorMenu.this.selectedBorder);
                    } else {
                        this.setBorder(ColorMenu.this.unselectedBorder);
                    }
                }

                public boolean isSelected() {
                    return this.isSelected;
                }

                public void mousePressed(MouseEvent e) {
                }

                public void mouseClicked(MouseEvent e) {
                }

                public void mouseReleased(MouseEvent e) {
                    ColorMenu.this.setColor(this.color);
                    MenuSelectionManager.defaultManager().clearSelectedPath();
                    ColorMenu.this.doSelection();
                    Assemble.this.mediator.getRenderer().setBackgroundColor(new OpenGLColor(this.color));
                    Assemble.this.mediator.getRenderer().reComputeNeeded();
                }

                public void mouseEntered(MouseEvent e) {
                    this.setBorder(ColorMenu.this.activeBorder);
                }

                public void mouseExited(MouseEvent e) {
                    this.setBorder(this.isSelected ? ColorMenu.this.selectedBorder : ColorMenu.this.unselectedBorder);
                }
            }
        }
    }

    private class FileMenu
    extends JMenu {
        public FileMenu() {
            super("File");
            JMenu load = new JMenu("Load...");
            load.setIcon(RessourcesUtils.getIcon("22/open.png"));
            this.add(load);
            JMenuItem item = new JMenuItem("Assemble Model");
            item.setIcon(RessourcesUtils.getIcon("22/open.png"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if ((Assemble.this.mediator.get3DModel() != null || Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().getModel2D() != null) && 0 != JOptionPane.showConfirmDialog(Assemble.this.window, "Are you sure to remove your current Model?")) {
                        return;
                    }
                    if (Assemble.this.mediator.get3DModel() != null || Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().getModel2D() != null) {
                        Assemble.this.mediator.clearSession();
                    }
                    Assemble.this.mediator.stopAnimator();
                    JFileChooser fileChooser = new JFileChooser(Paradise.getWorkingDirectory());
                    fileChooser.setFileView(new FileView(){

                        public Icon getIcon(File f) {
                            if (IOUtils.isParadiseProject((File)f) || f.getName().endsWith(".assemble")) {
                                return new ImageIcon(RessourcesUtils.getImage("paradise-project.png"));
                            }
                            return null;
                        }

                        public Boolean isTraversable(File f) {
                            return f.isDirectory() && !IOUtils.isParadiseProject((File)f);
                        }
                    });
                    fileChooser.setFileHidingEnabled(true);
                    fileChooser.setAcceptAllFileFilterUsed(false);
                    fileChooser.setFileSelectionMode(2);
                    fileChooser.setFileFilter(new FileFilter(){

                        public boolean accept(File file) {
                            return file.isDirectory() && !IOUtils.isParadiseProject((File)file) || file.getName().endsWith(".assemble");
                        }

                        public String getDescription() {
                            return "Assemble models (binary data)";
                        }
                    });
                    fileChooser.setFileFilter(new FileFilter(){

                        public boolean accept(File file) {
                            return file.isDirectory() && !IOUtils.isParadiseProject((File)file) || IOUtils.containsTertiaryStructureData((File)file);
                        }

                        public String getDescription() {
                            return "Assemble models (textual data)";
                        }
                    });
                    if (fileChooser.showOpenDialog(null) == 0) {
                        File f = fileChooser.getSelectedFile();
                        if (f.getName().endsWith(".assemble")) {
                            Paradise.setWorkingDirectory((String)f.getAbsolutePath());
                            AssembleModelParser parser = new AssembleModelParser((MoleculeFactory)Assemble.this.workingSession);
                            new FileParsingTask((Application)Assemble.this, f, (ParadiseFileIO)parser, Assemble.this.messageBar, Assemble.this.workingSession, (ParadiseFileIO)parser){
                                final /* synthetic */ ParadiseFileIO val$parser;
                                {
                                    this.val$parser = paradiseFileIO;
                                    super(x0, x1, x2, x3, x4);
                                }

                                /*
                                 * Enabled aggressive block sorting
                                 */
                                protected void finished() {
                                    block5: {
                                        block6: {
                                            List tss = this.val$parser.getTertiaryStructures();
                                            if (tss.isEmpty()) break block6;
                                            if (tss.size() > 1) {
                                                Object[] names = new String[tss.size()];
                                                for (int i = 0; i < names.length; ++i) {
                                                    names[i] = ((TertiaryStructure)tss.get(i)).getName();
                                                }
                                                String name = (String)JOptionPane.showInputDialog(Assemble.this.window, "Choose a 3D model", "Choose 3D model", -1, null, names, names[0]);
                                                if (name == null) {
                                                    this.finished();
                                                    return;
                                                }
                                                for (TertiaryStructure ts : tss) {
                                                    if (!ts.getName().equals(name)) continue;
                                                    Assemble.this.mediator.loadRNASecondaryStructure((SecondaryStructure)ts.getLinkedSecondaryStructures().get(0));
                                                    Assemble.this.mediator.createModel((SecondaryStructure)ts.getLinkedSecondaryStructures().get(0), ts);
                                                    Assemble.this.mediator.startAnimator();
                                                    break block5;
                                                }
                                                break block5;
                                            } else {
                                                Assemble.this.mediator.loadRNASecondaryStructure((SecondaryStructure)((TertiaryStructure)tss.get(0)).getLinkedSecondaryStructures().get(0));
                                                Assemble.this.mediator.createModel((SecondaryStructure)((TertiaryStructure)tss.get(0)).getLinkedSecondaryStructures().get(0), (TertiaryStructure)tss.get(0));
                                                Assemble.this.mediator.startAnimator();
                                            }
                                            break block5;
                                        }
                                        JOptionPane.showMessageDialog(Assemble.this.window, "Your Assemble model contains no data!!");
                                    }
                                    super.finished();
                                }
                            }.execute();
                        } else {
                            Paradise.setWorkingDirectory((String)f.getParentFile().getAbsolutePath());
                            ParadiseProjectIO parser = new ParadiseProjectIO((MoleculeFactory)Assemble.this.workingSession);
                            new FileParsingTask((Application)Assemble.this, f, (ParadiseFileIO)parser, Assemble.this.messageBar, Assemble.this.workingSession, (ParadiseFileIO)parser){
                                final /* synthetic */ ParadiseFileIO val$parser;
                                {
                                    this.val$parser = paradiseFileIO;
                                    super(x0, x1, x2, x3, x4);
                                }

                                /*
                                 * Enabled aggressive block sorting
                                 */
                                protected void finished() {
                                    block5: {
                                        block6: {
                                            List tss = this.val$parser.getTertiaryStructures();
                                            if (tss.isEmpty()) break block6;
                                            if (tss.size() > 1) {
                                                Object[] names = new String[tss.size()];
                                                for (int i = 0; i < names.length; ++i) {
                                                    names[i] = ((TertiaryStructure)tss.get(i)).getName();
                                                }
                                                String name = (String)JOptionPane.showInputDialog(Assemble.this.window, "Choose a 3D model", "Choose 3D model", -1, null, names, names[0]);
                                                if (name == null) {
                                                    this.finished();
                                                    return;
                                                }
                                                for (TertiaryStructure ts : tss) {
                                                    if (!ts.getName().equals(name)) continue;
                                                    Assemble.this.mediator.loadRNASecondaryStructure((SecondaryStructure)ts.getLinkedSecondaryStructures().get(0));
                                                    Assemble.this.mediator.createModel((SecondaryStructure)ts.getLinkedSecondaryStructures().get(0), ts);
                                                    Assemble.this.mediator.startAnimator();
                                                    break block5;
                                                }
                                                break block5;
                                            } else {
                                                Assemble.this.mediator.loadRNASecondaryStructure((SecondaryStructure)((TertiaryStructure)tss.get(0)).getLinkedSecondaryStructures().get(0));
                                                Assemble.this.mediator.createModel((SecondaryStructure)((TertiaryStructure)tss.get(0)).getLinkedSecondaryStructures().get(0), (TertiaryStructure)tss.get(0));
                                                Assemble.this.mediator.startAnimator();
                                            }
                                            break block5;
                                        }
                                        JOptionPane.showMessageDialog(Assemble.this.window, "Your Assemble model contains no data!!");
                                    }
                                    super.finished();
                                }
                            }.execute();
                        }
                    }
                }
            });
            load.add(item);
            item = new JMenuItem("RNA molecule");
            if (!Assemble.this.isConnected()) {
                item.setEnabled(false);
                item.setToolTipText("Need RNA algorithms");
            }
            item.setIcon(RessourcesUtils.getIcon("22/open.png"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if ((Assemble.this.mediator.get3DModel() != null || Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().getModel2D() != null) && 0 != JOptionPane.showConfirmDialog(Assemble.this.window, "Are you sure to remove your current Model?")) {
                        return;
                    }
                    if (Assemble.this.mediator.get3DModel() != null || Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().getModel2D() != null) {
                        Assemble.this.mediator.clearSession();
                    }
                    JFileChooser fileChooser = new JFileChooser(Paradise.getWorkingDirectory());
                    fileChooser.setFileHidingEnabled(true);
                    fileChooser.setAcceptAllFileFilterUsed(false);
                    final FastaFileIO parser = new FastaFileIO((MoleculeFactory)Assemble.this.workingSession);
                    fileChooser.setFileFilter((FileFilter)new OpenFileFilter((ParadiseFileIO)parser));
                    if (fileChooser.showOpenDialog(null) == 0) {
                        File f = fileChooser.getSelectedFile();
                        Paradise.setWorkingDirectory((String)f.getAbsolutePath());
                        new FileParsingTask((Application)Assemble.this, f, (ParadiseFileIO)parser, Assemble.this.messageBar, Assemble.this.workingSession){

                            protected void finished() {
                                List molecules = parser.getMolecules();
                                Molecule m = null;
                                if (molecules.size() == 0) {
                                    JOptionPane.showMessageDialog(Assemble.this.window, "No molecules available");
                                } else {
                                    m = molecules.size() > 1 ? (Molecule)JOptionPane.showInputDialog(Assemble.this.window, "Choose a molecule", "Choose a molecule", -1, null, molecules.toArray(), molecules.get(0)) : (Molecule)molecules.get(0);
                                }
                                if (m != null) {
                                    GuiEvent ev = new GuiEvent((Object)this, 1);
                                    ArrayList<Molecule> _molecules = new ArrayList<Molecule>();
                                    _molecules.add((Molecule)molecules.get(0));
                                    ev.addParameter((Object)new SecondaryStructurePredictionRequestAnswerBehaviour(_molecules, new Parameters()));
                                    ((AssembleAgent)Assemble.this.getAgent()).postGuiEvent(ev);
                                }
                                super.finished();
                            }
                        }.execute();
                    }
                }
            });
            load.add(item);
            item = new JMenuItem("RNA Secondary Structure");
            if (!Assemble.this.isConnected()) {
                item.setEnabled(false);
                item.setToolTipText("Need RNA algorithms");
            }
            item.setIcon(RessourcesUtils.getIcon("22/open.png"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if ((Assemble.this.mediator.get3DModel() != null || Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().getModel2D() != null) && 0 != JOptionPane.showConfirmDialog(Assemble.this.window, "Are you sure to remove your current Model?")) {
                        return;
                    }
                    if (Assemble.this.mediator.get3DModel() != null || Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().getModel2D() != null) {
                        Assemble.this.mediator.clearSession();
                    }
                    Assemble.this.mediator.stopAnimator();
                    JFileChooser fileChooser = new JFileChooser(Paradise.getWorkingDirectory());
                    fileChooser.setFileHidingEnabled(true);
                    fileChooser.setAcceptAllFileFilterUsed(false);
                    fileChooser.setFileFilter((FileFilter)new OpenFileFilter((ParadiseFileIO)new BPSeqFileIO((MoleculeFactory)Assemble.this.workingSession)));
                    fileChooser.setFileFilter((FileFilter)new OpenFileFilter((ParadiseFileIO)new CTFileIO((MoleculeFactory)Assemble.this.workingSession)));
                    fileChooser.setFileFilter((FileFilter)new OpenFileFilter((ParadiseFileIO)new FastaFileIO((MoleculeFactory)Assemble.this.workingSession)));
                    if (fileChooser.showOpenDialog(null) == 0) {
                        File f = fileChooser.getSelectedFile();
                        Paradise.setWorkingDirectory((String)f.getAbsolutePath());
                        final ParadiseFileIO parser = ((OpenFileFilter)fileChooser.getFileFilter()).getParser();
                        new FileParsingTask((Application)Assemble.this, f, parser, Assemble.this.messageBar, Assemble.this.workingSession){

                            protected void finished() {
                                if (FastaFileIO.class.isInstance(parser)) {
                                    Molecule m = (Molecule)parser.getMolecules().get(0);
                                    String bn = ((FastaFileIO)parser).getBracketNotation(m);
                                    if (bn != null) {
                                        GuiEvent ev = new GuiEvent((Object)this, 3);
                                        ArrayList<Molecule> molecules = new ArrayList<Molecule>();
                                        if (RNA.class.isInstance(m)) {
                                            m.removeAllSelectedFeatures();
                                            molecules.add(m);
                                        }
                                        try {
                                            File f = IOUtils.createTemporaryFile((String)"bracketNotation");
                                            CTFileIO.writeCTFile((File)f, (String)m.printSequence(), (String)bn);
                                            CTFileIO parser2 = new CTFileIO((MoleculeFactory)Assemble.this.workingSession);
                                            parser2.parseFile(f, (ProgressMonitor)new DefaultProgressMonitor());
                                            SecondaryStructure ss = (SecondaryStructure)parser2.getSecondaryStructures().get(0);
                                            SecondaryStructure copySS = ss.getFactory().copySecondaryStructure(Arrays.asList(m), ss, false);
                                            m.addSelectedFeature((ParadiseFeature)copySS);
                                        }
                                        catch (Exception e1) {
                                            e1.printStackTrace();
                                        }
                                        ev.addParameter((Object)new SecondaryStructureDrawingRequestAnswerBehaviour(molecules, new Parameters()));
                                        ((AbstractParadiseToolAgent)Assemble.this.getAgent()).postGuiEvent(ev);
                                    } else {
                                        JOptionPane.showMessageDialog(Assemble.this.window, "No Secondary Structure described in the FASTA file");
                                    }
                                } else {
                                    Assemble.this.mediator.loadRNASecondaryStructure((SecondaryStructure)parser.getSecondaryStructures().get(0));
                                }
                                Assemble.this.mediator.startAnimator();
                                super.finished();
                            }
                        }.execute();
                    }
                }
            });
            load.add(item);
            item = new JMenuItem("RNA Tertiary Structure");
            if (!Assemble.this.isConnected()) {
                item.setEnabled(false);
                item.setToolTipText("Need RNA algorithms");
            }
            item.setIcon(RessourcesUtils.getIcon("22/open.png"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if ((Assemble.this.mediator.get3DModel() != null || Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().getModel2D() != null) && 0 != JOptionPane.showConfirmDialog(Assemble.this.window, "Are you sure to remove your current Model?")) {
                        return;
                    }
                    if (Assemble.this.mediator.get3DModel() != null || Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().getModel2D() != null) {
                        Assemble.this.mediator.clearSession();
                    }
                    Assemble.this.mediator.stopAnimator();
                    JFileChooser fileChooser = new JFileChooser(Paradise.getWorkingDirectory());
                    fileChooser.setFileHidingEnabled(true);
                    fileChooser.setAcceptAllFileFilterUsed(false);
                    final PDBFileIO pdbParser = new PDBFileIO((MoleculeFactory)Assemble.this.workingSession);
                    fileChooser.setFileFilter((FileFilter)new OpenFileFilter((ParadiseFileIO)pdbParser));
                    if (fileChooser.showOpenDialog(null) == 0) {
                        File f = fileChooser.getSelectedFile();
                        Paradise.setWorkingDirectory((String)f.getAbsolutePath());
                        new FileParsingTask((Application)Assemble.this, f, (ParadiseFileIO)pdbParser, Assemble.this.messageBar, Assemble.this.workingSession){

                            protected void finished() {
                                super.finished();
                                TertiaryStructure ts = (TertiaryStructure)pdbParser.getTertiaryStructures().get(0);
                                GuiEvent ev = new GuiEvent((Object)this, 2);
                                ArrayList<Molecule> molecules = new ArrayList<Molecule>();
                                for (Molecule m : ts.getMolecules()) {
                                    m.removeAllSelectedFeatures();
                                    for (Residue3D r : ts.getSubFeatures(Residue3D.class, m)) {
                                        m.addSelectedFeature((ParadiseFeature)r);
                                    }
                                    molecules.add(m);
                                }
                                ev.addParameter((Object)new TertiaryStructureAnnotationRequestAnswerBehaviour(new ArrayList<Molecule>(molecules), new Parameters()));
                                ((AssembleAgent)Assemble.this.getAgent()).postGuiEvent(ev);
                            }
                        }.execute();
                    }
                }
            });
            load.add(item);
            item = new JMenuItem("Protein Partners");
            item.setIcon(RessourcesUtils.getIcon("22/open.png"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Assemble.this.mediator.stopAnimator();
                    Assemble.this.mediator.startAnimator();
                }
            });
            item = new JMenuItem("Electronic Density Map"){

                public void paintComponent(Graphics graphics) {
                    this.setEnabled(Assemble.this.mediator.get3DModel() != null);
                    super.paintComponent(graphics);
                }
            };
            item.setIcon(RessourcesUtils.getIcon("22/edmap.png"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Assemble.this.mediator.stopAnimator();
                    final JFileChooser openFile = new JFileChooser(Assemble.this.getAssembleLastLoadPath());
                    openFile.addChoosableFileFilter(new FileFilter(){

                        public boolean accept(File file) {
                            return file.isDirectory() || file.getName().endsWith("map");
                        }

                        public String getDescription() {
                            return "MAP files";
                        }
                    });
                    openFile.addChoosableFileFilter(new FileFilter(){

                        public boolean accept(File file) {
                            return file.isDirectory() || file.getName().endsWith("mrc");
                        }

                        public String getDescription() {
                            return "MRC files";
                        }
                    });
                    openFile.setAcceptAllFileFilterUsed(false);
                    int op = openFile.showOpenDialog(Assemble.this.getFrame());
                    if (op == 0) {
                        new ParadiseTask((Application)Assemble.this, Assemble.this.messageBar){

                            protected Object doInBackground() {
                                Assemble.this.messageBar.startAnimation();
                                try {
                                    Assemble.this.setAssembleLastLoadPath(openFile.getSelectedFile());
                                    String filename = openFile.getSelectedFile().getAbsolutePath();
                                    EDMap edmap = new EDMap(Assemble.this.mediator);
                                    int idx = filename.lastIndexOf(46);
                                    if (idx != -1) {
                                        if (filename.substring(idx).equals(".map")) {
                                            edmap.parseXPLORMap(filename);
                                        }
                                        if (filename.substring(idx).equals(".mrc")) {
                                            edmap.parseMRCMap(filename);
                                        }
                                        if (edmap.isValid()) {
                                            Assemble.this.mediator.loadEDMap(edmap);
                                        }
                                        Assemble.this.mediator.startAnimator();
                                    }
                                    this.monitor.printMessage("Electronic Density Map loaded successfully");
                                }
                                catch (Exception e) {
                                    this.monitor.printException(e);
                                }
                                this.finished();
                                return null;
                            }
                        }.execute();
                    }
                }
            });
            load.add(item);
            item = new JMenuItem("Save Model"){

                public void paintComponent(Graphics graphics) {
                    this.setEnabled(Assemble.this.mediator.get3DModel() != null && Assemble.this.mediator.get3DModel().getTertiaryStructure().getAssociatedFile() != null);
                    super.paintComponent(graphics);
                }
            };
            item.setIcon(RessourcesUtils.getIcon("22/saveas.png"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Assemble.this.mediator.stopAnimator();
                    final File saveFile = Assemble.this.mediator.get3DModel() != null && Assemble.this.mediator.get3DModel().getTertiaryStructure().getAssociatedFile() != null ? Assemble.this.mediator.get3DModel().getTertiaryStructure().getAssociatedFile() : Assemble.this.mediator.get2DModel().getSecondaryStructure().getAssociatedFile();
                    new ParadiseTask((Application)Assemble.this, Assemble.this.messageBar){

                        protected Object doInBackground() {
                            try {
                                Assemble.this.messageBar.startAnimation();
                                Assemble.this.synchronize();
                                if (saveFile.getName().endsWith(".rnaml")) {
                                    ParadiseProjectIO.saveWorkingSession((File)saveFile.getParentFile().getParentFile(), Arrays.asList(Assemble.this.mediator.get2DModel().getSecondaryStructure()));
                                    Assemble.this.setAssembleLastSavePath(saveFile.getParentFile().getParentFile().getParentFile());
                                } else if (saveFile.getName().endsWith(".assemble")) {
                                    ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(saveFile));
                                    oos.writeObject(Assemble.this.mediator.get3DModel().getTertiaryStructure());
                                    oos.flush();
                                    oos.close();
                                    Assemble.this.setAssembleLastSavePath(saveFile.getParentFile());
                                }
                                Assemble.this.mediator.startAnimator();
                                this.monitor.printMessage("Saving successful");
                            }
                            catch (Exception e) {
                                this.monitor.printException(e);
                            }
                            this.finished();
                            return null;
                        }
                    }.execute();
                }
            });
            this.add(item);
            item = new JMenuItem("Save Model As..."){

                public void paintComponent(Graphics graphics) {
                    this.setEnabled(Assemble.this.mediator.get2DModel() != null);
                    super.paintComponent(graphics);
                }
            };
            item.setIcon(RessourcesUtils.getIcon("22/saveas.png"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Assemble.this.mediator.stopAnimator();
                    JFileChooser fileChooser = new JFileChooser(Assemble.this.getAssembleLastSavePath());
                    fileChooser.setFileView(new FileView(){

                        public Icon getIcon(File f) {
                            if (IOUtils.isParadiseProject((File)f)) {
                                return new ImageIcon(RessourcesUtils.getImage("paradise-project.png"));
                            }
                            if (f.getName().endsWith(".assemble")) {
                                return new ImageIcon(RessourcesUtils.getImage("paradise-project.png"));
                            }
                            return null;
                        }

                        public Boolean isTraversable(File f) {
                            return f.isDirectory() && !IOUtils.isParadiseProject((File)f);
                        }
                    });
                    fileChooser.setFileHidingEnabled(true);
                    fileChooser.setAcceptAllFileFilterUsed(false);
                    fileChooser.setFileSelectionMode(2);
                    fileChooser.setFileFilter(new FileFilter(){

                        public boolean accept(File file) {
                            return file.isDirectory() && !IOUtils.isParadiseProject((File)file) || file.getName().endsWith(".assemble");
                        }

                        public String getDescription() {
                            return "Assemble models (binary data)";
                        }
                    });
                    fileChooser.setFileFilter(new FileFilter(){

                        public boolean accept(File file) {
                            return file.isDirectory() && !IOUtils.isParadiseProject((File)file) || IOUtils.containsTertiaryStructureData((File)file);
                        }

                        public String getDescription() {
                            return "Assemble models (textual data)";
                        }
                    });
                    if (0 == fileChooser.showSaveDialog(Assemble.this.window)) {
                        final File saveFile = fileChooser.getSelectedFile();
                        new ParadiseTask((Application)Assemble.this, Assemble.this.messageBar){

                            protected Object doInBackground() {
                                try {
                                    Assemble.this.messageBar.startAnimation();
                                    Assemble.this.synchronize();
                                    if (saveFile.getName().endsWith(".assemble")) {
                                        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(saveFile));
                                        oos.writeObject(Assemble.this.mediator.get3DModel().getTertiaryStructure());
                                        oos.flush();
                                        oos.close();
                                        Assemble.this.mediator.get3DModel().getTertiaryStructure().setAssociatedFile(saveFile);
                                        Assemble.this.setAssembleLastSavePath(saveFile.getParentFile());
                                    } else {
                                        ParadiseProjectIO.saveWorkingSession((File)saveFile, Arrays.asList(Assemble.this.mediator.get2DModel().getSecondaryStructure()));
                                        Assemble.this.setAssembleLastSavePath(saveFile.getParentFile());
                                    }
                                    Assemble.this.mediator.startAnimator();
                                    this.monitor.printMessage("Saving successful");
                                }
                                catch (Exception e) {
                                    this.monitor.printException(e);
                                }
                                this.finished();
                                return null;
                            }
                        }.execute();
                    }
                }
            });
            this.add(item);
            JMenu exportMenu = new JMenu("Export...");
            exportMenu.setIcon(RessourcesUtils.getIcon("22/saveas.png"));
            this.add(exportMenu);
            item = new JMenuItem("3D Model as PDB file"){

                public void paintComponent(Graphics graphics) {
                    this.setEnabled(Assemble.this.mediator.get3DModel() != null);
                    super.paintComponent(graphics);
                }
            };
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Assemble.this.mediator.stopAnimator();
                    final JFileChooser saveFile = new JFileChooser(Assemble.this.getAssembleLastSavePath());
                    saveFile.setFileFilter(new FileFilter(){

                        public boolean accept(File file) {
                            if (file.isDirectory()) {
                                return true;
                            }
                            for (String suffix : PDBFileIO.suffixes) {
                                if (!file.getName().endsWith(suffix)) continue;
                                return true;
                            }
                            return false;
                        }

                        public String getDescription() {
                            return "PDB files";
                        }
                    });
                    saveFile.setAcceptAllFileFilterUsed(false);
                    if (saveFile.showSaveDialog(Assemble.this.window) == 0) {
                        Assemble.this.setAssembleLastSavePath(saveFile.getSelectedFile());
                        new ParadiseTask((Application)Assemble.this, Assemble.this.messageBar){

                            protected Object doInBackground() {
                                Assemble.this.messageBar.startAnimation();
                                try {
                                    Assemble.this.mediator.get3DModel().exportAsPDB(saveFile.getSelectedFile());
                                    Assemble.this.mediator.startAnimator();
                                    this.monitor.printMessage("Export successful");
                                }
                                catch (Exception e) {
                                    this.monitor.printException(e);
                                }
                                this.finished();
                                return null;
                            }
                        }.execute();
                    }
                }
            });
            exportMenu.add(item);
            item = new JMenuItem("2D Model as CT file"){

                public void paintComponent(Graphics graphics) {
                    this.setEnabled(Assemble.this.mediator.get2DModel() != null);
                    super.paintComponent(graphics);
                }
            };
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Assemble.this.mediator.stopAnimator();
                    JFileChooser saveFile = new JFileChooser(Assemble.this.getAssembleLastSavePath());
                    saveFile.setFileFilter(new FileFilter(){

                        public boolean accept(File file) {
                            if (file.isDirectory()) {
                                return true;
                            }
                            for (String suffix : CTFileIO.suffixes) {
                                if (!file.getName().endsWith(suffix)) continue;
                                return true;
                            }
                            return false;
                        }

                        public String getDescription() {
                            return "CT files";
                        }
                    });
                    saveFile.setAcceptAllFileFilterUsed(false);
                    if (saveFile.showSaveDialog(null) == 0) {
                        final File file = saveFile.getSelectedFile();
                        new ParadiseTask((Application)Assemble.this, Assemble.this.messageBar){

                            protected Object doInBackground() {
                                try {
                                    Assemble.this.messageBar.startAnimation();
                                    if (!file.exists()) {
                                        file.createNewFile();
                                    }
                                    ArrayList<Residue> residues = new ArrayList<Residue>();
                                    HashSet<BaseBaseInteraction> interactions = new HashSet<BaseBaseInteraction>();
                                    Molecule currentMolecule = null;
                                    for (Residue2D r2D : Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().getModel2D().getResidues()) {
                                        Residue r = (Residue)r2D.getResidue2DFeature().getResidues().iterator().next();
                                        if (currentMolecule == null) {
                                            currentMolecule = r.getMolecule();
                                        } else if (currentMolecule != r.getMolecule()) {
                                            JOptionPane.showMessageDialog(Assemble.this.window, "You cannot export several molecules in one CT file");
                                            file.delete();
                                            return null;
                                        }
                                        residues.add(r);
                                        for (Interaction2D interaction : r2D.getInteractions()) {
                                            if (!BaseBaseInteraction2D.class.isInstance(interaction) || !((BaseBaseInteraction2D)interaction).getBaseBaseInteractionFeature().isSecondaryInteraction()) continue;
                                            interactions.add(((BaseBaseInteraction2D)interaction).getBaseBaseInteractionFeature());
                                        }
                                    }
                                    Collections.sort(residues, new Comparator(){

                                        public int compare(Object o1, Object o2) {
                                            return ((Residue)o1).getAbsolutePosition() - ((Residue)o2).getAbsolutePosition();
                                        }
                                    });
                                    CTFileIO.writeCTFile(residues, new ArrayList(interactions), (File)file);
                                    Assemble.this.mediator.startAnimator();
                                    this.monitor.printMessage("Export successful");
                                }
                                catch (Exception e) {
                                    this.monitor.printException(e);
                                }
                                this.finished();
                                return null;
                            }
                        }.execute();
                    }
                }
            });
            exportMenu.add(item);
            item = new JMenuItem("2D Model as SVG file"){

                public void paintComponent(Graphics graphics) {
                    this.setEnabled(Assemble.this.mediator.get2DModel() != null);
                    super.paintComponent(graphics);
                }
            };
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser fileChooser = new JFileChooser(Paradise.getWorkingDirectory());
                    fileChooser.setAcceptAllFileFilterUsed(false);
                    fileChooser.setFileHidingEnabled(true);
                    fileChooser.setFileFilter(new FileFilter(){

                        public boolean accept(File file) {
                            return file.isDirectory() || file.getName().endsWith("svg");
                        }

                        public String getDescription() {
                            return "SVG files";
                        }
                    });
                    if (fileChooser.showSaveDialog(null) == 0) {
                        final File file = fileChooser.getSelectedFile();
                        new ParadiseTask((Application)Assemble.this, Assemble.this.messageBar){

                            protected Object doInBackground() {
                                try {
                                    Assemble.this.messageBar.startAnimation();
                                    if (!file.exists()) {
                                        file.createNewFile();
                                    }
                                    PrintWriter pw = new PrintWriter(file);
                                    pw.print(Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().toSVG());
                                    pw.close();
                                    this.monitor.printMessage("Export successful");
                                }
                                catch (Exception e) {
                                    this.monitor.printException(e);
                                }
                                this.finished();
                                return null;
                            }
                        }.execute();
                    }
                }
            });
            exportMenu.add(item);
            item = new JMenuItem("RNA Molecules as FASTA file"){

                public void paintComponent(Graphics graphics) {
                    this.setEnabled(Assemble.this.mediator.get2DModel() != null);
                    super.paintComponent(graphics);
                }
            };
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Assemble.this.mediator.stopAnimator();
                    JFileChooser saveFile = new JFileChooser(Assemble.this.getAssembleLastSavePath());
                    saveFile.setFileFilter(new FileFilter(){

                        public boolean accept(File file) {
                            if (file.isDirectory()) {
                                return true;
                            }
                            for (String suffix : FastaFileIO.suffixes) {
                                if (!file.getName().endsWith(suffix)) continue;
                                return true;
                            }
                            return false;
                        }

                        public String getDescription() {
                            return "FASTA files";
                        }
                    });
                    saveFile.setAcceptAllFileFilterUsed(false);
                    if (saveFile.showSaveDialog(null) == 0) {
                        final File file = saveFile.getSelectedFile();
                        new ParadiseTask((Application)Assemble.this, Assemble.this.messageBar){

                            protected Object doInBackground() {
                                try {
                                    Assemble.this.messageBar.startAnimation();
                                    if (!file.exists()) {
                                        file.createNewFile();
                                    }
                                    ArrayList<String> names = new ArrayList<String>();
                                    ArrayList<String> sequences = new ArrayList<String>();
                                    for (Molecule m : Assemble.this.mediator.get2DModel().getSecondaryStructure().getMolecules()) {
                                        names.add(m.getName());
                                        sequences.add(m.printSequence());
                                    }
                                    FastaFileIO.exportMoleculesAsFastaFile((File)file, names, sequences);
                                    Assemble.this.mediator.startAnimator();
                                    this.monitor.printMessage("Export successful");
                                }
                                catch (Exception e) {
                                    this.monitor.printException(e);
                                }
                                this.finished();
                                return null;
                            }
                        }.execute();
                    }
                }
            });
            exportMenu.add(item);
            JMenu selectionMenu = new JMenu("Selection..."){

                public void paintComponent(Graphics graphics) {
                    this.setEnabled(Assemble.this.mediator.get3DModel() != null || Assemble.this.mediator.get2DModel() != null);
                    super.paintComponent(graphics);
                }
            };
            exportMenu.add(selectionMenu);
            item = new JMenuItem("as PDB file"){

                public void paintComponent(Graphics graphics) {
                    this.setEnabled(Assemble.this.mediator.get3DModel() != null);
                    super.paintComponent(graphics);
                }
            };
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (Assemble.this.mediator.getGlobalSelection().getSelectedResidues().isEmpty()) {
                        JOptionPane.showMessageDialog(Assemble.this.window, "No selection available");
                        return;
                    }
                    Assemble.this.mediator.stopAnimator();
                    JFileChooser saveFile = new JFileChooser(Assemble.this.getAssembleLastSavePath());
                    saveFile.setFileFilter(new FileFilter(){

                        public boolean accept(File file) {
                            if (file.isDirectory()) {
                                return true;
                            }
                            for (String suffix : PDBFileIO.suffixes) {
                                if (!file.getName().endsWith(suffix)) continue;
                                return true;
                            }
                            return false;
                        }

                        public String getDescription() {
                            return "PDB files";
                        }
                    });
                    saveFile.setAcceptAllFileFilterUsed(false);
                    if (saveFile.showSaveDialog(Assemble.this.window) == 0) {
                        Assemble.this.setAssembleLastSavePath(saveFile.getSelectedFile());
                        final String filename = saveFile.getSelectedFile().getAbsolutePath();
                        new ParadiseTask((Application)Assemble.this, Assemble.this.messageBar){

                            protected Object doInBackground() {
                                Assemble.this.messageBar.startAnimation();
                                try {
                                    Assemble.this.mediator.getGlobalSelection().exportAsPDB(filename);
                                    Assemble.this.mediator.startAnimator();
                                    this.monitor.printMessage("Export successful");
                                }
                                catch (Exception e) {
                                    this.monitor.printException(e);
                                }
                                this.finished();
                                return null;
                            }
                        }.execute();
                    }
                }
            });
            selectionMenu.add(item);
            item = new JMenuItem("as CT file"){

                public void paintComponent(Graphics graphics) {
                    this.setEnabled(Assemble.this.mediator.get2DModel() != null);
                    super.paintComponent(graphics);
                }
            };
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().getCurrentResidues().isEmpty()) {
                        JOptionPane.showMessageDialog(Assemble.this.window, "No selection available");
                        return;
                    }
                    Assemble.this.mediator.stopAnimator();
                    JFileChooser saveFile = new JFileChooser(Assemble.this.getAssembleLastSavePath());
                    saveFile.setFileFilter(new FileFilter(){

                        public boolean accept(File file) {
                            if (file.isDirectory()) {
                                return true;
                            }
                            for (String suffix : CTFileIO.suffixes) {
                                if (!file.getName().endsWith(suffix)) continue;
                                return true;
                            }
                            return false;
                        }

                        public String getDescription() {
                            return "CT files";
                        }
                    });
                    saveFile.setAcceptAllFileFilterUsed(false);
                    if (saveFile.showSaveDialog(null) == 0) {
                        final File file = saveFile.getSelectedFile();
                        new ParadiseTask((Application)Assemble.this, Assemble.this.messageBar){

                            protected Object doInBackground() {
                                try {
                                    Assemble.this.messageBar.startAnimation();
                                    if (!file.exists()) {
                                        file.createNewFile();
                                    }
                                    ArrayList<Residue> residues = new ArrayList<Residue>();
                                    HashSet<BaseBaseInteraction> interactions = new HashSet<BaseBaseInteraction>();
                                    Molecule currentMolecule = null;
                                    for (Residue2D r2D : Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().getCurrentResidues()) {
                                        Residue r = (Residue)r2D.getResidue2DFeature().getResidues().iterator().next();
                                        if (currentMolecule == null) {
                                            currentMolecule = r.getMolecule();
                                        } else if (currentMolecule != r.getMolecule()) {
                                            JOptionPane.showMessageDialog(Assemble.this.window, "You cannot export several molecules in one CT file");
                                            file.delete();
                                            return null;
                                        }
                                        residues.add(r);
                                        for (Interaction2D interaction : r2D.getInteractions()) {
                                            if (!BaseBaseInteraction2D.class.isInstance(interaction) || !((BaseBaseInteraction2D)interaction).getBaseBaseInteractionFeature().isSecondaryInteraction()) continue;
                                            interactions.add(((BaseBaseInteraction2D)interaction).getBaseBaseInteractionFeature());
                                        }
                                    }
                                    Collections.sort(residues, new Comparator(){

                                        public int compare(Object o1, Object o2) {
                                            return ((Residue)o1).getAbsolutePosition() - ((Residue)o2).getAbsolutePosition();
                                        }
                                    });
                                    CTFileIO.writeCTFile(residues, new ArrayList(interactions), (File)file);
                                    Assemble.this.mediator.startAnimator();
                                    this.monitor.printMessage("Export successful");
                                }
                                catch (Exception e) {
                                    this.monitor.printException(e);
                                }
                                this.finished();
                                return null;
                            }
                        }.execute();
                    }
                }
            });
            selectionMenu.add(item);
            item = new JMenuItem("as FASTA file"){

                public void paintComponent(Graphics graphics) {
                    this.setEnabled(Assemble.this.mediator.get2DModel() != null);
                    super.paintComponent(graphics);
                }
            };
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (Assemble.this.mediator.getGlobalSelection().getSelectedResidues().isEmpty() || Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().getCurrentResidues().isEmpty()) {
                        JOptionPane.showMessageDialog(Assemble.this.window, "No selection available");
                        return;
                    }
                    Assemble.this.mediator.stopAnimator();
                    JFileChooser saveFile = new JFileChooser(Assemble.this.getAssembleLastSavePath());
                    saveFile.setFileFilter(new FileFilter(){

                        public boolean accept(File file) {
                            if (file.isDirectory()) {
                                return true;
                            }
                            for (String suffix : FastaFileIO.suffixes) {
                                if (!file.getName().endsWith(suffix)) continue;
                                return true;
                            }
                            return false;
                        }

                        public String getDescription() {
                            return "FASTA files";
                        }
                    });
                    saveFile.setAcceptAllFileFilterUsed(false);
                    if (saveFile.showSaveDialog(null) == 0) {
                        final File file = saveFile.getSelectedFile();
                        new ParadiseTask((Application)Assemble.this, Assemble.this.messageBar){

                            protected Object doInBackground() {
                                try {
                                    Assemble.this.messageBar.startAnimation();
                                    if (!file.exists()) {
                                        file.createNewFile();
                                    }
                                    ArrayList<String> names = new ArrayList<String>();
                                    ArrayList<String> sequences = new ArrayList<String>();
                                    int start = -1;
                                    int currentPosition = -1;
                                    StringBuffer sequence = null;
                                    String currentName = null;
                                    for (Residue2D r : Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().getCurrentResidues()) {
                                        if (r.getAbsolutePosition() - 1 != currentPosition) {
                                            if (sequence != null) {
                                                names.add(currentName + " (" + start + "-" + currentPosition + ")");
                                                sequences.add(sequence.toString());
                                            }
                                            currentName = ((Residue)r.getResidue2DFeature().getResidues().iterator().next()).getMolecule().getName();
                                            currentPosition = r.getAbsolutePosition();
                                            start = r.getAbsolutePosition();
                                            sequence = new StringBuffer();
                                            sequence.append(r.getSymbol());
                                            continue;
                                        }
                                        sequence.append(r.getSymbol());
                                        currentPosition = r.getAbsolutePosition();
                                    }
                                    if (sequence != null) {
                                        names.add(currentName + " (" + start + "-" + currentPosition + ")");
                                        sequences.add(sequence.toString());
                                    }
                                    FastaFileIO.exportMoleculesAsFastaFile((File)file, names, sequences);
                                    Assemble.this.mediator.startAnimator();
                                    this.monitor.printMessage("Export successful");
                                }
                                catch (Exception e) {
                                    this.monitor.printException(e);
                                }
                                this.finished();
                                return null;
                            }
                        }.execute();
                    }
                }
            });
            selectionMenu.add(item);
            item = new JMenuItem("Quit");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (JOptionPane.showConfirmDialog(null, "Are you sure you want to exit Assemble?", "Confirm exit", 0) == 0) {
                        try {
                            AssembleConfig.save();
                        }
                        catch (BackingStoreException e1) {
                            e1.printStackTrace();
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                        System.exit(0);
                    }
                }
            });
            this.add(item);
        }
    }

    private class AssembleToolBar
    extends JToolBar {
        JButton selectAtom;
        JButton selectResidue;
        JButton selectChain;
        JButton selectStructuralDomain;
        JButton unselect;
        JButton cut;
        JButton bind;
        JButton twist;
        JButton deleteResidues;
        JButton stackResidue;
        JButton stackMolecularChain;
        JButton stackStructuralDomain;
        JButton stackUserSelection;
        JButton restoreAForm;
        JButton pairChain;
        JButton refine;
        JButton snapshot;
        JButton acceptModel;
        JButton rejectModel;
        JButton deleteModel;

        public AssembleToolBar() {
            this.selectAtom = new FlatButton("22/atom.png", "Select Atoms");
            this.selectResidue = new FlatButton("22/adenine.png", "Select Residues");
            this.selectChain = new FlatButton("22/chain.png", "Select Chains");
            this.selectStructuralDomain = new FlatButton("22/block.png", "Select Structural Domains");
            this.unselect = new FlatButton("22/unselect.png", "Clear Selection");
            this.cut = new FlatButton("22/cut.png", "Cut a Molecular Chain");
            this.bind = new FlatButton("22/link.png", "Bind Two Molecular Chains");
            this.twist = new FlatButton("22/torsion.png", "Twist Residue Angles");
            this.deleteResidues = new FlatButton("delete-interaction.png", "Delete Selected Residues");
            this.stackResidue = new FlatButton("22/adenine.png", "Stack Residue");
            this.stackMolecularChain = new FlatButton("22/chain.png", "Stack Molecular Chain");
            this.stackStructuralDomain = new FlatButton("22/block.png", "Stack Structural Domain");
            this.stackUserSelection = new FlatButton("22/user.png", "Stack User Selection");
            this.restoreAForm = new FlatButton("22/aform.png", "Set A-form backbone");
            this.pairChain = new FlatButton("22/block.png", "Pair Two Molecular Chains");
            this.refine = new FlatButton("22/refine.png", "Refine coordinates");
            this.snapshot = new FlatButton("capture.png", "Take a Snapshot");
            this.acceptModel = new FlatButton("22/accept-model.png", "Accept current 3D model");
            this.rejectModel = new FlatButton("22/reject-model.png", "Reject current 3D model");
            this.deleteModel = new FlatButton("22/delete-model.png", "Delete 3D model");
            this.setBackground(Color.WHITE);
            this.setFloatable(false);
            JLabel toolBarName = new JLabel();
            toolBarName.setIcon((Icon)new VTextIcon((Component)toolBarName, "3D", 2));
            this.add(toolBarName);
            this.add(Box.createHorizontalStrut(5));
            int height = RessourcesUtils.getIcon("22/open.png").getIconHeight();
            this.add(this.selectAtom);
            this.selectAtom.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Assemble.this.mediator.getRenderer().setSelectMode(0);
                }
            });
            this.add(this.selectResidue);
            this.selectResidue.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Assemble.this.mediator.getRenderer().setSelectMode(1);
                }
            });
            this.add(this.selectChain);
            this.selectChain.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Assemble.this.mediator.getRenderer().setSelectMode(2);
                }
            });
            this.add(this.selectStructuralDomain);
            this.selectStructuralDomain.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Assemble.this.mediator.getRenderer().setSelectMode(29);
                }
            });
            this.add(this.unselect);
            this.unselect.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Assemble.this.mediator.getGlobalSelection().clear();
                    Assemble.this.mediator.getRna2DViewer().getSecondaryCanvas().clearAllSelections();
                    Assemble.this.secondaryStructureNavigator.clearSelections();
                }
            });
            this.add(Box.createHorizontalStrut(5));
            JSeparator separator = new JSeparator(1);
            separator.setBackground(Color.GRAY);
            separator.setMaximumSize(new Dimension(2, height));
            this.add(separator);
            this.add(Box.createHorizontalStrut(5));
            this.add(this.cut);
            this.cut.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Assemble.this.edit.cut.doClick();
                }
            });
            this.add(this.bind);
            this.bind.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Assemble.this.edit.bind.doClick();
                }
            });
            this.add(this.twist);
            this.twist.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Assemble.this.edit.torsion.doClick();
                }
            });
            this.add(this.deleteResidues);
            this.deleteResidues.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (Assemble.this.mediator.getGlobalSelection().getSelectedResidues().isEmpty()) {
                        JOptionPane.showMessageDialog(null, "No Residues Selected");
                        return;
                    }
                    if (0 == JOptionPane.showConfirmDialog(null, "Are you sure to delete all the Residues selected?")) {
                        for (fr.unistra.ibmc.assemble.structures.Residue r : Assemble.this.mediator.getGlobalSelection().getSelectedResidues()) {
                            Assemble.this.mediator.get3DModel().eraseResidue(r);
                        }
                        Assemble.this.mediator.getRenderer().reComputeNeeded();
                        Assemble.this.mediator.getGlobalSelection().clear();
                        Assemble.this.mediator.startAnimator();
                        Assemble.this.mediator.get3DModel().fireModelModified();
                    }
                }
            });
            this.restoreAForm.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (Assemble.this.mediator.getGlobalSelection().getSelectedChains().size() != 1) {
                        JOptionPane.showMessageDialog(Assemble.this.window, "Select a single molecular chain to use this option.");
                        return;
                    }
                    Chain c = Assemble.this.mediator.getGlobalSelection().getSelectedChains().iterator().next();
                    if (!RNA.class.isInstance(c.getMolecule())) {
                        JOptionPane.showMessageDialog(Assemble.this.window, "The molecular chain selected is not an RNA molecule");
                        return;
                    }
                    c.restoreAFormConformation();
                    Assemble.this.mediator.get3DModel().fireModelModified();
                }
            });
            this.pairChain.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (Assemble.this.mediator.getGlobalSelection().getSelectedChains().size() != 2) {
                        JOptionPane.showMessageDialog(Assemble.this.window, "Select exactly 2 molecular chains to use this option.");
                        return;
                    }
                    Iterator<Chain> it = Assemble.this.mediator.getGlobalSelection().getSelectedChains().iterator();
                    Chain c1 = it.next();
                    Chain c2 = it.next();
                    if (c1.getLength() != c2.getLength()) {
                        JOptionPane.showMessageDialog(Assemble.this.window, "The molecular chains to pair need to have the same length");
                        return;
                    }
                    int length = c1.getLength();
                    for (int i = 0; i < length; ++i) {
                        try {
                            ((ResidueNA)c1.getResidue(i)).setPair((ResidueNA)c2.getResidue(length - (i + 1)));
                            continue;
                        }
                        catch (BiologicalSymbolException e) {
                            e.printStackTrace();
                        }
                    }
                    Assemble.this.mediator.get3DModel().fireModelModified();
                }
            });
            this.add(this.stackResidue);
            this.stackResidue.addActionListener(new ActionListener(){
                private boolean reverse;

                public void actionPerformed(ActionEvent actionEvent) {
                    if (Assemble.this.mediator.getGlobalSelection().getSelectedResidues().size() != 2) {
                        JOptionPane.showMessageDialog(Assemble.this.window, "Select exactly 2 residues to use this option.");
                        return;
                    }
                    Iterator<fr.unistra.ibmc.assemble.structures.Residue> it = Assemble.this.mediator.getGlobalSelection().getSelectedResidues().iterator();
                    fr.unistra.ibmc.assemble.structures.Residue r1 = it.next();
                    fr.unistra.ibmc.assemble.structures.Residue r2 = it.next();
                    if (this.reverse) {
                        ((ResidueNA)r2).stackResidueAfter((ResidueNA)r1);
                    } else {
                        ((ResidueNA)r1).stackResidueBefore((ResidueNA)r2);
                    }
                    this.reverse = !this.reverse;
                    Assemble.this.mediator.get3DModel().fireModelModified();
                }
            });
            this.add(this.stackMolecularChain);
            this.stackMolecularChain.addActionListener(new ActionListener(){
                private boolean reverse;

                public void actionPerformed(ActionEvent actionEvent) {
                    if (Assemble.this.mediator.getGlobalSelection().getSelectedResidues().size() != 2) {
                        JOptionPane.showMessageDialog(Assemble.this.window, "Select exactly 2 residues to use this option.");
                        return;
                    }
                    Iterator<fr.unistra.ibmc.assemble.structures.Residue> it = Assemble.this.mediator.getGlobalSelection().getSelectedResidues().iterator();
                    fr.unistra.ibmc.assemble.structures.Residue r1 = it.next();
                    fr.unistra.ibmc.assemble.structures.Residue r2 = it.next();
                    boolean stacked = false;
                    stacked = this.reverse ? ((ResidueNA)r2).stackChainAfter((ResidueNA)r1) : ((ResidueNA)r1).stackChainBefore((ResidueNA)r2);
                    if (stacked) {
                        this.reverse = !this.reverse;
                    }
                    Assemble.this.mediator.get3DModel().fireModelModified();
                }
            });
            this.add(this.stackStructuralDomain);
            this.stackStructuralDomain.addActionListener(new ActionListener(){
                private boolean reverse;

                public void actionPerformed(ActionEvent actionEvent) {
                    if (Assemble.this.mediator.getGlobalSelection().getSelectedResidues().size() != 2) {
                        JOptionPane.showMessageDialog(Assemble.this.window, "Select exactly 2 residues to use this option.");
                        return;
                    }
                    Iterator<fr.unistra.ibmc.assemble.structures.Residue> it = Assemble.this.mediator.getGlobalSelection().getSelectedResidues().iterator();
                    fr.unistra.ibmc.assemble.structures.Residue r1 = it.next();
                    fr.unistra.ibmc.assemble.structures.Residue r2 = it.next();
                    boolean stacked = false;
                    stacked = this.reverse ? ((ResidueNA)r2).stackStructuralDomainAfter((ResidueNA)r1) : ((ResidueNA)r1).stackStructuralDomainBefore((ResidueNA)r2);
                    if (stacked) {
                        this.reverse = !this.reverse;
                    }
                    Assemble.this.mediator.get3DModel().fireModelModified();
                }
            });
            this.add(this.stackUserSelection);
            this.stackUserSelection.addActionListener(new ActionListener(){
                private boolean reverse;

                public void actionPerformed(ActionEvent actionEvent) {
                    if (Assemble.this.mediator.getGlobalSelection().getSelectedResidues().size() != 2) {
                        JOptionPane.showMessageDialog(Assemble.this.window, "Select exactly 2 residues to use this option.");
                        return;
                    }
                    Iterator<fr.unistra.ibmc.assemble.structures.Residue> it = Assemble.this.mediator.getGlobalSelection().getSelectedResidues().iterator();
                    fr.unistra.ibmc.assemble.structures.Residue r1 = it.next();
                    fr.unistra.ibmc.assemble.structures.Residue r2 = it.next();
                    boolean stacked = false;
                    if (this.reverse) {
                        ArrayList<UserSelection> selections = new ArrayList<UserSelection>();
                        for (UserSelection us : Assemble.this.mediator.getUserSelections()) {
                            if (!us.getSelectedResidues().contains(r1)) continue;
                            selections.add(us);
                        }
                        UserSelection selection = null;
                        if (selections.size() == 0) {
                            JOptionPane.showMessageDialog(Assemble.this.window, "No User Selection containing the first residue clicked");
                            return;
                        }
                        selection = selections.size() == 1 ? (UserSelection)selections.get(0) : (UserSelection)JOptionPane.showInputDialog(Assemble.this.window, "Choose a User Selection to stack", "Choose a User Selection to stack", -1, null, selections.toArray(), selections.get(0));
                        if (selection != null) {
                            stacked = ((ResidueNA)r2).stackUserSelectionAfter((ResidueNA)r1, selection);
                        }
                    } else {
                        ArrayList<UserSelection> selections = new ArrayList<UserSelection>();
                        for (UserSelection us : Assemble.this.mediator.getUserSelections()) {
                            if (!us.getSelectedResidues().contains(r1)) continue;
                            selections.add(us);
                        }
                        UserSelection selection = null;
                        if (selections.size() == 0) {
                            JOptionPane.showMessageDialog(Assemble.this.window, "No User Selection containing the firest residue clicked");
                            return;
                        }
                        selection = selections.size() == 1 ? (UserSelection)selections.get(0) : (UserSelection)JOptionPane.showInputDialog(Assemble.this.window, "Choose a User Selection to stack", "Choose a User Selection to stack", -1, null, selections.toArray(), selections.get(0));
                        if (selection != null) {
                            stacked = ((ResidueNA)r1).stackUserSelectionBefore((ResidueNA)r2, selection);
                        }
                    }
                    if (stacked) {
                        this.reverse = !this.reverse;
                    }
                    Assemble.this.mediator.get3DModel().fireModelModified();
                }
            });
            this.add(Box.createHorizontalStrut(5));
            separator = new JSeparator(1);
            separator.setBackground(Color.GRAY);
            separator.setMaximumSize(new Dimension(2, height));
            this.add(separator);
            this.add(Box.createHorizontalStrut(5));
            this.add(this.refine);
            if (!Assemble.this.mediator.getAssemble().isConnected()) {
                this.refine.setToolTipText("Refine coordinates (need connection)");
                this.refine.setEnabled(false);
            }
            this.refine.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (Assemble.this.mediator.get3DModel() != null) {
                        Assemble.this.mediator.get3DModel().saveCoordinatesToParadise();
                        for (BaseBaseInteraction interaction : Assemble.this.mediator.get3DModel().getSecondaryStructure().getBaseBaseInteractions()) {
                            interaction.removeAtomAtomInteractions();
                            interaction.generateAtomAtomInteractions();
                        }
                        HashSet<Molecule> molecules = new HashSet<Molecule>();
                        for (Molecule molecule : Assemble.this.mediator.get3DModel().getTertiaryStructure().getMolecules()) {
                            if (!RNA.class.isInstance(molecule)) continue;
                            molecule.addSelectedFeature((ParadiseFeature)Assemble.this.mediator.get3DModel().getTertiaryStructure());
                            molecule.addSelectedFeature((ParadiseFeature)Assemble.this.mediator.get3DModel().getSecondaryStructure());
                            molecules.add(molecule);
                        }
                        new RnartDialog(Assemble.this.mediator, molecules);
                    }
                }
            });
            this.add(this.acceptModel);
            this.acceptModel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String name = JOptionPane.showInputDialog(Assemble.this.window, (Object)"Choose a name for this construction step");
                    if (name != null && name.length() != 0) {
                        Assemble.this.addUndoStep(name);
                    }
                }
            });
            this.add(this.deleteModel);
            this.deleteModel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (0 == JOptionPane.showConfirmDialog(null, "Are you sure to delete your 3D model?")) {
                        Assemble.this.mediator.stopAnimator();
                        for (fr.unistra.ibmc.assemble.structures.Residue r : Assemble.this.mediator.get3DModel().getResidues()) {
                            Assemble.this.mediator.get3DModel().eraseResidue(r);
                        }
                        Assemble.this.mediator.getRenderer().reComputeNeeded();
                        Assemble.this.mediator.getGlobalSelection().clear();
                        Assemble.this.mediator.startAnimator();
                        Assemble.this.mediator.get3DModel().fireModelModified();
                    }
                }
            });
            this.snapshot.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (Assemble.this.mediator.get3DModel() != null) {
                        JFileChooser fileChooser = new JFileChooser(Paradise.getWorkingDirectory());
                        fileChooser.setFileFilter(new FileFilter(){

                            public boolean accept(File f) {
                                return f.isDirectory() || f.getName().endsWith(".png");
                            }

                            public String getDescription() {
                                return "PNG file";
                            }
                        });
                        if (fileChooser.showSaveDialog(Assemble.this.window) == 0) {
                            new ParadiseTask((Application)Assemble.this, Assemble.this.messageBar){

                                protected Object doInBackground() {
                                    return null;
                                }
                            }.execute();
                        }
                    }
                }
            });
        }
    }

    private class AssembleMenu
    extends JMenuBar {
        private AssembleMenu() {
            Assemble.this.file = new FileMenu();
            Assemble.this.stereo = new StereoMenu();
            Assemble.this.tertiarySelection = new TertiarySelectionMenu();
            Assemble.this.secondaryModel = new SecondaryModelMenu();
            Assemble.this.tertiaryModel = new TertiaryModelMenu();
            Assemble.this.edit = new EditMenu();
            Assemble.this.plugins = new PluginsMenu();
            Assemble.this.help = new HelpMenu();
            this.add(Assemble.this.file);
            this.add(Assemble.this.secondaryModel);
            this.add(Assemble.this.tertiaryModel);
            this.add(Assemble.this.tertiarySelection);
            this.add(Assemble.this.plugins);
            this.add(Assemble.this.help);
        }
    }
}

