/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.gui;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.gui.DKnob;
import fr.unistra.ibmc.assemble.gui.rendering.OpenGLColor;
import fr.unistra.ibmc.assemble.maps.ContourLevel;
import fr.unistra.ibmc.assemble.maps.EDMap;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.text.Document;
import org.jdesktop.swingworker.SwingWorker;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.VerticalLayout;

public class EDMapPanel
extends JPanel
implements ActionListener,
ChangeListener {
    Slider isolevel;
    JLabel lMinX;
    JLabel lMinY;
    JLabel lMinZ;
    JLabel lMaxX;
    JLabel lMaxY;
    JLabel lMaxZ;
    JLabel tIsolevel;
    JButton save;
    JButton saveMat;
    JButton loadMat;
    Mediator mediator;
    EDMap edmap;

    public EDMapPanel(Mediator mediator, EDMap edmap) {
        this.mediator = mediator;
        this.edmap = edmap;
        this.setLayout(new BorderLayout());
        this.isolevel = new Slider(this.edmap.getContourLevel());
        this.isolevel.addChangeListener(this);
        this.tIsolevel = new JLabel("" + this.isolevel.getSelectedValue());
        this.save = new JButton("Save this selection");
        this.saveMat = new JButton("Save Transformation Matrix");
        this.loadMat = new JButton("Load Transformation Matrix");
        this.save.addActionListener(this);
        this.saveMat.addActionListener(this);
        this.loadMat.addActionListener(this);
        JPanel sigmaPanel = new JPanel();
        sigmaPanel.setBorder(BorderFactory.createTitledBorder("Sigma Level"));
        sigmaPanel.setLayout(new BorderLayout());
        sigmaPanel.add((Component)this.isolevel, "North");
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout(new BoxLayout(infoPanel, 0));
        infoPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        infoPanel.add(this.tIsolevel);
        sigmaPanel.add((Component)this.tIsolevel, "Center");
        JXPanel pivotPanel = new JXPanel();
        pivotPanel.setBorder(BorderFactory.createTitledBorder("Pivot"));
        pivotPanel.setLayout(new BorderLayout());
        final EDMapDKnobPanel aroundPivotDisplay = new EDMapDKnobPanel("Distance From Pivot", Color.GREEN, this.edmap.getRadius(), 0.0f, 100.0f);
        aroundPivotDisplay.setEnabled(false);
        final JCheckBox aroundPivot = new JCheckBox("Map's Display is relative to pivot");
        aroundPivot.setSelected(this.edmap.isRelativeToPivotDrawing());
        aroundPivot.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                aroundPivotDisplay.setEnabled(aroundPivot.isSelected());
                EDMapPanel.this.edmap.setRelativeToPivotDrawing(aroundPivot.isSelected());
            }
        });
        pivotPanel.add((Component)aroundPivot, "North");
        aroundPivotDisplay.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                EDMapPanel.this.edmap.setRadius((int)aroundPivotDisplay.getValue());
            }
        });
        pivotPanel.add((Component)aroundPivotDisplay, "Center");
        JXPanel renderingPanel = new JXPanel();
        renderingPanel.setLayout((LayoutManager)new VerticalLayout());
        renderingPanel.setBorder(BorderFactory.createTitledBorder("Map Precision"));
        renderingPanel.add(sigmaPanel);
        renderingPanel.add((Component)pivotPanel);
        final EDMapDKnobPanel granularity = new EDMapDKnobPanel("Granularity", Color.GREEN, this.edmap.getGranularity(), 1.0f, this.edmap.getSpread() / 2);
        granularity.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                EDMapPanel.this.edmap.setGranularity((int)granularity.getValue());
            }
        });
        renderingPanel.add(granularity);
        final JButton apply = new JButton("Apply");
        apply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                apply.setEnabled(false);
                new SwingWorker(){

                    protected Object doInBackground() throws Exception {
                        long lastPolygonisation = System.currentTimeMillis();
                        EDMapPanel.this.edmap.setLastPolygonisation(lastPolygonisation);
                        EDMapPanel.this.edmap.polygonise(lastPolygonisation);
                        EDMapPanel.this.edmap.setMustCompute(true);
                        apply.setEnabled(true);
                        return null;
                    }
                }.execute();
            }
        });
        renderingPanel.add(apply);
        JRadioButton mesh = new JRadioButton("Mesh");
        JRadioButton alpha = new JRadioButton("Transparent");
        JRadioButton dot = new JRadioButton("Dots");
        JRadioButton hide = new JRadioButton("Hide");
        ButtonGroup group = new ButtonGroup();
        group.add(mesh);
        group.add(alpha);
        group.add(dot);
        group.add(hide);
        mesh.setSelected(true);
        mesh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EDMapPanel.this.edmap.setMode(2);
            }
        });
        alpha.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EDMapPanel.this.edmap.setMode(1);
            }
        });
        dot.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EDMapPanel.this.edmap.setMode(4);
            }
        });
        hide.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EDMapPanel.this.edmap.setMode(3);
            }
        });
        JCheckBox mapBorders = new JCheckBox("Display Map Limits?");
        mapBorders.addActionListener(this);
        mapBorders.setSelected(false);
        mapBorders.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        JXPanel displayPanel = new JXPanel();
        displayPanel.setBorder((Border)BorderFactory.createTitledBorder("Display Options"));
        displayPanel.setLayout((LayoutManager)new VerticalLayout());
        displayPanel.add((Component)mesh);
        displayPanel.add((Component)hide);
        final EDMapDKnobPanel opacity = new EDMapDKnobPanel("Opacity", Color.GREEN, this.edmap.getAlpha(), 0.0f, 1.0f);
        opacity.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                EDMapPanel.this.edmap.setAlpha(opacity.getValue());
            }
        });
        displayPanel.add((Component)opacity);
        displayPanel.add((Component)((Object)new ColorPanel()));
        JXPanel mainPanel = new JXPanel();
        mainPanel.setLayout((LayoutManager)new BoxLayout((Container)mainPanel, 1));
        mainPanel.add((Component)renderingPanel);
        mainPanel.add((Component)displayPanel);
        this.add((Component)new JScrollPane((Component)mainPanel), "Center");
        apply.doClick();
    }

    public EDMap getEDMap() {
        return this.edmap;
    }

    public void actionPerformed(ActionEvent e) {
        JFileChooser openFile;
        int op;
        Object source = e.getSource();
        if (source == this.save) {
            // empty if block
        }
        if (source == this.saveMat) {
            // empty if block
        }
        if (source == this.loadMat && (op = (openFile = new JFileChooser(this.mediator.getAssemble().getAssembleLastLoadPath())).showOpenDialog(this)) == 0) {
            try {
                BufferedReader in = new BufferedReader(new FileReader(openFile.getSelectedFile()));
                in.readLine();
                StringTokenizer tok = new StringTokenizer(in.readLine());
                this.edmap.setTranslation(new float[]{Float.parseFloat(tok.nextToken()), Float.parseFloat(tok.nextToken()), Float.parseFloat(tok.nextToken())});
                float[] r = new float[16];
                in.readLine();
                tok = new StringTokenizer(in.readLine());
                r[0] = Float.parseFloat(tok.nextToken());
                r[1] = Float.parseFloat(tok.nextToken());
                r[2] = Float.parseFloat(tok.nextToken());
                r[3] = Float.parseFloat(tok.nextToken());
                tok = new StringTokenizer(in.readLine());
                r[4] = Float.parseFloat(tok.nextToken());
                r[5] = Float.parseFloat(tok.nextToken());
                r[6] = Float.parseFloat(tok.nextToken());
                r[7] = Float.parseFloat(tok.nextToken());
                tok = new StringTokenizer(in.readLine());
                r[8] = Float.parseFloat(tok.nextToken());
                r[9] = Float.parseFloat(tok.nextToken());
                r[10] = Float.parseFloat(tok.nextToken());
                r[11] = Float.parseFloat(tok.nextToken());
                tok = new StringTokenizer(in.readLine());
                r[12] = Float.parseFloat(tok.nextToken());
                r[13] = Float.parseFloat(tok.nextToken());
                r[14] = Float.parseFloat(tok.nextToken());
                r[15] = Float.parseFloat(tok.nextToken());
                this.edmap.setRotation(r);
                in.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (source == this.isolevel) {
            this.tIsolevel.setText("" + this.isolevel.getSelectedValue());
            this.edmap.setIsolevel(this.isolevel.getSelectedValue());
        }
    }

    public void enableApplyButton() {
    }

    private class ColorPanel
    extends JXPanel {
        protected Hashtable paneTable;
        protected Border unselectedBorder = new CompoundBorder(new MatteBorder(1, 1, 1, 1, this.getBackground()), new BevelBorder(1, Color.white, Color.gray));
        protected Border selectedBorder = new CompoundBorder(new MatteBorder(1, 1, 1, 1, Color.red), new MatteBorder(1, 1, 1, 1, this.getBackground()));
        protected Border activeBorder = new CompoundBorder(new MatteBorder(1, 1, 1, 1, Color.blue), new MatteBorder(1, 1, 1, 1, this.getBackground()));

        private ColorPanel() {
            this.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.setLayout(new GridLayout(8, 8));
            this.paneTable = new Hashtable();
            int[] values = new int[]{0, 128, 192, 255};
            for (int r = 0; r < values.length; ++r) {
                for (int g = 0; g < values.length; ++g) {
                    for (int b = 0; b < values.length; ++b) {
                        Color c = new Color(values[r], values[g], values[b]);
                        ColorPane pn = new ColorPane(c);
                        this.add(pn);
                        this.paneTable.put(c, pn);
                    }
                }
            }
        }

        private class ColorPane
        extends JPanel
        implements MouseListener {
            protected Color color;
            protected boolean isSelected;

            public ColorPane(Color c) {
                this.color = c;
                this.setBackground(c);
                this.setBorder(ColorPanel.this.unselectedBorder);
                String msg = "R " + c.getRed() + ", G " + c.getGreen() + ", B " + c.getBlue();
                this.setToolTipText(msg);
                this.addMouseListener(this);
            }

            public Color getColor() {
                return this.color;
            }

            public Dimension getPreferredSize() {
                return new Dimension(15, 15);
            }

            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            public void setSelected(boolean selected) {
                this.isSelected = selected;
                if (this.isSelected) {
                    this.setBorder(ColorPanel.this.selectedBorder);
                } else {
                    this.setBorder(ColorPanel.this.unselectedBorder);
                }
            }

            public boolean isSelected() {
                return this.isSelected;
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
                EDMapPanel.this.edmap.setColor(new OpenGLColor(this.color));
            }

            public void mouseEntered(MouseEvent e) {
                this.setBorder(ColorPanel.this.activeBorder);
            }

            public void mouseExited(MouseEvent e) {
                this.setBorder(this.isSelected ? ColorPanel.this.selectedBorder : ColorPanel.this.unselectedBorder);
            }
        }
    }

    private class EDMapDKnobPanel
    extends JPanel {
        private DKnob knob;
        private JLabel currentValue;
        private float min;
        private float max;

        private EDMapDKnobPanel(String title, Color c, float currentValue, float min, float max) {
            this.setLayout(new BorderLayout());
            this.min = min;
            this.max = max;
            this.knob = new DKnob(c);
            this.knob.setValue(currentValue / (max - min));
            this.currentValue = new JLabel("" + (min + this.knob.getValue() * (max - min)));
            this.knob.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    EDMapDKnobPanel.this.currentValue.setText("" + (EDMapDKnobPanel.this.min + EDMapDKnobPanel.this.knob.getValue() * (EDMapDKnobPanel.this.max - EDMapDKnobPanel.this.min)));
                }
            });
            JPanel center = new JPanel();
            FlowLayout fl = new FlowLayout();
            fl.setAlignment(1);
            center.setLayout(fl);
            this.currentValue.setHorizontalAlignment(0);
            center.add(this.knob);
            this.add((Component)center, "Center");
            this.add((Component)this.currentValue, "South");
            this.setBorder(BorderFactory.createTitledBorder(title));
        }

        private void addChangeListener(ChangeListener l) {
            this.knob.addChangeListener(l);
        }

        private float getValue() {
            return this.min + this.knob.getValue() * (this.max - this.min);
        }

        public void setEnabled(boolean b) {
            super.setEnabled(b);
            this.knob.setEnabled(b);
            this.currentValue.setEnabled(b);
        }
    }

    private class Slider
    extends JPanel
    implements MouseListener,
    MouseMotionListener {
        private int[] heights;
        private int barHeight = 50;
        private int barWidth = 2;
        private int space = 0;
        private int size;
        private int selectedIndex;
        private float selectedValue;
        private float min;
        private float max;
        private float step;
        protected transient ChangeEvent changeEvent = null;

        private Slider(ContourLevel cl) {
            this.size = cl.getSize();
            this.setPreferredSize(new Dimension(this.size * this.barWidth + (this.size - 1) * this.space, this.barHeight));
            float[] values = new float[this.size];
            this.heights = new int[this.size];
            this.min = cl.getMin();
            this.max = cl.getMax();
            this.step = (this.max - this.min) / (float)this.size;
            for (int i = 0; i < this.size; ++i) {
                values[i] = this.min + (float)i * this.step;
            }
            float[] h = cl.logLevels();
            for (int i = 0; i < this.size; ++i) {
                this.heights[i] = (int)(h[i] * (float)this.barHeight);
            }
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.setFocusable(true);
            this.setSelectedIndex(this.size / 2);
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2d.setColor(Color.WHITE);
            g2d.fillRect(0, 0, this.size * this.barWidth + (this.size - 1) * this.space, this.barHeight);
            for (int i = 0; i < this.size; ++i) {
                int x = i * (this.barWidth + this.space);
                g2d.setColor(Color.BLACK);
                if (i == this.selectedIndex) {
                    g2d.setColor(Color.GREEN);
                }
                g2d.fillRect(x, this.barHeight - this.heights[i], this.barWidth, this.heights[i]);
                if (i != this.selectedIndex) continue;
                g2d.setColor(Color.BLUE);
                g2d.fillRect(x, 0, this.barWidth, this.barHeight - this.heights[i]);
            }
        }

        private void setSelectedIndex(int index) {
            this.selectedIndex = index;
            this.selectedValue = this.min + (float)index * this.step;
            this.revalidate();
            this.repaint();
            this.fireStateChanged();
        }

        public void setSelectedValue(float value) {
            this.selectedValue = value;
            int index = (int)((value - this.min) / this.step);
            if (index < 0) {
                index = 0;
            }
            if (index >= this.size) {
                index = this.size - 1;
            }
            if (index != this.selectedIndex) {
                this.selectedIndex = index;
                this.revalidate();
                this.repaint();
                this.fireStateChanged();
            }
        }

        public float getSelectedValue() {
            return this.selectedValue;
        }

        protected void fireStateChanged() {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != ChangeListener.class) continue;
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
            }
        }

        public void addChangeListener(ChangeListener l) {
            this.listenerList.add(ChangeListener.class, l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.listenerList.remove(ChangeListener.class, l);
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
            this.setSelectedIndex(e.getX() / (this.barWidth + this.space));
        }

        public void mousePressed(MouseEvent e) {
            this.requestFocus();
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }

        public void insertUpdate(DocumentEvent e) {
            try {
                Document doc = e.getDocument();
                float value = Float.parseFloat(doc.getText(0, doc.getLength()));
                this.setSelectedValue(value);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public void removeUpdate(DocumentEvent e) {
            try {
                Document doc = e.getDocument();
                float value = Float.parseFloat(doc.getText(0, doc.getLength()));
                this.setSelectedValue(value);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public void changedUpdate(DocumentEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
            this.setSelectedIndex(e.getX() / (this.barWidth + this.space));
        }

        public void mouseMoved(MouseEvent e) {
        }
    }
}

