/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.gui;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.gui.rendering.KeyboardAction;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

public class KeyboardManager
extends JFrame
implements ActionListener {
    private Mediator mediator;
    private JButton setDefault;

    public KeyboardManager(Mediator mediator) {
        this.mediator = mediator;
        this.setDefault = new JButton("Set to Default");
        this.setDefault.addActionListener(this);
        this.setTitle("Keyboard Manager");
        this.refresh();
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.setDefault) {
            KeyboardAction.setDefault();
            this.refresh();
        }
    }

    public void refresh() {
        this.getContentPane().removeAll();
        this.getContentPane().setLayout(new BorderLayout());
        JPanel list = new JPanel();
        list.setLayout(new GridLayout(0, 2));
        list.add(new JLabel("Action"));
        list.add(new JLabel("Selected Key"));
        for (int i = 1; i <= 41; ++i) {
            final String action = KeyboardAction.getName(i);
            final String key = KeyboardAction.getKey(i);
            list.add(new JLabel(action));
            JButton button = new JButton();
            if (key.equals("No Key Assigned to this Action")) {
                button.setForeground(Color.RED);
            } else {
                button.setForeground(Color.BLACK);
            }
            button.setAction(new AbstractAction(){
                private KeyAssignment ka;

                public void actionPerformed(ActionEvent e) {
                    if (this.ka == null || !this.ka.isVisible()) {
                        this.ka = new KeyAssignment(action, key);
                    }
                }
            });
            button.setText(key.replace("pressed ", ""));
            list.add(button);
        }
        JScrollPane sp = new JScrollPane(list, 20, 30);
        JPanel main = new JPanel(new BorderLayout());
        main.setPreferredSize(new Dimension(800, 800));
        main.add((Component)sp, "Center");
        this.getContentPane().add((Component)main, "Center");
        this.getContentPane().add((Component)this.setDefault, "South");
        this.pack();
    }

    private class KeyAssignment
    extends JDialog
    implements KeyListener {
        JLabel nameLabel;
        JLabel valueLabel;

        public KeyAssignment(String name, String value) {
            this.nameLabel = new JLabel(name);
            Font f = this.nameLabel.getFont();
            this.nameLabel.setFont(new Font(f.getName(), 1, f.getSize() * 2));
            this.valueLabel = new JLabel(value.replace("pressed", ""));
            this.nameLabel.setForeground(Color.ORANGE.darker());
            this.valueLabel.setForeground(Color.GREEN.darker());
            this.addKeyListener(this);
            this.setTitle("Choose a (unique) key");
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this.nameLabel, "North");
            this.getContentPane().add((Component)this.valueLabel, "South");
            this.pack();
            this.setVisible(true);
        }

        public void keyPressed(KeyEvent e) {
            String value = KeyStroke.getKeyStrokeForEvent(e).toString();
            if (value.contains("SHIFT") || value.contains("CONTROL") || value.contains("ALT")) {
                JOptionPane.showMessageDialog(null, "The keys SHIFT, CONTROL and ALT are already used and cannot be assigned to this task");
            } else {
                this.valueLabel.setText(value.replace("pressed ", ""));
                KeyboardAction.setKey(this.nameLabel.getText(), value);
                KeyboardManager.this.refresh();
                this.dispose();
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }
    }
}

