/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.gui;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.gui.Assemble;
import fr.unistra.ibmc.assemble.gui.UserSelection;
import fr.unistra.ibmc.assemble.ssviewer.features.BaseBaseInteraction2D;
import fr.unistra.ibmc.assemble.ssviewer.features.Residue2D;
import fr.unistra.ibmc.assemble.structures.Atom;
import fr.unistra.ibmc.paradise.BiologicalSymbolException;
import fr.unistra.ibmc.paradise.core.features.Adenine3D;
import fr.unistra.ibmc.paradise.core.features.Cytosine3D;
import fr.unistra.ibmc.paradise.core.features.Guanine3D;
import fr.unistra.ibmc.paradise.core.features.Residue3D;
import fr.unistra.ibmc.paradise.core.features.Uridine3D;
import fr.unistra.ibmc.paradise.core.utils.Residue;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.html.HTMLEditorKit;
import org.jdesktop.swingworker.SwingWorker;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.AlternateRowHighlighter;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.noos.xing.mydoggy.DockedTypeDescriptor;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.ToolWindowType;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowManager;

public class RNAMotifsBrowser
extends JXTable {
    private JPopupMenu popupMenu;
    private MyTableModel model;
    private Mediator mediator;

    public RNAMotifsBrowser(final Mediator mediator) {
        this.mediator = mediator;
        this.model = new MyTableModel();
        this.setModel(this.model);
        this.setSelectionMode(0);
        this.setHorizontalScrollEnabled(true);
        this.setColumnControlVisible(true);
        this.setHighlighters(new Highlighter[]{AlternateRowHighlighter.quickSilver});
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    MyDoggyToolWindowManager toolWindowManager = mediator.getToolWindowManager();
                    if (toolWindowManager.getToolWindow((Object)"MotifDetails") != null) {
                        toolWindowManager.unregisterToolWindow("MotifDetails");
                    }
                    RNAMotifDetail detail = new RNAMotifDetail(RNAMotifsBrowser.this.model.getRNAMotifAt(RNAMotifsBrowser.this.convertRowIndexToModel(RNAMotifsBrowser.this.getSelectedRow())));
                    ToolWindow motif = toolWindowManager.registerToolWindow("MotifDetails", "RNA Motif Details", null, (Component)((Object)detail), toolWindowManager.getToolWindow((Object)"MotifsRepository").getAnchor());
                    DockedTypeDescriptor descriptor = (DockedTypeDescriptor)motif.getTypeDescriptor(ToolWindowType.DOCKED);
                    descriptor.setDockLength(200);
                    descriptor.setPreviewEnabled(false);
                    motif.aggregate();
                }
            }

            public void mousePressed(MouseEvent event) {
                RNAMotifsBrowser.this.maybeShowPopup(event);
            }

            public void mouseReleased(MouseEvent event) {
                RNAMotifsBrowser.this.maybeShowPopup(event);
            }

            public void mouseEntered(MouseEvent event) {
            }

            public void mouseExited(MouseEvent event) {
            }
        });
        this.popupMenu = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Delete RNA Motif");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RNAMotif motif = RNAMotifsBrowser.this.model.getRNAMotifAt(RNAMotifsBrowser.this.convertRowIndexToModel(RNAMotifsBrowser.this.getSelectedRow()));
                if (0 == JOptionPane.showConfirmDialog(null, "Are you sure to delete the selected motif?")) {
                    new File(Assemble.getMotifsPath() + motif.category + System.getProperty("file.separator") + motif.name + ".rnaml").delete();
                    new File(Assemble.getMotifsPath() + motif.category + System.getProperty("file.separator") + motif.name + ".png").delete();
                    new File(Assemble.getMotifsPath() + motif.category + System.getProperty("file.separator") + motif.name + ".txt").delete();
                    RNAMotifsBrowser.this.model.removeRow(RNAMotifsBrowser.this.convertRowIndexToModel(RNAMotifsBrowser.this.getSelectedRow()));
                }
            }
        });
        this.popupMenu.add(menuItem);
        menuItem = new JMenuItem("Delete Motifs Category");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (0 == JOptionPane.showConfirmDialog(null, "Are you sure to delete this category and all its motifs?")) {
                    RNAMotif motif = RNAMotifsBrowser.this.model.getRNAMotifAt(RNAMotifsBrowser.this.convertRowIndexToModel(RNAMotifsBrowser.this.getSelectedRow()));
                    String category = motif.category;
                    for (int i = RNAMotifsBrowser.this.model.getRowCount() - 1; i >= 0; --i) {
                        RNAMotif _motif = RNAMotifsBrowser.this.model.getRNAMotifAt(RNAMotifsBrowser.this.convertRowIndexToModel(i));
                        if (!category.equals(_motif.category)) continue;
                        new File(Assemble.getMotifsPath() + category + System.getProperty("file.separator") + _motif.name + ".rnaml").delete();
                        new File(Assemble.getMotifsPath() + category + System.getProperty("file.separator") + _motif.name + ".png").delete();
                        new File(Assemble.getMotifsPath() + category + System.getProperty("file.separator") + _motif.name + ".txt").delete();
                        RNAMotifsBrowser.this.model.removeRow(RNAMotifsBrowser.this.convertRowIndexToModel(i));
                    }
                    new File(Assemble.getMotifsPath() + motif.category).delete();
                }
            }
        });
        this.popupMenu.add(menuItem);
        this.popupMenu.addSeparator();
        menuItem = new JMenuItem("Reload Repository");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RNAMotifsBrowser.this.model.reload();
            }
        });
        this.popupMenu.add(menuItem);
        this.setOpaque(true);
        this.setVisible(true);
    }

    private void maybeShowPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public void addNewMotifEntry(File rnamlFile, String categoryName) throws IOException {
        this.model.motifs.add(new RNAMotif(rnamlFile, categoryName));
        this.model.fireTableRowsInserted(this.model.motifs.size() - 1, this.model.motifs.size() - 1);
    }

    private class RNAMotifDetail
    extends JXPanel {
        private RNAMotif motif;
        private JButton cancel;
        private JEditorPane comment;
        private JScrollPane jScrollPane1;
        private JScrollPane jScrollPane2;
        private JButton apply;
        private JXTable sequencesTable;
        private JLabel snapshot;

        public RNAMotifDetail(RNAMotif motif) {
            this.motif = motif;
            this.initComponents();
        }

        private void initComponents() {
            this.setBackground(Color.WHITE);
            this.jScrollPane1 = new JScrollPane();
            this.comment = new JEditorPane();
            this.comment.setEditorKit(new HTMLEditorKit());
            this.comment.setText("<h1><u>" + this.motif.name + "</u></h1>" + this.motif.comment);
            this.jScrollPane2 = new JScrollPane();
            this.sequencesTable = new JXTable();
            this.sequencesTable.setBackground(Color.WHITE);
            this.sequencesTable.setHighlighters(new Highlighter[]{AlternateRowHighlighter.quickSilver});
            ImageIcon capture = new ImageIcon(Assemble.getMotifsPath() + this.motif.category + System.getProperty("file.separator") + this.motif.name + ".png");
            this.snapshot = new JLabel(capture);
            this.snapshot.setPreferredSize(new Dimension(capture.getIconWidth(), capture.getIconHeight()));
            this.apply = new JButton();
            this.cancel = new JButton();
            this.comment.setBorder(null);
            this.comment.setEditable(false);
            this.jScrollPane1.setViewportView(this.comment);
            this.comment.setCaretPosition(0);
            Object[][] objects = new Object[this.motif.motifSequences.size()][6];
            for (int i = 0; i < this.motif.motifSequences.size(); ++i) {
                objects[i][0] = ((RNAMotif.RNAMotifSequence)this.motif.motifSequences.get(i)).sequence;
                objects[i][1] = ((RNAMotif.RNAMotifSequence)this.motif.motifSequences.get(i)).startPosition == -1 ? "NA" : "" + ((RNAMotif.RNAMotifSequence)this.motif.motifSequences.get(i)).startPosition;
                objects[i][2] = ((RNAMotif.RNAMotifSequence)this.motif.motifSequences.get(i)).endPosition == -1 ? "NA" : "" + ((RNAMotif.RNAMotifSequence)this.motif.motifSequences.get(i)).endPosition;
                objects[i][3] = ((RNAMotif.RNAMotifSequence)this.motif.motifSequences.get(i)).sequence.length();
                objects[i][4] = "???";
                objects[i][5] = "Link";
            }
            this.sequencesTable.setModel((TableModel)new DefaultTableModel(objects, new String[]{"Motif Sequences", "Start", "End", "Length", "Your Sequences", "Link Selection"}){
                Class[] types;
                boolean[] canEdit;
                {
                    this.types = new Class[]{String.class, String.class, String.class, String.class, String.class, String.class};
                    this.canEdit = new boolean[]{false, false, false, false, true, true};
                }

                public Class getColumnClass(int columnIndex) {
                    return this.types[columnIndex];
                }

                public boolean isCellEditable(int rowIndex, int columnIndex) {
                    return this.canEdit[columnIndex];
                }
            });
            this.sequencesTable.getTableHeader().setReorderingAllowed(false);
            this.sequencesTable.getColumn((Object)"Link Selection").setCellRenderer(new ButtonRenderer());
            this.sequencesTable.getColumn((Object)"Link Selection").setCellEditor(new ButtonEditor(new JCheckBox()));
            this.sequencesTable.getColumn((Object)"Link Selection").setMaxWidth(150);
            this.jScrollPane2.setViewportView((Component)this.sequencesTable);
            this.snapshot.setBackground(Color.WHITE);
            this.snapshot.setVerticalAlignment(1);
            this.snapshot.setBorder(BorderFactory.createEtchedBorder());
            this.apply.setText("Apply");
            this.apply.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    try {
                        RNAMotifDetail.this.applyActionPerformed(evt);
                    }
                    catch (BiologicalSymbolException e) {
                        e.printStackTrace();
                    }
                }
            });
            this.cancel.setText("Cancel");
            this.cancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    RNAMotifsBrowser.this.mediator.getToolWindowManager().unregisterToolWindow("MotifDetails");
                }
            });
            this.setLayout(new BorderLayout());
            this.add(this.snapshot, "West");
            JPanel subPanel = new JPanel();
            subPanel.setLayout(new BorderLayout());
            subPanel.add((Component)this.jScrollPane1, "North");
            subPanel.add((Component)this.jScrollPane2, "Center");
            subPanel.setBackground(Color.WHITE);
            JScrollPane captureScrollPane = new JScrollPane(this.snapshot);
            captureScrollPane.getViewport().setBackground(Color.WHITE);
            JSplitPane splitPane = new JSplitPane(1, captureScrollPane, subPanel);
            splitPane.setDividerSize(4);
            splitPane.setDividerLocation(capture.getIconWidth() + 10);
            splitPane.setBackground(Color.WHITE);
            JPanel buttonsPanel = new JPanel();
            buttonsPanel.add(this.cancel);
            buttonsPanel.add(this.apply);
            buttonsPanel.setBackground(Color.WHITE);
            this.add(splitPane, "Center");
            this.add(buttonsPanel, "South");
        }

        private void applyActionPerformed(ActionEvent evt) throws BiologicalSymbolException {
            int i;
            int i2;
            for (List residues : this.motif.userChains) {
                if (residues != null) continue;
                JOptionPane.showMessageDialog((Component)((Object)this), "You have to link all the sequences of the motif!!");
                return;
            }
            for (Element interactionEl : this.motif.interactions) {
                String molecule1ID = interactionEl.getAttributeValue("molecule1-id");
                String base5ID = interactionEl.getAttributeValue("base1-id");
                String molecule2ID = interactionEl.getAttributeValue("molecule2-id");
                String base3ID = interactionEl.getAttributeValue("base2-id");
                String edge1 = interactionEl.getAttributeValue("edge1");
                String edge2 = interactionEl.getAttributeValue("edge2");
                String orientation = interactionEl.getAttributeValue("orientation");
                Residue base1 = null;
                Residue base2 = null;
                for (int i3 = 0; i3 < this.motif.motifSequences.size(); ++i3) {
                    if (((RNAMotif.RNAMotifSequence)this.motif.motifSequences.get(i3)).sequenceID.equals(molecule1ID)) {
                        base1 = (Residue)((fr.unistra.ibmc.assemble.structures.Residue)((List)this.motif.userChains.get(i3)).get(Integer.parseInt(base5ID) - 1)).getResidue3D().getResidues().iterator().next();
                    }
                    if (!((RNAMotif.RNAMotifSequence)this.motif.motifSequences.get(i3)).sequenceID.equals(molecule2ID)) continue;
                    base2 = (Residue)((fr.unistra.ibmc.assemble.structures.Residue)((List)this.motif.userChains.get(i3)).get(Integer.parseInt(base3ID) - 1)).getResidue3D().getResidues().iterator().next();
                }
                if (base1 == null || base2 == null) continue;
                Residue2D base12D = RNAMotifsBrowser.this.mediator.getRna2DViewer().getSecondaryCanvas().seekResidue2D(base1);
                Residue2D base22D = RNAMotifsBrowser.this.mediator.getRna2DViewer().getSecondaryCanvas().seekResidue2D(base2);
                try {
                    boolean found = false;
                    for (BaseBaseInteraction2D interaction : RNAMotifsBrowser.this.mediator.getRna2DViewer().getSecondaryCanvas().getModel2D().getBaseBaseInteractions()) {
                        if (interaction.getResidue().equals(base12D) && interaction.getPartnerResidue().equals(base22D)) {
                            RNAMotifsBrowser.this.mediator.getRna2DViewer().getSecondaryCanvas().getModel2D().modifyInteractionType(interaction, base12D, edge1.charAt(0), base22D, edge2.charAt(0), orientation.charAt(0), -1);
                            found = true;
                            break;
                        }
                        if (!interaction.getResidue().equals(base22D) || !interaction.getPartnerResidue().equals(base12D)) continue;
                        RNAMotifsBrowser.this.mediator.getRna2DViewer().getSecondaryCanvas().getModel2D().modifyInteractionType(interaction, base22D, edge2.charAt(0), base12D, edge1.charAt(0), orientation.charAt(0), -1);
                        found = true;
                        break;
                    }
                    if (found) continue;
                    RNAMotifsBrowser.this.mediator.getRna2DViewer().getSecondaryCanvas().getModel2D().createTertiaryInteraction(base12D, edge1.charAt(0), base22D, edge2.charAt(0), orientation.charAt(0), 1);
                }
                catch (BiologicalSymbolException e) {
                    JOptionPane.showMessageDialog((Component)((Object)this), e.getMessage());
                    return;
                }
            }
            RNAMotifsBrowser.this.mediator.getRna2DViewer().getSecondaryCanvas().repaint();
            float[] center = new float[]{0.0f, 0.0f, 0.0f};
            int atomNb = 0;
            for (i2 = 0; i2 < this.motif.motifSequences.size(); ++i2) {
                for (fr.unistra.ibmc.assemble.structures.Residue r : (List)this.motif.userChains.get(i2)) {
                    for (Atom a : r.getAtoms()) {
                        ++atomNb;
                        float[] atc = a.getFloat();
                        for (int j = 0; j < 3; ++j) {
                            int n = j;
                            center[n] = center[n] + atc[j];
                        }
                    }
                }
            }
            if (atomNb > 0) {
                for (i2 = 0; i2 < 3; ++i2) {
                    center[i2] = center[i2] / (float)atomNb;
                }
            }
            for (i2 = 0; i2 < this.motif.motifSequences.size(); ++i2) {
                List residues3D = ((RNAMotif.RNAMotifSequence)this.motif.motifSequences.get(i2)).residues3D;
                for (int j = 0; j < residues3D.size(); ++j) {
                    Residue3D residue3D = (Residue3D)residues3D.get(j);
                    Residue3D newResidue3D = residue3D.createNewResidue3D(((fr.unistra.ibmc.assemble.structures.Residue)((List)this.motif.userChains.get(i2)).get(j)).getName().charAt(0));
                    fr.unistra.ibmc.assemble.structures.Residue assembleResidue = (fr.unistra.ibmc.assemble.structures.Residue)((List)this.motif.userChains.get(i2)).get(j);
                    for (Residue3D.Atom a : newResidue3D.getAtoms()) {
                        Atom _a;
                        if (!a.hasCoordinatesFilled() || (_a = assembleResidue.getAtom(a.getName())) == null) continue;
                        _a.setCoord(a.getX(), a.getY(), a.getZ());
                    }
                }
            }
            float[] newCenter = new float[]{0.0f, 0.0f, 0.0f};
            for (i = 0; i < this.motif.motifSequences.size(); ++i) {
                for (fr.unistra.ibmc.assemble.structures.Residue r : (List)this.motif.userChains.get(i)) {
                    for (Atom a : r.getAtoms()) {
                        float[] atc = a.getFloat();
                        for (int j = 0; j < 3; ++j) {
                            int n = j;
                            newCenter[n] = newCenter[n] + atc[j];
                        }
                    }
                }
            }
            if (atomNb > 0) {
                for (i = 0; i < 3; ++i) {
                    newCenter[i] = newCenter[i] / (float)atomNb;
                }
            }
            UserSelection selection = new UserSelection(RNAMotifsBrowser.this.mediator, this.motif.name);
            for (int i4 = 0; i4 < this.motif.motifSequences.size(); ++i4) {
                for (fr.unistra.ibmc.assemble.structures.Residue assembleResidue : (List)this.motif.userChains.get(i4)) {
                    assembleResidue.translate(center[0] - newCenter[0], center[1] - newCenter[1], center[2] - newCenter[2]);
                    for (Atom a : assembleResidue.getAtoms()) {
                        selection.add(a);
                    }
                }
            }
            RNAMotifsBrowser.this.mediator.get3DModel().fireModelModified();
            RNAMotifsBrowser.this.mediator.getSecondaryStructureNavigator().addUserSelection(selection);
            RNAMotifsBrowser.this.mediator.getGlobalSelection().clear();
            RNAMotifsBrowser.this.mediator.getGlobalSelection().add(selection);
        }

        private void cancelActionPerformed(ActionEvent evt) {
        }

        public class ButtonEditor
        extends DefaultCellEditor {
            protected JButton button;
            private String label;
            private boolean isPushed;
            private int selectedRow;

            public ButtonEditor(JCheckBox checkBox) {
                super(checkBox);
                this.button = new JButton();
                this.button.setOpaque(true);
                this.button.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ButtonEditor.this.fireEditingStopped();
                    }
                });
            }

            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                if (isSelected) {
                    this.button.setForeground(table.getSelectionForeground());
                    this.button.setBackground(table.getSelectionBackground());
                } else {
                    this.button.setForeground(table.getForeground());
                    this.button.setBackground(table.getBackground());
                }
                this.label = value == null ? "" : value.toString();
                this.button.setText(this.label);
                this.isPushed = true;
                this.selectedRow = row;
                return this.button;
            }

            public Object getCellEditorValue() {
                if (this.isPushed && RNAMotifsBrowser.this.mediator.getGlobalSelection().getSelectedResidues().isEmpty()) {
                    JOptionPane.showMessageDialog((Component)((Object)RNAMotifDetail.this), "No residues selected in the 3D scene!!");
                } else if (this.isPushed && RNAMotifsBrowser.this.mediator.getGlobalSelection().getSelectedResidues().size() != 0) {
                    if (((String)RNAMotifDetail.this.sequencesTable.getValueAt(this.selectedRow, 0)).length() != RNAMotifsBrowser.this.mediator.getGlobalSelection().getSelectedResidues().size()) {
                        JOptionPane.showMessageDialog((Component)((Object)RNAMotifDetail.this), "Your selection should have the same size than the sequence in the motif!!");
                    } else {
                        StringBuffer buff = new StringBuffer();
                        List<fr.unistra.ibmc.assemble.structures.Residue> sortedResidues = RNAMotifsBrowser.this.mediator.getGlobalSelection().getSelectedResidues();
                        Collections.sort(sortedResidues, new Comparator<fr.unistra.ibmc.assemble.structures.Residue>(){

                            @Override
                            public int compare(fr.unistra.ibmc.assemble.structures.Residue residue, fr.unistra.ibmc.assemble.structures.Residue residue1) {
                                return ((Residue)residue.getResidue3D().getResidues().iterator().next()).getAbsolutePosition() - ((Residue)residue1.getResidue3D().getResidues().iterator().next()).getAbsolutePosition();
                            }
                        });
                        for (fr.unistra.ibmc.assemble.structures.Residue r : sortedResidues) {
                            buff.append(r.getName().charAt(0));
                        }
                        RNAMotifDetail.this.sequencesTable.setValueAt((Object)buff.toString(), this.selectedRow, 4);
                        RNAMotifDetail.this.motif.userChains.set(this.selectedRow, new ArrayList<fr.unistra.ibmc.assemble.structures.Residue>(sortedResidues));
                    }
                }
                this.isPushed = false;
                return new String(this.label);
            }

            public boolean stopCellEditing() {
                this.isPushed = false;
                return super.stopCellEditing();
            }

            protected void fireEditingStopped() {
                super.fireEditingStopped();
            }
        }

        public class ButtonRenderer
        extends JButton
        implements TableCellRenderer {
            public ButtonRenderer() {
                this.setOpaque(true);
            }

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (isSelected) {
                    this.setForeground(table.getSelectionForeground());
                    this.setBackground(table.getSelectionBackground());
                } else {
                    this.setForeground(table.getForeground());
                    this.setBackground(UIManager.getColor("Button.background"));
                }
                this.setText(value == null ? "" : value.toString());
                return this;
            }
        }
    }

    private class RNAMotif {
        private String name;
        private String category;
        private String comment;
        private Date date;
        private List<RNAMotifSequence> motifSequences;
        private List<Element> interactions;
        private List<Element> helices;
        private List<List<fr.unistra.ibmc.assemble.structures.Residue>> userChains;

        private RNAMotif(File rnamlFile, String category) throws IOException {
            int i;
            Document doc = null;
            try {
                doc = new SAXBuilder().build(rnamlFile);
            }
            catch (JDOMException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            List molecules = doc.getRootElement().getChildren("molecule");
            List bases = doc.getRootElement().getChild("tertiary-structure").getChildren("base");
            this.motifSequences = new ArrayList<RNAMotifSequence>(molecules.size());
            this.userChains = new ArrayList<List<fr.unistra.ibmc.assemble.structures.Residue>>();
            this.interactions = doc.getRootElement().getChild("structure-annotation").getChildren("base-pair");
            this.helices = doc.getRootElement().getChild("structure-annotation").getChildren("helix");
            for (i = 0; i < molecules.size(); ++i) {
                this.userChains.add(null);
            }
            for (i = 0; i < molecules.size(); ++i) {
                Element molecule = (Element)molecules.get(i);
                char[] moleculeSequence = molecule.getChild("sequence").getChild("seq-data").getText().toCharArray();
                String moleculeId = molecule.getAttributeValue("id");
                ArrayList<Adenine3D> residues3D = new ArrayList<Adenine3D>();
                for (Object o : bases) {
                    Element base = (Element)o;
                    if (!moleculeId.equals(base.getAttributeValue("molecule-id"))) continue;
                    char symbol = moleculeSequence[Integer.parseInt(base.getAttributeValue("id")) - 1];
                    Adenine3D residue3D = null;
                    switch (symbol) {
                        case 'A': {
                            residue3D = new Adenine3D(null);
                            break;
                        }
                        case 'U': {
                            residue3D = new Uridine3D(null);
                            break;
                        }
                        case 'G': {
                            residue3D = new Guanine3D(null);
                            break;
                        }
                        case 'C': {
                            residue3D = new Cytosine3D(null);
                            break;
                        }
                    }
                    if (residue3D == null) continue;
                    for (Object _o : base.getChildren("atom")) {
                        residue3D.setAtomCoordinates(((Element)_o).getAttributeValue("type"), Float.parseFloat(((Element)_o).getAttributeValue("x")), Float.parseFloat(((Element)_o).getAttributeValue("y")), Float.parseFloat(((Element)_o).getAttributeValue("z")));
                    }
                    residues3D.add(residue3D);
                }
                Attribute start = molecule.getAttribute("start");
                Attribute end = molecule.getAttribute("end");
                if (start == null && end == null) {
                    this.motifSequences.add(new RNAMotifSequence(molecule.getAttributeValue("id"), molecule.getChild("sequence").getChild("seq-data").getText(), residues3D));
                    continue;
                }
                this.motifSequences.add(new RNAMotifSequence(molecule.getAttributeValue("id"), molecule.getChild("sequence").getChild("seq-data").getText(), residues3D, Integer.parseInt(start.getValue()), Integer.parseInt(end.getValue())));
            }
            this.name = rnamlFile.getName().split("\\.")[0];
            this.category = category;
            String line = null;
            BufferedReader buff = new BufferedReader(new FileReader(new File(rnamlFile.getParentFile(), this.name + ".txt")));
            StringBuilder _comment = new StringBuilder();
            line = null;
            while ((line = buff.readLine()) != null) {
                _comment.append(line);
                _comment.append("<br>");
            }
            buff.close();
            this.comment = _comment.toString();
            this.date = new Date(rnamlFile.lastModified());
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class RNAMotifSequence {
            private String sequenceID;
            private String sequence;
            private int startPosition;
            private int endPosition;
            private List<Residue3D> residues3D;

            private RNAMotifSequence(String sequenceID, String sequence, List<Residue3D> residues3D) {
                this(sequenceID, sequence, residues3D, -1, -1);
            }

            private RNAMotifSequence(String sequenceID, String sequence, List<Residue3D> residues3D, int startPosition, int endPosition) {
                this.sequenceID = sequenceID;
                this.sequence = sequence;
                this.residues3D = residues3D;
                this.startPosition = startPosition;
                this.endPosition = endPosition;
            }
        }
    }

    private class MyTableModel
    extends AbstractTableModel {
        private List<RNAMotif> motifs;
        private String[] columnNames = new String[]{"Motif Name", "Category", "Date"};

        private MyTableModel() {
            this.reload();
        }

        public void reload() {
            this.motifs = new ArrayList<RNAMotif>();
            new SwingWorker(){

                protected Object doInBackground() throws Exception {
                    File[] categories;
                    for (File category : categories = new File(Assemble.getMotifsPath()).listFiles(new FileFilter(){

                        public boolean accept(File file) {
                            return file.isDirectory() && !file.getName().equals(".svn");
                        }
                    })) {
                        File[] rnamlFiles;
                        for (File rnamlFile : rnamlFiles = category.listFiles(new FileFilter(){

                            public boolean accept(File file) {
                                return file.getName().endsWith(".rnaml");
                            }
                        })) {
                            MyTableModel.this.motifs.add(new RNAMotif(rnamlFile, category.getName()));
                        }
                    }
                    MyTableModel.this.fireTableDataChanged();
                    return null;
                }
            }.execute();
        }

        public Object getValueAt(int row, int col) {
            if (row < this.motifs.size()) {
                RNAMotif m = this.motifs.get(row);
                switch (col) {
                    case 0: {
                        return m.name;
                    }
                    case 1: {
                        return m.category;
                    }
                    case 2: {
                        return new SimpleDateFormat("yyyy.MM.dd HH:mm").format(m.date);
                    }
                }
                return null;
            }
            return null;
        }

        public RNAMotif getRNAMotifAt(int row) {
            return this.motifs.get(row);
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public int getRowCount() {
            return this.motifs.size();
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public void removeRow(int row) {
            this.motifs.remove(row);
            this.fireTableRowsDeleted(row, row);
        }
    }
}

