/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.gui;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.behaviours.TertiaryStructureRefinementAnswerBehaviour;
import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.analysis.Parameter;
import fr.unistra.ibmc.paradise.core.analysis.Parameters;
import fr.unistra.ibmc.paradise.tools.AbstractParadiseToolAgent;
import fr.unistra.ibmc.paradise.utils.GeneralUtils;
import jade.gui.GuiEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RnartDialog
extends JFrame {
    private JTextField thres;
    private JComboBox mod;

    public RnartDialog(final Mediator mediator, final Collection<Molecule> molecules) {
        this.setTitle("3D Model refinement");
        this.setResizable(false);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.add(mainPanel);
        this.mod = new JComboBox<Object>(new Object[]{"Number of passes (ex : 10)", "Average RMSD treshold (ex : 0.2)", "Similarity between 2 successive RMSD (in %, ex : 95)"});
        this.thres = new JTextField();
        this.thres.setPreferredSize(new Dimension(50, 0));
        JPanel buttonsPanel = new JPanel();
        JButton button = new JButton("Cancel");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RnartDialog.this.dispose();
            }
        });
        buttonsPanel.add(button);
        button = new JButton("Refine");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    Parameters parameters = new Parameters();
                    String mode = "";
                    switch (RnartDialog.this.mod.getSelectedIndex()) {
                        case 0: {
                            mode = "n";
                            Integer.parseInt(RnartDialog.this.thres.getText());
                            break;
                        }
                        case 1: {
                            mode = "v";
                            Float.parseFloat(RnartDialog.this.thres.getText());
                            break;
                        }
                        case 2: {
                            mode = "p";
                            Integer.parseInt(RnartDialog.this.thres.getText());
                        }
                    }
                    parameters.addParameter(new Parameter("mode", mode));
                    parameters.addParameter(new Parameter("threshold", RnartDialog.this.thres.getText()));
                    GuiEvent ev = new GuiEvent((Object)this, 6);
                    ev.addParameter((Object)new TertiaryStructureRefinementAnswerBehaviour(new ArrayList<Molecule>(molecules), parameters));
                    ((AbstractParadiseToolAgent)mediator.getAssemble().getAgent()).postGuiEvent(ev);
                    RnartDialog.this.dispose();
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog(null, "The value you entered is not a number");
                }
            }
        });
        buttonsPanel.add(button);
        mainPanel.add((Component)buttonsPanel, "South");
        JLabel warning = new JLabel("Warning ! This operation can take a LONG time !");
        warning.setForeground(Color.RED);
        mainPanel.add((Component)warning, "Center");
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BorderLayout());
        centerPanel.add((Component)new JLabel("Choose the stop condition of the Rnart algorithm"), "North");
        JPanel parametersPanel = new JPanel();
        parametersPanel.setBorder(new EmptyBorder(5, 0, 5, 0));
        parametersPanel.setLayout(new BoxLayout(parametersPanel, 0));
        parametersPanel.add(this.mod);
        parametersPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        parametersPanel.add(this.thres);
        centerPanel.add((Component)parametersPanel, "Center");
        mainPanel.add((Component)centerPanel, "North");
        this.pack();
        GeneralUtils.centerOnScreen((Window)this);
        this.setVisible(true);
    }
}

