/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.gui;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.structures.Atom;
import fr.unistra.ibmc.assemble.structures.AtomsSelection;
import fr.unistra.ibmc.assemble.structures.Residue;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserSelection
extends AtomsSelection {
    private String name;
    private Set<Residue> selectedResidues;

    public UserSelection(Mediator mediator, String name) {
        super(mediator);
        this.name = name;
        this.selectedResidues = new HashSet<Residue>();
    }

    public Set<Residue> getSelectedResidues() {
        return this.selectedResidues;
    }

    @Override
    public void add(Residue r) {
        for (Atom atom : r.getAtoms()) {
            this.add(atom);
        }
        this.selectedResidues.add(r);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public void setRenderingMode(int mode) {
        for (Atom a : this.selectedAtoms) {
            a.setRenderingMode(mode);
        }
        this.fireRenderingModified();
    }

    public void setBackBoneDisplayed(boolean b) {
        for (Residue r : this.selectedResidues) {
            r.setBackBoneDisplayed(b);
        }
        this.fireRenderingModified();
    }

    public void setPlaneDisplayed(boolean b) {
        for (Residue r : this.selectedResidues) {
            r.setPlaneDisplayed(b);
        }
        this.fireRenderingModified();
    }
}

