/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.gui.labels;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.gui.labels.AbstractLabel;
import fr.unistra.ibmc.assemble.gui.rendering.OpenGLColor;
import fr.unistra.ibmc.assemble.structures.Atom;
import fr.unistra.ibmc.paradise.utils.TBMath;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.media.opengl.GL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AngleLabel
extends AbstractLabel {
    public Atom firstAtom = null;
    public Atom secondAtom = null;
    public Atom thirdAtom = null;

    public AngleLabel(Mediator mediator, Atom a, Atom b, Atom c) {
        super(mediator);
        this.color = new OpenGLColor(Color.blue);
        this.firstAtom = a;
        this.secondAtom = b;
        this.thirdAtom = c;
        a.addAtomListener(this);
        b.addAtomListener(this);
        c.addAtomListener(this);
        this.compute();
    }

    @Override
    public List<Atom> getAtoms() {
        return new ArrayList<Atom>(Arrays.asList(this.firstAtom, this.secondAtom, this.thirdAtom));
    }

    @Override
    void compute() {
        for (int i = 0; i < 3; ++i) {
            this.position[i] = (this.firstAtom.getFloat()[i] + this.secondAtom.getFloat()[i] + this.thirdAtom.getFloat()[i]) / 3.0f;
        }
        double tmp = (double)TBMath.angle((float[])TBMath.vector((float[])this.secondAtom.getFloat(), (float[])this.firstAtom.getFloat()), (float[])TBMath.vector((float[])this.secondAtom.getFloat(), (float[])this.thirdAtom.getFloat())) * TBMath.RadianToDegree;
        this.value = "" + tmp;
        this.value = this.value.substring(0, this.value.lastIndexOf(".") + 4);
        this.value = this.value + "\u00b0";
    }

    @Override
    public void draw(GL gl) {
        super.draw(gl);
        gl.glLineStipple(1, (short)-11086);
        gl.glBegin(1);
        gl.glVertex3fv(this.firstAtom.getFloat(), 0);
        gl.glVertex3fv(this.secondAtom.getFloat(), 0);
        gl.glVertex3fv(this.secondAtom.getFloat(), 0);
        gl.glVertex3fv(this.thirdAtom.getFloat(), 0);
        gl.glEnd();
    }
}

