/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.gui.rendering;

import java.awt.event.KeyEvent;
import java.util.Locale;
import java.util.prefs.Preferences;
import javax.swing.KeyStroke;

public class KeyboardAction {
    public static final String NO_KEY_STRING = "No Key Assigned to this Action";
    public static final int KEY_SELECTION_ROTATION_X1 = 1;
    public static final int KEY_SELECTION_ROTATION_X2 = 2;
    public static final int KEY_SELECTION_ROTATION_Y1 = 3;
    public static final int KEY_SELECTION_ROTATION_Y2 = 4;
    public static final int KEY_SELECTION_ROTATION_Z1 = 5;
    public static final int KEY_SELECTION_ROTATION_Z2 = 6;
    public static final int KEY_SCENE_ROTATION_X1 = 7;
    public static final int KEY_SCENE_ROTATION_X2 = 8;
    public static final int KEY_SCENE_ROTATION_Y1 = 9;
    public static final int KEY_SCENE_ROTATION_Y2 = 10;
    public static final int KEY_SELECTION_TRANSLATION_X1 = 11;
    public static final int KEY_SELECTION_TRANSLATION_X2 = 12;
    public static final int KEY_SELECTION_TRANSLATION_Y1 = 13;
    public static final int KEY_SELECTION_TRANSLATION_Y2 = 14;
    public static final int KEY_DIRECT_ANGLE_1 = 15;
    public static final int KEY_DIRECT_ANGLE_2 = 16;
    public static final int KEY_DIRECT_ANGLE_3 = 17;
    public static final int KEY_DIRECT_ANGLE_4 = 18;
    public static final int KEY_DIRECT_ANGLE_5 = 19;
    public static final int KEY_INTERNAL_ANGLE_1 = 20;
    public static final int KEY_INTERNAL_ANGLE_2 = 21;
    public static final int KEY_INTERNAL_ANGLE_3 = 22;
    public static final int KEY_INTERNAL_ANGLE_4 = 23;
    public static final int KEY_INTERNAL_ANGLE_5 = 24;
    public static final int KEY_INTERNAL_ANGLE_6 = 25;
    public static final int KEY_INTERNAL_ANGLE_7 = 26;
    public static final int KEY_INTERNAL_ANGLE_8 = 27;
    public static final int KEY_INDIRECT_ANGLE_1 = 28;
    public static final int KEY_INDIRECT_ANGLE_2 = 29;
    public static final int KEY_INDIRECT_ANGLE_3 = 30;
    public static final int KEY_INDIRECT_ANGLE_4 = 31;
    public static final int KEY_INDIRECT_ANGLE_5 = 32;
    public static final int KEY_INCREASE_TRANLASTION_STEP = 33;
    public static final int KEY_DECREASE_TRANLASTION_STEP = 34;
    public static final int KEY_INCREASE_ROTATION_STEP = 35;
    public static final int KEY_DECREASE_ROTATION_STEP = 36;
    public static final int KEY_TORSION_NEXT_RESIDUE = 37;
    public static final int KEY_TORSION_PREVIOUS_RESIDUE = 38;
    public static final int KEY_TORSION_FIRST_RESIDUE = 39;
    public static final int KEY_TORSION_LAST_RESIDUE = 40;
    public static final int KEY_MAP_MOTION = 41;
    public static final int LAST_OPERATION = 41;
    public static final int KEY_UNKNOWN_ACTION = -1;

    public static int getActionForEvent(KeyEvent e) {
        String s = KeyStroke.getKeyStrokeForEvent(e).toString();
        for (int i = 1; i <= 41; ++i) {
            String key = KeyboardAction.getKey(i);
            if (!s.equals(key)) continue;
            return i;
        }
        return -1;
    }

    public static void setKey(String name, String value) {
        for (int i = 1; i <= 41; ++i) {
            String key = KeyboardAction.getKey(i);
            if (!value.equals(key) || name.equals(KeyboardAction.getName(i))) continue;
            KeyboardAction.setKey(KeyboardAction.getName(i), NO_KEY_STRING);
        }
        Preferences prefs = Preferences.userRoot().node("Assemble");
        prefs.put(name, value);
    }

    public static String getKey(int code) {
        Preferences prefs = Preferences.userRoot().node("Assemble");
        return prefs.get(KeyboardAction.getName(code), NO_KEY_STRING);
    }

    public static void setDefault() {
        for (int i = 1; i <= 41; ++i) {
            KeyboardAction.setKey(KeyboardAction.getName(i), KeyboardAction.getDefault(i));
        }
    }

    public static String getDefault(int code) {
        if (Locale.getDefault().toString().toLowerCase().indexOf("fr") != -1) {
            switch (code) {
                case 1: {
                    return "pressed A";
                }
                case 2: {
                    return "pressed W";
                }
                case 3: {
                    return "pressed Q";
                }
                case 5: {
                    return "pressed Z";
                }
                case 27: {
                    return "pressed M";
                }
                case 32: {
                    return "pressed COMMA";
                }
            }
        }
        switch (code) {
            case 7: {
                return "pressed UP";
            }
            case 8: {
                return "pressed DOWN";
            }
            case 9: {
                return "pressed LEFT";
            }
            case 10: {
                return "pressed RIGHT";
            }
            case 11: {
                return "pressed NUMPAD4";
            }
            case 12: {
                return "pressed NUMPAD6";
            }
            case 13: {
                return "pressed NUMPAD2";
            }
            case 14: {
                return "pressed NUMPAD8";
            }
            case 33: {
                return "pressed PAGE_UP";
            }
            case 34: {
                return "pressed PAGE_DOWN";
            }
            case 35: {
                return "pressed ADD";
            }
            case 36: {
                return "pressed SUBTRACT";
            }
            case 37: {
                return "pressed DELETE";
            }
            case 38: {
                return "pressed INSERT";
            }
            case 39: {
                return "pressed HOME";
            }
            case 40: {
                return "pressed END";
            }
            case 1: {
                return "pressed Q";
            }
            case 2: {
                return "pressed Z";
            }
            case 3: {
                return "pressed A";
            }
            case 4: {
                return "pressed S";
            }
            case 5: {
                return "pressed W";
            }
            case 6: {
                return "pressed X";
            }
            case 15: {
                return "pressed E";
            }
            case 16: {
                return "pressed R";
            }
            case 17: {
                return "pressed T";
            }
            case 18: {
                return "pressed Y";
            }
            case 19: {
                return "pressed U";
            }
            case 20: {
                return "pressed D";
            }
            case 21: {
                return "pressed F";
            }
            case 22: {
                return "pressed G";
            }
            case 23: {
                return "pressed H";
            }
            case 24: {
                return "pressed J";
            }
            case 25: {
                return "pressed K";
            }
            case 26: {
                return "pressed L";
            }
            case 27: {
                return "pressed SEMICOLON";
            }
            case 28: {
                return "pressed C";
            }
            case 29: {
                return "pressed V";
            }
            case 30: {
                return "pressed B";
            }
            case 31: {
                return "pressed N";
            }
            case 32: {
                return "pressed M";
            }
            case 41: {
                return "pressed SPACE";
            }
        }
        return NO_KEY_STRING;
    }

    public static String getName(int code) {
        switch (code) {
            case 1: {
                return "Rotate the Selection around the X axis clockwise";
            }
            case 2: {
                return "Rotate the Selection around the X axis counterclockwise";
            }
            case 3: {
                return "Rotate the Selection around the Y axis clockwise";
            }
            case 4: {
                return "Rotate the Selection around the Y axis counterclockwise";
            }
            case 5: {
                return "Rotate the Selection around the Z axis clockwise";
            }
            case 6: {
                return "Rotate the Selection around the Z axis counterclockwise";
            }
            case 7: {
                return "Rotate the Scene around the X axis clockwise";
            }
            case 8: {
                return "Rotate the Scene around the X axis counterclockwise";
            }
            case 9: {
                return "Rotate the Scene around the Y axis clockwise";
            }
            case 10: {
                return "Rotate the Scene around the Y axis counterclockwise";
            }
            case 11: {
                return "Translate the Selection left";
            }
            case 12: {
                return "Translate the Selection right";
            }
            case 13: {
                return "Translate the Selection down";
            }
            case 14: {
                return "Translate the Selection up";
            }
            case 15: {
                return "Twist the Direct Angle #1";
            }
            case 16: {
                return "Twist the Direct Angle #2";
            }
            case 17: {
                return "Twist the Direct Angle #3";
            }
            case 18: {
                return "Twist the Direct Angle #4";
            }
            case 19: {
                return "Twist the Direct Angle #5";
            }
            case 20: {
                return "Twist the Internal Angle #1";
            }
            case 21: {
                return "Twist the Internal Angle #2";
            }
            case 22: {
                return "Twist the Internal Angle #3";
            }
            case 23: {
                return "Twist the Internal Angle #4";
            }
            case 24: {
                return "Twist the Internal Angle #5";
            }
            case 25: {
                return "Twist the Internal Angle #6";
            }
            case 26: {
                return "Twist the Internal Angle #7";
            }
            case 27: {
                return "Twist the Internal Angle #8";
            }
            case 28: {
                return "Twist the Indirect Angle #1";
            }
            case 29: {
                return "Twist the Indirect Angle #2";
            }
            case 30: {
                return "Twist the Indirect Angle #3";
            }
            case 31: {
                return "Twist the Indirect Angle #4";
            }
            case 32: {
                return "Twist the Indirect Angle #5";
            }
            case 33: {
                return "Increase the Translation Step";
            }
            case 34: {
                return "Decrease the Translation Step";
            }
            case 35: {
                return "Increase the Rotation Step";
            }
            case 36: {
                return "Decrease the Rotation Step";
            }
            case 37: {
                return "Twist the Next Residue";
            }
            case 38: {
                return "Twist the Previous Residue";
            }
            case 39: {
                return "Twist the First Residue";
            }
            case 40: {
                return "Twist the Last Residue";
            }
            case 41: {
                return "Map Motion";
            }
        }
        return "";
    }
}

