/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.ssviewer.features;

import fr.unistra.ibmc.assemble.ssviewer.features.BaseBaseInteraction2D;
import fr.unistra.ibmc.assemble.ssviewer.features.Helix2D;
import fr.unistra.ibmc.assemble.ssviewer.features.Interaction2D;
import fr.unistra.ibmc.assemble.ssviewer.features.Residue2D;
import fr.unistra.ibmc.assemble.ssviewer.features.Residues2DRepository;
import fr.unistra.ibmc.assemble.ssviewer.features.Rna2D;
import fr.unistra.ibmc.assemble.ssviewer.features.Rna2DElement;
import fr.unistra.ibmc.assemble.ssviewer.features.Sstrand2D;
import fr.unistra.ibmc.assemble.ssviewer.graphics.GraphicContext;
import fr.unistra.ibmc.assemble.ssviewer.graphics.Mediator;
import fr.unistra.ibmc.paradise.ArchitectureException;
import fr.unistra.ibmc.paradise.BiologicalSymbolException;
import fr.unistra.ibmc.paradise.core.Location;
import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.ParadiseFeature;
import fr.unistra.ibmc.paradise.core.ParadiseID;
import fr.unistra.ibmc.paradise.core.RNA;
import fr.unistra.ibmc.paradise.core.features.BaseBaseInteraction;
import fr.unistra.ibmc.paradise.core.features.Helix;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructureDisplay;
import fr.unistra.ibmc.paradise.core.features.SingleStrand;
import fr.unistra.ibmc.paradise.core.utils.Residue;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Model2D
extends Rna2DElement {
    private List<Rna2D> rnas;
    private List<BaseBaseInteraction2D> interMolecularTertiaryInteractions;
    private List<Helix2D> interMolecularHelices;
    private SecondaryStructure secondaryStructure;

    public Model2D(SecondaryStructure secondaryStructure, SecondaryStructureDisplay display, Mediator mediator, GraphicContext gc) {
        super(new Residues2DRepository(display, mediator, gc), mediator, gc);
        this.secondaryStructure = secondaryStructure;
        Collection molecules = display.getMolecules();
        this.rnas = new ArrayList<Rna2D>(molecules.size());
        this.interMolecularTertiaryInteractions = new ArrayList<BaseBaseInteraction2D>();
        this.interMolecularHelices = new ArrayList<Helix2D>();
        for (Molecule m : secondaryStructure.getMolecules()) {
            Rna2D rna2D = new Rna2D((RNA)m, secondaryStructure, this.repository, mediator, gc);
            this.rnas.add(rna2D);
        }
        for (BaseBaseInteraction inter : secondaryStructure.getTertiaryInteractions()) {
            if (inter.isSecondaryInteraction() || inter.getMolecules().size() <= 1) continue;
            this.interMolecularTertiaryInteractions.add(BaseBaseInteraction2D.getInteraction(inter, this.repository, mediator, gc));
        }
        for (Helix h : secondaryStructure.getHelices()) {
            if (h.getMolecules().size() != 2) continue;
            this.interMolecularHelices.add(new Helix2D(h, this.repository, mediator, gc));
        }
    }

    public void extendWithModel2D(Model2D m) throws BiologicalSymbolException {
        for (Helix2D h2D : m.getInterMolecularHelices()) {
            this.interMolecularHelices.add(h2D);
            this.gc.intializeHelixCurrentContext(h2D);
        }
        for (Rna2D r : m.getRnas()) {
            for (Helix2D h2D : r.getHelices()) {
                this.gc.intializeHelixCurrentContext(h2D);
            }
            this.rnas.add(r);
        }
    }

    public SecondaryStructure getSecondaryStructure() {
        return this.secondaryStructure;
    }

    @Override
    public List<Residue2D> getResidues() {
        ArrayList<Residue2D> residues = new ArrayList<Residue2D>();
        for (Rna2D r : this.rnas) {
            residues.addAll(r.getResidues());
        }
        return residues;
    }

    @Override
    public void draw(Graphics2D g2) {
        g2.setColor(Color.BLACK);
        for (Rna2D r : this.rnas) {
            r.draw(g2);
        }
        for (BaseBaseInteraction2D i : this.interMolecularTertiaryInteractions) {
            i.draw(g2);
        }
        for (Helix2D h : this.interMolecularHelices) {
            h.draw(g2);
        }
    }

    @Override
    public boolean contains(double x, double y) {
        return this.getArea().contains(x, y);
    }

    @Override
    public Area getArea() {
        Rectangle2D surf = null;
        for (Helix2D h : this.interMolecularHelices) {
            if (!h.isDisplayed()) continue;
            if (surf == null) {
                surf = h.getArea().getBounds2D();
                continue;
            }
            surf.add(h.getArea().getBounds2D());
        }
        Area s = null;
        for (Rna2D r : this.rnas) {
            s = r.getArea();
            if (s == null) continue;
            if (surf == null) {
                surf = s.getBounds2D();
                continue;
            }
            surf.add(s.getBounds2D());
        }
        if (surf != null) {
            return new Area(surf);
        }
        return new Area();
    }

    @Override
    public String toSVG() {
        StringBuffer svg = new StringBuffer("<title>");
        svg.append("Model n");
        svg.append("???");
        svg.append("</title>\n");
        for (Rna2D r : this.rnas) {
            svg.append(r.toSVG());
        }
        for (BaseBaseInteraction2D i : this.interMolecularTertiaryInteractions) {
            svg.append(i.toSVG());
        }
        for (Helix2D h : this.interMolecularHelices) {
            svg.append(h.toSVG());
        }
        return svg.toString();
    }

    public List<Helix2D> getInterMolecularHelices() {
        return new ArrayList<Helix2D>(this.interMolecularHelices);
    }

    public List<Rna2D> getRnas() {
        return new ArrayList<Rna2D>(this.rnas);
    }

    public List<BaseBaseInteraction2D> getInterMolecularTertiaryInteractions() {
        return new ArrayList<BaseBaseInteraction2D>(this.interMolecularTertiaryInteractions);
    }

    public List<Interaction2D> getInteractions(ParadiseID moleculeResidueId, int residueAbsolutePosition, ParadiseID moleculePartnerResidueId, int partnerResidueAbsolutePosition) {
        ArrayList<Interaction2D> hits = new ArrayList<Interaction2D>();
        for (BaseBaseInteraction2D inter : this.getBaseBaseInteractions()) {
            if (inter.getResidue().getAbsolutePosition() != residueAbsolutePosition || !inter.getResidue().getMoleculeId().equals((Object)moleculeResidueId) || inter.getPartnerResidue().getAbsolutePosition() != partnerResidueAbsolutePosition || inter.getPartnerResidue().getMoleculeId() != moleculePartnerResidueId) continue;
            hits.add(inter);
        }
        return hits;
    }

    public Residue2D getResidue(ParadiseID moleculeID, int absolutePosition) {
        return this.repository.getResidue(moleculeID, absolutePosition);
    }

    public List<Helix2D> getHelices() {
        ArrayList<Helix2D> helices = new ArrayList<Helix2D>();
        helices.addAll(this.interMolecularHelices);
        for (Rna2D r : this.rnas) {
            helices.addAll(r.getHelices());
        }
        return helices;
    }

    public List<Sstrand2D> getSstrands() {
        ArrayList<Sstrand2D> sstrands = new ArrayList<Sstrand2D>();
        for (Rna2D rna : this.getRnas()) {
            sstrands.addAll(rna.getStrands());
        }
        return sstrands;
    }

    public List<Interaction2D> getInteractions(ParadiseID moleculeId, int absolutePosition) {
        ArrayList<Interaction2D> hits = new ArrayList<Interaction2D>();
        for (BaseBaseInteraction2D inter : this.getBaseBaseInteractions()) {
            if ((inter.getResidue().getAbsolutePosition() != absolutePosition || inter.getResidue().getMoleculeId() != moleculeId) && (inter.getPartnerResidue().getAbsolutePosition() != absolutePosition || inter.getPartnerResidue().getMoleculeId() != moleculeId)) continue;
            hits.add(inter);
        }
        return hits;
    }

    public List<BaseBaseInteraction2D> getBaseBaseInteractions() {
        ArrayList<BaseBaseInteraction2D> interactions = new ArrayList<BaseBaseInteraction2D>();
        interactions.addAll(this.interMolecularTertiaryInteractions);
        for (Helix2D h : this.interMolecularHelices) {
            for (BaseBaseInteraction2D inter : h.getSecondaryInteractions()) {
                interactions.add(inter);
            }
        }
        for (Rna2D r : this.rnas) {
            for (BaseBaseInteraction2D inter : r.getTertiaryInteractions()) {
                interactions.add(inter);
            }
            for (Helix2D h : r.getHelices()) {
                for (BaseBaseInteraction2D inter : h.getSecondaryInteractions()) {
                    interactions.add(inter);
                }
            }
        }
        return interactions;
    }

    public List<BaseBaseInteraction2D> getAllTertiaryInteractions() {
        ArrayList<BaseBaseInteraction2D> interactions = new ArrayList<BaseBaseInteraction2D>();
        interactions.addAll(this.interMolecularTertiaryInteractions);
        for (Helix2D h : this.interMolecularHelices) {
            for (BaseBaseInteraction2D inter : h.getSecondaryInteractions()) {
                interactions.add(inter);
            }
        }
        for (Rna2D r : this.rnas) {
            for (BaseBaseInteraction2D inter : r.getTertiaryInteractions()) {
                interactions.add(inter);
            }
        }
        return interactions;
    }

    private boolean alreadyExist(Residue2D r1, Residue2D r2) {
        for (BaseBaseInteraction2D interaction : this.getBaseBaseInteractions()) {
            if ((interaction.getResidue() != r1 || interaction.getPartnerResidue() != r2) && (interaction.getResidue() != r2 || interaction.getPartnerResidue() != r1)) continue;
            return true;
        }
        return false;
    }

    public void modifyInteractionType(BaseBaseInteraction2D interactionToModify, Residue2D residue1, char edge1, Residue2D residue2, char edge2, char orientation, int dominant) throws BiologicalSymbolException {
        block14: {
            ArrayList<BaseBaseInteraction> interactionsAdded = new ArrayList<BaseBaseInteraction>();
            ArrayList<BaseBaseInteraction> interactionsRemoved = new ArrayList<BaseBaseInteraction>();
            Iterator iterator = interactionToModify.getBaseBaseInteractionFeature().getMolecules().iterator();
            if (interactionToModify.getBaseBaseInteractionFeature().isSecondaryInteraction()) {
                Molecule m1 = (Molecule)iterator.next();
                if (iterator.hasNext()) {
                    Molecule m2 = (Molecule)iterator.next();
                    for (Helix2D helix : this.interMolecularHelices) {
                        for (BaseBaseInteraction2D _interaction : new ArrayList<BaseBaseInteraction2D>(helix.secondaryInteractions)) {
                            if (_interaction != interactionToModify) continue;
                            helix.secondaryInteractions.remove(interactionToModify);
                            interactionsRemoved.add(interactionToModify.getBaseBaseInteractionFeature());
                            this.mediator.removeNodeFromExplorer(helix.getHelixFeature(), interactionToModify.getBaseBaseInteractionFeature());
                            BaseBaseInteraction newInteraction = interactionToModify.getBaseBaseInteractionFeature().getFactory().createBaseBaseInteraction(edge1, edge2, orientation, dominant, (Helix)interactionToModify.getBaseBaseInteractionFeature().getParentFeatures(Helix.class).get(0), m1, interactionToModify.getBaseBaseInteractionFeature().getFullLocation(m1), m2, interactionToModify.getBaseBaseInteractionFeature().getFullLocation(m2));
                            newInteraction.generateAtomAtomInteractions();
                            BaseBaseInteraction2D newInteraction2D = BaseBaseInteraction2D.getInteraction(newInteraction, this.repository, this.mediator, this.gc);
                            helix.secondaryInteractions.add(newInteraction2D);
                            interactionsAdded.add(newInteraction);
                            this.mediator.insertNodeIntoExplorer(helix.getHelixFeature(), newInteraction);
                            break block14;
                        }
                    }
                } else {
                    for (Rna2D rna : this.rnas) {
                        for (Helix2D helix : rna.helices) {
                            for (BaseBaseInteraction2D _interaction : new ArrayList<BaseBaseInteraction2D>(helix.secondaryInteractions)) {
                                if (_interaction != interactionToModify) continue;
                                helix.secondaryInteractions.remove(interactionToModify);
                                this.mediator.removeNodeFromExplorer(helix.getHelixFeature(), interactionToModify.getBaseBaseInteractionFeature());
                                interactionsRemoved.add(interactionToModify.getBaseBaseInteractionFeature());
                                BaseBaseInteraction newInteraction = interactionToModify.getBaseBaseInteractionFeature().getFactory().createBaseBaseInteraction(edge1, edge2, orientation, dominant, (Helix)interactionToModify.getBaseBaseInteractionFeature().getParentFeatures(Helix.class).get(0), m1, interactionToModify.getBaseBaseInteractionFeature().getFullLocation(m1));
                                newInteraction.generateAtomAtomInteractions();
                                BaseBaseInteraction2D newInteraction2D = BaseBaseInteraction2D.getInteraction(newInteraction, this.repository, this.mediator, this.gc);
                                helix.secondaryInteractions.add(newInteraction2D);
                                interactionsAdded.add(newInteraction);
                                this.mediator.insertNodeIntoExplorer(helix.getHelixFeature(), newInteraction);
                                break block14;
                            }
                        }
                    }
                }
            } else {
                Molecule m1 = (Molecule)iterator.next();
                if (iterator.hasNext()) {
                    Molecule m2 = (Molecule)iterator.next();
                    for (BaseBaseInteraction2D interaction : new ArrayList<BaseBaseInteraction2D>(this.interMolecularTertiaryInteractions)) {
                        if (interaction != interactionToModify) continue;
                        this.interMolecularTertiaryInteractions.remove(interactionToModify);
                        this.mediator.removeNodeFromExplorer(this.getSecondaryStructure(), interactionToModify.getBaseBaseInteractionFeature());
                        interactionsRemoved.add(interactionToModify.getBaseBaseInteractionFeature());
                        BaseBaseInteraction newInteraction = interactionToModify.getBaseBaseInteractionFeature().getFactory().createBaseBaseInteraction(edge1, edge2, orientation, dominant, (SecondaryStructure)interactionToModify.getBaseBaseInteractionFeature().getParentFeatures(SecondaryStructure.class).get(0), m1, interactionToModify.getBaseBaseInteractionFeature().getFullLocation(m1), m2, interactionToModify.getBaseBaseInteractionFeature().getFullLocation(m2));
                        newInteraction.generateAtomAtomInteractions();
                        BaseBaseInteraction2D newInteraction2D = BaseBaseInteraction2D.getInteraction(newInteraction, this.repository, this.mediator, this.gc);
                        this.interMolecularTertiaryInteractions.add(newInteraction2D);
                        interactionsAdded.add(newInteraction);
                        this.mediator.insertNodeIntoExplorer(this.getSecondaryStructure(), newInteraction);
                        break;
                    }
                } else {
                    for (Rna2D rna : this.rnas) {
                        for (BaseBaseInteraction2D interaction : new ArrayList<BaseBaseInteraction2D>(rna.tertiaryInteractions)) {
                            if (interaction != interactionToModify) continue;
                            rna.tertiaryInteractions.remove(interactionToModify);
                            this.mediator.removeNodeFromExplorer(rna.getRnaMolecule(), interactionToModify.getBaseBaseInteractionFeature());
                            interactionsRemoved.add(interactionToModify.getBaseBaseInteractionFeature());
                            BaseBaseInteraction newInteraction = interactionToModify.getBaseBaseInteractionFeature().getFactory().createBaseBaseInteraction(edge1, edge2, orientation, dominant, (SecondaryStructure)interactionToModify.getBaseBaseInteractionFeature().getParentFeatures(SecondaryStructure.class).get(0), m1, interactionToModify.getBaseBaseInteractionFeature().getFullLocation(m1));
                            newInteraction.generateAtomAtomInteractions();
                            BaseBaseInteraction2D newInteraction2D = BaseBaseInteraction2D.getInteraction(newInteraction, this.repository, this.mediator, this.gc);
                            rna.tertiaryInteractions.add(newInteraction2D);
                            interactionsAdded.add(newInteraction);
                            this.mediator.insertNodeIntoExplorer(rna.getRnaMolecule(), newInteraction);
                            break block14;
                        }
                    }
                }
            }
        }
    }

    public Helix2D createHelix(Residue2D firstFivePrime, Residue2D firstThreePrime, Residue2D secondFivePrime, Residue2D secondThreePrime) throws ArchitectureException, BiologicalSymbolException {
        Sstrand2D ss2D;
        SingleStrand ss;
        int[] boundaries;
        Helix2D h2D = null;
        HashSet<Helix2D> helicesToRemove = new HashSet<Helix2D>();
        Residue2D nextResidue = firstFivePrime;
        Location newL1 = new Location(firstFivePrime.getAbsolutePosition(), firstThreePrime.getAbsolutePosition());
        Location newL2 = new Location(secondFivePrime.getAbsolutePosition(), secondThreePrime.getAbsolutePosition());
        if (newL1.getLength() != newL2.getLength()) {
            throw new ArchitectureException("The two strands need to have the same length");
        }
        if (newL1.getLength() < 2) {
            throw new ArchitectureException("You cannot construct an helix with strands shorter than two residues");
        }
        while (!firstThreePrime.equals(nextResidue)) {
            if (Helix2D.class.isInstance(nextResidue.getStructuralDomain())) {
                helicesToRemove.add((Helix2D)nextResidue.getStructuralDomain());
            }
            nextResidue = nextResidue.getNextResidue();
        }
        nextResidue = secondFivePrime;
        while (!secondThreePrime.equals(nextResidue)) {
            if (Helix2D.class.isInstance(nextResidue.getStructuralDomain())) {
                helicesToRemove.add((Helix2D)nextResidue.getStructuralDomain());
            }
            nextResidue = nextResidue.getNextResidue();
        }
        for (Helix2D h : helicesToRemove) {
            this.removeHelix(h, true);
        }
        Sstrand2D firstSstrandToRemove = (Sstrand2D)firstFivePrime.getStructuralDomain();
        Sstrand2D secondSstrandToRemove = (Sstrand2D)secondFivePrime.getStructuralDomain();
        Location previousL1 = firstSstrandToRemove.getSingleStrandFeature().getFullLocation((Molecule)firstSstrandToRemove.getRna().getRnaMolecule());
        Location previousL2 = secondSstrandToRemove.getSingleStrandFeature().getFullLocation((Molecule)secondSstrandToRemove.getRna().getRnaMolecule());
        firstSstrandToRemove.getRna().removeSstrand(firstSstrandToRemove);
        this.mediator.removeNodeFromExplorer(firstSstrandToRemove.getRna().getRnaMolecule(), firstSstrandToRemove.getSingleStrandFeature());
        this.secondaryStructure.removeSingleStrand(firstSstrandToRemove.getSingleStrandFeature());
        if (firstSstrandToRemove != secondSstrandToRemove) {
            secondSstrandToRemove.getRna().removeSstrand(secondSstrandToRemove);
            this.mediator.removeNodeFromExplorer(secondSstrandToRemove.getRna().getRnaMolecule(), secondSstrandToRemove.getSingleStrandFeature());
            this.secondaryStructure.removeSingleStrand(secondSstrandToRemove.getSingleStrandFeature());
        }
        Helix h = null;
        if (firstSstrandToRemove.getRna() == secondSstrandToRemove.getRna()) {
            h = this.secondaryStructure.getFactory().createHelix("Helix", this.secondaryStructure, (Molecule)firstSstrandToRemove.getRna().getRnaMolecule(), new Location(newL1, newL2));
            h2D = new Helix2D(h, this.repository, this.mediator, this.gc);
            firstSstrandToRemove.getRna().helices.add(h2D);
            this.mediator.insertNodeIntoExplorer(firstSstrandToRemove.getRna().getRnaMolecule(), h);
        } else {
            h = this.secondaryStructure.getFactory().createHelix("Helix", this.secondaryStructure, (Molecule)firstSstrandToRemove.getRna().getRnaMolecule(), newL1, (Molecule)secondSstrandToRemove.getRna().getRnaMolecule(), newL2);
            h2D = new Helix2D(h, this.repository, this.mediator, this.gc);
            this.interMolecularHelices.add(h2D);
            this.mediator.insertNodeIntoExplorer(this.secondaryStructure, h);
        }
        for (BaseBaseInteraction interaction : h.getBaseBaseInteractions()) {
            this.mediator.insertNodeIntoExplorer(h, interaction);
        }
        block4: for (BaseBaseInteraction2D interaction2D : h2D.getSecondaryInteractions()) {
            for (BaseBaseInteraction2D tertiary : this.getAllTertiaryInteractions()) {
                if (tertiary.getResidue().equals(interaction2D.getResidue()) && tertiary.getPartnerResidue().equals(interaction2D.getPartnerResidue())) {
                    this.modifyInteractionType(interaction2D, interaction2D.getResidue(), tertiary.getBaseBaseInteractionFeature().getEdge1(), interaction2D.getPartnerResidue(), tertiary.getBaseBaseInteractionFeature().getEdge2(), tertiary.getBaseBaseInteractionFeature().getOrientation(), tertiary.getBaseBaseInteractionFeature().getDominant());
                    this.removeTertiaryInteraction(tertiary);
                    continue block4;
                }
                if (!tertiary.getPartnerResidue().equals(interaction2D.getResidue()) || !tertiary.getResidue().equals(interaction2D.getPartnerResidue())) continue;
                this.modifyInteractionType(interaction2D, interaction2D.getResidue(), tertiary.getBaseBaseInteractionFeature().getEdge2(), interaction2D.getPartnerResidue(), tertiary.getBaseBaseInteractionFeature().getEdge1(), tertiary.getBaseBaseInteractionFeature().getOrientation(), tertiary.getBaseBaseInteractionFeature().getDominant());
                this.removeTertiaryInteraction(tertiary);
                continue block4;
            }
        }
        if (firstSstrandToRemove != secondSstrandToRemove) {
            previousL1.remove(newL1);
        } else {
            previousL1.remove(newL1);
            previousL1.remove(newL2);
        }
        if (!previousL1.isEmpty()) {
            boundaries = previousL1.getBoundaries();
            for (int i = 0; i < boundaries.length - 1; i += 2) {
                ss = this.secondaryStructure.getFactory().createSingleStrand("Single-Strand", this.secondaryStructure, (Molecule)firstSstrandToRemove.getRna().getRnaMolecule(), new Location(boundaries[i], boundaries[i + 1]));
                ss2D = new Sstrand2D(firstSstrandToRemove.getRna(), this.secondaryStructure, ss, this.repository, this.mediator, this.gc);
                ss2D.setCoordinates();
                firstSstrandToRemove.getRna().strands.add(ss2D);
                this.mediator.insertNodeIntoExplorer(firstSstrandToRemove.getRna().getRnaMolecule(), ss);
            }
        }
        if (firstSstrandToRemove != secondSstrandToRemove) {
            previousL2.remove(newL2);
            if (!previousL2.isEmpty()) {
                boundaries = previousL2.getBoundaries();
                for (int i = 0; i < boundaries.length - 1; i += 2) {
                    ss = this.secondaryStructure.getFactory().createSingleStrand("Single-Strand", this.secondaryStructure, (Molecule)secondSstrandToRemove.getRna().getRnaMolecule(), new Location(boundaries[i], boundaries[i + 1]));
                    ss2D = new Sstrand2D(secondSstrandToRemove.getRna(), this.secondaryStructure, ss, this.repository, this.mediator, this.gc);
                    ss2D.setCoordinates();
                    secondSstrandToRemove.getRna().strands.add(ss2D);
                    this.mediator.insertNodeIntoExplorer(secondSstrandToRemove.getRna().getRnaMolecule(), ss);
                }
            }
        }
        int x = (int)(firstFivePrime.getRealX() + firstThreePrime.getRealX() + secondFivePrime.getRealX() + secondThreePrime.getRealX()) / 4;
        int y = (int)(firstFivePrime.getRealY() + firstThreePrime.getRealY() + secondFivePrime.getRealY() + secondThreePrime.getRealY()) / 4;
        firstFivePrime.setRealCoordinates(x, y);
        firstThreePrime.setRealCoordinates(x, (double)y - this.gc.getHeight() * (double)(newL1.getLength() - 1));
        secondThreePrime.setRealCoordinates((double)x + this.gc.getWidth() * 4.0, y);
        secondFivePrime.setRealCoordinates((double)x + this.gc.getWidth() * 4.0, (double)y - this.gc.getHeight() * (double)(newL1.getLength() - 1));
        h2D.setCoordinates();
        return h2D;
    }

    public List<BaseBaseInteraction2D> removeHelix(Helix2D h, boolean keepInteractionsAsTertiary) throws BiologicalSymbolException {
        boolean isInterHelix;
        ArrayList<BaseBaseInteraction2D> tertiaryInteractions = new ArrayList<BaseBaseInteraction2D>();
        Rna2D rna = null;
        Molecule m = null;
        for (Residue2D r : h.get5PrimeEnds()) {
            Sstrand2D ss2D;
            SingleStrand ss;
            m = ((Residue)r.getResidue2DFeature().getResidues().iterator().next()).getMolecule();
            for (Rna2D _rna : this.getRnas()) {
                if (!_rna.getRnaMolecule().equals((Object)m)) continue;
                rna = _rna;
                break;
            }
            Residue2D previousResidue = r.getPreviousResidue();
            Residue2D nextResidue = h.get3PrimeEnd(r).getNextResidue();
            if (previousResidue != null) {
                if (nextResidue == null) {
                    if (Helix2D.class.isInstance(previousResidue.getStructuralDomain())) {
                        ss = this.secondaryStructure.getFactory().createSingleStrand("Single-Strand", this.secondaryStructure, m, new Location(r.getAbsolutePosition(), m.getLength()));
                        ss2D = new Sstrand2D(rna, this.secondaryStructure, ss, this.repository, this.mediator, this.gc);
                        ss2D.setCoordinates();
                        rna.strands.add(ss2D);
                        this.mediator.insertNodeIntoExplorer(rna.getRnaMolecule(), ss);
                        continue;
                    }
                    ((Sstrand2D)previousResidue.getStructuralDomain()).extend(new Location(r.getAbsolutePosition(), m.getLength()));
                    previousResidue.getStructuralDomain().setCoordinates();
                    continue;
                }
                if (Helix2D.class.isInstance(previousResidue.getStructuralDomain()) && Helix2D.class.isInstance(nextResidue.getStructuralDomain())) {
                    ss = this.secondaryStructure.getFactory().createSingleStrand("Single-Strand", this.secondaryStructure, m, new Location(r.getAbsolutePosition(), nextResidue.getPreviousResidue().getAbsolutePosition()));
                    ss2D = new Sstrand2D(rna, this.secondaryStructure, ss, this.repository, this.mediator, this.gc);
                    ss2D.setCoordinates();
                    rna.strands.add(ss2D);
                    this.mediator.insertNodeIntoExplorer(rna.getRnaMolecule(), ss);
                    continue;
                }
                if (Helix2D.class.isInstance(previousResidue.getStructuralDomain()) && Sstrand2D.class.isInstance(nextResidue.getStructuralDomain())) {
                    ((Sstrand2D)nextResidue.getStructuralDomain()).extend(new Location(r.getAbsolutePosition(), nextResidue.getPreviousResidue().getAbsolutePosition()));
                    nextResidue.getStructuralDomain().setCoordinates();
                    continue;
                }
                if (Sstrand2D.class.isInstance(previousResidue.getStructuralDomain()) && Helix2D.class.isInstance(nextResidue.getStructuralDomain())) {
                    ((Sstrand2D)previousResidue.getStructuralDomain()).extend(new Location(r.getAbsolutePosition(), nextResidue.getPreviousResidue().getAbsolutePosition()));
                    previousResidue.getStructuralDomain().setCoordinates();
                    continue;
                }
                Residue2D lastSingleStrandPosition = ((Sstrand2D)nextResidue.getStructuralDomain()).getBase3();
                Sstrand2D ssToRemove = (Sstrand2D)nextResidue.getStructuralDomain();
                ((Sstrand2D)previousResidue.getStructuralDomain()).extend(new Location(r.getAbsolutePosition(), lastSingleStrandPosition.getAbsolutePosition()));
                previousResidue.getStructuralDomain().setCoordinates();
                rna.removeSstrand(ssToRemove);
                this.mediator.removeNodeFromExplorer(rna.getRnaMolecule(), ssToRemove.getSingleStrandFeature());
                this.secondaryStructure.removeSingleStrand(ssToRemove.getSingleStrandFeature());
                continue;
            }
            if (nextResidue == null) {
                ss = this.secondaryStructure.getFactory().createSingleStrand("Single-Strand", this.secondaryStructure, m, new Location(r.getAbsolutePosition(), m.getLength()));
                ss2D = new Sstrand2D(rna, this.secondaryStructure, ss, this.repository, this.mediator, this.gc);
                ss2D.setCoordinates();
                rna.strands.add(ss2D);
                this.mediator.insertNodeIntoExplorer(rna.getRnaMolecule(), ss);
                continue;
            }
            if (Helix2D.class.isInstance(nextResidue.getStructuralDomain())) {
                ss = this.secondaryStructure.getFactory().createSingleStrand("Single-Strand", this.secondaryStructure, m, new Location(r.getAbsolutePosition(), nextResidue.getPreviousResidue().getAbsolutePosition()));
                ss2D = new Sstrand2D(rna, this.secondaryStructure, ss, this.repository, this.mediator, this.gc);
                ss2D.setCoordinates();
                rna.strands.add(ss2D);
                this.mediator.insertNodeIntoExplorer(rna.getRnaMolecule(), ss);
                continue;
            }
            ((Sstrand2D)nextResidue.getStructuralDomain()).extend(new Location(r.getAbsolutePosition(), nextResidue.getAbsolutePosition() - 1));
            nextResidue.getStructuralDomain().setCoordinates();
        }
        for (BaseBaseInteraction2D _interaction : h.getSecondaryInteractions()) {
            _interaction.getResidue().removeInteraction(_interaction);
            _interaction.getPartnerResidue().removeInteraction(_interaction);
            m.removeFeature((ParadiseFeature)_interaction.getBaseBaseInteractionFeature());
            if (!keepInteractionsAsTertiary) continue;
            tertiaryInteractions.add(this.createTertiaryInteraction(_interaction.getResidue(), _interaction.getBaseBaseInteractionFeature().getEdge1(), _interaction.getPartnerResidue(), _interaction.getBaseBaseInteractionFeature().getEdge2(), _interaction.getBaseBaseInteractionFeature().getOrientation(), _interaction.getBaseBaseInteractionFeature().getDominant()));
        }
        boolean bl = isInterHelix = h.getHelixFeature().getMolecules().size() == 2;
        if (isInterHelix) {
            this.interMolecularHelices.remove(h);
            this.mediator.removeNodeFromExplorer(this.secondaryStructure, h.getHelixFeature());
        } else {
            rna.helices.remove(h);
            this.mediator.removeNodeFromExplorer(rna.getRnaMolecule(), h.getHelixFeature());
        }
        this.secondaryStructure.removeHelix(h.getHelixFeature());
        return tertiaryInteractions;
    }

    public BaseBaseInteraction2D createTertiaryInteraction(Residue2D residue1, char edge1, Residue2D residue2, char edge2, char orientation, int dominant) throws BiologicalSymbolException {
        BaseBaseInteraction bbi;
        Molecule m1 = (Molecule)residue1.getResidue2DFeature().getMolecules().iterator().next();
        Molecule m2 = (Molecule)residue2.getResidue2DFeature().getMolecules().iterator().next();
        int pos1 = residue1.getAbsolutePosition();
        int pos2 = residue2.getAbsolutePosition();
        BaseBaseInteraction2D interaction = null;
        if (m1 == m2) {
            if (pos1 > pos2) {
                int tmp = pos2;
                pos2 = pos1;
                pos1 = tmp;
                char _tmp = edge2;
                edge2 = edge1;
                edge1 = _tmp;
            }
            bbi = this.getSecondaryStructure().getFactory().createBaseBaseInteraction(edge1, edge2, orientation, dominant, this.getSecondaryStructure(), m1, new Location(new Location(pos1), new Location(pos2)));
            for (Rna2D rna : this.getRnas()) {
                if (!rna.getRnaMolecule().getParadiseID().equals((Object)m1.getParadiseID())) continue;
                interaction = BaseBaseInteraction2D.getInteraction(bbi, this.repository, this.mediator, this.gc);
                rna.addTertiaryInteraction(interaction);
                this.mediator.insertNodeIntoExplorer(rna.getRnaMolecule(), bbi);
                break;
            }
        } else {
            bbi = this.getSecondaryStructure().getFactory().createBaseBaseInteraction(edge1, edge2, orientation, dominant, this.getSecondaryStructure(), m1, new Location(pos1), m2, new Location(pos2));
            interaction = BaseBaseInteraction2D.getInteraction(bbi, this.repository, this.mediator, this.gc);
            this.mediator.insertNodeIntoExplorer(this.getSecondaryStructure(), bbi);
            this.interMolecularTertiaryInteractions.add(interaction);
        }
        bbi.generateAtomAtomInteractions();
        return interaction;
    }

    public void removeTertiaryInteraction(BaseBaseInteraction2D interaction) {
        if (!interaction.getBaseBaseInteractionFeature().isSecondaryInteraction()) {
            for (BaseBaseInteraction2D _interaction : this.getInterMolecularTertiaryInteractions()) {
                if (_interaction != interaction) continue;
                this.interMolecularTertiaryInteractions.remove(interaction);
                this.mediator.removeNodeFromExplorer(this.getSecondaryStructure(), interaction.getBaseBaseInteractionFeature());
                break;
            }
            block1: for (Rna2D rna : this.getRnas()) {
                for (BaseBaseInteraction2D _interaction : rna.getTertiaryInteractions()) {
                    if (_interaction != interaction) continue;
                    rna.removeTertiaryInteraction(interaction);
                    this.mediator.removeNodeFromExplorer(rna.getRnaMolecule(), interaction.getBaseBaseInteractionFeature());
                    continue block1;
                }
            }
            interaction.getResidue().removeInteraction(interaction);
            interaction.getPartnerResidue().removeInteraction(interaction);
            this.secondaryStructure.removeBaseBaseInteraction(interaction.getBaseBaseInteractionFeature());
            for (Molecule m : interaction.getBaseBaseInteractionFeature().getMolecules()) {
                m.removeFeature((ParadiseFeature)interaction.getBaseBaseInteractionFeature());
            }
        }
    }
}

