/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.ssviewer.features;

import fr.unistra.ibmc.assemble.ssviewer.features.Interaction2D;
import fr.unistra.ibmc.assemble.ssviewer.features.Line;
import fr.unistra.ibmc.assemble.ssviewer.features.Residues2DRepository;
import fr.unistra.ibmc.assemble.ssviewer.features.Triangle;
import fr.unistra.ibmc.assemble.ssviewer.graphics.GraphicContext;
import fr.unistra.ibmc.assemble.ssviewer.graphics.Mediator;
import fr.unistra.ibmc.assemble.ssviewer.utils.DrawingUtils;
import fr.unistra.ibmc.paradise.core.utils.Residue;
import java.awt.geom.Point2D;

public class PhosphodiesterBond2D
extends Interaction2D {
    PhosphodiesterBond2D(Residue residue5, Residue residue3, Residues2DRepository repository, Mediator mediator, GraphicContext gc) {
        super(repository, residue5, residue3, mediator, gc);
        this.getResidue().setPhosphodiesterBond2D(this);
    }

    protected void setDefaultSymbol() {
        this.defaultSymbol.clear();
        if (this.op != null) {
            double distance = DrawingUtils.getDistance(this.op[0], this.op[1]);
            this.defaultSymbol.addSymbol(new Line(this.op[0], this.op[1], this.gc));
            if (distance >= this.gc.getCurrentSymbolSize() / 3.0 && this.gc.isFiveToThreeOrientationDisplayed()) {
                Point2D[] points = DrawingUtils.fit(this.op[0].getX(), this.op[0].getY(), this.op[1].getX(), this.op[1].getY(), (distance - this.gc.getCurrentSymbolSize() / 2.0) / 2.0);
                this.defaultSymbol.addSymbol(new Triangle(points[0], points[1], this.getResidue(), this.getPartnerResidue(), this.gc.getCurrentSymbolSize(), 'C', this.gc));
            }
        }
    }

    protected void setRealSymbol() {
        this.setDefaultSymbol();
    }

    protected Interaction2D.SymbolsArray getRealSymbol() {
        return this.getDefaultSymbol();
    }

    public String toSVG() {
        this.setOutsidePoints();
        if (this.real_op != null) {
            this.op = new Point2D[2];
            this.op[0] = new Point2D.Double(this.real_op[0].getX() * this.gc.getFinalZoomLevel() + this.gc.getViewX(), this.real_op[0].getY() * this.gc.getFinalZoomLevel() + this.gc.getViewY());
            this.op[1] = new Point2D.Double(this.real_op[1].getX() * this.gc.getFinalZoomLevel() + this.gc.getViewX(), this.real_op[1].getY() * this.gc.getFinalZoomLevel() + this.gc.getViewY());
        } else {
            this.op = null;
        }
        this.setDefaultSymbol();
        return this.toSVGDefault();
    }

    protected void setRealSymbol(Point2D point1, Point2D point2, double distance) {
    }
}

