/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.ssviewer.features;

import fr.unistra.ibmc.assemble.ssviewer.features.BaseBaseInteraction2D;
import fr.unistra.ibmc.assemble.ssviewer.features.Helix2D;
import fr.unistra.ibmc.assemble.ssviewer.features.Interaction2D;
import fr.unistra.ibmc.assemble.ssviewer.features.PhosphodiesterBond2D;
import fr.unistra.ibmc.assemble.ssviewer.features.Residues2DRepository;
import fr.unistra.ibmc.assemble.ssviewer.features.Rna2DElement;
import fr.unistra.ibmc.assemble.ssviewer.features.Sstrand2D;
import fr.unistra.ibmc.assemble.ssviewer.features.StructuralDomain2D;
import fr.unistra.ibmc.assemble.ssviewer.graphics.GraphicContext;
import fr.unistra.ibmc.assemble.ssviewer.graphics.Mediator;
import fr.unistra.ibmc.assemble.ssviewer.utils.DrawingUtils;
import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.ParadiseID;
import fr.unistra.ibmc.paradise.core.utils.Residue;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Residue2D
extends Rna2DElement
implements Comparable {
    private boolean updated;
    private boolean isDisplayed = true;
    private boolean selected;
    private List<Interaction2D> interactions;
    private PhosphodiesterBond2D phosphodiesterBond2D;
    private StructuralDomain2D structuralDomain;
    private fr.unistra.ibmc.paradise.core.features.Residue2D residue2D;

    Residue2D(fr.unistra.ibmc.paradise.core.features.Residue2D residue2D, Residues2DRepository repository, Mediator mediator, GraphicContext gc) {
        super(repository, mediator, gc);
        this.residue2D = residue2D;
        this.updated = true;
        this.interactions = new ArrayList<Interaction2D>();
    }

    @Override
    public void isSelected(boolean selected) {
        this.selected = selected;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    public fr.unistra.ibmc.paradise.core.features.Residue2D getResidue2DFeature() {
        return this.residue2D;
    }

    public char getSymbol() {
        return ((Residue)this.residue2D.getResidues().iterator().next()).getSymbol();
    }

    public int getAbsolutePosition() {
        return this.residue2D.getFullLocation((Molecule)this.residue2D.getMolecules().iterator().next()).getStart();
    }

    public double getRealX() {
        return this.residue2D.getX();
    }

    public double getRealY() {
        return this.residue2D.getY();
    }

    public double getCurrentX() {
        return (double)this.residue2D.getX() * this.gc.getFinalZoomLevel() + this.gc.getViewX();
    }

    public double getCurrentY() {
        return (double)this.residue2D.getY() * this.gc.getFinalZoomLevel() + this.gc.getViewY();
    }

    public Point2D getRealCoordinates() {
        return new Point2D.Double(this.getRealX(), this.getRealY());
    }

    public Point2D getCurrentCoordinates() {
        return new Point2D.Double(this.getCurrentX(), this.getCurrentY());
    }

    void setRealCoordinates(Point2D coord) {
        this.setRealCoordinates(coord.getX(), coord.getY());
    }

    public void setRealCoordinates(double x, double y) {
        this.setX(x);
        this.setY(y);
    }

    void setX(double x) {
        this.residue2D.setX((float)x);
        this.isUpdated(true);
    }

    void setY(double y) {
        this.residue2D.setY((float)y);
        this.isUpdated(true);
    }

    public Residue2D getNextResidue() {
        return this.repository.getResidue(((Residue)this.residue2D.getResidues().iterator().next()).getNextResidue());
    }

    public Residue2D getPreviousResidue() {
        return this.repository.getResidue(((Residue)this.residue2D.getResidues().iterator().next()).getPreviousResidue());
    }

    @Override
    public boolean isInsideDrawingArea() {
        Rectangle r = this.gc.getDrawingArea();
        return r.contains(this.getCurrentX(), this.getCurrentY()) || r.contains(this.getCurrentX() + this.gc.getCurrentWidth(), this.getCurrentY()) || r.contains(this.getCurrentX(), this.getCurrentY() - this.gc.getCurrentHeight()) || r.contains(this.getCurrentX() + this.gc.getCurrentWidth(), this.getCurrentY() - this.gc.getCurrentHeight());
    }

    public boolean isStrictlyInsideDrawingArea() {
        Rectangle r = this.gc.getDrawingArea();
        return r.contains(this.getCurrentX(), this.getCurrentY()) && r.contains(this.getCurrentX() + this.gc.getCurrentWidth(), this.getCurrentY()) && r.contains(this.getCurrentX(), this.getCurrentY() - this.gc.getCurrentHeight()) && r.contains(this.getCurrentX() + this.gc.getCurrentWidth(), this.getCurrentY() - this.gc.getCurrentHeight());
    }

    public boolean isInsideHelix() {
        return Helix2D.class.isInstance(this.structuralDomain);
    }

    public StructuralDomain2D getStructuralDomain() {
        return this.structuralDomain;
    }

    public void setStructuralDomain(StructuralDomain2D structure) {
        this.structuralDomain = structure;
        if (Helix2D.class.isInstance(structure)) {
            this.setColor(Helix2D.DEFAULT_COLOR);
        } else {
            this.setColor(Sstrand2D.DEFAULT_COLOR);
        }
    }

    public void setPhosphodiesterBond2D(PhosphodiesterBond2D phosphodiesterBond2D) {
        this.phosphodiesterBond2D = phosphodiesterBond2D;
    }

    public void addInteraction(Interaction2D interaction) {
        this.interactions.add(interaction);
    }

    public void removeInteraction(BaseBaseInteraction2D interaction) {
        this.interactions.remove(interaction);
    }

    public List<Interaction2D> getInteractions() {
        return this.interactions;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public void isUpdated(boolean updated) {
        this.updated = updated;
        if (updated) {
            Iterator<Interaction2D> i = this.interactions.iterator();
            while (i.hasNext()) {
                i.next().isUpdated(updated);
            }
            if (this.phosphodiesterBond2D != null) {
                this.phosphodiesterBond2D.isUpdated(updated);
                if (this.getPreviousResidue() != null) {
                    this.getPreviousResidue().phosphodiesterBond2D.isUpdated(updated);
                }
            }
        }
    }

    @Override
    public boolean contains(double x, double y) {
        return this.getArea().contains(x, y);
    }

    @Override
    public List<Residue2D> getResidues() {
        ArrayList<Residue2D> residues = new ArrayList<Residue2D>();
        residues.add(this);
        return residues;
    }

    private boolean isToBeLinked() {
        fr.unistra.ibmc.paradise.core.features.Residue2D r = this.getResidue2DFeature();
        Molecule m = (Molecule)r.getMolecules().iterator().next();
        int p = r.getFullLocation(m).getStart();
        return this.repository.mediator.isToBeLinked(m, p);
    }

    @Override
    public void draw(Graphics2D g2) {
        if (!(!this.gc.isDrawOnlySelectedMotif() || this.isSelected() && this.isStrictlyInsideDrawingArea())) {
            return;
        }
        if (this.isDisplayed() && this.isInsideDrawingArea()) {
            if (this.isSelected() && !this.gc.isDrawOnlySelectedMotif()) {
                g2.setColor(Color.red);
            } else {
                g2.setColor(this.color);
            }
            if (this.isToBeLinked()) {
                g2.setColor(Color.GREEN.darker());
            }
            this.drawStringCentered(g2, "" + this.getSymbol(), this.getCurrentCenterX(), this.getCurrentCenterY());
            Residue2D nextR = this.getNextResidue();
            Residue2D previousR = this.getPreviousResidue();
            if (!(nextR == null || previousR != null && previousR.isDisplayed())) {
                g2.drawString("5'", (float)(this.getCurrentX() - (nextR.getCurrentX() - this.getCurrentX())), (float)(this.getCurrentY() - (nextR.getCurrentY() - this.getCurrentY())));
            } else if (!(previousR == null || nextR != null && nextR.isDisplayed())) {
                g2.drawString("3'", (float)(this.getCurrentX() + this.getCurrentX() - previousR.getCurrentX()), (float)(this.getCurrentY() + this.getCurrentY() - previousR.getCurrentY()));
            }
            this.isUpdated(false);
            if (this.isSelected() && this.gc.isDrawOnlySelectedMotif()) {
                if (this.getNextResidue() == null || !this.getNextResidue().isSelected() || this.getPreviousResidue() == null || !this.getPreviousResidue().isSelected()) {
                    this.gc.addToSelectionArea(this.drawId(g2).getBounds2D());
                }
                this.gc.addToSelectionArea(this.getArea().getBounds2D());
                this.gc.addResidueFromMotif(this);
            }
        }
        if (this.phosphodiesterBond2D != null && (this.isDisplayed() && this.isInsideDrawingArea() || this.getNextResidue().isDisplayed && this.getNextResidue().isInsideDrawingArea())) {
            this.phosphodiesterBond2D.draw(g2);
        }
    }

    private Area drawId(Graphics2D g) {
        Font f = g.getFont();
        g.setFont(f.deriveFont(f.getSize2D() / 2.0f));
        Color c = g.getColor();
        g.setColor(Color.BLACK);
        String id = "" + ((Residue)this.residue2D.getResidues().iterator().next()).getAbsolutePosition();
        Dimension d = this.getStringDimension(g, id);
        g.drawString(id, (float)(this.getCurrentX() + this.gc.getCurrentWidth()), (float)(this.getCurrentY() - this.gc.getCurrentHeight()));
        g.setFont(f);
        g.setColor(c);
        return new Area(new Rectangle2D.Double(this.getCurrentX() + this.gc.getCurrentWidth(), this.getCurrentY() - 2.0 * this.gc.getCurrentHeight(), d.width, d.height));
    }

    private void drawStringCentered(Graphics2D g2, String res, double x, double y) {
        Dimension d = this.getStringDimension(g2, res);
        g2.drawString(res, (int)(x -= (double)d.width / 2.0), (int)(y += (double)d.height / 2.0));
    }

    private Dimension getStringDimension(Graphics2D g, String s) {
        FontMetrics fm = g.getFontMetrics();
        Rectangle2D r = fm.getStringBounds(s, g);
        return new Dimension((int)r.getWidth(), fm.getAscent() - fm.getDescent());
    }

    @Override
    public Area getArea() {
        return new Area(new Rectangle2D.Double(this.getCurrentX(), this.getCurrentY() - this.gc.getCurrentHeight(), this.gc.getCurrentWidth(), this.gc.getCurrentHeight()));
    }

    public double getCurrentCenterX() {
        return this.getCurrentX() + this.gc.getCurrentWidth() / 2.0;
    }

    public double getRealCenterX() {
        return this.getRealX() + this.gc.getRealWidth() / 2.0;
    }

    public double getCurrentCenterY() {
        return this.getCurrentY() - this.gc.getCurrentHeight() / 2.0;
    }

    public double getRealCenterY() {
        return this.getRealY() - this.gc.getRealHeight() / 2.0;
    }

    public Point2D getCurrentCenter() {
        return new Point2D.Double(this.getCurrentCenterX(), this.getCurrentCenterY());
    }

    public Point2D getRealCenter() {
        return new Point2D.Double(this.getRealCenterX(), this.getRealCenterY());
    }

    public double getMaxX() {
        return this.getArea().getBounds2D().getMaxX();
    }

    public double getMaxY() {
        return this.getArea().getBounds2D().getMaxY();
    }

    public double getMinX() {
        return this.getArea().getBounds2D().getMinX();
    }

    public double getMinY() {
        return this.getArea().getBounds2D().getMinY();
    }

    @Override
    public boolean isDisplayed() {
        return this.isDisplayed;
    }

    @Override
    public void isDisplayed(boolean displayed) {
        this.isDisplayed = displayed;
    }

    @Override
    public String toSVG() {
        StringBuffer svg = new StringBuffer();
        svg.append("<text fill=\"" + DrawingUtils.colorToString(this.getSVGColor()) + "\" font-moleculesCount=\"" + (int)((double)this.gc.getFont().getSize() / this.gc.getFinalZoomLevel()) + "\" x=\"" + this.getRealX() + "\" y=\"" + this.getRealY() + "\">" + ((Residue)this.residue2D.getResidues().iterator().next()).getSymbol() + "</text>\n");
        if (this.phosphodiesterBond2D != null) {
            svg.append(this.phosphodiesterBond2D.toSVG());
        }
        return svg.toString();
    }

    private Color getSVGColor() {
        return Color.BLACK;
    }

    public void translate(double transX, double transY) {
        this.setX(this.getRealX() + (transX /= this.gc.getFinalZoomLevel()));
        this.setY(this.getRealY() + (transY /= this.gc.getFinalZoomLevel()));
    }

    public void rotate(Point2D centerPoint, double angle) {
        Point2D p = DrawingUtils.getRotatedPoint(this.getCurrentCoordinates(), angle, centerPoint);
        this.setRealCoordinates((p.getX() - this.gc.getViewX()) / this.gc.getFinalZoomLevel(), (p.getY() - this.gc.getViewY()) / this.gc.getFinalZoomLevel());
    }

    public void flip(Point2D center) {
        this.translate(-2.0 * (this.getCurrentX() - center.getX()), 0.0);
    }

    public ParadiseID getMoleculeId() {
        return ((Residue)this.residue2D.getResidues().iterator().next()).getMoleculeId();
    }

    public boolean equals(Object obj) {
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        return ((Residue)this.residue2D.getResidues().iterator().next()).equals(((Residue2D)obj).residue2D.getResidues().iterator().next());
    }

    public int compareTo(Object o) {
        if (!Residue2D.class.isInstance(o)) {
            return -1;
        }
        if (!this.getMoleculeId().equals((Object)((Residue2D)o).getMoleculeId())) {
            return this.getMoleculeId().toString().compareTo(((Residue2D)o).getMoleculeId().toString());
        }
        return new Integer(this.getAbsolutePosition()).compareTo(new Integer(((Residue2D)o).getAbsolutePosition()));
    }
}

