/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.ssviewer.graphics;

import fr.unistra.ibmc.assemble.gui.Assemble;
import fr.unistra.ibmc.assemble.gui.SecondaryStructureNavigator;
import fr.unistra.ibmc.assemble.ssviewer.features.Model2D;
import fr.unistra.ibmc.assemble.ssviewer.graphics.Rna2DViewer;
import fr.unistra.ibmc.assemble.ssviewer.graphics.SecondaryCanvas;
import fr.unistra.ibmc.assemble.ssviewer.graphics.State;
import fr.unistra.ibmc.assemble.ssviewer.graphics.StructSelect;
import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructureDisplay;

public class Mediator {
    SecondaryStructureNavigator secondaryStructureNavigator;
    private State currentState;
    private Rna2DViewer viewer;
    private boolean linked = true;
    private Molecule linkMolecule = null;
    private int linkPosition = -1;

    Mediator(Rna2DViewer viewer) {
        this.viewer = viewer;
        this.currentState = new StructSelect(this);
    }

    public Rna2DViewer getRna2DViewer() {
        return this.viewer;
    }

    public SecondaryCanvas getSecondaryCanvas() {
        return this.viewer.getSecondaryCanvas();
    }

    public Assemble getAssemble() {
        return this.viewer.getAssembleMediator().getAssemble();
    }

    State getCurrentState() {
        return this.currentState;
    }

    Model2D getModel2D() {
        return this.getSecondaryCanvas().getModel2D();
    }

    void setModel2D(SecondaryStructure ss, SecondaryStructureDisplay ssd) {
        this.getSecondaryCanvas().setModel2D(ss, ssd);
    }

    void setState(State state) {
        this.currentState = state;
    }

    void isLinked(boolean linked) {
        this.linked = linked;
    }

    boolean isLinked() {
        return this.linked;
    }

    void setToBeLinked(Molecule molecule, int position) {
        this.linkMolecule = molecule;
        this.linkPosition = position;
    }

    void clearToBeLinked() {
        this.linkMolecule = null;
        this.linkPosition = -1;
    }

    public boolean isToBeLinked(Molecule molecule, int position) {
        return this.linkMolecule == molecule && this.linkPosition == position;
    }

    public void insertNodeIntoExplorer(Object parentNode, Object newNode) {
        this.secondaryStructureNavigator.insertNode(parentNode, newNode);
    }

    public void removeNodeFromExplorer(Object parentNode, Object childNode) {
        this.secondaryStructureNavigator.removeNode(parentNode, childNode);
    }

    public void updateNodeInExplorer(Object parentNode, Object childNode) {
        this.secondaryStructureNavigator.updateNode(parentNode, childNode);
    }

    public void setSecondaryStructureNavigator(SecondaryStructureNavigator secondaryStructureNavigator) {
        this.secondaryStructureNavigator = secondaryStructureNavigator;
    }
}

