/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.structures;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.gui.event.AtomListener;
import fr.unistra.ibmc.assemble.structures.Atom;
import fr.unistra.ibmc.assemble.structures.AtomSet;
import fr.unistra.ibmc.assemble.structures.AtomsSelection;
import fr.unistra.ibmc.assemble.structures.Link;
import fr.unistra.ibmc.assemble.structures.Residue;
import fr.unistra.ibmc.paradise.core.features.StructuralDomain;
import fr.unistra.ibmc.paradise.utils.TBMath;

public class Angle
implements AtomListener {
    public AtomSet willBeRotated;
    private Residue residue;
    private boolean twistNext = false;
    private boolean twistPrevious = false;
    private boolean valid = false;
    private String name;
    private Atom[] atoms;
    float value;
    private Mediator mediator;

    public Angle(Residue r, Atom b1, Atom b2, Atom b3, Atom b4, String name, boolean previous, boolean next, Mediator mediator) {
        this.mediator = mediator;
        this.willBeRotated = new AtomSet(mediator);
        this.residue = r;
        this.twistNext = next;
        this.twistPrevious = previous;
        this.atoms = new Atom[]{b1, b2, b3, b4};
        this.name = name;
        if (b1 != null && b2 != null && b3 != null && b4 != null) {
            b1.addAtomListener(this);
            b2.addAtomListener(this);
            b3.addAtomListener(this);
            b4.addAtomListener(this);
            this.valid = true;
        }
        this.computeValue();
    }

    public void setAtoms(Atom b1, Atom b2, Atom b3, Atom b4) {
        this.atoms[0] = b1;
        this.atoms[1] = b2;
        this.atoms[2] = b3;
        this.atoms[3] = b4;
        if (b1 != null && b2 != null && b3 != null && b4 != null) {
            b1.addAtomListener(this);
            b2.addAtomListener(this);
            b3.addAtomListener(this);
            b4.addAtomListener(this);
            this.valid = true;
        } else {
            this.valid = false;
        }
    }

    private void computeValue() {
        this.value = !this.valid ? 0.0f : TBMath.dihedral((float[])this.atoms[0].getFloat(), (float[])this.atoms[1].getFloat(), (float[])this.atoms[2].getFloat(), (float[])this.atoms[3].getFloat());
    }

    public float getRadianValue() {
        if (this.valid) {
            this.computeValue();
        }
        return this.value;
    }

    public float getDegreeValue() {
        if (this.valid) {
            this.computeValue();
        }
        return this.value * (float)TBMath.RadianToDegree;
    }

    public String getName() {
        return this.name;
    }

    public boolean isValid() {
        return this.valid;
    }

    public Link getAxis() {
        return new Link(this.mediator, this.atoms[1], this.atoms[2]);
    }

    public void torsDegree(float degreeAngle, boolean affectStructuralDomain) {
        StructuralDomain sd;
        AtomsSelection sel = new AtomsSelection(this.mediator);
        sel.add(this.willBeRotated);
        if (this.twistNext) {
            this.residue.addNextToSelection(sel);
            if (affectStructuralDomain) {
                sd = this.mediator.get3DModel().getSecondaryStructure().getEnclosingStructuralDomain((fr.unistra.ibmc.paradise.core.utils.Residue)this.residue.getResidue3D().getResidues().iterator().next());
                for (Atom a : this.mediator.getAssemble().getAtomsForStructuralDomain(sd).getAtoms()) {
                    sel.add(a);
                }
            }
        }
        if (this.twistPrevious) {
            this.residue.addPreviousToSelection(sel);
            if (affectStructuralDomain) {
                sd = this.mediator.get3DModel().getSecondaryStructure().getEnclosingStructuralDomain((fr.unistra.ibmc.paradise.core.utils.Residue)this.residue.getResidue3D().getResidues().iterator().next());
                for (Atom a : this.mediator.getAssemble().getAtomsForStructuralDomain(sd).getAtoms()) {
                    sel.add(a);
                }
            }
        }
        sel.rotateAroundLinkDegree(this.getAxis(), degreeAngle);
        this.mediator.get3DModel().fireModelModified();
        this.computeValue();
    }

    public void torsToDegree(float degreeAngle, boolean affectStructuralDomain) {
        float valueCanonical = (degreeAngle + 360.0f) % 360.0f;
        float actualValue = (this.getDegreeValue() + 360.0f) % 360.0f;
        this.torsDegree(actualValue - valueCanonical, affectStructuralDomain);
    }

    public void atomMoved() {
        this.computeValue();
    }

    public void remove(Atom atom) {
        if (this.atoms[0] == atom) {
            this.atoms[0] = null;
            this.valid = false;
            return;
        }
        if (this.atoms[1] == atom) {
            this.atoms[1] = null;
            this.valid = false;
            return;
        }
        if (this.atoms[2] == atom) {
            this.atoms[2] = null;
            this.valid = false;
            return;
        }
        if (this.atoms[3] == atom) {
            this.atoms[3] = null;
            this.valid = false;
        }
    }
}

