/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.structures;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.structures.AbstractDrawable;
import fr.unistra.ibmc.assemble.structures.Model3D;
import fr.unistra.ibmc.assemble.structures.Residue;
import fr.unistra.ibmc.assemble.structures.Undoable;
import fr.unistra.ibmc.assemble.structures.aminoAcids.ResidueAA;
import fr.unistra.ibmc.assemble.structures.nucleicAcids.ResidueNA;
import fr.unistra.ibmc.assemble.structures.nucleicAcids.ResidueRNA;
import fr.unistra.ibmc.paradise.BiologicalSymbolException;
import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.features.Residue3D;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.media.opengl.GL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Chain
extends AbstractDrawable
implements Undoable {
    public static char chainID = (char)65;
    public Model3D model3D;
    private char name;
    private List<Residue> residues;
    private Map<String, List<Residue>> undoResidues;

    public Chain(Mediator mediator, char name) {
        super(mediator);
        this.name = name;
        this.residues = new ArrayList<Residue>();
        this.undoResidues = new HashMap<String, List<Residue>>();
    }

    @Override
    public void addUndoStep(String stateName) {
        this.undoResidues.put(stateName, new ArrayList<Residue>(this.residues));
        for (Residue res : this.residues) {
            res.addUndoStep(stateName);
        }
    }

    @Override
    public void restoreState(String stateName) {
        this.residues = new ArrayList<Residue>((Collection)this.undoResidues.get(stateName));
        for (Residue r : this.residues) {
            r.setChain(this);
            r.restoreState(stateName);
        }
    }

    @Override
    public void removeState(String stateName) {
        List<Residue> _residues = this.undoResidues.get(stateName);
        for (Residue r : _residues) {
            r.removeState(stateName);
        }
        this.undoResidues.remove(stateName);
    }

    public Residue getResidue(int i) {
        return this.residues.get(i);
    }

    public Molecule getMolecule() {
        if (this.residues.size() > 0) {
            return ((Molecule.Annotation)this.residues.get(0).getResidue3D().getAnnotations().get(0)).getMolecule();
        }
        return null;
    }

    public List<Residue> getResidues() {
        return this.residues;
    }

    public void extendChain(Residue r) {
        if (r != null) {
            if (r.getChain() != null) {
                r.getChain().removeResidue(r);
            }
            r.setChain(this);
            this.residues.add(r);
            Collections.sort(this.residues, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((Residue)o1).getResidue3D().getFullLocation((Molecule)((Residue)o1).getResidue3D().getMolecules().iterator().next()).getStart() - ((Residue)o2).getResidue3D().getFullLocation((Molecule)((Residue)o2).getResidue3D().getMolecules().iterator().next()).getStart();
                }
            });
            if (this.residues.size() > 1) {
                this.residues.get(this.residues.size() - 2).setNext(r);
                r.setPrev(this.residues.get(this.residues.size() - 2));
            }
            this.mediator.get3DModel().fireModelModified();
        }
    }

    public void removeResidue(Residue r) {
        r.setChain(null);
        this.residues.remove(r);
        r.setPrev(null);
        r.setNext(null);
        if (this.getLength() == 0) {
            this.mediator.get3DModel().removeChain(this);
        }
    }

    public int getLength() {
        return this.residues.size();
    }

    public int indexOf(Residue r) {
        return this.residues.indexOf(r);
    }

    public boolean containsResidue(Residue r) {
        return this.residues.contains(r);
    }

    public Residue getFirstResidue(Class c) {
        for (Residue residue : this.residues) {
            if (!c.isInstance(residue)) continue;
            return residue;
        }
        return null;
    }

    @Override
    public void draw(GL gl) {
        for (Residue residue : this.residues) {
            residue.draw(gl);
        }
    }

    public void drawSelectScene(GL gl) {
        for (Residue residue : this.residues) {
            residue.drawSelectScene(gl);
        }
    }

    public void translate(float x, float y, float z) {
        for (Residue residue : this.residues) {
            residue.translate(x, y, z);
        }
    }

    public int getChainIndex() {
        int i = 0;
        for (Chain chain : this.model3D.getChains()) {
            if (this == chain) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public char getName() {
        return this.name;
    }

    public void setName(char name) {
        this.name = name;
    }

    public void restoreAFormConformation() {
        for (Residue residue : this.residues) {
            ((ResidueNA)residue).restoreAFormConformation();
        }
    }

    public String getType() {
        if (this.getLength() > 0) {
            if (this.getResidue(0) instanceof ResidueRNA) {
                return "rna";
            }
            if (this.getResidue(0) instanceof ResidueAA) {
                return "protein";
            }
        }
        return "unknown";
    }

    public String getSequence() {
        StringBuffer seq = new StringBuffer();
        for (Residue residue : this.residues) {
            seq.append(residue.getName().charAt(0));
        }
        return seq.toString();
    }

    public String getNumberingTable() {
        String ret = "\t\t\t\t";
        for (int i = 0; i < this.getLength(); ++i) {
            ret = ret + "\t" + this.getResidue(i).getNumber();
            if (i % 10 != 9) continue;
            ret = ret + "\n";
        }
        return ret;
    }

    public Residue getResidueFor(Residue3D paradiseResidue) {
        for (Residue residue : this.residues) {
            if (!residue.matches(paradiseResidue)) continue;
            return residue;
        }
        return null;
    }

    public void saveCoordinatesToParadise() {
        for (Residue residue : this.residues) {
            residue.saveCoordinatesToParadise();
        }
    }

    public boolean isBefore(Chain chain) {
        Molecule m1 = this.getMolecule();
        Molecule m2 = chain.getMolecule();
        if (this.getLength() == 0 || chain.getLength() == 0) {
            return true;
        }
        if (m1 == m2) {
            return this.getResidue(0).getResidue3D().getFullLocation(m1).getStart() < chain.getResidue(0).getResidue3D().getFullLocation(m1).getStart();
        }
        List molecules = this.mediator.getAssemble().getWorkingSession().getMolecules();
        return molecules.indexOf(m1) < molecules.indexOf(m2);
    }

    public static List<Chain> order(List<Chain> chains) {
        ArrayList<Chain> ret = new ArrayList<Chain>();
        for (Chain chain : chains) {
            boolean added = false;
            for (Chain tmp : ret) {
                if (chain.getResidues().size() == 0 || tmp.getResidues().size() == 0 || chain.getResidue(0).getNumber() >= tmp.getResidue(0).getNumber()) continue;
                ret.add(ret.indexOf(tmp), chain);
                added = true;
                break;
            }
            if (added) continue;
            ret.add(chain);
        }
        return ret;
    }

    public boolean before(Chain c) {
        return this.model3D.getChains().indexOf(this) <= c.model3D.getChains().indexOf(c);
    }

    public void pairWith(Chain c) throws BiologicalSymbolException {
        int s = this.getLength();
        if (s < 1) {
            if (c.getLength() != s) {
                System.err.println("You are trying to pair two chains with different lengths");
            } else if (!(this.getResidue(0) instanceof ResidueNA) || !(c.getResidue(0) instanceof ResidueNA)) {
                System.err.println("At least one of the chain you are trying to pair doesn't contains Nucleic Acids");
            } else {
                for (int i = 0; i < s; ++i) {
                    ResidueNA r1 = (ResidueNA)this.getResidue(i);
                    ResidueNA r2 = (ResidueNA)c.getResidue(s - 1 - i);
                    r1.setPair(r2);
                }
            }
        }
    }

    public void setColor(Color c) {
        for (Residue r : this.residues) {
            r.setColor(c);
        }
        this.fireRenderingModified();
    }

    @Override
    public void setRenderingMode(int mode) {
        for (Residue r : this.residues) {
            r.setRenderingMode(mode);
        }
        this.fireRenderingModified();
    }
}

