/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.structures;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.gui.event.ModelListener;
import fr.unistra.ibmc.assemble.gui.labels.Label;
import fr.unistra.ibmc.assemble.gui.rendering.OpenGLColor;
import fr.unistra.ibmc.assemble.structures.AbstractDrawable;
import fr.unistra.ibmc.assemble.structures.Atom;
import fr.unistra.ibmc.assemble.structures.Chain;
import fr.unistra.ibmc.assemble.structures.Residue;
import fr.unistra.ibmc.assemble.structures.Undoable;
import fr.unistra.ibmc.assemble.structures.nucleicAcids.ResidueNA;
import fr.unistra.ibmc.paradise.core.Location;
import fr.unistra.ibmc.paradise.core.Molecule;
import fr.unistra.ibmc.paradise.core.Protein;
import fr.unistra.ibmc.paradise.core.RNA;
import fr.unistra.ibmc.paradise.core.features.BaseBaseInteraction;
import fr.unistra.ibmc.paradise.core.features.Helix;
import fr.unistra.ibmc.paradise.core.features.Residue3D;
import fr.unistra.ibmc.paradise.core.features.SecondaryStructure;
import fr.unistra.ibmc.paradise.core.features.TertiaryStructure;
import fr.unistra.ibmc.paradise.core.io.PDBFileIO;
import fr.unistra.ibmc.paradise.utils.ParsingException;
import fr.unistra.ibmc.paradise.utils.TBMath;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.media.opengl.GL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Model3D
extends AbstractDrawable
implements Undoable {
    private List<ModelListener> modelListeners;
    private List<Label> labels;
    private List<Chain> chains = new ArrayList<Chain>();
    private TertiaryStructure tertiaryStructure;
    private SecondaryStructure secondaryStructure;
    private Map<String, List<Chain>> undoChains;

    public Model3D(Mediator mediator, SecondaryStructure ss, TertiaryStructure ts) {
        super(mediator);
        this.modelListeners = new ArrayList<ModelListener>();
        this.labels = new ArrayList<Label>();
        this.setSecondaryStructure(ss);
        this.tertiaryStructure = ts;
        this.undoChains = new HashMap<String, List<Chain>>();
    }

    public void translate(float[] f) {
        for (Chain c : this.chains) {
            for (Residue r : c.getResidues()) {
                for (Atom a : r.getAtoms()) {
                    a.translate(f);
                }
            }
        }
    }

    public float[] getCenter() {
        float[] center = new float[]{0.0f, 0.0f, 0.0f};
        int atomNb = 0;
        for (Chain c : this.chains) {
            for (Residue r : c.getResidues()) {
                for (Atom a : r.getAtoms()) {
                    ++atomNb;
                    float[] atc = a.getFloat();
                    for (int i = 0; i < 3; ++i) {
                        int n = i;
                        center[n] = center[n] + atc[i];
                    }
                }
            }
        }
        for (int i = 0; i < 3; ++i) {
            center[i] = center[i] / (float)atomNb;
        }
        return center;
    }

    public List<Residue> getResidues() {
        ArrayList<Residue> residues = new ArrayList<Residue>();
        for (Chain c : this.chains) {
            residues.addAll(c.getResidues());
        }
        return residues;
    }

    public List<Atom> getAtoms() {
        ArrayList<Atom> atoms = new ArrayList<Atom>();
        for (Residue r : this.getResidues()) {
            atoms.addAll(r.getAtoms());
        }
        return atoms;
    }

    public void addLabel(Label label) {
        this.labels.add(label);
        this.fireRenderingModified();
    }

    public void hideLabelsForSelection() {
        ArrayList<Label> _labels = new ArrayList<Label>(this.labels);
        block0: for (Label l : _labels) {
            for (Atom a : l.getAtoms()) {
                if (this.mediator.getGlobalSelection().getSelectedAtoms().contains(a)) continue;
                continue block0;
            }
            this.labels.remove(l);
        }
        this.fireRenderingModified();
    }

    public void hideLabels() {
        this.labels.clear();
        this.fireRenderingModified();
    }

    public Residue getResidue(fr.unistra.ibmc.paradise.core.utils.Residue paradiseResidue) {
        for (Chain c : this.chains) {
            for (Residue _r : c.getResidues()) {
                if (!((fr.unistra.ibmc.paradise.core.utils.Residue)_r.getResidue3D().getResidues().getResidues().iterator().next()).equals((Object)paradiseResidue)) continue;
                return _r;
            }
        }
        return null;
    }

    public void addModelListener(ModelListener l) {
        this.modelListeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.modelListeners.remove(l);
    }

    public void eraseResidue(Residue r) {
        r.getChain().removeResidue(r);
    }

    public Chain getChain(int i) {
        return this.chains.get(i);
    }

    public List<Chain> getChains() {
        return this.chains;
    }

    public boolean contains(Molecule m) {
        for (Chain c : this.chains) {
            if (c.getMolecule() != m) continue;
            return true;
        }
        return false;
    }

    public ArrayList<Chain> getChains(Molecule molecule) {
        ArrayList<Chain> ret = new ArrayList<Chain>();
        for (Chain chain : this.chains) {
            if (chain.getMolecule() != molecule) continue;
            ret.add(chain);
        }
        return ret;
    }

    public void addChain(Chain chain) {
        chain.model3D = this;
        this.chains.add(chain);
    }

    public void removeChain(Chain chain) {
        chain.model3D = null;
        this.chains.remove(chain);
    }

    public boolean containsChain(Chain c) {
        return this.chains.contains(c);
    }

    public Residue3D getResidue3DAt(Molecule m, int position) {
        List anns = m.getAnnotations(new Location(position));
        for (Molecule.Annotation ann : anns) {
            if (!(ann.getFeature() instanceof Residue3D)) continue;
            return (Residue3D)ann.getFeature();
        }
        return null;
    }

    public void initialize() {
        this.extendModel(this.tertiaryStructure.getResidues3D());
        this.mediator.getGlobalSelection().clear();
    }

    public void extendModel(List<Residue3D> residues) {
        if (residues.size() > 0) {
            this.mediator.getGlobalSelection().clear();
            ArrayList<ResidueNA> allResidues = new ArrayList<ResidueNA>();
            for (Residue3D residue3D : residues) {
                ResidueNA residueNA = ResidueNA.createResidueNA(residue3D, this.mediator);
                allResidues.add(residueNA);
            }
            int lastPosition = -1;
            int lastMoleculeID = -1;
            int lastStructuralDomainID = -1;
            Chain chain = null;
            for (ResidueNA res : allResidues) {
                fr.unistra.ibmc.paradise.core.utils.Residue _r = (fr.unistra.ibmc.paradise.core.utils.Residue)res.getResidue3D().getResidues().iterator().next();
                int currentPosition = _r.getAbsolutePosition();
                int currentMoleculeID = _r.getMoleculeId().hashCode();
                int currentStructuralDomainID = this.secondaryStructure.getEnclosingStructuralDomain((fr.unistra.ibmc.paradise.core.utils.Residue)res.getResidue3D().getResidues().iterator().next()).hashCode();
                if (currentPosition - 1 != lastPosition || currentMoleculeID != lastMoleculeID || currentStructuralDomainID != lastStructuralDomainID) {
                    if (chain != null) {
                        this.mediator.getGlobalSelection().add(chain);
                    }
                    char c = Chain.chainID;
                    Chain.chainID = (char)(c + '\u0001');
                    chain = new Chain(this.mediator, c);
                    this.addChain(chain);
                }
                chain.extendChain(res);
                lastPosition = currentPosition;
                lastMoleculeID = currentMoleculeID;
                lastStructuralDomainID = currentStructuralDomainID;
            }
            if (chain != null) {
                this.mediator.getGlobalSelection().add(chain);
            }
            this.mediator.getRenderer().setPivot(this.mediator.getGlobalSelection().getSelectionCenter());
            this.mediator.getGlobalSelection().fireRenderingModified();
            this.fireModelModified();
        }
    }

    public TertiaryStructure getTertiaryStructure() {
        return this.tertiaryStructure;
    }

    public SecondaryStructure getSecondaryStructure() {
        return this.secondaryStructure;
    }

    public boolean hasStructuralInformation(SecondaryStructure ss, RNA rna) {
        for (Helix f : ss.getHelices()) {
            if (!f.annotates((Molecule)rna)) continue;
            return true;
        }
        for (Helix f : ss.getSingleStrands()) {
            if (!f.annotates((Molecule)rna)) continue;
            return true;
        }
        return false;
    }

    public void bindAllChains() {
        for (Molecule molecule : this.mediator.getAssemble().getWorkingSession().getMolecules()) {
            this.bindAllChains(molecule);
        }
    }

    public void bindAllChains(Molecule molecule) {
    }

    public void renameChains() {
        int id = 65;
        for (Chain chain : this.getChains()) {
            chain.setName((char)id);
            id = (char)(id + '\u0001');
            if (id == 91) {
                id = 97;
            }
            if (id == 123) {
                id = 48;
            }
            if (id != 58) continue;
            id = 65;
        }
    }

    public void fireModelModified() {
        for (ModelListener m : this.modelListeners) {
            m.modelModified();
        }
    }

    public void fireModelRejected() {
        for (ModelListener m : this.modelListeners) {
            m.modelRejected();
        }
    }

    public void exportAsPDB(File f) throws IOException, ParsingException {
        ArrayList<Residue3D> residues = new ArrayList<Residue3D>();
        for (Residue r : this.mediator.get3DModel().getResidues()) {
            r.saveCoordinatesToParadise();
            residues.add(r.getResidue3D());
        }
        try {
            PDBFileIO.writePDBFile(residues, (boolean)true, (File)f);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void draw(GL gl) {
        for (Chain chain : this.chains) {
            chain.draw(gl);
        }
        for (Label l : this.labels) {
            l.draw(gl);
        }
    }

    public Residue3D getResidue(Molecule m, int p, TertiaryStructure ts) {
        for (Residue3D r : ts.getResidues3D()) {
            if (!r.annotates(m) || r.getFullLocation(m).getStart() != p) continue;
            return r;
        }
        return null;
    }

    public boolean containsProteins() {
        for (Molecule mol : this.mediator.getAssemble().getWorkingSession().getMolecules()) {
            if (!(mol instanceof Protein)) continue;
            return true;
        }
        return false;
    }

    private void drawBaseBaseInteraction(GL gl, Atom a1, Atom a2, char type) {
        float min = 2.7f;
        float max = 3.1f;
        Color color = Color.WHITE;
        switch (type) {
            case 'H': {
                min = 2.7f;
                max = 3.1f;
                color = Color.WHITE;
                break;
            }
            case 'C': {
                min = 2.8f;
                max = 4.0f;
                color = Color.GREEN;
                break;
            }
            case 'W': {
                min = 3.3f;
                max = 5.0f;
                color = Color.BLUE;
                break;
            }
            case 'M': {
                min = 1.8f;
                max = 2.2f;
                color = Color.ORANGE;
                break;
            }
            case 'N': {
                min = 3.0f;
                max = 3.5f;
                color = Color.ORANGE;
            }
        }
        float[] p1 = a1.getFloat();
        float[] p2 = a2.getFloat();
        float[] m = TBMath.middle((float[])p1, (float[])p2);
        float d = TBMath.distance((float[])p1, (float[])m);
        float[] mm1 = TBMath.multVectorScalar((float[])TBMath.vector((float[])m, (float[])p1), (float)(min / (2.0f * d)));
        float[] m1 = TBMath.sumVectors((float[])m, (float[])mm1);
        float[] mM1 = TBMath.multVectorScalar((float[])TBMath.vector((float[])m, (float[])p1), (float)(max / (2.0f * d)));
        float[] M1 = TBMath.sumVectors((float[])m, (float[])mM1);
        float[] mm2 = TBMath.multVectorScalar((float[])TBMath.vector((float[])m, (float[])p2), (float)(min / (2.0f * d)));
        float[] m2 = TBMath.sumVectors((float[])m, (float[])mm2);
        float[] mM2 = TBMath.multVectorScalar((float[])TBMath.vector((float[])m, (float[])p2), (float)(max / (2.0f * d)));
        float[] M2 = TBMath.sumVectors((float[])m, (float[])mM2);
        OpenGLColor oglColor = new OpenGLColor(color);
        gl.glColor3fv(oglColor.getRGBOpenGl(), 0);
        gl.glLineWidth(0.5f);
        gl.glEnable(2852);
        gl.glLineStipple(1, (short)257);
        gl.glBegin(1);
        if (TBMath.distance((float[])p1, (float[])p2) < max) {
            gl.glVertex3fv(m1, 0);
            gl.glVertex3fv(m2, 0);
        } else {
            gl.glVertex3fv(p1, 0);
            gl.glVertex3fv(p2, 0);
        }
        gl.glEnd();
        gl.glDisable(2852);
        gl.glColor3f(1.0f, 0.0f, 0.0f);
        gl.glBegin(1);
        gl.glVertex3fv(m1, 0);
        gl.glVertex3fv(M1, 0);
        gl.glVertex3fv(m2, 0);
        gl.glVertex3fv(M2, 0);
        gl.glEnd();
    }

    public void drawSelectScene(GL gl) {
        for (Chain chain : this.getChains()) {
            chain.drawSelectScene(gl);
        }
    }

    @Override
    public void addUndoStep(String stateName) {
        this.undoChains.put(stateName, new ArrayList<Chain>(this.chains));
        for (Chain chain : this.chains) {
            chain.addUndoStep(stateName);
        }
    }

    @Override
    public void restoreState(String stateName) {
        this.chains = new ArrayList<Chain>((Collection)this.undoChains.get(stateName));
        for (Chain c : this.chains) {
            c.restoreState(stateName);
        }
    }

    @Override
    public void removeState(String stateName) {
        List<Chain> _chains = this.undoChains.get(stateName);
        for (Chain c : _chains) {
            c.removeState(stateName);
        }
        this.undoChains.remove(stateName);
    }

    public Residue getResidueFor(Residue3D paradiseResidue) {
        for (Chain chain : this.chains) {
            Residue residue = chain.getResidueFor(paradiseResidue);
            if (residue == null) continue;
            return residue;
        }
        return null;
    }

    public Atom getAtomFor(Residue3D.Atom paradiseAtom) {
        Residue residue = this.getResidueFor(paradiseAtom.getResidue3D());
        if (residue != null) {
            return residue.getAtomFor(paradiseAtom);
        }
        return null;
    }

    public Atom getAtomByID(int id) {
        for (Chain c : this.chains) {
            for (Residue r : c.getResidues()) {
                for (Atom atom : r.getAtoms()) {
                    if (atom.getObjId() != id) continue;
                    return atom;
                }
            }
        }
        return null;
    }

    public void saveCoordinatesToParadise() {
        for (Chain chain : this.chains) {
            chain.saveCoordinatesToParadise();
        }
    }

    public SecondaryStructure getCurrentSecondaryStructure() {
        return this.secondaryStructure;
    }

    public void setSecondaryStructure(SecondaryStructure ss) {
        for (BaseBaseInteraction bbi : ss.getBaseBaseInteractions()) {
            if (bbi.getAtomAtomInteractions().size() != 0) continue;
            bbi.generateAtomAtomInteractions();
        }
        this.secondaryStructure = ss;
    }

    public void stackBuildingBlockInOrder(RNA rna) {
    }
}

