/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.structures.aminoAcids;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.gui.rendering.OpenGLColor;
import fr.unistra.ibmc.assemble.structures.Atom;
import fr.unistra.ibmc.assemble.structures.Link;
import fr.unistra.ibmc.assemble.structures.Residue;
import fr.unistra.ibmc.assemble.structures.aminoAcids.SideChain;
import fr.unistra.ibmc.paradise.core.features.Residue3D;
import java.awt.Color;

public class GlnSC
extends SideChain {
    Atom CB;
    Atom H1B;
    Atom H2B;
    Atom CG;
    Atom H1G;
    Atom H2G;
    Atom CD;
    Atom OE1;
    Atom NE2;
    Atom H1E2;
    Atom H2E2;
    Link CBH1B;
    Link CBH2B;
    Link CBCG;
    Link CGH1G;
    Link CGH2G;
    Link CGCD;
    Link CDOE1;
    Link CDNE2;
    Link NE2H1E2;
    Link NE2H2E2;
    private static OpenGLColor standardColor = new OpenGLColor(Color.MAGENTA);

    public GlnSC(Residue r, Mediator mediator) {
        super(mediator);
        this.residue = r;
    }

    public boolean parseResidue3D(Residue3D.Atom atom) {
        String name = atom.getName();
        if (name.equals("CB")) {
            this.CB = new Atom(this.mediator, atom, this.residue, 6);
            return true;
        }
        if (name.equals("1HB")) {
            this.H1B = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("2HB")) {
            this.H2B = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("CG")) {
            this.CG = new Atom(this.mediator, atom, this.residue, 6);
            return true;
        }
        if (name.equals("1HG")) {
            this.H1G = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("2HG")) {
            this.H2G = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("CD")) {
            this.CD = new Atom(this.mediator, atom, this.residue, 6);
            return true;
        }
        if (name.equals("OE1")) {
            this.OE1 = new Atom(this.mediator, atom, this.residue, 8);
            return true;
        }
        if (name.equals("NE2")) {
            this.NE2 = new Atom(this.mediator, atom, this.residue, 7);
            return true;
        }
        if (name.equals("1HE2")) {
            this.H1E2 = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("2HE2")) {
            this.H2E2 = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        return false;
    }

    public void generateAtoms() {
        if (this.CB != null) {
            this.add(this.CB);
        }
        this.first = this.CB;
        if (this.H1B != null) {
            this.add(this.H1B);
        }
        if (this.H2B != null) {
            this.add(this.H2B);
        }
        if (this.CG != null) {
            this.add(this.CG);
        }
        if (this.H1G != null) {
            this.add(this.H1G);
        }
        if (this.H2G != null) {
            this.add(this.H2G);
        }
        if (this.CD != null) {
            this.add(this.CD);
        }
        if (this.OE1 != null) {
            this.add(this.OE1);
        }
        if (this.NE2 != null) {
            this.add(this.NE2);
        }
        if (this.H1E2 != null) {
            this.add(this.H1E2);
        }
        if (this.H2E2 != null) {
            this.add(this.H2E2);
        }
    }

    public void generateInternalLinks() {
        this.CBH1B = Link.createLink(this.mediator, this.CB, this.H1B);
        this.CBH2B = Link.createLink(this.mediator, this.CB, this.H2B);
        this.CBCG = Link.createLink(this.mediator, this.CB, this.CG);
        this.CGH1G = Link.createLink(this.mediator, this.CG, this.H1G);
        this.CGH2G = Link.createLink(this.mediator, this.CG, this.H2G);
        this.CGCD = Link.createLink(this.mediator, this.CG, this.CD);
        this.CDOE1 = Link.createLink(this.mediator, this.CD, this.OE1);
        this.CDNE2 = Link.createLink(this.mediator, this.CD, this.NE2);
        this.NE2H1E2 = Link.createLink(this.mediator, this.NE2, this.H1E2);
        this.NE2H2E2 = Link.createLink(this.mediator, this.NE2, this.H2E2);
        if (this.CBH1B != null) {
            this.links.add(this.CBH1B);
        }
        if (this.CBH2B != null) {
            this.links.add(this.CBH2B);
        }
        if (this.CBCG != null) {
            this.links.add(this.CBCG);
        }
        if (this.CGH1G != null) {
            this.links.add(this.CGH1G);
        }
        if (this.CGH2G != null) {
            this.links.add(this.CGH2G);
        }
        if (this.CGCD != null) {
            this.links.add(this.CGCD);
        }
        if (this.CDOE1 != null) {
            this.links.add(this.CDOE1);
        }
        if (this.CDNE2 != null) {
            this.links.add(this.CDNE2);
        }
        if (this.NE2H1E2 != null) {
            this.links.add(this.NE2H1E2);
        }
        if (this.NE2H2E2 != null) {
            this.links.add(this.NE2H2E2);
        }
    }

    public OpenGLColor getStandardColor() {
        return standardColor;
    }
}

