/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.structures.aminoAcids;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.gui.rendering.OpenGLColor;
import fr.unistra.ibmc.assemble.structures.Atom;
import fr.unistra.ibmc.assemble.structures.Link;
import fr.unistra.ibmc.assemble.structures.Residue;
import fr.unistra.ibmc.assemble.structures.aminoAcids.SideChain;
import fr.unistra.ibmc.paradise.core.features.Residue3D;
import java.awt.Color;

public class LeuSC
extends SideChain {
    Atom CB;
    Atom H1B;
    Atom H2B;
    Atom CG;
    Atom HG;
    Atom CD1;
    Atom H1D1;
    Atom H2D1;
    Atom H3D1;
    Atom CD2;
    Atom H1D2;
    Atom H2D2;
    Atom H3D2;
    Link CBH1B;
    Link CBH2B;
    Link CBCG;
    Link CGHG;
    Link CGCD1;
    Link CD1H1D1;
    Link CD1H2D1;
    Link CD1H3D1;
    Link CGCD2;
    Link CD2H1D2;
    Link CD2H2D2;
    Link CD2H3D2;
    private static OpenGLColor standardColor = new OpenGLColor(Color.GREEN);

    public LeuSC(Residue r, Mediator mediator) {
        super(mediator);
        this.residue = r;
    }

    public boolean parseResidue3D(Residue3D.Atom atom) {
        String name = atom.getName();
        if (name.equals("CB")) {
            this.CB = new Atom(this.mediator, atom, this.residue, 6);
            return true;
        }
        if (name.equals("1HB")) {
            this.H1B = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("2HB")) {
            this.H2B = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("CG")) {
            this.CG = new Atom(this.mediator, atom, this.residue, 6);
            return true;
        }
        if (name.equals("HG")) {
            this.HG = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("CD1")) {
            this.CD1 = new Atom(this.mediator, atom, this.residue, 6);
            return true;
        }
        if (name.equals("1HD1")) {
            this.H1D1 = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("2HD1")) {
            this.H2D1 = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("3HD1")) {
            this.H3D1 = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("CD2")) {
            this.CD2 = new Atom(this.mediator, atom, this.residue, 6);
            return true;
        }
        if (name.equals("1HD2")) {
            this.H1D2 = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("2HD2")) {
            this.H2D2 = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("3HD2")) {
            this.H3D2 = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        return false;
    }

    public void generateAtoms() {
        if (this.CB != null) {
            this.add(this.CB);
        }
        this.first = this.CB;
        if (this.H1B != null) {
            this.add(this.H1B);
        }
        if (this.H2B != null) {
            this.add(this.H2B);
        }
        if (this.CG != null) {
            this.add(this.CG);
        }
        if (this.HG != null) {
            this.add(this.HG);
        }
        if (this.CD1 != null) {
            this.add(this.CD1);
        }
        if (this.H1D1 != null) {
            this.add(this.H1D1);
        }
        if (this.H2D1 != null) {
            this.add(this.H2D1);
        }
        if (this.H3D1 != null) {
            this.add(this.H3D1);
        }
        if (this.CD2 != null) {
            this.add(this.CD2);
        }
        if (this.H1D2 != null) {
            this.add(this.H1D2);
        }
        if (this.H2D2 != null) {
            this.add(this.H2D2);
        }
        if (this.H3D2 != null) {
            this.add(this.H3D2);
        }
    }

    public void generateInternalLinks() {
        this.CBH1B = Link.createLink(this.mediator, this.CB, this.H1B);
        if (this.CBH1B != null) {
            this.links.add(this.CBH1B);
        }
        if ((this.CBH2B = Link.createLink(this.mediator, this.CB, this.H2B)) != null) {
            this.links.add(this.CBH2B);
        }
        if ((this.CBCG = Link.createLink(this.mediator, this.CB, this.CG)) != null) {
            this.links.add(this.CBCG);
        }
        if ((this.CGHG = Link.createLink(this.mediator, this.CG, this.HG)) != null) {
            this.links.add(this.CGHG);
        }
        if ((this.CGCD1 = Link.createLink(this.mediator, this.CG, this.CD1)) != null) {
            this.links.add(this.CGCD1);
        }
        if ((this.CD1H1D1 = Link.createLink(this.mediator, this.CD1, this.H1D1)) != null) {
            this.links.add(this.CD1H1D1);
        }
        if ((this.CD1H2D1 = Link.createLink(this.mediator, this.CD1, this.H2D1)) != null) {
            this.links.add(this.CD1H2D1);
        }
        if ((this.CD1H3D1 = Link.createLink(this.mediator, this.CD1, this.H3D1)) != null) {
            this.links.add(this.CD1H3D1);
        }
        if ((this.CGCD2 = Link.createLink(this.mediator, this.CG, this.CD2)) != null) {
            this.links.add(this.CGCD2);
        }
        if ((this.CD2H1D2 = Link.createLink(this.mediator, this.CD2, this.H1D2)) != null) {
            this.links.add(this.CD2H1D2);
        }
        if ((this.CD2H2D2 = Link.createLink(this.mediator, this.CD2, this.H2D2)) != null) {
            this.links.add(this.CD2H2D2);
        }
        if ((this.CD2H3D2 = Link.createLink(this.mediator, this.CD2, this.H3D2)) != null) {
            this.links.add(this.CD2H3D2);
        }
    }

    public OpenGLColor getStandardColor() {
        return standardColor;
    }
}

