/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.structures.aminoAcids;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.gui.rendering.OpenGLColor;
import fr.unistra.ibmc.assemble.structures.Atom;
import fr.unistra.ibmc.assemble.structures.Link;
import fr.unistra.ibmc.assemble.structures.Residue;
import fr.unistra.ibmc.assemble.structures.aminoAcids.SideChain;
import fr.unistra.ibmc.paradise.core.features.Residue3D;
import java.awt.Color;

public class LysSC
extends SideChain {
    Atom CB;
    Atom H1B;
    Atom H2B;
    Atom CG;
    Atom H1G;
    Atom H2G;
    Atom CD;
    Atom H1D;
    Atom H2D;
    Atom CE;
    Atom H1E;
    Atom H2E;
    Atom NZ;
    Atom H1Z;
    Atom H2Z;
    Atom H3Z;
    Link CBH1B;
    Link CBH2B;
    Link CBCG;
    Link CGH1G;
    Link CGH2G;
    Link CGCD;
    Link CDH1D;
    Link CDH2D;
    Link CDCE;
    Link CEH1E;
    Link CEH2E;
    Link CENZ;
    Link NZH1Z;
    Link NZH2Z;
    Link NZH3Z;
    private static OpenGLColor standardColor = new OpenGLColor(Color.CYAN);

    public LysSC(Residue r, Mediator mediator) {
        super(mediator);
        this.residue = r;
    }

    public boolean parseResidue3D(Residue3D.Atom atom) {
        String name = atom.getName();
        if (name.equals("CB")) {
            this.CB = new Atom(this.mediator, atom, this.residue, 6);
            return true;
        }
        if (name.equals("1HB")) {
            this.H1B = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("2HB")) {
            this.H2B = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("CG")) {
            this.CG = new Atom(this.mediator, atom, this.residue, 6);
            return true;
        }
        if (name.equals("1HG")) {
            this.H1G = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("2HG")) {
            this.H2G = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("CD")) {
            this.CD = new Atom(this.mediator, atom, this.residue, 6);
            return true;
        }
        if (name.equals("1HD")) {
            this.H1D = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("2HD")) {
            this.H2D = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("CE")) {
            this.CE = new Atom(this.mediator, atom, this.residue, 6);
            return true;
        }
        if (name.equals("1HE")) {
            this.H1E = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("2HE")) {
            this.H2E = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("NZ")) {
            this.NZ = new Atom(this.mediator, atom, this.residue, 7);
            return true;
        }
        if (name.equals("1HZ")) {
            this.H1Z = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("2HZ")) {
            this.H2Z = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("3HZ")) {
            this.H3Z = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        return false;
    }

    public void generateAtoms() {
        if (this.CB != null) {
            this.add(this.CB);
        }
        this.first = this.CB;
        if (this.H1B != null) {
            this.add(this.H1B);
        }
        if (this.H2B != null) {
            this.add(this.H2B);
        }
        if (this.CG != null) {
            this.add(this.CG);
        }
        if (this.H1G != null) {
            this.add(this.H1G);
        }
        if (this.H2G != null) {
            this.add(this.H2G);
        }
        if (this.CD != null) {
            this.add(this.CD);
        }
        if (this.H1D != null) {
            this.add(this.H1D);
        }
        if (this.H2D != null) {
            this.add(this.H2D);
        }
        if (this.CE != null) {
            this.add(this.CE);
        }
        if (this.H1E != null) {
            this.add(this.H1E);
        }
        if (this.H2E != null) {
            this.add(this.H2E);
        }
        if (this.NZ != null) {
            this.add(this.NZ);
        }
        if (this.H1Z != null) {
            this.add(this.H1Z);
        }
        if (this.H2Z != null) {
            this.add(this.H2Z);
        }
        if (this.H3Z != null) {
            this.add(this.H3Z);
        }
    }

    public void generateInternalLinks() {
        this.CBH1B = Link.createLink(this.mediator, this.CB, this.H1B);
        if (this.CBH1B != null) {
            this.links.add(this.CBH1B);
        }
        if ((this.CBH2B = Link.createLink(this.mediator, this.CB, this.H2B)) != null) {
            this.links.add(this.CBH2B);
        }
        if ((this.CBCG = Link.createLink(this.mediator, this.CB, this.CG)) != null) {
            this.links.add(this.CBCG);
        }
        if ((this.CGH1G = Link.createLink(this.mediator, this.CG, this.H1G)) != null) {
            this.links.add(this.CGH1G);
        }
        if ((this.CGH2G = Link.createLink(this.mediator, this.CG, this.H2G)) != null) {
            this.links.add(this.CGH2G);
        }
        if ((this.CGCD = Link.createLink(this.mediator, this.CG, this.CD)) != null) {
            this.links.add(this.CGCD);
        }
        if ((this.CDH1D = Link.createLink(this.mediator, this.CD, this.H1D)) != null) {
            this.links.add(this.CDH1D);
        }
        if ((this.CDH2D = Link.createLink(this.mediator, this.CD, this.H2D)) != null) {
            this.links.add(this.CDH2D);
        }
        if ((this.CDCE = Link.createLink(this.mediator, this.CD, this.CE)) != null) {
            this.links.add(this.CDCE);
        }
        if ((this.CEH1E = Link.createLink(this.mediator, this.CE, this.H1E)) != null) {
            this.links.add(this.CEH1E);
        }
        if ((this.CEH2E = Link.createLink(this.mediator, this.CE, this.H2E)) != null) {
            this.links.add(this.CEH2E);
        }
        if ((this.CENZ = Link.createLink(this.mediator, this.CE, this.NZ)) != null) {
            this.links.add(this.CENZ);
        }
        if ((this.NZH1Z = Link.createLink(this.mediator, this.NZ, this.H1Z)) != null) {
            this.links.add(this.NZH1Z);
        }
        if ((this.NZH2Z = Link.createLink(this.mediator, this.NZ, this.H2Z)) != null) {
            this.links.add(this.NZH2Z);
        }
        if ((this.NZH3Z = Link.createLink(this.mediator, this.NZ, this.H3Z)) != null) {
            this.links.add(this.NZH3Z);
        }
    }

    public OpenGLColor getStandardColor() {
        return standardColor;
    }
}

