/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.structures.aminoAcids;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.gui.rendering.OpenGLColor;
import fr.unistra.ibmc.assemble.structures.Atom;
import fr.unistra.ibmc.assemble.structures.Link;
import fr.unistra.ibmc.assemble.structures.Residue;
import fr.unistra.ibmc.assemble.structures.aminoAcids.SideChain;
import fr.unistra.ibmc.paradise.core.features.Residue3D;
import java.awt.Color;

public class PheSC
extends SideChain {
    Atom CB;
    Atom H1B;
    Atom H2B;
    Atom CG;
    Atom CD1;
    Atom HD1;
    Atom CD2;
    Atom HD2;
    Atom CE1;
    Atom HE1;
    Atom CE2;
    Atom HE2;
    Atom CZ;
    Atom HZ;
    Link CBH1B;
    Link CBH2B;
    Link CBCG;
    Link CGCD1;
    Link CD1HD1;
    Link CD1CE1;
    Link CE1HE1;
    Link CE1CZ;
    Link CZHZ;
    Link CZCE2;
    Link CE2HE2;
    Link CE2CD2;
    Link CD2HD2;
    Link CD2CG;
    private static OpenGLColor standardColor = new OpenGLColor(Color.GREEN);

    public PheSC(Residue r, Mediator mediator) {
        super(mediator);
        this.residue = r;
    }

    public boolean parseResidue3D(Residue3D.Atom atom) {
        String name = atom.getName();
        if (name.equals("CB")) {
            this.CB = new Atom(this.mediator, atom, this.residue, 6);
            return true;
        }
        if (name.equals("1HB")) {
            this.H1B = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("2HB")) {
            this.H2B = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("CG")) {
            this.CG = new Atom(this.mediator, atom, this.residue, 6);
            return true;
        }
        if (name.equals("CD1")) {
            this.CD1 = new Atom(this.mediator, atom, this.residue, 6);
            return true;
        }
        if (name.equals("HD1")) {
            this.HD1 = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("CD2")) {
            this.CD2 = new Atom(this.mediator, atom, this.residue, 6);
            return true;
        }
        if (name.equals("HD2")) {
            this.HD2 = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("CE1")) {
            this.CE1 = new Atom(this.mediator, atom, this.residue, 6);
            return true;
        }
        if (name.equals("HE1")) {
            this.HE1 = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("CE2")) {
            this.CE2 = new Atom(this.mediator, atom, this.residue, 6);
            return true;
        }
        if (name.equals("HE2")) {
            this.HE2 = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("CZ")) {
            this.CZ = new Atom(this.mediator, atom, this.residue, 6);
            return true;
        }
        if (name.equals("HZ")) {
            this.HZ = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        return false;
    }

    public void generateAtoms() {
        if (this.CB != null) {
            this.add(this.CB);
        }
        this.first = this.CB;
        if (this.H1B != null) {
            this.add(this.H1B);
        }
        if (this.H2B != null) {
            this.add(this.H2B);
        }
        if (this.CG != null) {
            this.add(this.CG);
        }
        if (this.CD1 != null) {
            this.add(this.CD1);
        }
        if (this.HD1 != null) {
            this.add(this.HD1);
        }
        if (this.CD2 != null) {
            this.add(this.CD2);
        }
        if (this.HD2 != null) {
            this.add(this.HD2);
        }
        if (this.CE1 != null) {
            this.add(this.CE1);
        }
        if (this.HE1 != null) {
            this.add(this.HE1);
        }
        if (this.CE2 != null) {
            this.add(this.CE2);
        }
        if (this.HE2 != null) {
            this.add(this.HE2);
        }
        if (this.CZ != null) {
            this.add(this.CZ);
        }
        if (this.HZ != null) {
            this.add(this.HZ);
        }
    }

    public void generateInternalLinks() {
        this.CBH1B = Link.createLink(this.mediator, this.CB, this.H1B);
        if (this.CBH1B != null) {
            this.links.add(this.CBH1B);
        }
        if ((this.CBH2B = Link.createLink(this.mediator, this.CB, this.H2B)) != null) {
            this.links.add(this.CBH2B);
        }
        if ((this.CBCG = Link.createLink(this.mediator, this.CB, this.CG)) != null) {
            this.links.add(this.CBCG);
        }
        if ((this.CGCD1 = Link.createLink(this.mediator, this.CG, this.CD1)) != null) {
            this.links.add(this.CGCD1);
        }
        if ((this.CD1HD1 = Link.createLink(this.mediator, this.CD1, this.HD1)) != null) {
            this.links.add(this.CD1HD1);
        }
        if ((this.CD1CE1 = Link.createLink(this.mediator, this.CD1, this.CE1)) != null) {
            this.links.add(this.CD1CE1);
        }
        if ((this.CE1HE1 = Link.createLink(this.mediator, this.CE1, this.HE1)) != null) {
            this.links.add(this.CE1HE1);
        }
        if ((this.CE1CZ = Link.createLink(this.mediator, this.CE1, this.CZ)) != null) {
            this.links.add(this.CE1CZ);
        }
        if ((this.CZHZ = Link.createLink(this.mediator, this.CZ, this.HZ)) != null) {
            this.links.add(this.CZHZ);
        }
        if ((this.CZCE2 = Link.createLink(this.mediator, this.CZ, this.CE2)) != null) {
            this.links.add(this.CZCE2);
        }
        if ((this.CE2HE2 = Link.createLink(this.mediator, this.CE2, this.HE2)) != null) {
            this.links.add(this.CE2HE2);
        }
        if ((this.CE2CD2 = Link.createLink(this.mediator, this.CE2, this.CD2)) != null) {
            this.links.add(this.CE2CD2);
        }
        if ((this.CD2HD2 = Link.createLink(this.mediator, this.CD2, this.HD2)) != null) {
            this.links.add(this.CD2HD2);
        }
        if ((this.CD2CG = Link.createLink(this.mediator, this.CD2, this.CG)) != null) {
            this.links.add(this.CD2CG);
        }
    }

    public OpenGLColor getStandardColor() {
        return standardColor;
    }
}

