/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.structures.aminoAcids;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.gui.rendering.OpenGLColor;
import fr.unistra.ibmc.assemble.structures.Angle;
import fr.unistra.ibmc.assemble.structures.Atom;
import fr.unistra.ibmc.assemble.structures.AtomSet;
import fr.unistra.ibmc.assemble.structures.Link;
import fr.unistra.ibmc.assemble.structures.Residue;
import fr.unistra.ibmc.assemble.structures.aminoAcids.Alanine;
import fr.unistra.ibmc.assemble.structures.aminoAcids.Arginine;
import fr.unistra.ibmc.assemble.structures.aminoAcids.Asparagine;
import fr.unistra.ibmc.assemble.structures.aminoAcids.AsparticAcid;
import fr.unistra.ibmc.assemble.structures.aminoAcids.Cysteine;
import fr.unistra.ibmc.assemble.structures.aminoAcids.GlutamicAcid;
import fr.unistra.ibmc.assemble.structures.aminoAcids.Glutamine;
import fr.unistra.ibmc.assemble.structures.aminoAcids.Glycine;
import fr.unistra.ibmc.assemble.structures.aminoAcids.Histidine;
import fr.unistra.ibmc.assemble.structures.aminoAcids.Isoleucine;
import fr.unistra.ibmc.assemble.structures.aminoAcids.Leucine;
import fr.unistra.ibmc.assemble.structures.aminoAcids.Lysine;
import fr.unistra.ibmc.assemble.structures.aminoAcids.Methionine;
import fr.unistra.ibmc.assemble.structures.aminoAcids.Phenylalanine;
import fr.unistra.ibmc.assemble.structures.aminoAcids.Proline;
import fr.unistra.ibmc.assemble.structures.aminoAcids.Serine;
import fr.unistra.ibmc.assemble.structures.aminoAcids.SideChain;
import fr.unistra.ibmc.assemble.structures.aminoAcids.Threonine;
import fr.unistra.ibmc.assemble.structures.aminoAcids.Tryptophane;
import fr.unistra.ibmc.assemble.structures.aminoAcids.Tyrosine;
import fr.unistra.ibmc.assemble.structures.aminoAcids.Valine;
import fr.unistra.ibmc.paradise.core.features.Alanine3D;
import fr.unistra.ibmc.paradise.core.features.AminoAcid3D;
import fr.unistra.ibmc.paradise.core.features.Arginine3D;
import fr.unistra.ibmc.paradise.core.features.Asparagine3D;
import fr.unistra.ibmc.paradise.core.features.AsparticAcid3D;
import fr.unistra.ibmc.paradise.core.features.Cysteine3D;
import fr.unistra.ibmc.paradise.core.features.GlutamicAcid3D;
import fr.unistra.ibmc.paradise.core.features.Glutamine3D;
import fr.unistra.ibmc.paradise.core.features.Glycine3D;
import fr.unistra.ibmc.paradise.core.features.Histidine3D;
import fr.unistra.ibmc.paradise.core.features.Isoleucine3D;
import fr.unistra.ibmc.paradise.core.features.Leucine3D;
import fr.unistra.ibmc.paradise.core.features.Lysine3D;
import fr.unistra.ibmc.paradise.core.features.Methionine3D;
import fr.unistra.ibmc.paradise.core.features.Phenylalanine3D;
import fr.unistra.ibmc.paradise.core.features.Proline3D;
import fr.unistra.ibmc.paradise.core.features.Residue3D;
import fr.unistra.ibmc.paradise.core.features.Serine3D;
import fr.unistra.ibmc.paradise.core.features.Threonine3D;
import fr.unistra.ibmc.paradise.core.features.Tryptophane3D;
import fr.unistra.ibmc.paradise.core.features.Tyrosine3D;
import fr.unistra.ibmc.paradise.core.features.Valine3D;

public class ResidueAA
extends Residue {
    SideChain sc;
    Atom N;
    Atom H;
    Atom HN2;
    Atom C;
    Atom OXT;
    Atom HXT;
    Atom CA;
    Atom HA;
    Atom O;
    Link NH;
    Link NHN2;
    Link COXT;
    Link OXTHXT;
    Link CO;
    Link CAHA;
    Link CAN;
    Link CAC;
    Link CASideChain;
    Angle psiAC;
    Angle phiAC;
    Angle psiCA;
    Angle phiCA;

    public ResidueAA(Residue3D res3D, Mediator mediator) {
        super(res3D, mediator);
        this.types.add("AA");
    }

    public static ResidueAA createResidueAA(Residue3D residue3D, Mediator mediator) {
        if (!(residue3D instanceof AminoAcid3D)) {
            System.err.println("This residue is not an Amino Acid " + residue3D.getClass().getName());
            return null;
        }
        if (residue3D instanceof Alanine3D) {
            return new Alanine((Alanine3D)residue3D, mediator);
        }
        if (residue3D instanceof Arginine3D) {
            return new Arginine((Arginine3D)residue3D, mediator);
        }
        if (residue3D instanceof Asparagine3D) {
            return new Asparagine((Asparagine3D)residue3D, mediator);
        }
        if (residue3D instanceof AsparticAcid3D) {
            return new AsparticAcid((AsparticAcid3D)residue3D, mediator);
        }
        if (residue3D instanceof Cysteine3D) {
            return new Cysteine((Cysteine3D)residue3D, mediator);
        }
        if (residue3D instanceof GlutamicAcid3D) {
            return new GlutamicAcid((GlutamicAcid3D)residue3D, mediator);
        }
        if (residue3D instanceof Glutamine3D) {
            return new Glutamine((Glutamine3D)residue3D, mediator);
        }
        if (residue3D instanceof Glycine3D) {
            return new Glycine((Glycine3D)residue3D, mediator);
        }
        if (residue3D instanceof Histidine3D) {
            return new Histidine((Histidine3D)residue3D, mediator);
        }
        if (residue3D instanceof Isoleucine3D) {
            return new Isoleucine((Isoleucine3D)residue3D, mediator);
        }
        if (residue3D instanceof Leucine3D) {
            return new Leucine((Leucine3D)residue3D, mediator);
        }
        if (residue3D instanceof Lysine3D) {
            return new Lysine((Lysine3D)residue3D, mediator);
        }
        if (residue3D instanceof Methionine3D) {
            return new Methionine((Methionine3D)residue3D, mediator);
        }
        if (residue3D instanceof Phenylalanine3D) {
            return new Phenylalanine((Phenylalanine3D)residue3D, mediator);
        }
        if (residue3D instanceof Proline3D) {
            return new Proline((Proline3D)residue3D, mediator);
        }
        if (residue3D instanceof Serine3D) {
            return new Serine((Serine3D)residue3D, mediator);
        }
        if (residue3D instanceof Threonine3D) {
            return new Threonine((Threonine3D)residue3D, mediator);
        }
        if (residue3D instanceof Tryptophane3D) {
            return new Tryptophane((Tryptophane3D)residue3D, mediator);
        }
        if (residue3D instanceof Tyrosine3D) {
            return new Tyrosine((Tyrosine3D)residue3D, mediator);
        }
        if (residue3D instanceof Valine3D) {
            return new Valine((Valine3D)residue3D, mediator);
        }
        System.err.println("Unknown residue3D for Assemble: " + residue3D.getClass().getName());
        return null;
    }

    public boolean parseResidue3D(Residue3D.Atom atom) {
        String name = atom.getName();
        boolean ret = false;
        if (ret) {
            return ret;
        }
        ret = this.sc.parseResidue3D(atom);
        if (ret) {
            return ret;
        }
        if (name.equals("N")) {
            this.N = new Atom(this.mediator, atom, this, 7);
            return true;
        }
        if (name.equals("H")) {
            this.H = new Atom(this.mediator, atom, this, 1);
            return true;
        }
        if (name.equals("HN2")) {
            this.HN2 = new Atom(this.mediator, atom, this, 1);
            return true;
        }
        if (name.equals("CA")) {
            this.CA = new Atom(this.mediator, atom, this, 6);
            return true;
        }
        if (name.equals("HA")) {
            this.HA = new Atom(this.mediator, atom, this, 1);
            return true;
        }
        if (name.equals("C")) {
            this.C = new Atom(this.mediator, atom, this, 6);
            return true;
        }
        if (name.equals("OXT")) {
            this.OXT = new Atom(this.mediator, atom, this, 8);
            return true;
        }
        if (name.equals("O")) {
            this.O = new Atom(this.mediator, atom, this, 8);
            return true;
        }
        if (name.equals("HXT")) {
            this.HXT = new Atom(this.mediator, atom, this, 1);
            return true;
        }
        if (!ret) {
            this.unknownAtoms.add(new Atom(this.mediator, atom, this, 1));
        }
        return ret;
    }

    public float[] getCoordCA() {
        if (this.CA == null) {
            return new float[]{0.0f, 0.0f, 0.0f};
        }
        return this.CA.getFloat();
    }

    public void generatePreviousLinks() {
        super.generatePreviousLinks();
    }

    public void generateNextLinks() {
    }

    public void generateInternalLinks() {
        this.sc.generateInternalLinks();
        this.NH = Link.createLink(this.mediator, this.N, this.H);
        this.NHN2 = Link.createLink(this.mediator, this.N, this.HN2);
        this.CAN = Link.createLink(this.mediator, this.CA, this.N);
        this.CAHA = Link.createLink(this.mediator, this.CA, this.HA);
        this.CAC = Link.createLink(this.mediator, this.CA, this.C);
        this.COXT = Link.createLink(this.mediator, this.C, this.OXT);
        this.CO = Link.createLink(this.mediator, this.C, this.O);
        this.OXTHXT = Link.createLink(this.mediator, this.OXT, this.HXT);
        this.CASideChain = Link.createLink(this.mediator, this.CA, this.sc.first);
        if (this.NH != null) {
            this.links.add(this.NH);
        }
        if (this.NHN2 != null) {
            this.links.add(this.NHN2);
        }
        if (this.CAN != null) {
            this.links.add(this.CAN);
        }
        if (this.CAHA != null) {
            this.links.add(this.CAHA);
        }
        if (this.CAC != null) {
            this.links.add(this.CAC);
        }
        if (this.COXT != null) {
            this.links.add(this.COXT);
        }
        if (this.CO != null) {
            this.links.add(this.CO);
        }
        if (this.OXTHXT != null) {
            this.links.add(this.OXTHXT);
        }
        if (this.CASideChain != null) {
            this.links.add(this.CASideChain);
        }
        for (int i = 0; i < this.sc.links.size(); ++i) {
            this.links.add(this.sc.links.get(i));
        }
    }

    public void generateAtoms() {
        if (this.getAtoms().size() > 0) {
            this.sc.generateAtoms();
            this.begining = this.N != null ? this.N : this.getAtoms().iterator().next();
            this.ending = this.C != null ? this.C : this.getAtoms().iterator().next();
            this.backBone = this.CA != null ? this.CA : this.getAtoms().iterator().next();
        }
        for (Atom atom : this.unknownAtoms) {
            this.getAtoms().add(atom);
        }
    }

    public void generatePreviousAngles() {
        Atom pr = null;
        if (this.getPrev() != null) {
            pr = ((ResidueAA)this.getPrev()).C;
        }
        this.phiAC.setAtoms(pr, this.N, this.CA, this.C);
        this.phiCA.setAtoms(this.C, this.CA, this.N, pr);
        this.phiAC.willBeRotated = new AtomSet(this.mediator);
        this.phiAC.willBeRotated.add(this.sc);
        this.phiAC.willBeRotated.add(this.HA);
        this.phiAC.willBeRotated.add(this.C);
        this.phiAC.willBeRotated.add(this.OXT);
        this.phiCA.willBeRotated = new AtomSet(this.mediator);
        this.phiCA.willBeRotated.add(this.H);
    }

    public void generateNextAngles() {
        Atom nx = null;
        if (this.getNext() != null) {
            nx = ((ResidueAA)this.getNext()).N;
        }
        this.psiAC.setAtoms(this.N, this.CA, this.C, nx);
        this.psiCA.setAtoms(nx, this.C, this.CA, this.N);
        this.psiAC.willBeRotated = new AtomSet(this.mediator);
        this.psiAC.willBeRotated.add(this.OXT);
        this.psiCA.willBeRotated = new AtomSet(this.mediator);
        this.psiCA.willBeRotated.add(this.HA);
        this.psiCA.willBeRotated.add(this.N);
        this.psiCA.willBeRotated.add(this.H);
        this.psiCA.willBeRotated.add(this.sc);
    }

    public void generateInternalAngles() {
        this.phiAC = new Angle(this, null, this.N, this.CA, this.C, "Phi animo->carboxyl", false, true, this.mediator);
        this.phiCA = new Angle(this, this.C, this.CA, this.N, null, "Phi carboxyl->animo", true, false, this.mediator);
        this.psiAC = new Angle(this, this.N, this.CA, this.C, null, "Psi animo->carboxyl", false, true, this.mediator);
        this.psiCA = new Angle(this, null, this.C, this.CA, this.N, "Psi carboxyl->animo", true, false, this.mediator);
        this.anglesDirect.add(this.phiAC);
        this.anglesDirect.add(this.psiAC);
        this.anglesIndirect.add(this.phiCA);
        this.anglesIndirect.add(this.psiCA);
    }

    public void deleteAtom(Atom atom) {
        super.deleteAtom(atom, true);
        this.sc.removeAtom(atom);
        this.sc.removeLinks(atom);
    }

    public OpenGLColor getStandardColor() {
        return this.sc.getStandardColor();
    }
}

