/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.structures.aminoAcids;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.gui.rendering.OpenGLColor;
import fr.unistra.ibmc.assemble.structures.Atom;
import fr.unistra.ibmc.assemble.structures.Link;
import fr.unistra.ibmc.assemble.structures.Residue;
import fr.unistra.ibmc.assemble.structures.aminoAcids.SideChain;
import fr.unistra.ibmc.paradise.core.features.Residue3D;
import java.awt.Color;

public class ThrSC
extends SideChain {
    Atom CB;
    Atom HB;
    Atom OG1;
    Atom HG1;
    Atom CG2;
    Atom H1G2;
    Atom H2G2;
    Atom H3G2;
    Link CBH1B;
    Link CBOG1;
    Link OG1HG1;
    Link CBCG2;
    Link CG2H1G2;
    Link CG2H2G2;
    Link CG2H3G2;
    private static OpenGLColor standardColor = new OpenGLColor(Color.MAGENTA);

    public ThrSC(Residue r, Mediator mediator) {
        super(mediator);
        this.residue = r;
    }

    public boolean parseResidue3D(Residue3D.Atom atom) {
        String name = atom.getName();
        if (name.equals("CB")) {
            this.CB = new Atom(this.mediator, atom, this.residue, 6);
            return true;
        }
        if (name.equals("HB")) {
            this.HB = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("HG1")) {
            this.HG1 = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("OG1")) {
            this.OG1 = new Atom(this.mediator, atom, this.residue, 8);
            return true;
        }
        if (name.equals("CG2")) {
            this.CG2 = new Atom(this.mediator, atom, this.residue, 6);
            return true;
        }
        if (name.equals("1HG2")) {
            this.H1G2 = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("2HG2")) {
            this.H2G2 = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("3HG2")) {
            this.H3G2 = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        return false;
    }

    public void generateAtoms() {
        if (this.CB != null) {
            this.add(this.CB);
        }
        this.first = this.CB;
        if (this.HB != null) {
            this.add(this.HB);
        }
        if (this.HG1 != null) {
            this.add(this.HG1);
        }
        if (this.OG1 != null) {
            this.add(this.OG1);
        }
        if (this.CG2 != null) {
            this.add(this.CG2);
        }
        if (this.H1G2 != null) {
            this.add(this.H1G2);
        }
        if (this.H2G2 != null) {
            this.add(this.H2G2);
        }
        if (this.H3G2 != null) {
            this.add(this.H3G2);
        }
    }

    public void generateInternalLinks() {
        this.CBH1B = Link.createLink(this.mediator, this.CB, this.HB);
        this.CBOG1 = Link.createLink(this.mediator, this.CB, this.OG1);
        this.OG1HG1 = Link.createLink(this.mediator, this.OG1, this.HG1);
        this.CBCG2 = Link.createLink(this.mediator, this.CB, this.CG2);
        this.CG2H1G2 = Link.createLink(this.mediator, this.CG2, this.H1G2);
        this.CG2H2G2 = Link.createLink(this.mediator, this.CG2, this.H2G2);
        this.CG2H3G2 = Link.createLink(this.mediator, this.CG2, this.H3G2);
        if (this.CBH1B != null) {
            this.links.add(this.CBH1B);
        }
        if (this.CBOG1 != null) {
            this.links.add(this.CBOG1);
        }
        if (this.OG1HG1 != null) {
            this.links.add(this.OG1HG1);
        }
        if (this.CBCG2 != null) {
            this.links.add(this.CBCG2);
        }
        if (this.CG2H1G2 != null) {
            this.links.add(this.CG2H1G2);
        }
        if (this.CG2H2G2 != null) {
            this.links.add(this.CG2H2G2);
        }
        if (this.CG2H3G2 != null) {
            this.links.add(this.CG2H3G2);
        }
    }

    public OpenGLColor getStandardColor() {
        return standardColor;
    }
}

