/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.structures.aminoAcids;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.gui.rendering.OpenGLColor;
import fr.unistra.ibmc.assemble.structures.Atom;
import fr.unistra.ibmc.assemble.structures.Link;
import fr.unistra.ibmc.assemble.structures.Residue;
import fr.unistra.ibmc.assemble.structures.aminoAcids.SideChain;
import fr.unistra.ibmc.paradise.core.features.Residue3D;
import java.awt.Color;

public class ValSC
extends SideChain {
    Atom CB;
    Atom HB;
    Atom CG1;
    Atom H1G1;
    Atom H2G1;
    Atom H3G1;
    Atom CG2;
    Atom H1G2;
    Atom H2G2;
    Atom H3G2;
    Link CCB;
    Link CO;
    Link CBHB;
    Link CBCG1;
    Link CG1H1G1;
    Link CG1H2G1;
    Link CG1H3G1;
    Link CBCG2;
    Link CG2H1G2;
    Link CG2H2G2;
    Link CG2H3G2;
    private static OpenGLColor standardColor = new OpenGLColor(Color.GREEN);

    public ValSC(Residue r, Mediator mediator) {
        super(mediator);
        this.residue = r;
    }

    public boolean parseResidue3D(Residue3D.Atom atom) {
        String name = atom.getName();
        if (name.equals("CB")) {
            this.CB = new Atom(this.mediator, atom, this.residue, 6);
            return true;
        }
        if (name.equals("HB")) {
            this.HB = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("CG1")) {
            this.CG1 = new Atom(this.mediator, atom, this.residue, 6);
            return true;
        }
        if (name.equals("1HG1")) {
            this.H1G1 = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("2HG1")) {
            this.H2G1 = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("3HG1")) {
            this.H3G1 = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("CG2")) {
            this.CG2 = new Atom(this.mediator, atom, this.residue, 6);
            return true;
        }
        if (name.equals("1HG2")) {
            this.H1G2 = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("2HG2")) {
            this.H2G2 = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("3HG2")) {
            this.H3G2 = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        return false;
    }

    public void generateAtoms() {
        if (this.CB != null) {
            this.add(this.CB);
        }
        this.first = this.CB;
        if (this.HB != null) {
            this.add(this.HB);
        }
        if (this.CG1 != null) {
            this.add(this.CG1);
        }
        if (this.H1G1 != null) {
            this.add(this.H1G1);
        }
        if (this.H2G1 != null) {
            this.add(this.H2G1);
        }
        if (this.H3G1 != null) {
            this.add(this.H3G1);
        }
        if (this.CG2 != null) {
            this.add(this.CG2);
        }
        if (this.H1G2 != null) {
            this.add(this.H1G2);
        }
        if (this.H2G2 != null) {
            this.add(this.H2G2);
        }
        if (this.H3G2 != null) {
            this.add(this.H3G2);
        }
    }

    public void generateInternalLinks() {
        this.CBHB = Link.createLink(this.mediator, this.CB, this.HB);
        this.CBCG1 = Link.createLink(this.mediator, this.CB, this.CG1);
        this.CG1H1G1 = Link.createLink(this.mediator, this.CG1, this.H1G1);
        this.CG1H2G1 = Link.createLink(this.mediator, this.CG1, this.H2G1);
        this.CG1H3G1 = Link.createLink(this.mediator, this.CG1, this.H3G1);
        this.CBCG2 = Link.createLink(this.mediator, this.CB, this.CG2);
        this.CG2H1G2 = Link.createLink(this.mediator, this.CG2, this.H1G2);
        this.CG2H2G2 = Link.createLink(this.mediator, this.CG2, this.H2G2);
        this.CG2H3G2 = Link.createLink(this.mediator, this.CG2, this.H3G2);
        if (this.CO != null) {
            this.links.add(this.CO);
        }
        if (this.CCB != null) {
            this.links.add(this.CCB);
        }
        if (this.CBHB != null) {
            this.links.add(this.CBHB);
        }
        if (this.CBCG1 != null) {
            this.links.add(this.CBCG1);
        }
        if (this.CG1H1G1 != null) {
            this.links.add(this.CG1H1G1);
        }
        if (this.CG1H2G1 != null) {
            this.links.add(this.CG1H2G1);
        }
        if (this.CG1H3G1 != null) {
            this.links.add(this.CG1H3G1);
        }
        if (this.CBCG2 != null) {
            this.links.add(this.CBCG2);
        }
        if (this.CG2H1G2 != null) {
            this.links.add(this.CG2H1G2);
        }
        if (this.CG2H2G2 != null) {
            this.links.add(this.CG2H2G2);
        }
        if (this.CG2H3G2 != null) {
            this.links.add(this.CG2H3G2);
        }
    }

    public OpenGLColor getStandardColor() {
        return standardColor;
    }
}

