/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.structures.nucleicAcids;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.gui.rendering.OpenGLColor;
import fr.unistra.ibmc.assemble.structures.Atom;
import fr.unistra.ibmc.assemble.structures.Link;
import fr.unistra.ibmc.assemble.structures.Residue;
import fr.unistra.ibmc.assemble.structures.nucleicAcids.Base;
import fr.unistra.ibmc.paradise.core.features.Residue3D;
import java.awt.Color;
import javax.media.opengl.GL;

public class Cytosine
extends Base {
    Residue residue;
    Atom N1 = null;
    Atom C2 = null;
    Atom O2 = null;
    Atom N3 = null;
    Atom C4 = null;
    Atom N4 = null;
    Atom H1N4 = null;
    Atom H2N4 = null;
    Atom C5 = null;
    Atom HC5 = null;
    Atom C6 = null;
    Atom HC6 = null;
    Link N1C2 = null;
    Link C2O2 = null;
    Link C2N3 = null;
    Link N3C4 = null;
    Link C4N4 = null;
    Link N4H1N4 = null;
    Link N4H2N4 = null;
    Link C4C5 = null;
    Link C5HC5 = null;
    Link C5C6 = null;
    Link C6HC6 = null;
    Link C6N1 = null;
    private static OpenGLColor standardColor = new OpenGLColor(Color.BLUE);

    public Cytosine(Residue r, Mediator mediator) {
        super(mediator);
        this.setColor(standardColor);
        this.residue = r;
        this.residue.types.add("Cytosine");
        this.residue.types.add("C");
    }

    public boolean parseResidue3D(Residue3D.Atom atom) {
        String name = atom.getName();
        if (name.equals("N1")) {
            this.firstChi = this.N1 = new Atom(this.mediator, atom, this.residue, 7);
            return true;
        }
        if (name.equals("C2")) {
            this.secondChi = this.C2 = new Atom(this.mediator, atom, this.residue, 6);
            return true;
        }
        if (name.equals("O2")) {
            this.O2 = new Atom(this.mediator, atom, this.residue, 8);
            return true;
        }
        if (name.equals("N3")) {
            this.N3 = new Atom(this.mediator, atom, this.residue, 7);
            return true;
        }
        if (name.equals("C4")) {
            this.C4 = new Atom(this.mediator, atom, this.residue, 6);
            return true;
        }
        if (name.equals("N4")) {
            this.N4 = new Atom(this.mediator, atom, this.residue, 7);
            return true;
        }
        if (name.equals("1H4")) {
            this.H1N4 = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("2H4")) {
            this.H2N4 = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("C5")) {
            this.C5 = new Atom(this.mediator, atom, this.residue, 6);
            return true;
        }
        if (name.equals("H5")) {
            this.HC5 = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        if (name.equals("C6")) {
            this.C6 = new Atom(this.mediator, atom, this.residue, 6);
            return true;
        }
        if (name.equals("H6")) {
            this.HC6 = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        return false;
    }

    public void generateAtoms() {
        if (this.N1 != null) {
            this.add(this.N1);
        }
        if (this.C2 != null) {
            this.add(this.C2);
        }
        if (this.O2 != null) {
            this.add(this.O2);
        }
        if (this.N3 != null) {
            this.add(this.N3);
        }
        if (this.C4 != null) {
            this.add(this.C4);
        }
        if (this.N4 != null) {
            this.add(this.N4);
        }
        if (this.H1N4 != null) {
            this.add(this.H1N4);
        }
        if (this.H2N4 != null) {
            this.add(this.H2N4);
        }
        if (this.C5 != null) {
            this.add(this.C5);
        }
        if (this.HC5 != null) {
            this.add(this.HC5);
        }
        if (this.C6 != null) {
            this.add(this.C6);
        }
        if (this.HC6 != null) {
            this.add(this.HC6);
        }
    }

    public void generateInternalLinks() {
        this.N1C2 = Link.createLink(this.mediator, this.N1, this.C2);
        this.C2O2 = Link.createLink(this.mediator, this.C2, this.O2);
        this.C2N3 = Link.createLink(this.mediator, this.C2, this.N3);
        this.N3C4 = Link.createLink(this.mediator, this.N3, this.C4);
        this.C4N4 = Link.createLink(this.mediator, this.C4, this.N4);
        this.N4H1N4 = Link.createLink(this.mediator, this.N4, this.H1N4);
        this.N4H2N4 = Link.createLink(this.mediator, this.N4, this.H2N4);
        this.C4C5 = Link.createLink(this.mediator, this.C4, this.C5);
        this.C5HC5 = Link.createLink(this.mediator, this.C5, this.HC5);
        this.C5C6 = Link.createLink(this.mediator, this.C5, this.C6);
        this.C6HC6 = Link.createLink(this.mediator, this.C6, this.HC6);
        this.C6N1 = Link.createLink(this.mediator, this.C6, this.N1);
        if (this.N1C2 != null) {
            this.links.add(this.N1C2);
        }
        if (this.C2O2 != null) {
            this.links.add(this.C2O2);
        }
        if (this.C2N3 != null) {
            this.links.add(this.C2N3);
        }
        if (this.N3C4 != null) {
            this.links.add(this.N3C4);
        }
        if (this.C4N4 != null) {
            this.links.add(this.C4N4);
        }
        if (this.N4H1N4 != null) {
            this.links.add(this.N4H1N4);
        }
        if (this.N4H2N4 != null) {
            this.links.add(this.N4H2N4);
        }
        if (this.C4C5 != null) {
            this.links.add(this.C4C5);
        }
        if (this.C5HC5 != null) {
            this.links.add(this.C5HC5);
        }
        if (this.C5C6 != null) {
            this.links.add(this.C5C6);
        }
        if (this.C6HC6 != null) {
            this.links.add(this.C6HC6);
        }
        if (this.C6N1 != null) {
            this.links.add(this.C6N1);
        }
    }

    public OpenGLColor getStandardColor() {
        return standardColor;
    }

    public void drawPlane(GL gl) {
        gl.glBegin(9);
        gl.glColor3fv(this.getStandardColor().getRGBOpenGl(), 0);
        gl.glVertex3fv(this.N1.getFloat(), 0);
        gl.glVertex3fv(this.C2.getFloat(), 0);
        gl.glVertex3fv(this.N3.getFloat(), 0);
        gl.glVertex3fv(this.C4.getFloat(), 0);
        gl.glVertex3fv(this.C5.getFloat(), 0);
        gl.glVertex3fv(this.C6.getFloat(), 0);
        gl.glEnd();
        gl.glBegin(9);
        gl.glVertex3fv(this.C6.getFloat(), 0);
        gl.glVertex3fv(this.C5.getFloat(), 0);
        gl.glVertex3fv(this.C4.getFloat(), 0);
        gl.glVertex3fv(this.N3.getFloat(), 0);
        gl.glVertex3fv(this.C2.getFloat(), 0);
        gl.glVertex3fv(this.N1.getFloat(), 0);
        gl.glEnd();
    }
}

