/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.structures.nucleicAcids;

import fr.unistra.ibmc.assemble.Mediator;
import fr.unistra.ibmc.assemble.gui.rendering.OpenGLColor;
import fr.unistra.ibmc.assemble.structures.Atom;
import fr.unistra.ibmc.assemble.structures.Link;
import fr.unistra.ibmc.assemble.structures.Residue;
import fr.unistra.ibmc.assemble.structures.nucleicAcids.SugarPhosphate;
import fr.unistra.ibmc.paradise.core.features.Residue3D;
import java.awt.Color;

public class Desoxyribose
extends SugarPhosphate {
    Atom H2C2 = null;
    Link C2H2C2 = null;
    private static OpenGLColor standardColor = new OpenGLColor(Color.MAGENTA);

    public Desoxyribose(Residue r, Mediator mediator) {
        super(r, mediator);
        this.setColor(standardColor);
    }

    public boolean parseResidue3D(Residue3D.Atom atom) {
        super.parseResidue3D(atom);
        String name = atom.getName();
        if (name.equals("2H2'")) {
            this.H2C2 = new Atom(this.mediator, atom, this.residue, 1);
            return true;
        }
        return false;
    }

    public void generateAtoms() {
        super.generateAtoms();
        if (this.H2C2 != null) {
            this.add(this.H2C2);
        }
    }

    public void generateInternalLinks() {
        this.C2H2C2 = Link.createLink(this.mediator, this.C2, this.H2C2);
        if (this.C2H2C2 != null) {
            this.links.add(this.C2H2C2);
        }
        super.generateInternalLinks();
    }

    public OpenGLColor getStandardColor() {
        return standardColor;
    }
}

