/*
 * Decompiled with CFR 0.152.
 */
package fr.unistra.ibmc.assemble.utils;

import com.sun.opengl.util.Animator;
import fr.unistra.ibmc.assemble.gui.Assemble;
import fr.unistra.ibmc.paradise.utils.JavaLibraryPath;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.glu.GLU;
import javax.swing.JFrame;

public class Training
extends JFrame {
    public Training() {
        super("Training");
        this.setSize(300, 300);
        this.setBackground(Color.WHITE);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        try {
            String osName = System.getProperty("os.name");
            if (osName.startsWith("Mac OS")) {
                JavaLibraryPath.add((File)new File(Assemble.getInstallPath() + "native" + System.getProperty("file.separator") + "mac"));
            } else if (osName.startsWith("Windows")) {
                if (System.getProperty("sun.arch.data.model").equals("32")) {
                    System.out.println("Loading Windows 32 Libraries");
                    JavaLibraryPath.add((File)new File(Assemble.getInstallPath() + "native" + System.getProperty("file.separator") + "win32"));
                } else if (System.getProperty("sun.arch.data.model").equals("64")) {
                    System.out.println("Loading Windows 64 Libraries");
                    JavaLibraryPath.add((File)new File(Assemble.getInstallPath() + "native" + System.getProperty("file.separator") + "win64"));
                } else {
                    System.err.println("Your Windows system is not recognized as either a 32bit nor a 64bit platform");
                    System.exit(1);
                }
            } else if (osName.startsWith("Linux") || osName.startsWith("FreeBSD")) {
                if (System.getProperty("sun.arch.data.model").equals("32")) {
                    System.out.println("Loading Linux32 Libraries");
                    JavaLibraryPath.add((File)new File(Assemble.getInstallPath() + "native" + System.getProperty("file.separator") + "linux32"));
                } else if (System.getProperty("sun.arch.data.model").equals("64")) {
                    System.out.println("Loading Linux64 Libraries");
                    JavaLibraryPath.add((File)new File(Assemble.getInstallPath() + "native" + System.getProperty("file.separator") + "linux64"));
                } else {
                    System.err.println("Your linux system is not recognized as either a 32bit nor a 64bit platform");
                    System.exit(1);
                }
            } else {
                System.err.println("Your system in not recognized as Windows, MacOS or Linux : no appropriate 3D drivers available. sorry.");
                System.exit(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        GLCapabilities caps = new GLCapabilities();
        caps.setHardwareAccelerated(true);
        caps.setDoubleBuffered(true);
        GLCanvas canvas = new GLCanvas(caps, null, null, null);
        canvas.addGLEventListener((GLEventListener)new Renderer1());
        Animator anim = new Animator((GLAutoDrawable)canvas);
        anim.start();
        this.add((Component)canvas);
        this.setVisible(true);
    }

    private class Renderer2
    implements GLEventListener {
        private final GLU glu = new GLU();
        private final int SIZE = 1;
        private float angle = 0.0f;

        private Renderer2() {
        }

        public void init(GLAutoDrawable glAutoDrawable) {
            GL gl = glAutoDrawable.getGL();
            gl.glShadeModel(7425);
            gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            gl.glClearDepth(1.0);
            gl.glEnable(2929);
            gl.glDepthFunc(515);
            gl.glHint(3152, 4354);
        }

        public void display(GLAutoDrawable glAutoDrawable) {
            GL gl = glAutoDrawable.getGL();
            gl.glClear(16384);
            gl.glColor3f(1.0f, 0.0f, 0.0f);
            gl.glRecti(0, 0, 0, 0);
            gl.glColor3f(0.0f, 0.0f, 0.0f);
            this.angle += 1.0f;
            gl.glMatrixMode(5888);
            gl.glLoadIdentity();
            gl.glRotatef(this.angle, 0.0f, 0.0f, 1.0f);
        }

        public void reshape(GLAutoDrawable glAutoDrawable, int x, int y, int width, int height) {
            GL gl = glAutoDrawable.getGL();
            if (height <= 0) {
                height = 1;
            }
            float h = (float)width / (float)height;
            gl.glMatrixMode(5889);
            gl.glLoadIdentity();
            this.glu.gluPerspective(50.0, (double)h, 1.0, 1000.0);
            gl.glMatrixMode(5888);
            gl.glLoadIdentity();
        }

        public void displayChanged(GLAutoDrawable glAutoDrawable, boolean b, boolean b1) {
        }
    }

    private class Renderer1
    implements GLEventListener {
        private final GLU glu = new GLU();

        private Renderer1() {
        }

        public void init(GLAutoDrawable glAutoDrawable) {
            GL gl = glAutoDrawable.getGL();
            gl.glShadeModel(7425);
            gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            gl.glEnable(2929);
            gl.glDepthFunc(515);
            gl.glHint(3152, 4354);
        }

        public void display(GLAutoDrawable glAutoDrawable) {
            GL gl = glAutoDrawable.getGL();
            gl.glClear(16384);
            gl.glClear(256);
            gl.glLoadIdentity();
            gl.glTranslatef(0.0f, 0.0f, -5.0f);
            gl.glBegin(7);
            gl.glColor3f(1.0f, 0.0f, 0.0f);
            gl.glVertex3f(-1.0f, 1.0f, 0.0f);
            gl.glVertex3f(-1.0f, -1.0f, 0.0f);
            gl.glVertex3f(1.0f, -1.0f, 0.0f);
            gl.glVertex3f(1.0f, 1.0f, 0.0f);
            gl.glEnd();
        }

        public void reshape(GLAutoDrawable glAutoDrawable, int x, int y, int width, int height) {
            GL gl = glAutoDrawable.getGL();
            if (height <= 0) {
                height = 1;
            }
            float h = (float)width / (float)height;
            gl.glMatrixMode(5889);
            gl.glLoadIdentity();
            this.glu.gluPerspective(50.0, (double)h, 1.0, 1000.0);
            gl.glMatrixMode(5888);
            gl.glLoadIdentity();
        }

        public void displayChanged(GLAutoDrawable glAutoDrawable, boolean b, boolean b1) {
        }
    }
}

