/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.rma;

import jade.gui.AgentTree;
import jade.tools.rma.AddRemotePlatformAction;
import jade.tools.rma.AddRemotePlatformFromURLAction;
import jade.tools.rma.AgentAction;
import jade.tools.rma.ChangeAgentOwnershipAction;
import jade.tools.rma.CloneAgentAction;
import jade.tools.rma.CloseRMAAction;
import jade.tools.rma.ContainerAction;
import jade.tools.rma.CustomAction;
import jade.tools.rma.DummyAgentAction;
import jade.tools.rma.ExitAction;
import jade.tools.rma.FixedAction;
import jade.tools.rma.FreezeAgentAction;
import jade.tools.rma.GenericAction;
import jade.tools.rma.InstallMTPAction;
import jade.tools.rma.IntrospectorAction;
import jade.tools.rma.KillAction;
import jade.tools.rma.LoadAgentAction;
import jade.tools.rma.LoadContainerAction;
import jade.tools.rma.LogManagerAgentAction;
import jade.tools.rma.MainPanel;
import jade.tools.rma.MainWindow;
import jade.tools.rma.ManageMTPsAction;
import jade.tools.rma.MoveAgentAction;
import jade.tools.rma.PlatformAction;
import jade.tools.rma.RMAAction;
import jade.tools.rma.RefreshAMSAgentAction;
import jade.tools.rma.RefreshAPDescriptionAction;
import jade.tools.rma.RegisterRemoteAgentAction;
import jade.tools.rma.RemoveRemoteAMSAction;
import jade.tools.rma.ResumeAction;
import jade.tools.rma.SaveAgentAction;
import jade.tools.rma.SaveContainerAction;
import jade.tools.rma.ShowDFGuiAction;
import jade.tools.rma.ShutDownAction;
import jade.tools.rma.SnifferAction;
import jade.tools.rma.StartException;
import jade.tools.rma.StartNewAgentAction;
import jade.tools.rma.SuspendAction;
import jade.tools.rma.ThawAgentAction;
import jade.tools.rma.UninstallMTPAction;
import jade.tools.rma.ViewAPDescriptionAction;
import jade.tools.rma.rma;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;

class ActionProcessor {
    private MainPanel panel;
    private RMAAction action;
    public static final String START_ACTION = "Start new Agent";
    public static final String MANAGE_MTPS_ACTION = "Manage Installed MTPs";
    public static final String INSTALL_MTP_ACTION = "Install a new MTP";
    public static final String UNINSTALL_MTP_ACTION = "Uninstall an MTP";
    public static final String KILL_ACTION = "Kill";
    public static final String SUSPEND_ACTION = "Suspend Agent";
    public static final String RESUME_ACTION = "Resume Agent";
    public static final String CHANGE_AGENT_OWNERSHIP_ACTION = "Change Agent Ownership";
    public static final String CUSTOM_ACTION = "Custom Agent";
    public static final String SNIFFER_ACTION = "Start Sniffer";
    public static final String DUMMYAG_ACTION = "Start DummyAgent";
    public static final String LOGGERAG_ACTION = "Start LoggerAgent";
    public static final String INTROSPECTOR_ACTION = "Start IntrospectAgent ";
    public static final String CLOSE_ACTION = "Close RMA";
    public static final String EXIT_ACTION = "Exit RMA";
    public static final String SHUTDOWN_ACTION = "Shutdown action";
    public static final String SHOWDF_ACTION = "ShowDfGui Action";
    public static final String MOVEAGENT_ACTION = "Migrate Agent";
    public static final String CLONEAGENT_ACTION = "Clone Agent";
    public static final String SAVEAGENT_ACTION = "Save Agent";
    public static final String LOADAGENT_ACTION = "Load Agent";
    public static final String FREEZEAGENT_ACTION = "Freeze Agent";
    public static final String THAWAGENT_ACTION = "Thaw Agent";
    public static final String SAVECONTAINER_ACTION = "Save Container";
    public static final String LOADCONTAINER_ACTION = "Load Container";
    public static final String ADDREMOTEPLATFORM_ACTION = "Add Platform via AMS AID";
    public static final String ADDREMOTEPLATFORMFROMURL_ACTION = "Add Platform via URL";
    public static final String VIEWPLATFORM_ACTION = "View AP Description";
    public static final String REFRESHAPDESCRIPTION_ACTION = "Refresh AP Description";
    public static final String REMOVEREMOTEAMS_ACTION = "Remove Remote Platform";
    public static final String REFRESHAMSAGENT_ACTION = "Refresh Agent List";
    public static final String REGISTERREMOTEAGENTWITHAMS_ACTION = "Register Remote Agent with local AMS";
    public static final Map actions = new HashMap();

    public ActionProcessor(rma anRma, MainWindow mWnd, MainPanel panel) {
        this.panel = panel;
        actions.put(START_ACTION, new StartNewAgentAction(anRma, mWnd, this));
        actions.put(MANAGE_MTPS_ACTION, new ManageMTPsAction(mWnd, this));
        actions.put(INSTALL_MTP_ACTION, new InstallMTPAction(anRma, this));
        actions.put(UNINSTALL_MTP_ACTION, new UninstallMTPAction(anRma, this));
        actions.put(KILL_ACTION, new KillAction(KILL_ACTION, anRma, this));
        actions.put(SUSPEND_ACTION, new SuspendAction(anRma, this));
        actions.put(RESUME_ACTION, new ResumeAction(anRma, this));
        actions.put(CHANGE_AGENT_OWNERSHIP_ACTION, new ChangeAgentOwnershipAction(anRma, this, mWnd));
        actions.put(CUSTOM_ACTION, new CustomAction(anRma, mWnd, this));
        actions.put(SNIFFER_ACTION, new SnifferAction(anRma, this));
        actions.put(DUMMYAG_ACTION, new DummyAgentAction(anRma, this));
        actions.put(LOGGERAG_ACTION, new LogManagerAgentAction(anRma, this));
        actions.put(INTROSPECTOR_ACTION, new IntrospectorAction(anRma, this));
        actions.put(CLOSE_ACTION, new CloseRMAAction(anRma, this));
        actions.put(EXIT_ACTION, new ExitAction(anRma, this));
        actions.put(SHUTDOWN_ACTION, new ShutDownAction(anRma, this));
        actions.put(SHOWDF_ACTION, new ShowDFGuiAction(anRma, this));
        actions.put(MOVEAGENT_ACTION, new MoveAgentAction(anRma, this, mWnd));
        actions.put(CLONEAGENT_ACTION, new CloneAgentAction(anRma, this, mWnd));
        actions.put(SAVEAGENT_ACTION, new SaveAgentAction(anRma, this));
        actions.put(LOADAGENT_ACTION, new LoadAgentAction(anRma, this, mWnd));
        actions.put(FREEZEAGENT_ACTION, new FreezeAgentAction(anRma, this));
        actions.put(THAWAGENT_ACTION, new ThawAgentAction(anRma, this, mWnd));
        actions.put(SAVECONTAINER_ACTION, new SaveContainerAction(anRma, this));
        actions.put(LOADCONTAINER_ACTION, new LoadContainerAction(anRma, this));
        actions.put(ADDREMOTEPLATFORM_ACTION, new AddRemotePlatformAction(anRma, this, mWnd));
        actions.put(VIEWPLATFORM_ACTION, new ViewAPDescriptionAction(anRma, this));
        actions.put(REFRESHAPDESCRIPTION_ACTION, new RefreshAPDescriptionAction(anRma, this));
        actions.put(REMOVEREMOTEAMS_ACTION, new RemoveRemoteAMSAction(anRma, this));
        actions.put(REFRESHAMSAGENT_ACTION, new RefreshAMSAgentAction(anRma, this));
        actions.put(ADDREMOTEPLATFORMFROMURL_ACTION, new AddRemotePlatformFromURLAction(anRma, this, mWnd));
        actions.put(REGISTERREMOTEAGENTWITHAMS_ACTION, new RegisterRemoteAgentAction(anRma, this));
    }

    public void process(RMAAction a) {
        this.action = a;
        TreePath[] paths = this.panel.treeAgent.tree.getSelectionPaths();
        if (this.action instanceof FixedAction) {
            this.fixedAct();
        } else if (paths != null) {
            int lungpath = paths.length;
            int i = 0;
            while (i < lungpath) {
                AgentTree.Node now = (AgentTree.Node)paths[i].getLastPathComponent();
                if (this.action instanceof AgentAction) {
                    this.agentAct(now);
                } else if (this.action instanceof ContainerAction) {
                    this.containerAct(now);
                } else if (this.action instanceof GenericAction) {
                    this.genericAct(now);
                } else if (this.action instanceof PlatformAction) {
                    this.platformAct(now);
                }
                ++i;
            }
        } else if (this.action instanceof AgentAction) {
            JOptionPane.showMessageDialog(new JFrame(), "You must select an agent in the Tree", "Start Procedure Error", 0);
        } else if (this.action instanceof DummyAgentAction || this.action instanceof SnifferAction || this.action instanceof IntrospectorAction || this.action instanceof LogManagerAgentAction) {
            this.containerAct(null);
        } else if (this.action instanceof PlatformAction) {
            JOptionPane.showMessageDialog(new JFrame(), "You must select a platform", "Error", 0);
        } else {
            JOptionPane.showMessageDialog(new JFrame(), "You must select an agent-platform or a agent-container in the Tree", "Start Procedure Error", 0);
        }
    }

    private void fixedAct() {
        FixedAction fx = (FixedAction)this.action;
        fx.doAction();
    }

    private void agentAct(AgentTree.Node node) {
        AgentAction ag = (AgentAction)this.action;
        if (node instanceof AgentTree.AgentNode) {
            AgentTree.AgentNode nod = (AgentTree.AgentNode)node;
            ag.doAction(nod);
        }
    }

    private void containerAct(AgentTree.Node node) {
        ContainerAction ac = (ContainerAction)this.action;
        if ((ac instanceof DummyAgentAction || ac instanceof SnifferAction || ac instanceof IntrospectorAction || ac instanceof LogManagerAgentAction) && (node == null || node instanceof AgentTree.SuperContainer)) {
            ac.doAction(null);
        } else {
            try {
                if (!(node instanceof AgentTree.ContainerNode)) {
                    throw new StartException();
                }
                AgentTree.ContainerNode nod = (AgentTree.ContainerNode)node;
                ac.doAction(nod);
            }
            catch (StartException ex) {
                StartException.handle();
            }
        }
    }

    private void genericAct(AgentTree.Node node) {
        GenericAction ga = (GenericAction)this.action;
        if (node instanceof AgentTree.ContainerNode) {
            AgentTree.ContainerNode nod2 = (AgentTree.ContainerNode)node;
            ga.doAction(nod2);
        } else if (node instanceof AgentTree.AgentNode) {
            AgentTree.AgentNode nod1 = (AgentTree.AgentNode)node;
            ga.doAction(nod1);
        }
    }

    private void platformAct(AgentTree.Node node) {
        PlatformAction ac = (PlatformAction)this.action;
        if (node instanceof AgentTree.LocalPlatformFolderNode || node instanceof AgentTree.RemotePlatformNode) {
            ac.doAction(node);
        }
    }
}

