# $Id: Marker.pm,v 1.2 2003/11/18 19:18:11 malay Exp $
# Perl module for BioSVG::Plasmid::Marker
# Author: Malay < curiouser@ccmb.res.in >
# Copyright (c) 2003 by Malay. All rights reserved.
# You may distribute this module under the same terms as perl itself


package BioSVG::Plasmid::Marker;

sub new {
    my ( $class, @args ) = @_;
    my $self = { (@args) };
    bless $self, ref $class || $class;
    return $self;
}

sub get_name {
    return $_[0]->{name};
}

sub get_stroke {
    return $_[0]->{stroke} ? $_[0]->{stroke} : undef;

}

sub get_stroke_color {
    return $_[0]->{stroke_color} ? $_[0]->{stroke_color} : undef;
}

sub get_text_color {
    return $_[0]->{text_color} ? $_[0]->{text_color} : undef;
}

sub get_style {
    return $_[0]->{style}? $_[0]->{style} : "arrow";
}

sub get_fill {
    return $_[0]->{fill} ? $_[0]->{fill} : undef ;
}

sub get_start {
    return $_[0]->{start};
    
}

sub get_end {
    return $_[0]->{end};
}

sub get_font {
    return $_[0]->{font} ? $_[0]->{font} : undef;
}

sub get_width {
    return $_[0]->{width} ? $_[0]->{width} : 14; 
}

1;
