#! /usr/bin/perl -w

use blib;
use strict;
use Test::More 'no_plan';

require_ok("BioSVG::Plasmid");
require_ok("BioSVG::CircularPlasmid");
require_ok("BioSVG::Canvas");

my $plasmid = BioSVG::Plasmid->new(-name=>"pSomething",-size=>8000,
				   -shape=>"circular");
#$plasmid->set_radius(200);

isa_ok($plasmid, "BioSVG::CircularPlasmid");
is($plasmid->{name}, "pSomething");
is($plasmid->{size}, 8000);
is($plasmid->get_radius(), 150);

$plasmid->draw_backbone(-width=>2,-stroke_color=>Pastel::Color->red());
my $backbone = $plasmid->get_backbone();
isa_ok($backbone, "BioSVG::Plasmid::Backbone");

my $canvas = BioSVG::Canvas->new();
is($canvas->get_height(), 600);
is($canvas->get_width(), 800);
$canvas->add($plasmid);

#print STDERR "Something\n";

 print  STDERR $canvas->get_svg(),"\n";
