/***************************************************************************
                          pairs_parser.h  -  description
                             -------------------
    begin                : Mon Oct 20, 2003
    copyright            : (C) 2003 by Hong Qin
    email                : hongqin@uchicago.edu
 ***************************************************************************/
#ifndef  _PAIRS_PARSER_H
#define  _PAIRS_PARSER_H  

#include <string>
#include "mytypes.h"
#include "node.h"
#include "graph.h"
#include "edge.h"

class CPairs_Parser {
public:
 vector<PAIR_str_t> 		pairs_in;
 SET_str_t			set_ids;		
 VECTOR_str_t			ordered_ids;
 std::map<string, int>  	m_id2pos;
 MLMAP_ii_t		  	ml_pos2pos_edges; // can be redunant, for pasrsing only
 MLMAP_ii_t	  		mliiEdges;  //this is the one analysis
 bool 				isDirected; 

 CPairs_Parser();
 ~CPairs_Parser();

 int generate_undirected_graph_without_self_pairing(const string& flname, Graph& g );

protected:
 
private:
 int generate_nodes_without_neighbours( Graph& g );
 int generate_nodes_without_neighbours( vector<Node>& vNodes );
 int set_neighbours_in_nodes( vector<Node>& vNodes );
 int generate_nodes_with_neighbours( vector<Node>& vNodes );

 int set_pairs_frm_one_fasta_fl(const string& flname);
 int set_pairs_frm_one_fasta_fl_wo_self_pairs(const string& flname);
 int set_uniq_elements();
 int set_ordered_ids();
 int set_map_id2pos();
 int set_mlmap_pos2pos_edges();
 int set_as_undirected_pairs(); // remove redundant pairs
 int rm_self_pairings();

 int set_mliiEdges();
 int _set_int2NodePtr_lookup_table( vector<Node>& vNodes );

 std::vector<Node*> 		v_int2NodePtr;
 
};

#endif 
