/***************************************************************************
                          node.h  -  description
                             -------------------
    begin                : Monday Oct 20, 2003
    copyright            : (C) 2003 Hong Qin
    email                : hongqin@uchicago.edu
 ***************************************************************************/
#ifndef _NODE_H
#define _NODE_H
#include <vector>
#include <string>

class Node {
public:
	char * 			    pId;		//eg orf
	int				    iRank;		//unique numeric label
	std::vector <Node*> vpNeighbors;
    std::vector <float> vnWeights;  //013006, defalut is 1

	char *			    pColor;		//for graph algorithm
	char * 			    pCategory;
	bool				isDirected;

	float				nD;		   // distance, runtime value

	bool 				isVerified;
	std::string		    sDescription;	//functional description of orf
	int					iK;		  //degreee, connectivity
	int					iTmp;		//temp variable

	Node *			    pPredecessor;   //120805 for dijkstra or tree

    //for digraph
	std::vector <Node*> 	vpNeighborsIn;
	std::vector <Node*> 	vpNeighborsOut;
	int					iKin;		  //in_degree
	int					iKout;		//out_defree

	Node(char* 	pId_in);
	Node(char*  pId_in, int iRank_in);
	Node();
	Node( const Node & inNode );
	~Node();

protected:
private:
};

#endif
