/*
 Return a Graph
 Generate a MS02 null graph;
*/
#include <string>
#include <iostream>
#include <map>
//#include <iomanip>
#include <utility>
#include "graph.h"
#include "mytypes.h"
#include "util.h"
#include "pairs_parser.h"
#include "WSLsplit.h"

using namespace std;        

int main() { 
 CPairs_Parser parser1;
 string file = "data/pair.tab";
 
 parser1.set_pairs_frm_one_fasta_fl( file );  
 cout << parser1.pairs_in.size()<<endl;

 parser1.set_uniq_elements();
 cout << parser1.set_ids.size()<<endl;

 parser1.set_ordered_ids();
 cout << parser1.ordered_ids.size()<<endl;

 parser1.set_map_id2pos();
 cout << parser1.m_id2pos.size()<<endl;

 parser1.set_mlmap_pos2pos_edges();
 cout <<"multimap size is: " << parser1.ml_pos2pos_edges.size()<<endl;

 cout << "Now remove redundant pairs\n";
 parser1.set_as_undirected_pairs();

 parser1.set_mlmap_pos2pos_edges();
 cout <<"multimap size is: " << parser1.ml_pos2pos_edges.size()<<endl;

 cout << "Now remove self pairs\n";
 parser1.rm_self_pairings();   

 parser1.set_mlmap_pos2pos_edges();
 cout <<"multimap size is: " << parser1.ml_pos2pos_edges.size()<<endl;

 Graph g2;

 parser1.isDirected = 0;
 parser1.generate_nodes_without_neighbours( g2.vNodes );
 parser1.set_neighbours_in_nodes( g2.vNodes );
 cout << "g2.vNodes.size()=" << g2.vNodes.size() << endl;

 g2.print_graph_in_adj_list( );

}
