#ifndef INCLUDE_FASTALIB_H
#define INCLUDE_FASTALIB_H

#include <stdio.h>

//#define MAX_SEQ_LENGTH (64 * 1024)


typedef struct { 
    char *readBuffer;

    char *seqName;
    unsigned char *seqBuffer;

    int pos;
    int size;

    FILE *fp;

    int sequences;
    int residues;

    int pad;
} FASTA_LIB;

FASTA_LIB *openLib (char *file, int pad);
void closeLib (FASTA_LIB *lib);

unsigned char *nextSeq (FASTA_LIB *lib, int *length);
unsigned char *nextSeqPPE (FASTA_LIB *lib, int *length);
void skipSeq (FASTA_LIB *lib);

#define seqName(LIB) (LIB->seqName)

#endif /* INCLUDE_FASTALIB_H */
