#ifndef INCLUDE_SWSSE2_H
#define INCLUDE_SWSSE2_H

typedef void SW_DATA;

#define ALPHA_SIZE 23

extern const char AMINO_ACIDS[ALPHA_SIZE];
extern const int AMINO_ACID_VALUE[256];

#define SHORT_BIAS 16384

//moved from fastalib.c
#define MAX_SEQ_LENGTH (1024*64)
#define READ_BUFFER_SIZE (16384)
#define SEQ_NAME_SIZE    (128)
#define NUM_DB_SEQS    (1024)


typedef struct {
    short gapInit;
    short gapExt;
    int   threshold;
} SEARCH_OPTIONS;

#define MAX_SCORE_NAME 64
typedef struct SCORE_STRUCT {
    int score;
    char name[MAX_SCORE_NAME];
    struct SCORE_STRUCT *prev;
    struct SCORE_STRUCT *next;
} SCORE_NODE;

typedef struct {
    int minScore;
    SCORE_NODE *first;
    SCORE_NODE *last;
    SCORE_NODE *free;
    void *buffer;
} SCORE_LIST;

//added - Hieu 

typedef union
{
  unsigned long long ull;
  unsigned int ui[2];
} addr64;

typedef struct{
	char vect[16];
}ppeVector;

typedef struct {
    ppeVector 	     *pvbQueryProf;
    ppeVector        *pvsQueryProf;
    ppeVector        *pvH1;
    ppeVector        *pvH2;
    ppeVector        *pvE;
    unsigned char  *pData;
    unsigned short  bias;
    char padding[102];
} SwDataPPE;

typedef struct {
	SwDataPPE *swData;
	//int padding1[4];
    	unsigned char  *pData;
	//int padding2[4];
	int nCount;	
	int pos;
	int queryLen;
	int *dbPos;
	int *dbLenPos;
	int padding3[25];
} context;


int insertList (SCORE_LIST *list, int score, char *name);

#endif
