#!/bin/bash

#******************************************************************************
#  lscel.sh : list cell files with chiptype detail
#
#  Author:  david paladini <david.paladini.1@ulaval.ca>,
#           Copyright (C) 2005, Quebec Genomic Center
#
#******************************************************************************
#
#                            PUBLIC DOMAIN NOTICE
#                            Quebec Genomic Center
#
#   This software/database is freely available to the public for use or
#   reproduction.
#
#   Although all reasonable efforts have been taken to ensure the accuracy
#   and reliability of the software and data, the Quebec Genomic Center
#   do not and cannot warrant the performance or results that may be obtained
#   by using this software or data.
#   The Quebec Genomic Center disclaim all warranties, express or implied,
#   including warranties of performance, merchantability or fitness for
#   any particular purpose.
#
#   Please cite the author in any work or product based on this material.
#
#******************************************************************************
#   using sample on bash prompt
#
#   s1. list cel under current dir and subdir, sorted by chiptype :
#   > lscel.sh | sort
#
#   s2. list cel under current dir and subdir, which have HG-U133_Plus_2 in 
#       chiptype and write it in a file :
#   > lscel.sh | grep HG-U133_Plus_2 > HG-U133_Plus_2.txt
#
#   s3. list cel under current dir and subdir, which have HG-U133_Plus_2 in 
#       chiptype write it in a file sorted by CEL full filename :
#   > lscel.sh | grep HG-U133_Plus_2 | sort  > HG-U133_Plus_2.txt
#
#******************************************************************************

echo "CHIPTYPE" "CEL"  | awk '{printf("%-20s %-50s\n", $1, $2)}'

# find all cel file from the current dir 
for onefile in $( find ./ 2>/dev/null | grep "\.CEL*" 2>/dev/null  )
do
  # print CEL file info on standard output
  echo $onefile $( celutil $onefile qry -Dt 2>/dev/null ) | awk '{printf("%-20s %-50s\n", $2, $1)}'
done

exit 0