/*
________________________________________________________________________________

  hpp Implementation: CELFile, 2005
________________________________________________________________________________

                            PUBLIC DOMAIN NOTICE
                            Quebec Genomic Center

  This software/database is freely available to the public for use or
  reproduction.

  Although all reasonable efforts have been taken to ensure the accuracy
  and reliability of the software and data, the Quebec Genomic Center
  do not and cannot warrant the performance or results that may be obtained
  by using this software or data.
  The Quebec Genomic Center disclaim all warranties, express or implied,
  including warranties of performance, merchantability or fitness for
  any particular purpose.

  Please cite the author in any work or product based on this material.
________________________________________________________________________________

 Author:  david paladini <david.paladini.bioinfo@gmail.com>,
          Copyright (C) 2005, Quebec functional Genomic Center

 File Description: celFile utility class implant :
                   - equality operation between to CELFile class
                   - Based on CEl File Parser class CCELFileData of Affy, add
                     writing capabilities in both ASCII and XDA (binary) CEL
                     File format.
________________________________________________________________________________
*/
#if !defined(CELFILE_H)
#define CELFILE_H

//______________________________________________________________________________

#include <iostream>
#include <CELFileData.h>

#ifdef WIN32
#include <windows.h>
#endif

//______________________________________________________________________________

namespace affxcel_ext
{
typedef enum {
 eList = 0,
 eTabTitleOnly = 1,
 eTabDataOnly = 2,
 eTabTitleAndData = 3,
}ePropFmt;
//______________________________________________________________________________

class CCELFileIO // utility
{
public:
  static void WRITE_INT(std::ostream &_OStr, int _Value);
  static void WRITE_UINT(std::ostream &_OStr, unsigned int _Value);
  static void WRITE_SHORT(std::ostream &_OStr, unsigned short _Value);
  static void WRITE_FLOAT(std::ostream &_OStr, float _Value);
  static void WRITE_STRING(std::ostream &_OStr, std::string _Value);
  static void DOSENDL(char* _Value);
};

//______________________________________________________________________________

class CCELFile : public affxcel::CCELFileData
{
public:
  // Constructor/destructor
  CCELFile() : CCELFileData(){};
  ~CCELFile(){};

protected:

  bool WriteTextHeader(std::ostream &_OStr);
  bool WriteTextIntensityData(std::ostream &_OStr);
  bool WriteTextFooter(std::ostream &_OStr);

  bool WriteXDAHeader(std::ostream &_OStr);
  bool WriteXDAIntensityData(std::ostream &_OStr);
  bool WriteXDAFooter(std::ostream &_OStr);

  int CheckDosfile();
public:
  // overloading operator
  bool operator==(CCELFile& _Rigth)
  {
    return memcmp(m_pEntries, _Rigth.m_pEntries, sizeof(m_pEntries));
  };

  // For writing a file
  bool Write(std::ostream &_OStr, int _XdaFormat);
  bool WriteIntensityProp(std::ostream &_OStr);
  bool WriteProp( std::ostream &_OStr,
                  ePropFmt _format,
                  bool _GetHeader      = false,
                  bool _GetVersion     = false,
                  bool _GetCols        = false,
                  bool _GetRows        = false,
                  bool _GetNumCells    = false,
                  bool _GetAlg         = false,
                  bool _GetParams      = false,
                  bool _GetChipType    = false,
                  bool _GetCellMargin  = false,
                  bool _GetNumOutliers = false,
                  bool _GetNumMasked   = false,
                  bool _GetParameters  = false,
                  bool _GridCorners    = false,
                  bool _GetDatHeader   = false);
};

//______________________________________________________________________________

} // namespace

//______________________________________________________________________________

#endif // !defined(CELFILE_H)

