/*
________________________________________________________________________________

  hpp Implementation: CELUtilApp, 2005
________________________________________________________________________________

                            PUBLIC DOMAIN NOTICE
                            Quebec Genomic Center

  This software/database is freely available to the public for use or
  reproduction.

  Although all reasonable efforts have been taken to ensure the accuracy
  and reliability of the software and data, the Quebec Genomic Center
  do not and cannot warrant the performance or results that may be obtained
  by using this software or data.
  The Quebec Genomic Center disclaim all warranties, express or implied,
  including warranties of performance, merchantability or fitness for
  any particular purpose.

  Please cite the author in any work or product based on this material.
________________________________________________________________________________

 Author:  david paladini <david.paladini.bioinfo@gmail.com>,
          Copyright (C) 2005, Quebec functional Genomic Center

 File Description: celUtilApp class implant application controler to read,
                   compare and convert CEL files
________________________________________________________________________________
*/
#if !defined(CELUTILAPP_H)
#define CELUTILAPP_H

#include <fstream>
#include <string>
#include <list>
#include <map>

#include "CELFile.h"

#ifdef WIN32
#include <windows.h>
#endif


//______________________________________________________________________________
typedef enum
{
  eHelp,
  eRead,
  eCompare,
  eConvert,
  eQuery
} eCmd;

class CCELUtilApp
{
protected:

  std::string m_Runable;
  std::string m_FileNameA;
  std::string m_FileNameB;
  std::string m_Option;
  eCmd   m_Command;

  int    PrintHelp();
  int    Failure(std::string _Msg, int _PrintHelp=false);
  int    IsOptionSet (char _Option);

  int    CmdRead();
  int    CmdQuery ();
  int    CmdCompare();
  int    CmdConvert();

  int    ReadCel (std::string, affxcel_ext::CCELFile& _Cel, bool _ReadHeaderOnly=false);
  int    WriteCel(std::string, affxcel_ext::CCELFile& _Cel , int, int);
  int    CompareCel();
  int    ConvertCel();
  int    WriteCelProp( std::string,
                       affxcel_ext::CCELFile& _Cel,
                       affxcel_ext::ePropFmt _format = affxcel_ext::eList ,
                       bool _GetHeader      = false,
                       bool _GetVersion     = false,
                       bool _GetCols        = false,
                       bool _GetRows        = false,
                       bool _GetNumCells    = false,
                       bool _GetAlg         = false,
                       bool _GetParams      = false,
                       bool _GetChipType    = false,
                       bool _GetCellMargin  = false,
                       bool _GetNumOutliers = false,
                       bool _GetNumMasked   = false,
                       bool _GetParameters  = false,
                       bool _GridCorners    = false,
                       bool _GetDatHeader   = false,
                       bool _GetIntensities = false);

public:
  // Constructor/destructor
  CCELUtilApp(int argc, char *argv[]) { Init(argc, argv); }
  ~CCELUtilApp(){};

  int Init(int argc, char *argv[]);
  int Run();

};

//______________________________________________________________________________

#endif // !defined(CELUTILAPP_H)

