/////////////////////////////////////////////////////////////////
//
// Copyright (C) 2004 Affymetrix, Inc.
//
// This library is free software; you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as published
// by the Free Software Foundation; either version 2.1 of the License,
// or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
// or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
// for more details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with this library; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
/////////////////////////////////////////////////////////////////
/*
________________________________________________________________________________
                            PUBLIC DOMAIN  NOTICE
________________________________________________________________________________

 Author:  david paladini <david.paladini.bioinfo@gmail.com>,
          Copyright (C) 2005, Quebec functional Genomic Center

 Description: - replace ifstream by igzstream from zlib C++ wrapper to
                add gzipped files reading capabilities
________________________________________________________________________________
*/
#if !defined(AFX_FILEIO_H__8A5CA65E_C2E0_4C36_9B60_30C2020D5DC0__INCLUDED_)
#define AFX_FILEIO_H__8A5CA65E_C2E0_4C36_9B60_30C2020D5DC0__INCLUDED_

//////////////////////////////////////////////////////////////////////

#include <fstream>
#include <string>

#include <iostream>
#include "gzstream.h"

//////////////////////////////////////////////////////////////////////

#define FLOAT_SIZE sizeof(float)
#define INT_SIZE sizeof(int)
#define UINT_SIZE sizeof(unsigned int)
#define SHORT_SIZE sizeof(short)
#define USHORT_SIZE sizeof(unsigned short)
#define CHAR_SIZE sizeof(char)
#define UCHAR_SIZE sizeof(unsigned char)

//////////////////////////////////////////////////////////////////////

void SwapBytes(char *src, char *dest, int size);

//////////////////////////////////////////////////////////////////////

void READ_INT(igzstream &instr, int &value);
void READ_UINT(igzstream &instr, unsigned int &value);
void READ_SHORT(igzstream &instr, short &value);
void READ_USHORT(igzstream &instr, unsigned short &value);
void READ_CHAR(igzstream &instr, char &value);
void READ_UCHAR(igzstream &instr, unsigned char &value);
void READ_BOOL(igzstream &instr, char &value);
void READ_FLOAT(igzstream &instr, float &value);
void READ_STRING(igzstream &instr, char * &value);
void READ_FIXED_STRING(igzstream &instr, char *value, int len);
void GET_NEXT_LINE(igzstream &instr, char *line, int len);
void READ_INT(const char* instr, int &value);

//////////////////////////////////////////////////////////////////////

void ReadInt(igzstream &instr, int &ival);
void ReadUChar(igzstream &instr, unsigned char &ucval);
void ReadUShort(igzstream &instr, unsigned short &usval);
void ReadUInt(igzstream &instr, unsigned int &uval);
void ReadFixedString(igzstream &instr, std::string &s, int len);
void ReadFixedUChar(igzstream &instr, unsigned char *s, int len);
void ReadUIntLenString(igzstream &instr, std::string &s);
void ReadString(igzstream &instr, std::string &s);
void ReadFloat(igzstream &instr, float &fval);
void ReadFloatFromOldBPMAP(igzstream &instr, float &fval);
void ReadUInt(const char *instr, unsigned int &uval);
void ReadFloat(const char *instr, float &fval);
void ReadFloatFromOldBPMAP(const char *instr, float &fval);
void ReadInt(const char *instr, int &ival);

//////////////////////////////////////////////////////////////////////


#endif // !defined(AFX_FILEIO_H__8A5CA65E_C2E0_4C36_9B60_30C2020D5DC0__INCLUDED_)
