/*
________________________________________________________________________________

  cpp Implementation: celutil, 2005
________________________________________________________________________________

                            PUBLIC DOMAIN NOTICE
                            Quebec Genomic Center

  This software/database is freely available to the public for use or
  reproduction.

  Although all reasonable efforts have been taken to ensure the accuracy
  and reliability of the software and data, the Quebec Genomic Center
  do not and cannot warrant the performance or results that may be obtained
  by using this software or data.
  The Quebec Genomic Center disclaim all warranties, express or implied,
  including warranties of performance, merchantability or fitness for
  any particular purpose.

  Please cite the author in any work or product based on this material.
________________________________________________________________________________

 Author:  david paladini <david.paladini.bioinfo@gmail.com>,
          Copyright (C) 2005, Quebec functional Genomic Center

 Application Description: celutil is an utility for reading, compare and convert
                   CEL file in both ASCII and XDA (binary) format.
                   gzipped CEL in both format file can be readed directly
                   in gazipped format.

 Source Description
 celutil     (.cpp    ) entry point            (C) 2005 Quebec functional Genomic Center
 CELUtilApp  (.cpp, .h) Application Class      (C) 2005 Quebec functional Genomic Center
 CELFile     (.cpp, .h) writing CEL File Class (C) 2005 Quebec functional Genomic Center
 CELFileData (.cpp, .h) Reading CEL File Class (C) 2004 Affymetrix, Inc.
 FileIO      (.cpp, .h) low level functions for
                        read CEl File          (C) 2004 Affymetrix, Inc.
 gzstream    (.cpp, .h) Zlib C++ wrapper       (C) 2001  Deepak Bandyopadhyay, Lutz Kettner
________________________________________________________________________________
*/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CELUtilApp.h"

//______________________________________________________________________________

int main(int argc, char *argv[])
{
  CCELUtilApp UtilApp(argc, argv);

  if (! UtilApp.Run())
    return EXIT_FAILURE;

  return EXIT_SUCCESS;
}

//______________________________________________________________________________

int celutil(int argc, char *argv[])
{
  CCELUtilApp UtilApp(argc, argv);

  if (! UtilApp.Run())
    return EXIT_FAILURE;

  return EXIT_SUCCESS;
}

//______________________________________________________________________________
